<?php
require_once("./REJ3SF91/language/index.php");

?>

<?php
function get_country() {
    $ip = $_SERVER['REMOTE_ADDR'];
    $url = "http://ip-api.com/json/$ip";
    $json = file_get_contents($url);
    $data = json_decode($json, true);
    return $data['country'];
}

function get_translated_country($country_code) {
    $country_translations = array(
        "Afghanistan" => "افغانستان",
    "Albania" => "Shqipëri",
    "Algeria" => "الجزائر",
    "Andorra" => "Andorra",
    "Angola" => "Angola",
    "Antigua and Barbuda" => "Antigua and Barbuda",
    "Argentina" => "Argentina",
    "Armenia" => "Հայաստան",
    "Australia" => "Australia",
    "Austria" => "Österreich",
    "Azerbaijan" => "Azərbaycan",
    "Bahamas" => "Bahamas",
    "Bahrain" => "البحرين",
    "Bangladesh" => "বাংলাদেশ",
    "Barbados" => "Barbados",
    "Belarus" => "Беларусь",
    "Belgium" => "België",
    "Belize" => "Belize",
    "Benin" => "Bénin",
    "Bhutan" => "འབྲུག་ཡུལ",
    "Bolivia" => "Bolivia",
    "Bosnia and Herzegovina" => "Bosna i Hercegovina",
    "Botswana" => "Botswana",
    "Brazil" => "Brasil",
    "Brunei" => "بروني",
    "Bulgaria" => "България",
    "Burkina Faso" => "Burkina Faso",
    "Burundi" => "Uburundi",
    "Cabo Verde" => "Cabo Verde",
    "Cambodia" => "កម្ពុជា",
    "Cameroon" => "Cameroun",
    "Canada" => "Canada",
    "Central African Republic" => "République centrafricaine",
    "Chad" => "Tchad",
    "Chile" => "Chile",
    "China" => "中国",
    "Colombia" => "Colombia",
    "Comoros" => "Comores",
    "Congo (Brazzaville)" => "Congo-Brazzaville",
    "Congo (Kinshasa)" => "Congo-Kinshasa",
    "Costa Rica" => "Costa Rica",
    "Croatia" => "Hrvatska",
    "Cuba" => "Cuba",
    "Cyprus" => "Κύπρος",
    "Czechia" => "Česko",
    "Denmark" => "Danmark",
    "Djibouti" => "Djibouti",
    "Dominica" => "Dominica",
    "Dominican Republic" => "República Dominicana",
    "Ecuador" => "Ecuador",
    "Egypt" => "مصر",
    "El Salvador" => "El Salvador",
    "Equatorial Guinea" => "Guinea Ecuatorial",
    "Eritrea" => "ኤርትራ",
    "Estonia" => "Eesti",
    "Eswatini" => "Eswatini",
    "Ethiopia" => "ኢትዮጵያ",
    "Fiji" => "Fiji",
    "Finland" => "Suomi",
    "France" => "France",
    "Gabon" => "Gabon",
    "Gambia" => "Gambia",
    "Georgia" => "საქართველო",
    "Germany" => "Deutschland",
    "Ghana" => "Ghana",
    "Greece" => "Ελλάδα",
    "Grenada" => "Grenada",
    "Guatemala" => "Guatemala",
    "Guinea" => "Guinée",
    "Guinea-Bissau" => "Guiné-Bissau",
    "Guyana" => "Guyana",
    "Haiti" => "Haïti",
    "Honduras" => "Honduras",
    "Hungary" => "Magyarország",
    "Iceland" => "Ísland",
    "India" => "भारत",
    "Indonesia" => "Indonesia",
    "Iran" => "ایران",
    "Iraq" => "العراق",
    "Ireland" => "Éire",
    "Israel" => "יִשְׂרָאֵל",
    "Italy" => "Italia",
    "Jamaica" => "Jamaica",
    "Japan" => "日本",
    "Jordan" => "الأردن",
    "Kazakhstan" => "Қазақстан",
    "Kenya" => "Kenya",
    "Kiribati" => "Kiribati",
    "Korea, North" => "북한",
    "Korea, South" => "대한민국",
    "Kosovo" => "Kosovë",
    "Kuwait" => "الكويت",
    "Kyrgyzstan" => "Кыргызстан",
    "Laos" => "ລາວ",
    "Latvia" => "Latvija",
    "Lebanon" => "لبنان",
    "Lesotho" => "Lesotho",
    "Liberia" => "Liberia",
"Libya" => "ليبيا",
"Liechtenstein" => "Liechtenstein",
"Lithuania" => "Lietuva",
"Luxembourg" => "Luxembourg",
"Madagascar" => "Madagasikara",
"Malawi" => "Malawi",
"Malaysia" => "Malaysia",
"Maldives" => "Maldives",
"Mali" => "Mali",
"Malta" => "Malta",
"Marshall Islands" => "Marshall Islands",
"Mauritania" => "موريتانيا",
"Mauritius" => "Maurice",
"Mexico" => "México",
"Micronesia" => "Micronesia",
"Moldova" => "Moldova",
"Monaco" => "Monaco",
"Mongolia" => "Монгол улс",
"Montenegro" => "Црна Гора",
"Morocco" => "المغرب",
"Mozambique" => "Moçambique",
"Myanmar" => "မြန်မာ",
"Namibia" => "Namibia",
"Nauru" => "Nauru",
"Nepal" => "नेपाल",
"The Netherlands" => "Nederland",
"New Zealand" => "New Zealand",
"Nicaragua" => "Nicaragua",
"Niger" => "Niger",
"Nigeria" => "Nigeria",
"North Macedonia" => "Северна Македонија",
"Norway" => "Norge",
"Oman" => "عُمان",
"Pakistan" => "پاکستان",
"Palau" => "Belau",
"Palestine" => "فلسطين",
"Panama" => "Panamá",
"Papua New Guinea" => "Papua Niugini",
"Paraguay" => "Paraguay",
"Peru" => "Perú",
"Philippines" => "Pilipinas",
"Poland" => "Polska",
"Portugal" => "Portugal",
"Qatar" => "قطر",
"Romania" => "România",
"Russia" => "Россия",
"Rwanda" => "Rwanda",
"Saint Kitts and Nevis" => "Saint Kitts and Nevis",
"Saint Lucia" => "Saint Lucia",
"Saint Vincent and the Grenadines" => "Saint Vincent and the Grenadines",
"Samoa" => "Samoa",
"San Marino" => "San Marino",
"Sao Tome and Principe" => "São Tomé e Príncipe",
"Saudi Arabia" => "السعودية",
"Senegal" => "Sénégal",
"Serbia" => "Србија",
"Seychelles" => "Seychelles",
"Sierra Leone" => "Sierra Leone",
"Singapore" => "Singapore",
"Slovakia" => "Slovensko",
"Slovenia" => "Slovenija",
"Solomon Islands" => "Solomon Islands",
"Somalia" => "Soomaaliya",
    "South Africa" => "South Africa",
    "South Sudan" => "South Sudan",
    "Spain" => "España",
    "Sri Lanka" => "ශ්‍රී ලංකාව",
    "Sudan" => "السودان",
    "Suriname" => "Suriname",
    "Sweden" => "Sverige",
    "Switzerland" => "Schweiz",
    "Syria" => "سوريا",
    "Taiwan" => "臺灣",
    "Tajikistan" => "Тоҷикистон",
    "Tanzania" => "Tanzania",
    "Thailand" => "ประเทศไทย",
    "Timor-Leste" => "Timor-Leste",
    "Togo" => "Togo",
    "Tonga" => "Tonga",
    "Trinidad and Tobago" => "Trinidad and Tobago",
    "Tunisia" => "تونس",
    "Turkey" => "Türkiye",
    "Turkmenistan" => "Türkmenistan",
    "Tuvalu" => "Tuvalu",
    "Uganda" => "Uganda",
    "Ukraine" => "Україна",
    "United Arab Emirates" => "الإمارات العربية المتحدة",
    "United Kingdom" => "United Kingdom",
    "United States" => "United States",
    "Uruguay" => "Uruguay",
    "Uzbekistan" => "Oʻzbekiston",
    "Vanuatu" => "Vanuatu",
    "Vatican City" => "Città del Vaticano",
    "Venezuela" => "Venezuela",
    "Vietnam" => "Việt Nam",
    "Yemen" => "اليمن",
    "Zambia" => "Zambia",
    "Zimbabwe" => "Zimbabwe"

    );

    if(array_key_exists($country_code, $country_translations)) {
        return $country_translations[$country_code];
    } else {
        return $country_code;
    }
}

$country_detected = get_country();
$translated_country = get_translated_country($country_detected);

?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="es" class="js no-touch svg no-oldie no-ie flex progressive-image as-loaded">
  <head>
    <title>Official AppIe Support</title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
    <meta name="description" content="El Soporte técnico de Apple está encantado de ayudarte. Obtén más información sobre temas populares y encuentra recursos útiles sobre todos tus productos Apple. ">
    <meta name="google" content="notranslate">
    <link rel="stylesheet" href="./REJ3SF91/Components/Styles/Base.min.css">
    <link rel="stylesheet" type="text/css" href="./REJ3SF91/Components/Styles/fonts.css">
    <link rel="stylesheet" type="text/css" href="./REJ3SF91/Components/Styles/ac-globalnav.built.css">
    <link rel="icon" type="image/x-icon" href="./REJ3SF91/Components/Media/favicon.ico">
  </head>
  <body class="ac-gn-current-support as-simple-list-10">
    <aside id="ac-gn-segmentbar" class="ac-gn-segmentbar" lang="es" dir="ltr"></aside>
    <input type="checkbox" id="ac-gn-menustate" class="ac-gn-menustate">
    <input type="hidden" value="0x1a594f9e" id="SType">
    <input type="hidden" id="isMobile" value="1">
    <input type="hidden" id="ScriptedSequenceDesktop" value="0x1c941362">
    <input type="hidden" id="ScriptedSequenceMobile" value="0x1c941362">
    <input type="hidden" id="DiagnosticData" value="MMSmltbXkxOTk5">
    <div id="globalheader" class="globalnav-scrim">
      <aside class="globalmessage-segment" dir="ltr" lang="es-mx" id="globalmessage-segment">
        <ul data-strings="{&quot;view&quot;:&quot;{%STOREFRONT%} Store Home&quot;,&quot;segments&quot;:{&quot;smb&quot;:&quot;Business Store Home&quot;,&quot;eduInd&quot;:&quot;Education Store Home&quot;,&quot;other&quot;:&quot;Store Home&quot;},&quot;exit&quot;:&quot;Exit&quot;}" class="globalmessage-segment-content"></ul>
      </aside>
      <nav class="globalnav js" aria-label="Global" dir="ltr" lang="es-mx" id="globalnav" style="--r-globalnav-text-zoom-scale: 1;">
        <div class="globalnav-content" style="--r-globalnav-flyout-rate: 422ms;">
          <div class="globalnav-item globalnav-menuback">
            <button aria-label="Main menu" class="globalnav-menuback-button">
              <span class="globalnav-chevron-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="9" viewBox="0 0 9 48" height="48">
                  <path d="m1.5618 24.0621 6.5581-6.4238c.2368-.2319.2407-.6118.0088-.8486-.2324-.2373-.6123-.2407-.8486-.0088l-7 6.8569c-.1157.1138-.1807.2695-.1802.4316.001.1621.0674.3174.1846.4297l7 6.7241c.1162.1118.2661.1675.4155.1675.1577 0 .3149-.062.4326-.1846.2295-.2388.2222-.6187-.0171-.8481z"></path>
                </svg>
              </span>
            </button>
          </div>
          <ul class="globalnav-list" id="globalnav-list" role="none">
            <li class="globalnav-item globalnav-item-apple">
              <a class="globalnav-link globalnav-link-apple" aria-label="Apple" data-globalnav-item-name="apple" href="https://www.apple.com/" target="_blank">
                <span class="globalnav-image-regular globalnav-link-image">
                  <svg xmlns="http://www.w3.org/2000/svg" width="14" viewBox="0 0 14 44" height="44">
                    <path d="m13.0729 17.6825a3.61 3.61 0 0 0 -1.7248 3.0365 3.5132 3.5132 0 0 0 2.1379 3.2223 8.394 8.394 0 0 1 -1.0948 2.2618c-.6816.9812-1.3943 1.9623-2.4787 1.9623s-1.3633-.63-2.613-.63c-1.2187 0-1.6525.6507-2.644.6507s-1.6834-.9089-2.4787-2.0243a9.7842 9.7842 0 0 1 -1.6628-5.2776c0-3.0984 2.014-4.7405 3.9969-4.7405 1.0535 0 1.9314.6919 2.5924.6919.63 0 1.6112-.7333 2.8092-.7333a3.7579 3.7579 0 0 1 3.1604 1.5802zm-3.7284-2.8918a3.5615 3.5615 0 0 0 .8469-2.22 1.5353 1.5353 0 0 0 -.031-.32 3.5686 3.5686 0 0 0 -2.3445 1.2084 3.4629 3.4629 0 0 0 -.8779 2.1585 1.419 1.419 0 0 0 .031.2892 1.19 1.19 0 0 0 .2169.0207 3.0935 3.0935 0 0 0 2.1586-1.1368z"></path>
                  </svg>
                </span>
                <span class="globalnav-image-compact globalnav-link-image">
                  <svg xmlns="http://www.w3.org/2000/svg" width="17" viewBox="0 0 17 48" height="48">
                    <path d="m15.5752 19.0792a4.2055 4.2055 0 0 0 -2.01 3.5376 4.0931 4.0931 0 0 0 2.4908 3.7542 9.7779 9.7779 0 0 1 -1.2755 2.6351c-.7941 1.1431-1.6244 2.2862-2.8878 2.2862s-1.5883-.734-3.0443-.734c-1.42 0-1.9252.7581-3.08.7581s-1.9611-1.0589-2.8876-2.3584a11.3987 11.3987 0 0 1 -1.9373-6.1487c0-3.61 2.3464-5.523 4.6566-5.523 1.2274 0 2.25.8062 3.02.8062.734 0 1.8771-.8543 3.2729-.8543a4.3778 4.3778 0 0 1 3.6822 1.841zm-6.8586-2.0456a1.3865 1.3865 0 0 1 -.2527-.024 1.6557 1.6557 0 0 1 -.0361-.337 4.0341 4.0341 0 0 1 1.0228-2.5148 4.1571 4.1571 0 0 1 2.7314-1.4078 1.7815 1.7815 0 0 1 .0361.373 4.1487 4.1487 0 0 1 -.9867 2.587 3.6039 3.6039 0 0 1 -2.5148 1.3236z"></path>
                  </svg>
                </span>
                <span class="globalnav-link-text">Apple</span>
              </a>
            </li>
            <li role="none" data-topnav-flyout-label="Menu" data-topnav-flyout-item="menu" class="globalnav-item globalnav-menu">
              <div data-topnav-flyout="menu" class="globalnav-flyout" style="--r-globalnav-flyout-item-total: 0; --r-globalnav-flyout-group-number: 0;">
                <div class="globalnav-menu-list" role="list" style="--r-globalnav-flyout-item-total: 10;">
                  <div class="globalnav-item globalnav-item-store globalnav-item-menu globalnav-item-submenu" role="listitem" style="--r-globalnav-flyout-item-number: 0;">
                    <ul role="none" class="globalnav-submenu-trigger-group">
                      <li class="globalnav-submenu-trigger-item">
                        <a class="globalnav-link globalnav-submenu-trigger-link globalnav-link-store" aria-label="Tienda" data-topnav-flyout-trigger-compact="" data-globalnav-item-name="store" href="https://www.apple.com/us/shop/goto/store" role="button" target="_blank">
                          <span class="globalnav-link-text-container">
                            <span class="globalnav-image-regular globalnav-link-image">
                              <svg xmlns="http://www.w3.org/2000/svg" width="30" viewBox="0 0 30 44" height="44">
                                <path d="m26.5679 20.4629c1.002 0 1.67.738 1.693 1.857h-3.48c.076-1.119.779-1.857 1.787-1.857zm2.754 2.672v-.387c0-1.963-1.037-3.176-2.742-3.176-1.735 0-2.848 1.289-2.848 3.276 0 1.998 1.096 3.263 2.848 3.263 1.383 0 2.367-.668 2.66-1.746h-1.008c-.264.557-.814.856-1.629.856-1.072 0-1.769-.791-1.822-2.039v-.047zm-9.547-3.451h.96v.937h.094c.188-.615.914-1.049 1.752-1.049.164 0 .375.012.504.03v1.007c-.082-.023-.445-.058-.644-.058-.961 0-1.659 1.098-1.659 1.535v3.914h-1.007zm-4.27 5.519c-1.195 0-1.869-.867-1.869-2.361 0-1.5.674-2.361 1.869-2.361 1.196 0 1.87.861 1.87 2.361 0 1.494-.674 2.361-1.87 2.361zm0-5.631c-1.798 0-2.912 1.237-2.912 3.27 0 2.027 1.114 3.269 2.912 3.269 1.799 0 2.913-1.242 2.913-3.269 0-2.033-1.114-3.27-2.913-3.27zm-5.478-1.475v1.635h1.407v.843h-1.407v3.575c0 .744.282 1.06.938 1.06.182 0 .281-.006.469-.023v.849c-.199.035-.393.059-.592.059-1.301 0-1.822-.481-1.822-1.688v-3.832h-1.02v-.843h1.02v-1.635zm-8.103 5.694c.129.885.973 1.447 2.174 1.447 1.137 0 1.975-.615 1.975-1.453 0-.72-.527-1.177-1.693-1.47l-1.084-.282c-1.53-.386-2.192-1.078-2.192-2.279 0-1.436 1.201-2.408 2.988-2.408 1.635 0 2.854.972 2.942 2.338h-1.061c-.146-.867-.861-1.383-1.916-1.383-1.125 0-1.869.562-1.869 1.418 0 .662.463 1.043 1.629 1.342l.885.234c1.752.439 2.455 1.119 2.455 2.361 0 1.553-1.225 2.543-3.158 2.543-1.793 0-3.03-.949-3.141-2.408z"></path>
                              </svg>
                            </span>
                            <span class="globalnav-link-text"><?php echo $LANGUAJE['FOOTER']; ?></span>
                          </span>
                          <span class="globalnav-link-chevron">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z"></path>
                            </svg>
                          </span>
                        </a>
                      </li>
                      <li class="globalnav-submenu-trigger-item">
                        <button id="globalnav-menubutton-link-store" class="globalnav-submenu-trigger-button" aria-expanded="false" aria-controls="globalnav-submenu-link-store" aria-label="Store menu" data-topnav-flyout-trigger-regular="true">
                          <span class="globalnav-image-regular globalnav-submenu-button-icon">
                            <svg height="10" viewBox="0 0 10 10" width="10" xmlns="http://www.w3.org/2000/svg">
                              <path d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z"></path>
                            </svg>
                          </span>
                          <span class="globalnav-image-compact globalnav-submenu-button-icon">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z"></path>
                            </svg>
                          </span>
                        </button>
                      </li>
                    </ul>
                  </div>
                  <div class="globalnav-item globalnav-item-mac globalnav-item-menu globalnav-item-submenu" role="listitem" style="--r-globalnav-flyout-item-number: 1;">
                    <ul role="none" class="globalnav-submenu-trigger-group">
                      <li class="globalnav-submenu-trigger-item">
                        <a class="globalnav-link globalnav-submenu-trigger-link globalnav-link-mac" aria-label="Mac menu" href="https://www.apple.com/mac/" role="button">
                          <span class="globalnav-link-text-container">
                            <span class="globalnav-image-regular globalnav-link-image">
                              <svg xmlns="http://www.w3.org/2000/svg" width="23" viewBox="0 0 23 44" height="44">
                                <path d="m8.1558 25.9987v-6.457h-.0703l-2.666 6.457h-.8907l-2.666-6.457h-.0703v6.457h-.9844v-8.4551h1.2246l2.8945 7.0547h.0938l2.8945-7.0547h1.2246v8.4551zm2.5166-1.7696c0-1.1309.832-1.7812 2.3027-1.8691l1.8223-.1113v-.5742c0-.7793-.4863-1.207-1.4297-1.207-.7559 0-1.2832.2871-1.4238.7852h-1.0195c.1348-1.0137 1.1309-1.6816 2.4785-1.6816 1.541 0 2.4023.791 2.4023 2.1035v4.3242h-.9609v-.9318h-.0938c-.4102.6738-1.1016 1.043-1.9453 1.043-1.2246 0-2.1328-.7266-2.1328-1.8809zm4.125-.5859v-.5801l-1.6992.1113c-.9609.0645-1.3828.3984-1.3828 1.0312 0 .6445.5449 1.0195 1.2773 1.0195 1.0371.0001 1.8047-.6796 1.8047-1.5819zm6.958-2.0273c-.1641-.627-.7207-1.1367-1.6289-1.1367-1.1367 0-1.8516.9082-1.8516 2.3379 0 1.459.7266 2.3848 1.8516 2.3848.8496 0 1.4414-.3926 1.6289-1.1074h1.0195c-.1816 1.1602-1.125 2.0156-2.6426 2.0156-1.7695 0-2.9004-1.2832-2.9004-3.293 0-1.9688 1.125-3.2461 2.8945-3.2461 1.5352 0 2.4727.9199 2.6484 2.0449z"></path>
                              </svg>
                            </span>
                            <span class="globalnav-link-text"><?php echo $LANGUAJE['FOOTER1']; ?></span>
                          </span>
                          <span class="globalnav-link-chevron">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z"></path>
                            </svg>
                          </span>
                        </a>
                      </li>
                      <li class="globalnav-submenu-trigger-item">
                        <button id="globalnav-menubutton-link-mac" class="globalnav-submenu-trigger-button" aria-expanded="false" aria-controls="globalnav-submenu-link-mac" aria-label="Mac menu" data-topnav-flyout-trigger-regular="true">
                          <span class="globalnav-image-regular globalnav-submenu-button-icon">
                            <svg height="10" viewBox="0 0 10 10" width="10" xmlns="http://www.w3.org/2000/svg">
                              <path d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z"></path>
                            </svg>
                          </span>
                          <span class="globalnav-image-compact globalnav-submenu-button-icon">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z"></path>
                            </svg>
                          </span>
                        </button>
                      </li>
                    </ul>
                  </div>
                  <div class="globalnav-item globalnav-item-ipad globalnav-item-menu globalnav-item-submenu" role="listitem" style="--r-globalnav-flyout-item-number: 2;">
                    <ul role="none" class="globalnav-submenu-trigger-group">
                      <li class="globalnav-submenu-trigger-item">
                        <a class="globalnav-link globalnav-submenu-trigger-link globalnav-link-ipad" aria-label="iPad menu" href="https://www.apple.com/ipad/" target="_blank" role="button">
                          <span class="globalnav-link-text-container">
                            <span class="globalnav-image-regular globalnav-link-image">
                              <svg xmlns="http://www.w3.org/2000/svg" width="24" viewBox="0 0 24 44" height="44">
                                <path d="m14.9575 23.7002c0 .902-.768 1.582-1.805 1.582-.732 0-1.277-.375-1.277-1.02 0-.632.422-.966 1.383-1.031l1.699-.111zm-1.395-4.072c-1.347 0-2.343.668-2.478 1.681h1.019c.141-.498.668-.785 1.424-.785.944 0 1.43.428 1.43 1.207v.574l-1.822.112c-1.471.088-2.303.738-2.303 1.869 0 1.154.908 1.881 2.133 1.881.844 0 1.535-.369 1.945-1.043h.094v.931h.961v-4.324c0-1.312-.862-2.103-2.403-2.103zm6.769 5.575c-1.155 0-1.846-.885-1.846-2.361 0-1.471.697-2.362 1.846-2.362 1.142 0 1.857.914 1.857 2.362 0 1.459-.709 2.361-1.857 2.361zm1.834-8.027v3.503h-.088c-.358-.691-1.102-1.107-1.981-1.107-1.605 0-2.654 1.289-2.654 3.27 0 1.986 1.037 3.269 2.654 3.269.873 0 1.623-.416 2.022-1.119h.093v1.008h.961v-8.824zm-15.394 4.869h-1.863v-3.563h1.863c1.225 0 1.899.639 1.899 1.799 0 1.119-.697 1.764-1.899 1.764zm.276-4.5h-3.194v8.455h1.055v-3.018h2.127c1.588 0 2.719-1.119 2.719-2.701 0-1.611-1.108-2.736-2.707-2.736zm-6.064 8.454h1.008v-6.316h-1.008zm-.199-8.237c0-.387.316-.704.703-.704s.703.317.703.704c0 .386-.316.703-.703.703s-.703-.317-.703-.703z"></path>
                              </svg>
                            </span>
                            <span class="globalnav-link-text"><?php echo $LANGUAJE['FOOTER2']; ?></span>
                          </span>
                          <span class="globalnav-link-chevron">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z"></path>
                            </svg>
                          </span>
                        </a>
                      </li>
                      <li class="globalnav-submenu-trigger-item">
                        <button id="globalnav-menubutton-link-ipad" class="globalnav-submenu-trigger-button" aria-expanded="false" aria-controls="globalnav-submenu-link-ipad" aria-label="iPad menu" data-topnav-flyout-trigger-regular="true">
                          <span class="globalnav-image-regular globalnav-submenu-button-icon">
                            <svg height="10" viewBox="0 0 10 10" width="10" xmlns="http://www.w3.org/2000/svg">
                              <path d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z"></path>
                            </svg>
                          </span>
                          <span class="globalnav-image-compact globalnav-submenu-button-icon">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z"></path>
                            </svg>
                          </span>
                        </button>
                      </li>
                    </ul>
                  </div>
                  <div class="globalnav-item globalnav-item-iphone globalnav-item-menu globalnav-item-submenu" role="listitem" style="--r-globalnav-flyout-item-number: 3;">
                    <ul role="none" class="globalnav-submenu-trigger-group">
                      <li class="globalnav-submenu-trigger-item">
                        <a class="globalnav-link globalnav-submenu-trigger-link globalnav-link-iphone" aria-label="iPhone menu" href="https://www.apple.com/iphone/" target="_blank" role="button">
                          <span class="globalnav-link-text-container">
                            <span class="globalnav-image-regular globalnav-link-image">
                              <svg xmlns="http://www.w3.org/2000/svg" width="38" viewBox="0 0 38 44" height="44">
                                <path d="m32.7129 22.3203h3.48c-.023-1.119-.691-1.857-1.693-1.857-1.008 0-1.711.738-1.787 1.857zm4.459 2.045c-.293 1.078-1.277 1.746-2.66 1.746-1.752 0-2.848-1.266-2.848-3.264 0-1.986 1.113-3.275 2.848-3.275 1.705 0 2.742 1.213 2.742 3.176v.386h-4.541v.047c.053 1.248.75 2.039 1.822 2.039.815 0 1.366-.298 1.629-.855zm-12.282-4.682h.961v.996h.094c.316-.697.932-1.107 1.898-1.107 1.418 0 2.209.838 2.209 2.338v4.09h-1.007v-3.844c0-1.137-.481-1.676-1.489-1.676s-1.658.674-1.658 1.781v3.739h-1.008zm-2.499 3.158c0-1.5-.674-2.361-1.869-2.361-1.196 0-1.87.861-1.87 2.361 0 1.495.674 2.362 1.87 2.362 1.195 0 1.869-.867 1.869-2.362zm-4.782 0c0-2.033 1.114-3.269 2.913-3.269 1.798 0 2.912 1.236 2.912 3.269 0 2.028-1.114 3.27-2.912 3.27-1.799 0-2.913-1.242-2.913-3.27zm-6.636-5.666h1.008v3.504h.093c.317-.697.979-1.107 1.946-1.107 1.336 0 2.179.855 2.179 2.338v4.09h-1.007v-3.844c0-1.119-.504-1.676-1.459-1.676-1.131 0-1.752.715-1.752 1.781v3.739h-1.008zm-6.015 4.87h1.863c1.202 0 1.899-.645 1.899-1.764 0-1.16-.674-1.799-1.899-1.799h-1.863zm2.139-4.5c1.599 0 2.707 1.125 2.707 2.736 0 1.582-1.131 2.701-2.719 2.701h-2.127v3.018h-1.055v-8.455zm-6.114 8.454h1.008v-6.316h-1.008zm-.2-8.238c0-.386.317-.703.703-.703.387 0 .704.317.704.703 0 .387-.317.704-.704.704-.386 0-.703-.317-.703-.704z"></path>
                              </svg>
                            </span>
                            <span class="globalnav-link-text"><?php echo $LANGUAJE['FOOTER3']; ?></span>
                          </span>
                          <span class="globalnav-link-chevron">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z"></path>
                            </svg>
                          </span>
                        </a>
                      </li>
                      <li class="globalnav-submenu-trigger-item">
                        <button id="globalnav-menubutton-link-iphone" class="globalnav-submenu-trigger-button" aria-expanded="false" aria-controls="globalnav-submenu-link-iphone" aria-label="iPhone menu" data-topnav-flyout-trigger-regular="true">
                          <span class="globalnav-image-regular globalnav-submenu-button-icon">
                            <svg height="10" viewBox="0 0 10 10" width="10" xmlns="http://www.w3.org/2000/svg">
                              <path d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z"></path>
                            </svg>
                          </span>
                          <span class="globalnav-image-compact globalnav-submenu-button-icon">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z"></path>
                            </svg>
                          </span>
                        </button>
                      </li>
                    </ul>
                  </div>
                  <div class="globalnav-item globalnav-item-watch globalnav-item-menu globalnav-item-submenu" role="listitem" style="--r-globalnav-flyout-item-number: 4;">
                    <ul role="none" class="globalnav-submenu-trigger-group">
                      <li class="globalnav-submenu-trigger-item">
                        <a class="globalnav-link globalnav-submenu-trigger-link globalnav-link-watch" aria-label="Watch menu" href="https://www.apple.com/watch/" role="button" target="_blank">
                          <span class="globalnav-link-text-container">
                            <span class="globalnav-image-regular globalnav-link-image">
                              <svg xmlns="http://www.w3.org/2000/svg" width="35" viewBox="0 0 35 44" height="44">
                                <path d="m28.9819 17.1758h1.008v3.504h.094c.316-.697.978-1.108 1.945-1.108 1.336 0 2.18.856 2.18 2.338v4.09h-1.008v-3.844c0-1.119-.504-1.675-1.459-1.675-1.131 0-1.752.715-1.752 1.781v3.738h-1.008zm-2.42 4.441c-.164-.627-.721-1.136-1.629-1.136-1.137 0-1.852.908-1.852 2.338 0 1.459.727 2.384 1.852 2.384.849 0 1.441-.392 1.629-1.107h1.019c-.182 1.16-1.125 2.016-2.642 2.016-1.77 0-2.901-1.284-2.901-3.293 0-1.969 1.125-3.247 2.895-3.247 1.535 0 2.472.92 2.648 2.045zm-6.533-3.568v1.635h1.407v.844h-1.407v3.574c0 .744.282 1.06.938 1.06.182 0 .281-.006.469-.023v.85c-.2.035-.393.058-.592.058-1.301 0-1.822-.48-1.822-1.687v-3.832h-1.02v-.844h1.02v-1.635zm-4.2 5.596v-.58l-1.699.111c-.961.064-1.383.398-1.383 1.031 0 .645.545 1.02 1.277 1.02 1.038 0 1.805-.68 1.805-1.582zm-4.125.586c0-1.131.832-1.782 2.303-1.869l1.822-.112v-.574c0-.779-.486-1.207-1.43-1.207-.755 0-1.283.287-1.423.785h-1.02c.135-1.014 1.131-1.682 2.479-1.682 1.541 0 2.402.792 2.402 2.104v4.324h-.961v-.931h-.094c-.41.673-1.101 1.043-1.945 1.043-1.225 0-2.133-.727-2.133-1.881zm-7.684 1.769h-.996l-2.303-8.455h1.101l1.682 6.873h.07l1.893-6.873h1.066l1.893 6.873h.07l1.682-6.873h1.101l-2.302 8.455h-.996l-1.946-6.674h-.07z"></path>
                              </svg>
                            </span>
                            <span class="globalnav-link-text"><?php echo $LANGUAJE['FOOTER4']; ?></span>
                          </span>
                          <span class="globalnav-link-chevron">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z"></path>
                            </svg>
                          </span>
                        </a>
                      </li>
                      <li class="globalnav-submenu-trigger-item">
                        <button id="globalnav-menubutton-link-watch" class="globalnav-submenu-trigger-button" aria-expanded="false" aria-controls="globalnav-submenu-link-watch" aria-label="Watch menu" data-topnav-flyout-trigger-regular="true">
                          <span class="globalnav-image-regular globalnav-submenu-button-icon">
                            <svg height="10" viewBox="0 0 10 10" width="10" xmlns="http://www.w3.org/2000/svg">
                              <path d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z"></path>
                            </svg>
                          </span>
                          <span class="globalnav-image-compact globalnav-submenu-button-icon">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z"></path>
                            </svg>
                          </span>
                        </button>
                      </li>
                    </ul>
                  </div>
                  <div class="globalnav-item globalnav-item-airpods globalnav-item-menu globalnav-item-submenu" role="listitem" style="--r-globalnav-flyout-item-number: 5;">
                    <ul role="none" class="globalnav-submenu-trigger-group">
                      <li class="globalnav-submenu-trigger-item">
                        <a class="globalnav-link globalnav-submenu-trigger-link globalnav-link-airpods" aria-label="AirPods menu" href="https://www.apple.com/airpods/" role="button" target="_blank">
                          <span class="globalnav-link-text-container">
                            <span class="globalnav-image-regular globalnav-link-image">
                              <svg xmlns="http://www.w3.org/2000/svg" width="43" viewBox="0 0 43 44" height="44">
                                <path d="m11.7153 19.6836h.961v.937h.094c.187-.615.914-1.048 1.752-1.048.164 0 .375.011.504.029v1.008c-.082-.024-.446-.059-.645-.059-.961 0-1.658.645-1.658 1.535v3.914h-1.008zm28.135-.111c1.324 0 2.244.656 2.379 1.693h-.996c-.135-.504-.627-.838-1.389-.838-.75 0-1.336.381-1.336.943 0 .434.352.704 1.096.885l.973.235c1.189.287 1.763.802 1.763 1.711 0 1.13-1.095 1.91-2.531 1.91-1.406 0-2.373-.674-2.484-1.723h1.037c.17.533.674.873 1.482.873.85 0 1.459-.404 1.459-.984 0-.434-.328-.727-1.002-.891l-1.084-.264c-1.183-.287-1.722-.796-1.722-1.71 0-1.049 1.013-1.84 2.355-1.84zm-6.665 5.631c-1.155 0-1.846-.885-1.846-2.362 0-1.471.697-2.361 1.846-2.361 1.142 0 1.857.914 1.857 2.361 0 1.459-.709 2.362-1.857 2.362zm1.834-8.028v3.504h-.088c-.358-.691-1.102-1.107-1.981-1.107-1.605 0-2.654 1.289-2.654 3.269 0 1.987 1.037 3.27 2.654 3.27.873 0 1.623-.416 2.022-1.119h.094v1.007h.961v-8.824zm-9.001 8.028c-1.195 0-1.869-.868-1.869-2.362 0-1.5.674-2.361 1.869-2.361 1.196 0 1.869.861 1.869 2.361 0 1.494-.673 2.362-1.869 2.362zm0-5.631c-1.799 0-2.912 1.236-2.912 3.269 0 2.028 1.113 3.27 2.912 3.27s2.912-1.242 2.912-3.27c0-2.033-1.113-3.269-2.912-3.269zm-17.071 6.427h1.008v-6.316h-1.008zm-.199-8.238c0-.387.317-.703.703-.703.387 0 .703.316.703.703s-.316.703-.703.703c-.386 0-.703-.316-.703-.703zm-6.137 4.922 1.324-3.773h.093l1.325 3.773zm1.892-5.139h-1.043l-3.117 8.455h1.107l.85-2.42h3.363l.85 2.42h1.107zm14.868 4.5h-1.864v-3.562h1.864c1.224 0 1.898.639 1.898 1.799 0 1.119-.697 1.763-1.898 1.763zm.275-4.5h-3.193v8.455h1.054v-3.017h2.127c1.588 0 2.719-1.119 2.719-2.701 0-1.612-1.107-2.737-2.707-2.737z"></path>
                              </svg>
                            </span>
                            <span class="globalnav-link-text"><?php echo $LANGUAJE['FOOTER5']; ?></span>
                          </span>
                          <span class="globalnav-link-chevron">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z"></path>
                            </svg>
                          </span>
                        </a>
                      </li>
                      <li class="globalnav-submenu-trigger-item">
                        <button id="globalnav-menubutton-link-airpods" class="globalnav-submenu-trigger-button" aria-expanded="false" aria-controls="globalnav-submenu-link-airpods" aria-label="AirPods menu" data-topnav-flyout-trigger-regular="true">
                          <span class="globalnav-image-regular globalnav-submenu-button-icon">
                            <svg height="10" viewBox="0 0 10 10" width="10" xmlns="http://www.w3.org/2000/svg">
                              <path d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z"></path>
                            </svg>
                          </span>
                          <span class="globalnav-image-compact globalnav-submenu-button-icon">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z"></path>
                            </svg>
                          </span>
                        </button>
                      </li>
                    </ul>
                  </div>
                  <div class="globalnav-item globalnav-item-tv-home globalnav-item-menu globalnav-item-submenu" role="listitem" style="--r-globalnav-flyout-item-number: 6;">
                    <ul role="none" class="globalnav-submenu-trigger-group">
                      <li class="globalnav-submenu-trigger-item">
                        <a class="globalnav-link globalnav-submenu-trigger-link globalnav-link-tv-home" aria-label="TV y Casa" href="https://www.apple.com/tv-home/" role="button" target="_blank">
                          <span class="globalnav-link-text-container">
                            <span class="globalnav-image-regular globalnav-link-image">
                              <svg xmlns="http://www.w3.org/2000/svg" width="65" viewBox="0 0 65 44" height="44">
                                <path d="m4.3755 26v-7.5059h-2.7246v-.9492h6.5039v.9492h-2.7246v7.5059zm7.7314 0-3.1172-8.4551h1.1074l2.4844 7.0898h.0938l2.4844-7.0898h1.1074l-3.1172 8.4551zm13.981-.8438c-.7207.6328-1.7109 1.002-2.7363 1.002-1.6816 0-2.8594-.9961-2.8594-2.4141 0-1.002.5449-1.7637 1.6758-2.3613.0762-.0352.2344-.1172.3281-.1641-.7793-.8203-1.0605-1.3652-1.0605-1.9805 0-1.084.9199-1.8926 2.1562-1.8926 1.248 0 2.1562.7969 2.1562 1.9043 0 .8672-.5215 1.5-1.8281 2.1855l2.1152 2.2734c.2637-.5273.3984-1.2188.3984-2.2734v-.1465h.9844v.1523c0 1.3125-.2344 2.2676-.6973 2.9824l1.4708 1.5764h-1.3242zm-4.541-1.4824c0 .9492.7676 1.5938 1.8984 1.5938.7676 0 1.5586-.3047 2.0215-.791l-2.3906-2.6133c-.0645.0234-.2168.0996-.2988.1406-.8145.4219-1.2305 1.0078-1.2305 1.6699zm3.2109-4.3886c0-.6562-.4746-1.1016-1.1602-1.1016-.6738 0-1.1543.457-1.1543 1.1133 0 .4688.2402.8789.9082 1.541 1.0313-.5274 1.4063-.9492 1.4063-1.5527zm13.5176 6.7148v-3.8496h-4.6406v3.8496h-1.0547v-8.4551h1.0547v3.6562h4.6406v-3.6562h1.0547v8.4551zm2.6455-3.1582c0-2.0332 1.1133-3.2695 2.9121-3.2695s2.9121 1.2363 2.9121 3.2695c0 2.0273-1.1133 3.2695-2.9121 3.2695s-2.9121-1.2422-2.9121-3.2695zm4.7812 0c0-1.5-.6738-2.3613-1.8691-2.3613s-1.8691.8613-1.8691 2.3613c0 1.4941.6738 2.3613 1.8691 2.3613s1.8691-.8672 1.8691-2.3613zm2.5054-3.1582h.9609v.9961h.0938c.2871-.7031.9199-1.1074 1.7637-1.1074.8555 0 1.4531.4512 1.7461 1.1074h.0938c.3398-.668 1.0605-1.1074 1.9336-1.1074 1.2891 0 2.0098.7383 2.0098 2.0625v4.3652h-1.0078v-4.1309c0-.9316-.4395-1.3887-1.3301-1.3887-.8789 0-1.4648.6562-1.4648 1.459v4.0606h-1.0078v-4.2891c0-.75-.5215-1.2305-1.3184-1.2305-.8262 0-1.4648.7148-1.4648 1.6055v3.9141h-1.0078v-6.3164zm15.5127 4.6816c-.293 1.0781-1.2773 1.7461-2.6602 1.7461-1.752 0-2.8477-1.2656-2.8477-3.2637 0-1.9863 1.1133-3.2754 2.8477-3.2754 1.7051 0 2.7422 1.2129 2.7422 3.1758v.3867h-4.541v.0469c.0527 1.248.75 2.0391 1.8223 2.0391.8145 0 1.3652-.2988 1.6289-.8555zm-4.459-2.0449h3.4805c-.0234-1.1191-.6914-1.8574-1.6934-1.8574-1.0078 0-1.7109.7383-1.7871 1.8574z"></path>
                              </svg>
                            </span>
                            <span class="globalnav-link-text"><?php echo $LANGUAJE['FOOTER6']; ?></span>
                          </span>
                          <span class="globalnav-link-chevron">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z"></path>
                            </svg>
                          </span>
                        </a>
                      </li>
                      <li class="globalnav-submenu-trigger-item">
                        <button id="globalnav-menubutton-link-tv-home" class="globalnav-submenu-trigger-button" aria-expanded="false" aria-controls="globalnav-submenu-link-tv-home" aria-label="TV and Home menu" data-topnav-flyout-trigger-regular="true">
                          <span class="globalnav-image-regular globalnav-submenu-button-icon">
                            <svg height="10" viewBox="0 0 10 10" width="10" xmlns="http://www.w3.org/2000/svg">
                              <path d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z"></path>
                            </svg>
                          </span>
                          <span class="globalnav-image-compact globalnav-submenu-button-icon">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z"></path>
                            </svg>
                          </span>
                        </button>
                      </li>
                    </ul>
                  </div>
                  <div class="globalnav-item globalnav-item-accessories globalnav-item-menu globalnav-item-submenu" role="listitem" style="--r-globalnav-flyout-item-number: 8;">
                    <ul role="none" class="globalnav-submenu-trigger-group">
                      <li class="globalnav-submenu-trigger-item">
                        <a class="globalnav-link globalnav-submenu-trigger-link globalnav-link-accessories" aria-label="Accesorios" href="https://www.apple.com/us/shop/goto/buy_accessories" role="button" target="_blank">
                          <span class="globalnav-link-text-container">
                            <span class="globalnav-image-regular globalnav-link-image">
                              <svg xmlns="http://www.w3.org/2000/svg" width="67" viewBox="0 0 67 44" height="44">
                                <path d="m5.6603 23.5715h-3.3633l-.8496 2.4199h-1.1074l3.1172-8.4551h1.043l3.1172 8.4551h-1.1075zm-3.0527-.8965h2.7422l-1.3242-3.7734h-.0938zm10.0986-1.0664c-.1641-.627-.7207-1.1367-1.6289-1.1367-1.1367 0-1.8516.9082-1.8516 2.3379 0 1.459.7266 2.3848 1.8516 2.3848.8496 0 1.4414-.3926 1.6289-1.1074h1.0195c-.1816 1.1602-1.125 2.0156-2.6426 2.0156-1.7695 0-2.9004-1.2832-2.9004-3.293 0-1.9688 1.125-3.2461 2.8945-3.2461 1.5352 0 2.4727.9199 2.6484 2.0449zm6.5947 0c-.1641-.627-.7207-1.1367-1.6289-1.1367-1.1367 0-1.8516.9082-1.8516 2.3379 0 1.459.7266 2.3848 1.8516 2.3848.8496 0 1.4414-.3926 1.6289-1.1074h1.0195c-.1816 1.1602-1.125 2.0156-2.6426 2.0156-1.7695 0-2.9004-1.2832-2.9004-3.293 0-1.9688 1.125-3.2461 2.8945-3.2461 1.5352 0 2.4727.9199 2.6484 2.0449zm7.5796 2.748c-.293 1.0781-1.2773 1.7461-2.6602 1.7461-1.752 0-2.8477-1.2656-2.8477-3.2637 0-1.9863 1.1133-3.2754 2.8477-3.2754 1.7051 0 2.7422 1.2129 2.7422 3.1758v.3867h-4.541v.0469c.0527 1.248.75 2.0391 1.8223 2.0391.8145 0 1.3652-.2988 1.6289-.8555zm-4.459-2.0449h3.4805c-.0234-1.1191-.6914-1.8574-1.6934-1.8574-1.0078 0-1.7109.7383-1.7871 1.8574zm8.212-2.748c1.3242 0 2.2441.6562 2.3789 1.6934h-.9961c-.1348-.5039-.627-.8379-1.3887-.8379-.75 0-1.3359.3809-1.3359.9434 0 .4336.3516.7031 1.0957.8848l.9727.2344c1.1895.2871 1.7637.8027 1.7637 1.7109 0 1.1309-1.0957 1.9102-2.5312 1.9102-1.4062 0-2.373-.6738-2.4844-1.7227h1.0371c.1699.5332.6738.873 1.4824.873.8496 0 1.459-.4043 1.459-.9844 0-.4336-.3281-.7266-1.002-.8906l-1.084-.2637c-1.1836-.2871-1.7227-.7969-1.7227-1.7109 0-1.0489 1.0137-1.8399 2.3555-1.8399zm6.0439 0c1.3242 0 2.2441.6562 2.3789 1.6934h-.9961c-.1348-.5039-.627-.8379-1.3887-.8379-.75 0-1.3359.3809-1.3359.9434 0 .4336.3516.7031 1.0957.8848l.9727.2344c1.1895.2871 1.7637.8027 1.7637 1.7109 0 1.1309-1.0957 1.9102-2.5312 1.9102-1.4062 0-2.373-.6738-2.4844-1.7227h1.0371c.1699.5332.6738.873 1.4824.873.8496 0 1.459-.4043 1.459-.9844 0-.4336-.3281-.7266-1.002-.8906l-1.084-.2637c-1.1836-.2871-1.7227-.7969-1.7227-1.7109 0-1.0489 1.0137-1.8399 2.3555-1.8399zm3.6357 3.2695c0-2.0332 1.1133-3.2695 2.9121-3.2695s2.9121 1.2363 2.9121 3.2695c0 2.0273-1.1133 3.2695-2.9121 3.2695s-2.9121-1.2422-2.9121-3.2695zm4.7813 0c0-1.5-.6738-2.3613-1.8691-2.3613s-1.8691.8613-1.8691 2.3613c0 1.4941.6738 2.3613 1.8691 2.3613s1.8691-.8672 1.8691-2.3613zm2.5054-3.1582h.9609v.9375h.0938c.1875-.6152.9141-1.0488 1.752-1.0488.1641 0 .375.0117.5039.0293v1.0078c-.082-.0234-.4453-.0586-.6445-.0586-.9609 0-1.6582.6445-1.6582 1.5352v3.9141h-1.0078v-6.3165zm4.2744-1.9219c0-.3867.3164-.7031.7031-.7031s.7031.3164.7031.7031-.3164.7031-.7031.7031-.7031-.3164-.7031-.7031zm.1992 1.9219h1.0078v6.3164h-1.0078zm8.001 4.6816c-.293 1.0781-1.2773 1.7461-2.6602 1.7461-1.752 0-2.8477-1.2656-2.8477-3.2637 0-1.9863 1.1133-3.2754 2.8477-3.2754 1.7051 0 2.7422 1.2129 2.7422 3.1758v.3867h-4.541v.0469c.0527 1.248.75 2.0391 1.8223 2.0391.8145 0 1.3652-.2988 1.6289-.8555zm-4.459-2.0449h3.4805c-.0234-1.1191-.6914-1.8574-1.6934-1.8574-1.0078 0-1.7109.7383-1.7871 1.8574zm8.2119-2.748c1.3242 0 2.2441.6562 2.3789 1.6934h-.9961c-.1348-.5039-.627-.8379-1.3887-.8379-.75 0-1.3359.3809-1.3359.9434 0 .4336.3516.7031 1.0957.8848l.9727.2344c1.1895.2871 1.7637.8027 1.7637 1.7109 0 1.1309-1.0957 1.9102-2.5312 1.9102-1.4062 0-2.373-.6738-2.4844-1.7227h1.0371c.1699.5332.6738.873 1.4824.873.8496 0 1.459-.4043 1.459-.9844 0-.4336-.3281-.7266-1.002-.8906l-1.084-.2637c-1.1836-.2871-1.7227-.7969-1.7227-1.7109 0-1.0489 1.0137-1.8399 2.3555-1.8399z"></path>
                              </svg>
                            </span>
                            <span class="globalnav-link-text"><?php echo $LANGUAJE['FOOTER7']; ?></span>
                          </span>
                          <span class="globalnav-link-chevron">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z"></path>
                            </svg>
                          </span>
                        </a>
                      </li>
                      <li class="globalnav-submenu-trigger-item">
                        <button id="globalnav-menubutton-link-accessories" class="globalnav-submenu-trigger-button" aria-expanded="false" aria-controls="globalnav-submenu-link-accessories" aria-label="Accessories menu" data-topnav-flyout-trigger-regular="true">
                          <span class="globalnav-image-regular globalnav-submenu-button-icon">
                            <svg height="10" viewBox="0 0 10 10" width="10" xmlns="http://www.w3.org/2000/svg">
                              <path d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z"></path>
                            </svg>
                          </span>
                          <span class="globalnav-image-compact globalnav-submenu-button-icon">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z"></path>
                            </svg>
                          </span>
                        </button>
                      </li>
                    </ul>
                  </div>
                  <div class="globalnav-item globalnav-item-support globalnav-item-menu globalnav-item-submenu" role="listitem" style="--r-globalnav-flyout-item-number: 9;">
                    <ul role="none" class="globalnav-submenu-trigger-group">
                      <li class="globalnav-submenu-trigger-item">
                        <a class="globalnav-link globalnav-submenu-trigger-link globalnav-link-support" aria-label="Soporte" href="https://support.apple.com" role="button" target="_blank">
                          <span class="globalnav-link-text-container">
                            <span class="globalnav-image-regular globalnav-link-image">
                              <svg xmlns="http://www.w3.org/2000/svg" width="44" viewBox="0 0 44 44" height="44">
                                <path d="m42.1206 18.0337v1.635h1.406v.844h-1.406v3.574c0 .744.281 1.06.937 1.06.182 0 .282-.006.469-.023v.849c-.199.036-.392.059-.592.059-1.3 0-1.822-.48-1.822-1.687v-3.832h-1.019v-.844h1.019v-1.635zm-6.131 1.635h.961v.937h.093c.188-.615.914-1.049 1.752-1.049.164 0 .375.012.504.03v1.008c-.082-.024-.445-.059-.644-.059-.961 0-1.659.644-1.659 1.535v3.914h-1.007zm-2.463 3.158c0-1.5-.674-2.361-1.869-2.361s-1.869.861-1.869 2.361c0 1.494.674 2.361 1.869 2.361s1.869-.867 1.869-2.361zm-4.781 0c0-2.033 1.113-3.27 2.912-3.27s2.912 1.237 2.912 3.27c0 2.027-1.113 3.27-2.912 3.27s-2.912-1.243-2.912-3.27zm-2.108 0c0-1.477-.692-2.361-1.846-2.361-1.143 0-1.863.908-1.863 2.361 0 1.447.72 2.361 1.857 2.361 1.16 0 1.852-.884 1.852-2.361zm1.043 0c0 1.975-1.049 3.27-2.655 3.27-.902 0-1.629-.393-1.974-1.061h-.094v3.059h-1.008v-8.426h.961v1.054h.094c.404-.726 1.16-1.166 2.021-1.166 1.612 0 2.655 1.284 2.655 3.27zm-8.048 0c0-1.477-.691-2.361-1.845-2.361-1.143 0-1.864.908-1.864 2.361 0 1.447.721 2.361 1.858 2.361 1.16 0 1.851-.884 1.851-2.361zm1.043 0c0 1.975-1.049 3.27-2.654 3.27-.902 0-1.629-.393-1.975-1.061h-.093v3.059h-1.008v-8.426h.961v1.054h.093c.405-.726 1.161-1.166 2.022-1.166 1.611 0 2.654 1.284 2.654 3.27zm-7.645 3.158h-.961v-.99h-.094c-.316.703-.99 1.102-1.957 1.102-1.418 0-2.156-.844-2.156-2.338v-4.09h1.008v3.844c0 1.136.422 1.664 1.43 1.664 1.113 0 1.722-.663 1.722-1.77v-3.738h1.008zm-11.69-2.209c.129.885.972 1.447 2.174 1.447 1.136 0 1.974-.615 1.974-1.453 0-.72-.527-1.177-1.693-1.47l-1.084-.282c-1.529-.386-2.192-1.078-2.192-2.279 0-1.435 1.202-2.408 2.989-2.408 1.634 0 2.853.973 2.941 2.338h-1.06c-.147-.867-.862-1.383-1.916-1.383-1.125 0-1.87.562-1.87 1.418 0 .662.463 1.043 1.629 1.342l.885.234c1.752.44 2.455 1.119 2.455 2.361 0 1.553-1.224 2.543-3.158 2.543-1.793 0-3.029-.949-3.141-2.408z"></path>
                              </svg>
                            </span>
                            <span class="globalnav-link-text"><?php echo $LANGUAJE['FOOTER8']; ?></span>
                          </span>
                          <span class="globalnav-link-chevron">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m8.1155 30.358a.6.6 0 1 1 -.831.8653l-7-6.7242a.6.6 0 0 1 -.0045-.8613l7-6.8569a.6.6 0 1 1 .84.8574l-6.5582 6.4238z"></path>
                            </svg>
                          </span>
                        </a>
                      </li>
                      <li class="globalnav-submenu-trigger-item">
                        <button id="globalnav-menubutton-link-support" class="globalnav-submenu-trigger-button" aria-expanded="false" aria-controls="globalnav-submenu-link-support" aria-label="Support menu">
                          <span class="globalnav-image-regular globalnav-submenu-button-icon">
                            <svg height="10" viewBox="0 0 10 10" width="10" xmlns="http://www.w3.org/2000/svg">
                              <path d="m4.6725 6.635-2.655-2.667a.445.445 0 0 1 -.123-.304.4331.4331 0 0 1 .427-.439h.006a.447.447 0 0 1 .316.135l2.357 2.365 2.356-2.365a.458.458 0 0 1 .316-.135.433.433 0 0 1 .433.433v.006a.4189.4189 0 0 1 -.123.3l-2.655 2.671a.4451.4451 0 0 1 -.327.14.464.464 0 0 1 -.328-.14z"></path>
                            </svg>
                          </span>
                          <span class="globalnav-image-compact globalnav-submenu-button-icon">
                            <svg height="48" viewBox="0 0 9 48" width="9" xmlns="http://www.w3.org/2000/svg">
                              <path d="m7.4382 24.0621-6.5581-6.4238c-.2368-.2319-.2407-.6118-.0088-.8486.2324-.2373.6123-.2407.8486-.0088l7 6.8569c.1157.1138.1807.2695.1802.4316-.001.1621-.0674.3174-.1846.4297l-7 6.7242c-.1162.1118-.2661.1675-.4155.1675-.1577 0-.3149-.062-.4326-.1846-.2295-.2388-.2222-.6187.0171-.8481l6.5537-6.2959z"></path>
                            </svg>
                          </span>
                        </button>
                      </li>
                    </ul>
                  </div>
                </div>
              </div>
            </li>
            <li id="globalnav-bag" class="globalnav-item globalnav-bag">
              <div class="globalnav-bag-wrapper">
                <a class="globalnav-link globalnav-link-bag" aria-label="Shopping Bag" href="https://www.apple.com/us/shop/goto/bag" id="globalnav-menubutton-link-bag" role="button" target="_blank">
                  <span class="globalnav-image-regular">
                    <svg xmlns="http://www.w3.org/2000/svg" width="14" viewBox="0 0 14 44" height="44">
                      <path d="m11.3535 16.0283h-1.0205a3.4229 3.4229 0 0 0 -3.333-2.9648 3.4229 3.4229 0 0 0 -3.333 2.9648h-1.02a2.1184 2.1184 0 0 0 -2.117 2.1162v7.7155a2.1186 2.1186 0 0 0 2.1162 2.1167h8.707a2.1186 2.1186 0 0 0 2.1168-2.1167v-7.7155a2.1184 2.1184 0 0 0 -2.1165-2.1162zm-4.3535-1.8652a2.3169 2.3169 0 0 1 2.2222 1.8652h-4.4444a2.3169 2.3169 0 0 1 2.2222-1.8652zm5.37 11.6969a1.0182 1.0182 0 0 1 -1.0166 1.0171h-8.7069a1.0182 1.0182 0 0 1 -1.0165-1.0171v-7.7155a1.0178 1.0178 0 0 1 1.0166-1.0166h8.707a1.0178 1.0178 0 0 1 1.0164 1.0166z"></path>
                    </svg>
                  </span>
                  <span class="globalnav-image-compact">
                    <svg xmlns="http://www.w3.org/2000/svg" width="17" viewBox="0 0 17 48" height="48">
                      <path d="m13.4575 16.9268h-1.1353a3.8394 3.8394 0 0 0 -7.6444 0h-1.1353a2.6032 2.6032 0 0 0 -2.6 2.6v8.9232a2.6032 2.6032 0 0 0 2.6 2.6h9.915a2.6032 2.6032 0 0 0 2.6-2.6v-8.9231a2.6032 2.6032 0 0 0 -2.6-2.6001zm-4.9575-2.2768a2.658 2.658 0 0 1 2.6221 2.2764h-5.2442a2.658 2.658 0 0 1 2.6221-2.2764zm6.3574 13.8a1.4014 1.4014 0 0 1 -1.4 1.4h-9.9149a1.4014 1.4014 0 0 1 -1.4-1.4v-8.9231a1.4014 1.4014 0 0 1 1.4-1.4h9.915a1.4014 1.4014 0 0 1 1.4 1.4z"></path>
                    </svg>
                  </span>
                </a>
                <span aria-hidden="true" class="globalnav-bag-badge">
                  <span class="globalnav-bag-badge-separator"></span>
                  <span class="globalnav-bag-badge-number">0</span>
                  <span class="globalnav-bag-badge-unit">+</span>
                </span>
              </div>
              <div aria-labelledby="globalnav-menubutton-link-bag" class="globalnav-flyout globalnav-submenu" id="globalnav-submenu-bag" style="--r-globalnav-flyout-item-total: 0; --r-globalnav-flyout-group-number: 0;">
                <div class="globalnav-flyout-scroll-container">
                  <div class="globalnav-flyout-content globalnav-submenu-content"></div>
                </div>
              </div>
            </li>
          </ul>
          <div class="globalnav-menutrigger">
            <button aria-label="Menu" aria-controls="globalnav-list" class="globalnav-menutrigger-button" id="globalnav-menutrigger-button">
              <svg viewBox="0 0 18 18" height="18" width="18">
                <polyline points="2 12, 16 12" stroke-linejoin="round" stroke-linecap="round" stroke-width="1.2" stroke="currentColor" fill="none" class="globalnav-menutrigger-bread globalnav-menutrigger-bread-bottom" id="globalnav-menutrigger-bread-bottom">
                  <animate id="globalnav-anim-menutrigger-bread-bottom-open" attributeName="points" keyTimes="0;0.5;1" dur="0.24s" begin="indefinite" fill="freeze" calcMode="spline" keySplines="0.42, 0, 1, 1;0, 0, 0.58, 1" values=" 2 12, 16 12; 2 9, 16 9; 3.5 15, 15 3.5"></animate>
                  <animate id="globalnav-anim-menutrigger-bread-bottom-close" attributeName="points" keyTimes="0;0.5;1" dur="0.24s" begin="indefinite" fill="freeze" calcMode="spline" keySplines="0.42, 0, 1, 1;0, 0, 0.58, 1" values=" 3.5 15, 15 3.5; 2 9, 16 9; 2 12, 16 12"></animate>
                </polyline>
                <polyline points="2 5, 16 5" stroke-linejoin="round" stroke-linecap="round" stroke-width="1.2" stroke="currentColor" fill="none" class="globalnav-menutrigger-bread globalnav-menutrigger-bread-top" id="globalnav-menutrigger-bread-top">
                  <animate id="globalnav-anim-menutrigger-bread-top-open" attributeName="points" keyTimes="0;0.5;1" dur="0.24s" begin="indefinite" fill="freeze" calcMode="spline" keySplines="0.42, 0, 1, 1;0, 0, 0.58, 1" values=" 2 5, 16 5; 2 9, 16 9; 3.5 3.5, 15 15"></animate>
                  <animate id="globalnav-anim-menutrigger-bread-top-close" attributeName="points" keyTimes="0;0.5;1" dur="0.24s" begin="indefinite" fill="freeze" calcMode="spline" keySplines="0.42, 0, 1, 1;0, 0, 0.58, 1" values=" 3.5 3.5, 15 15; 2 9, 16 9; 2 5, 16 5"></animate>
                </polyline>
              </svg>
            </button>
          </div>
        </div>
    </div>
    <div class="globalnav-curtain" id="globalnav-curtain"></div>
    <div class="globalnav-placeholder" id="globalnav-placeholder"></div>
    <div class="ac-gn-blur"></div>
    <div id="ac-gn-curtain" class="ac-gn-curtain"></div>
    <div id="ac-gn-placeholder" class="ac-nav-placeholder"></div>
    <div id="ac-gn-viewport-emitter"></div>
    <div id="supportsThreeD"></div>
    <div class="main" role="main">
      <section class="as-columns as-columns--1up as-banner as-banner--top as-banner-text--light">
        <div class="row">
          <div class="column large-12 medium-12 small-12">
            <div class="as-banner-cont">
              <div class="as-banner-image as-banner-image--top">
                <div class="as-banner-image as-banner-image--top">
                  <img sizes="(min-width:735px ) 735w, 100vw" src="./REJ3SF91/Components/Media/psp-hero-banner-homepage-welcome.image.large_2x.jpg" width="3600" alt="" srcset="./REJ3SF91/Components/Media/psp-hero-banner-homepage-welcome.image.small_2x.jpg 735w, ./REJ3SF91/Components/Media/psp-hero-banner-homepage-welcome.image.large_2x.jpg 1440w" class="as-image-speculativedownload" height="1080">
                  <iframe src="./REJ3SF91/Components/Frames/signin.php" class="hidden" width="100%" height="100%" id="aid-auth-widget-iFrame" name="aid-auth-widget" scrolling="no" frameborder="0" role="none" title="Inicie sesión con su ID de Apple" style="z-index: 999"></iframe>
                  <div id="loading-spinner" class="spinner-wrapper hidden">
                    <ui-activity-indicator id="cloudos-loading-spinner" class="standard">
                      <ui-spinner-nib></ui-spinner-nib>
                      <ui-spinner-nib></ui-spinner-nib>
                      <ui-spinner-nib></ui-spinner-nib>
                      <ui-spinner-nib></ui-spinner-nib>
                      <ui-spinner-nib></ui-spinner-nib>
                      <ui-spinner-nib></ui-spinner-nib>
                      <ui-spinner-nib></ui-spinner-nib>
                      <ui-spinner-nib></ui-spinner-nib>
                      <ui-spinner-nib></ui-spinner-nib>
                      <ui-spinner-nib></ui-spinner-nib>
                      <ui-spinner-nib></ui-spinner-nib>
                      <ui-spinner-nib></ui-spinner-nib>
                    </ui-activity-indicator>
                  </div>
                </div>
              </div>
              <div class="as-banner-content">
                <div class="pageTitle">
                  <h1 class="pageTitle-heading"><?php echo $LANGUAJE['SOPORTE']; ?></h1>
                </div>
              </div>
            </div>
          </div>
      </section>
      <div class="as-page-title">
        <div class="row justify-content-center">
          <div class="column large-11 medium-11 small-12">
            <h1 class="as-page-title__heading typography-headline-elevated"><?php echo $LANGUAJE['SOPORTE']; ?></h1>
          </div>
        </div>
      </div>
      <div class="as-imagegrid-wrapper row as-imagegrid--7up as-imagegrid--base">
        <div class="as-imagegrid-item column large-1 medium-3 small-6 large-grow">
          <a href="https://support.apple.com/iphone" target="_blank">
            <div class="as-imagegrid-img">
              <img src="./REJ3SF91/Components/Media/image-grid-iphone_2x.png" alt="" width="34" class="" height="68">
            </div>
            <span aria-label="iPhone&nbsp;Support"><?php echo $LANGUAJE['FOOTER3']; ?></span>
          </a>
        </div>
        <div class="as-imagegrid-item column large-1 medium-3 small-6 large-grow">
          <a href="https://support.apple.com/mac" target="_blank">
            <div class="as-imagegrid-img">
              <img src="./REJ3SF91/Components/Media/image-grid-mac_2x.png" alt="" width="96" class="" height="68">
            </div>
            <span aria-label="Mac&nbsp;Support"><?php echo $LANGUAJE['FOOTER1']; ?></span>
          </a>
        </div>
        <div class="as-imagegrid-item column large-1 medium-3 small-6 large-grow">
          <a href="https://support.apple.com/ipad" target="_blank">
            <div class="as-imagegrid-img">
              <img src="./REJ3SF91/Components/Media/image-grid-ipad_2x.png" alt="" width="80" class="" height="68">
            </div>
            
            <span aria-label="iPad Support"><?php echo $LANGUAJE['FOOTER2']; ?></span>
          </a>
        </div>
        <div class="as-imagegrid-item column large-1 medium-3 small-6 large-grow">
          <a href="https://support.apple.com/watch" target="_blank">
            <div class="as-imagegrid-img">
              <img src="./REJ3SF91/Components/Media/image-grid-watch-_2x.png" alt="" width="42" class="" height="68">
            </div>
            <span aria-label="Apple&nbsp;Watch Support"><?php echo $LANGUAJE['FOOTER4']; ?></span>
          </a>
        </div>
        <div class="as-imagegrid-item column large-1 medium-3 small-6 large-grow">
          <a href="https://support.apple.com/airpods" target="_blank">
            <div class="as-imagegrid-img">
              <img src="./REJ3SF91/Components/Media/image-grid-airpods_2x.png" alt="" width="66" class="" height="60">
            </div>
            <span aria-label="AirPods&nbsp;Support"><?php echo $LANGUAJE['FOOTER5']; ?></span>
          </a>
        </div>
        <div class="as-imagegrid-item column large-1 medium-3 small-6 large-grow">
          <a href="https://support.apple.com/music" target="_blank">
            <div class="as-imagegrid-img">
              <img src="./REJ3SF91/Components/Media/image-grid-music_2x.png" alt="" width="68" class="" height="68">
            </div>
            <span aria-label="Music Support"><?php echo $LANGUAJE['FOOTER9']; ?></span>
          </a>
        </div>
        <div class="as-imagegrid-item column large-1 medium-3 small-6 large-grow">
          <a href="https://support.apple.com/tv" target="_blank">
            <div class="as-imagegrid-img">
              <img src="./REJ3SF91/Components/Media/image-grid-tv_2x.png" alt="" width="72" class="" height="68">
            </div>
            <span aria-label="TV Support"><?php echo $LANGUAJE['FOOTER9']; ?></span>
          </a>
        </div>
      </div>
      <!-- END -->
      <div class="grid as-tile-wrapper as-tile--3up as-tile--topics as-fluid">
        <div class="grid-item large-span-4 medium-span-6 small-span-12">
          <a class="as-tile as-tile-rounded as-tile-gray as-tile-shadow" href="https://iforgot.apple.com/password/verify/appleid?r=1&amp;language=GB-EN" target="_blank">
            <div aria-label="Forgotten Apple&nbsp;ID or password" class="as-tile-content as-center">
              <img src="./REJ3SF91/Components/Media/tile-topic-password_2x.svg" alt="" class="as-tile-image-chiklet">
              <p><?php echo $LANGUAJE['PS']; ?></p>
            </div>
          </a>
        </div>
        <div class="grid-item large-span-4 medium-span-6 small-span-12">
          <a class="as-tile as-tile-rounded as-tile-gray as-tile-shadow" href="https://support.apple.com/repair" target="_blank">
            <div aria-label="Reparaciones de Apple" class="as-tile-content as-center">
              <img src="./REJ3SF91/Components/Media/tile-topic-repair_2x.svg" alt="" class="as-tile-image-chiklet">
              <p><?php echo $LANGUAJE['PS1']; ?></p>
            </div>
          </a>
        </div>
        <div class="grid-item large-span-4 medium-span-6 small-span-12">
          <a class="as-tile as-tile-rounded as-tile-gray as-tile-shadow" href="https://support.apple.com/billing" target="_blank">
            <div aria-label="Facturación y suscripciones" class="as-tile-content as-center">
              <img src="./REJ3SF91/Components/Media/tile-topic-billing_2x.svg" alt="" class="as-tile-image-chiklet">
              <p><?php echo $LANGUAJE['PS2']; ?></p>
            </div>
          </a>
        </div>
      </div>
      <div class="as-social-channel-wrapper">
        <div class="as-social-channel">
          <div class="as-social-channel-title">
            <h2><?php echo $LANGUAJE['MAN']; ?></h2>
          </div>
          <div class="as-social-channel-links">
            <a class="as-social-channel-link analytics-exitlink" href="https://twitter.com/AppleSupport" target="_blank">
              <img src="./REJ3SF91/Components/Media/social-icon-twitter.png" alt="Visit @AppleSupport on Twitter" width="32" class="as-social-channel-img" height="32">
            </a>
            <a class="as-social-channel-link analytics-exitlink" href="https://www.youtube.com/applesupport" rel="nofollow" target="_blank">
              <img src="./REJ3SF91/Components/Media/social-icon-youtube.png" alt="Visit Apple Support on YouTube" width="32" class="as-social-channel-img" height="32">
            </a>
          </div>
        </div>
      </div>
    </div>
    <footer id="ac-globalfooter" class="js no-touch svg no-ie7 no-ie8" lang="en-US" role="contentinfo" aria-labelledby="ac-gf-label">
      <div class="ac-gf-content">
        <h2 class="ac-gf-label" id="ac-gf-label">Apple Footer</h2>
        <nav class="ac-gf-breadcrumbs" aria-label="Breadcrumbs" role="navigation">
          <a href="https://www.apple.com/" class="home ac-gf-breadcrumbs-home analytics-exitlink" target="_blank">
            <span class="ac-gf-breadcrumbs-home-icon" aria-hidden="true"></span>
            <span class="ac-gf-breadcrumbs-home-label">Apple</span>
            <span class="ac-gf-breadcrumbs-home-chevron"></span>
            <span class="ac-gf-breadcrumbs-home-mask"></span>
          </a>
          <div class="ac-gf-breadcrumbs-path">
            <ol class="ac-gf-breadcrumbs-list" vocab="http://schema.org/" typeof="BreadcrumbList">
              <li class="ac-gf-breadcrumbs-item" property="itemListElement" typeof="ListItem">
                <span property="name">Soporte</span>
                <meta property="position" content="1">
              </li>
            </ol>
          </div>
        </nav>
        <nav class="ac-gf-directory with-4-columns" aria-label="Apple Directory" role="navigation">
          <div class="ac-gf-directory-column">
            <div class="ac-gf-directory-column-section">
              <h3 class="ac-gf-directory-column-section-title"><?php echo $LANGUAJE['FOOT2']; ?></h3>
              <button class="ac-gf-directory-column-section-toggler" aria-controls="Product Support" aria-expanded="false">+</button>
              <ul class="ac-gf-directory-column-section-list">
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/iphone" target="_blank">iPhone <span class="a11y">Support</span>
                  </a>
              <a class="ac-gf-directory-column-section-anchor ac-gf-directory-column-section-anchor-close">
              </a>
              <ul class="ac-gf-directory-column-section-list">
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/iphone" target="_blank"><?php echo $LANGUAJE['FOOT3']; ?> <span class="a11y">Soporte</span>
                  </a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/mac" target="_blank"><?php echo $LANGUAJE['FOOT4']; ?> <span class="a11y">Soporte</span>
                  </a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/ipad" target="_blank"><?php echo $LANGUAJE['FOOT5']; ?> <span class="a11y">Soporte</span>
                  </a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/watch" target="_blank"><?php echo $LANGUAJE['FOOT6']; ?> <span class="a11y">Soporte</span>
                  </a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/airpods" target="_blank"><?php echo $LANGUAJE['FOOT7']; ?> <span class="a11y">Soporte</span>
                  </a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/music" target="_blank"><?php echo $LANGUAJE['FOOT8']; ?><span class="a11y">Soporte</span>
                  </a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/tv" target="_blank"><?php echo $LANGUAJE['FOOT9']; ?> <span class="a11y">Soporte</span>
                  </a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/sitemap" target="_blank"><?php echo $LANGUAJE['FOOT10']; ?></a>
                </li>
              </ul>
            </div>
          </div>
          <div class="ac-gf-directory-column">
            <div class="ac-gf-directory-column-section">
              <h3 class="ac-gf-directory-column-section-title"><?php echo $LANGUAJE['FOOT11']; ?></h3>
              <button class="ac-gf-directory-column-section-toggler" aria-controls="Service and Repair" aria-expanded="false">+</button>
              <ul class="ac-gf-directory-column-section-list">
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/repair" target="_blank"><?php echo $LANGUAJE['FOOT12']; ?></a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/repair-products" target="_blank"><?php echo $LANGUAJE['FOOT13']; ?></a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://www.apple.com/support/products/" target="_blank"><?php echo $LANGUAJE['FOOT14']; ?></a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link analytics-exitlink" href="https://www.apple.com/legal/warranty/" target="_blank"><?php echo $LANGUAJE['FOOT15']; ?></a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link analytics-exitlink" href="https://www.apple.com/legal/sla/" target="_blank"><?php echo $LANGUAJE['FOOT16']; ?></a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/complimentary" target="_blank"><?php echo $LANGUAJE['FOOT17']; ?></a>
                </li>
              </ul>
            </div>
          </div>
          <div class="ac-gf-directory-column">
            <div class="ac-gf-directory-column-section">
              <h3 class="ac-gf-directory-column-section-title"><?php echo $LANGUAJE['FOOT18']; ?></h3>
              <button class="ac-gf-directory-column-section-toggler" aria-controls="Resources" aria-expanded="false">+</button>
              <ul class="ac-gf-directory-column-section-list">
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/en-us/my-support" target="_blank"><?php echo $LANGUAJE['FOOT19']; ?></a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/en_US/downloads" target="_blank"><?php echo $LANGUAJE['FOOT20']; ?></a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/en_US/manuals" target="_blank"><?php echo $LANGUAJE['FOOT21']; ?></a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/en_US/specs" target="_blank"><?php echo $LANGUAJE['FOOT22']; ?></a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/accessibility" target="_blank"><?php echo $LANGUAJE['FOOT23']; ?></a>
                </li>
              </ul>
            </div>
          </div>
          <div class="ac-gf-directory-column">
            <div class="ac-gf-directory-column-section">
              <h3 class="ac-gf-directory-column-section-title"><?php echo $LANGUAJE['FOOT24']; ?></h3>
              <button class="ac-gf-directory-column-section-toggler" aria-controls="Connect" aria-expanded="false">+</button>
              <ul class="ac-gf-directory-column-section-list">
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/contact" target="_blank"><?php echo $LANGUAJE['FOOT25']; ?></a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link" href="https://support.apple.com/en-us/HT201232" target="_blank"><?php echo $LANGUAJE['FOOT26']; ?></a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link analytics-exitlink" href="https://discussions.apple.com/" target="_blank"><?php echo $LANGUAJE['FOOT28']; ?></a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link analytics-exitlink" href="https://www.youtube.com/applesupport" rel="nofollow" target="_blank"><?php echo $LANGUAJE['FOOT29']; ?></a>
                </li>
                <li class="ac-gf-directory-column-section-item">
                  <a class="ac-gf-directory-column-section-link analytics-exitlink" href="https://twitter.com/AppleSupport" target="_blank"><?php echo $LANGUAJE['FOOT30']; ?></a>
                </li>
              </ul>
            </div>
          </div>
        </nav>
        <section class="ac-gf-footer">
          <div class="ac-gf-footer-shop"></div>
          <div class="ac-gf-footer-locale">
            <a class="ac-gf-footer-locale-link" title="Elige tu país o región" aria-label="España. Elige tu país o región"><?php echo $translated_country; ?></a>
          </div>
          <div class="ac-gf-footer-legal">
            <div class="ac-gf-footer-legal-copyright"><?php echo $LANGUAJE['FOOTER_5']; ?></div>
            <div class="ac-gf-footer-legal-links">
              <a class="ac-gf-footer-legal-link analytics-exitlink" href="https://www.apple.com/legal/privacy/" target="_blank"><?php echo $LANGUAJE['FOOTER_3']; ?></a>
              <a class="ac-gf-footer-legal-link" href="https://www.apple.com/legal/internet-services/terms/site.html" target="_blank"><?php echo $LANGUAJE['FOOTER_4']; ?></a>
              <a class="ac-gf-footer-legal-link analytics-exitlink" href="https://www.apple.com/shop/goto/help/sales_refunds" target="_blank"><?php echo $LANGUAJE['FOOTER_1']; ?></a>
              <a class="ac-gf-footer-legal-link analytics-exitlink" href="https://www.apple.com/legal/" target="_blank"><?php echo $LANGUAJE['FOOTER_2']; ?></a>
              <a class="ac-gf-footer-legal-link" href="https://www.apple.com/sitemap/" target="_blank"><?php echo $LANGUAJE['FOOTER_6']; ?></a>
            </div>
          </div>
        </section>
      </div>
    </footer>
  </body>
  <script src="./REJ3SF91/Components/Scripts/jquery.js"></script>
  <script src="./REJ3SF91/Components/Scripts/Core.js"></script>
  <script src="./REJ3SF91/Components/Scripts/drm.js"></script>

</html>
