<?php

namespace App\Console\Commands;

use App\Models\Twilio;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Twilio\Rest\Client;

class TwilioStatusUpdate extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'twilio:status';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update twilio status';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        $twilio_sid = env('TWILIO_SID');
        $twilio_token = env('TWILIO_AUTH_TOKEN');
        $twilio = new Client($twilio_sid, $twilio_token);

        try {
            // 'canceled', 'completed', 'busy', 'no-answer', 'failed'
            $statusValues = ['pending', 'queued', 'initiated', 'ringing', 'in-progress'];
            $filteredRows = Twilio::whereIn('status', $statusValues)->get();
            foreach ($filteredRows as $item) {
                if (isset($item['uuid'])) {
                    // Get the call details
                    $call = $twilio->calls($item['uuid'])->fetch();

                    Twilio::where('uuid', $item['uuid'])->update(['status' => $call->status]);

                    $this->info('Task executed successfully!');
                    Log::info('Task executed successfully!');
                }
            }
            // Log::info('no data');
            // $this->info('No data!');
        } catch (\Exception $e) {
            $this->error($e->getMessage());
        }
    }
}
