<?php

namespace App\Http\Controllers;

use App\Models\Audio;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class AudioController extends Controller
{
    private $prefix = "admin/voice-call/";
    private $resources = [];
    private $checkPermissionAndRolesController;

    function __construct(
        CheckPermissionsAndRolesController $checkPermissionAndRolesController
    ) {
        $this->resources['prefix'] = $this->prefix;
        $this->checkPermissionAndRolesController = $checkPermissionAndRolesController;
    }

    public function index(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Voice Call Audio Upload']);
        $this->resources['audios'] = $this->getAudio($request, 15);
        return view('admin.voice-call.audio_upload')->with($this->resources);
    }
    public function upload(Request $request)
    {
        $credentials = $request->validate([
            'title' => ['required'],
            'audio' => ['required'],
            'input' => ['required'],
        ]);
        try {
            $audio = $request->file('audio');
            $filename = time() . '.' . $audio->getClientOriginalExtension();
            $path = Storage::disk('local')->put('public/audio',$audio, 'public');

            $audioModel = new Audio();
            $audioModel->title = $request->input('title');
            $audioModel->input = $request->input('input');
            $audioModel->audio = str_replace("public/", "storage/", $path);
            $audioModel->digits = $request->input('digits');
            $audioModel->save();

            $this->resources['messages'] = array("type" => "success", "description" => "Audio uploaded successfully.");
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
    public function getAudio($request, $count)
    {
        try{
           
            $superAdmin = $this->checkPermissionAndRolesController->superAdmin($request);
            $query = Audio::orderBy('id','desc');
            // if(!$superAdmin){
            //     $query->where('created_by', $request->user()->id);
            // }
            $result = $query->paginate($count);
            return $result;
        }catch(\Exception $e){
            throw $e;
        }
    }
    public function getAudioById($request)
    {
        try{
           
            $superAdmin = $this->checkPermissionAndRolesController->superAdmin($request);
            $query = Audio::query();
            // if(!$superAdmin){
            //     $query->where('created_by', $request->user()->id);
            // }
            $result = $query->where('id', $request->id)->first();
            return $result;
        }catch(\Exception $e){
            throw $e;
        }
    }
    public function edit(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission'=>'Voice Call Audio Upload']);
        $this->resources['data'] = $this->getAudioById($request);
        return view('admin.voice-call.audio_edit')->with($this->resources);
    }
    public function update(Request $request)
    {
        $credentials = $request->validate([
            'title' => ['required'],
            'audio' => ['required'],
            'input' => ['required'],
        ]);
        try {
            $get = $this->getAudioById($request);
            // delete file
            $ex_filepath = public_path($get['audio']);
            if (file_exists($ex_filepath)) {
                Storage::disk('local')->delete('public/' . str_replace('storage/', '', $get['audio']));
            }
            $audio = $request->file('audio');
            $path = Storage::disk('local')->put('public/audio',$audio, 'public');
            
            Audio::where('id', $request->id)->update([
                'title'=>$request->input('title'),
                'input'=> $request->input('input'),
                'audio' => str_replace("public/", "storage/", $path),
                'digits'=> $request->input('digits')
            ]);
            $this->resources['messages'] = array("type" => "success", "description" => "Audio updated successfully.");
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
    public function delete(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission'=>'Voice Call Audio Upload']);
        $request->validate([
            'id' => ['required'],   
        ]);
        try {
            $superAdmin = $this->checkPermissionAndRolesController->superAdmin($request);
            $get = $this->getAudioById($request);
            // delete file
            $ex_filepath = public_path($get['audio']);
            if (file_exists($ex_filepath)) {
                Storage::disk('local')->delete('public/' . str_replace('storage/', '', $get['audio']));
            }
            $query = Audio::where('id', $request->id);
            $result = $query->delete();

            if($result){
                $this->resources['messages'] = array("type" => "success", "description"=>"Audio deleted success");
            }else{
                $this->resources['messages'] = array("type" => "error", "description"=>"Audio deleted failed");
            }
            return redirect()->back()->with('messages',$this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description"=>$th->getMessage());
            return redirect()->back()->with('messages',$this->resources);
        }
    }
}
