<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class CommonController extends Controller
{
    public function getGeoLocation(Request $request)
    {
        try {
            $request->validate([
                'query' => ['required'],
                'region' => ['required'],
            ]);
            $data = $request->all();
            $result = forwordGeocoding([
                'query' => $data['query'],
                'region' => $data['region']
            ]);
            return array(
                'latitude' => $result['results'][0]['geometry']['lat'],
                'longitude'=>$result['results'][0]['geometry']['lng']
            );
        } catch (\Throwable $th) {
            return response()->json(['error' => $th->getMessage()], 500);
        }
    }

    public function validatePhoneNumber(Request $request)
    {
        try {
            $request->validate([
                'number' => ['required']
            ]);
            $data = $request->all();
            $result = validatePhoneNumber($data['number']);
            return response()->json(['success' => true, 'data'=>$result], 200);
        } catch (\Throwable $th) {
            return response()->json(['error' => $th->getMessage()], 500);
        }
    }
}
