<?php

namespace App\Http\Controllers;

use App\Models\Media;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class MediaController extends Controller
{
    private $prefix = "admin/media/";
    private $resources = [];
    private $checkPermissionAndRolesController;

    public function __construct(CheckPermissionsAndRolesController $checkPermissionAndRolesController)
    {
        $this->resources['prefix'] = $this->prefix;
        $this->checkPermissionAndRolesController = $checkPermissionAndRolesController;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Media']);
        $this->resources['data'] = $this->getMedia($request);
        return view('admin.media.index')->with($this->resources);
    }
    public function getMedia($request)
    {
        try {

            $superAdmin = $this->checkPermissionAndRolesController->superAdmin($request);
            $query = Media::orderBy('id', 'desc');
            if (!$superAdmin) {
                $query->where('create_by', $request->user()->id);
            }
            $result = $query->get();
            return $result;
        } catch (\Exception $e) {
            throw $e;
        }
    }
    public function upload(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Media']);
        $credentials = $request->validate([
            'name' => ['required'],
            'files' => ['required'],
        ]);
        try {
            $files = $request->file('files');
            foreach ($files as $value) {
                $filename = $this->fileUpload(['image' => $value, 'user_id' => $request->user()->id]);
                Media::create([
                    "name" => $request->name,
                    "path" => $filename,
                    "create_by" => $request->user()->id
                ]);
            }
            $this->resources['messages'] = array("type" => "success", "description" => "Media upload success");
            return redirect()->back()->with('messages', $this->resources);

            $this->resources['messages'] = array("type" => "success", "description" => "Something went wrong");
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
    public function fileUpload(array $data)
    {
        try {
            $path = Storage::disk('local')->put('public/media/' . $data['user_id'], $data['image'], 'public');
            return str_replace("public/", "storage/", $path);
        } catch (\Throwable $th) {
            throw $th;
        }
    }
    public function delete(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Media']);
        $request->validate([
            'id' => ['required'],
        ]);
        try {
            $superAdmin = $this->checkPermissionAndRolesController->superAdmin($request);
            $get = Media::where('id', $request->id)->first();
            $query = Media::where('id', $request->id);
            if (!$superAdmin) {
                $query->where('create_by', $request->user()->id);
            }
            $result = $query->delete();

            if ($result) {
                // delete file
                if ($get['path'] != NULL && file_exists(public_path($get['path']))) {
                    Storage::disk('local')->delete('public/' . str_replace('storage/', '', $get['path']));
                }
                $this->resources['messages'] = array("type" => "success", "description" => "Media deleted success");
            } else {
                $this->resources['messages'] = array("type" => "error", "description" => "Media deleted failed");
            }
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            dd($th);
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
}
