<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class SettingController extends Controller
{
    private $prefix = "admin/profile/";
    private $resources = [];
    private $checkPermissionAndRolesController;

    public function __construct(CheckPermissionsAndRolesController $checkPermissionAndRolesController)
    {
        $this->checkPermissionAndRolesController = $checkPermissionAndRolesController;
        $this->resources['prefix'] = $this->prefix;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Manage Profile']);
        $this->resources['user'] = $this->getUserData($request->user()->id);
        return view('admin.profile.profile_manage')->with($this->resources);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function show(Setting $setting)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function edit(Setting $setting)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Manage Profile']);
        $credentials = $request->validate([
            'name' => ['required'],
            'email' => ['required', 'email'],
        ]);
        try {
            $requestParam = $request->all();
            User::where('id', $request->user()->id)
                ->update([
                    'name' => $requestParam['name'],
                    'email' => $requestParam['email'],
                    'teligram' => $requestParam['teligram'],
                ]);
            $this->resources['messages'] = array("type" => "success", "description" => "Profile updated success");
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
    public function passwordReset(Request $request)
    {
        try {
            $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Password Reset']);
            $credentials = $request->validate([
                'password' => ['required', 'required_with:password_confirmation', 'same:password_confirmation', 'min:6'],
                'password_confirmation' => ['required', 'min:6']
            ]);
            $requestParam = $request->all();
            User::where('id', $request->user()->id)
                ->update([
                    'password' => Hash::make($requestParam['password'])
                ]);
            $this->resources['messages'] = array("type" => "success", "description" => "Password reset success");
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function destroy(Setting $setting)
    {
        //
    }

    public function getUserData($id)
    {
        try {
            return User::where('id', $id)->first();
        } catch (\Throwable $th) {
            throw $th;
        }
    }
}
