<?php

namespace App\Http\Controllers;

use App\Models\SmsApi;
use Illuminate\Http\Request;

class SmsController extends Controller
{
    public function sendSms($data, $link)
    {
        try {

            $api = SmsApi::where('id', $data->sender_api_id)->first();

            $makeArr = [];
            $makeArr['api'] = $api;
            $makeArr['order'] = $data;
            $makeArr['link'] = $link;
            $result = $this->sendRequest($makeArr);
            return $result;
        } catch (\Throwable $th) {
            throw $th;
        }
    }
    public function sendMultiple($data, $link, $numbers)
    {
        try {

            $api = SmsApi::where('id', $data->sender_api_id)->first();

            $makeArr = [];
            $makeArr['api'] = $api;
            $makeArr['order'] = $data;
            $makeArr['link'] = $link;
            $makeArr['multiple'] = true;
            $makeArr['multiple_phone_numbers'] = $numbers;
            $result = $this->sendRequest($makeArr);
        } catch (\Throwable $th) {
            throw $th;
        }
    }
    public function sendRequest($data)
    {
        try {
            $arr = array();

            $arr[$data['api']['sender_parameter']] = $data['order']["sender_id"];
            if (isset($data['multiple']) && $data['multiple'] == true) {
                $arr[$data['api']['to_parameter']] = $data['multiple_phone_numbers'];
            } else {
                $arr[$data['api']['to_parameter']] = $data['order']['phone_number'];
            }
            $arr[$data['api']['message_parameter']] = $this->makeMessage($data['order'], $data['link']);

            if (is_array($data['api']['parameters'])) {
                foreach ($data['api']['parameters'] as $key => $value) {
                    $arr[$key] = $value;
                }
            }

            // Get all keys with null values
            $nullKeys = array_keys($arr, null, true);
            $nullKeysString = '';
            if (!empty($nullKeys))
            {
                $nullKeysString = implode('&', $nullKeys) . '&';
            }

            $ch = curl_init();
            if ($data['api']['method'] == "get")
            {
                if($nullKeysString != ''){
                    curl_setopt($ch, CURLOPT_URL, $data['api']['url'] . "?$nullKeysString" . http_build_query($arr));
                }else{
                    curl_setopt($ch, CURLOPT_URL, $data['api']['url'] . "?" . http_build_query($arr));
                }
            } else {
                curl_setopt($ch, CURLOPT_URL, $data['api']['url']);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, ($data['api']['json_encoded'] == 1) ? json_encode($arr) : $arr);
            }

            if ($data['api']['authentication'] == 1) {
                if ($data['api']['use_token'] == 1) {
                    $headers = array("Authorization:  Bearer " . $data['api']['token']);
                } else {
                    if ($data['api']['base64_encoded_authentication'] == 1) {
                        $headers = array("Authorization: Basic " . base64_encode((string) $data['api']['auth_username'] . ":" . $data['api']['auth_password']));
                    } else {
                        $headers = array("Authorization: Basic " . (string) $data['api']['auth_username'] . ":" . $data['api']['auth_password']);
                    }
                }

                curl_setopt($ch, CURLOPT_HEADER, 1);
                curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            }

            // dd($arr, $headers, $ch);

            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($ch, CURLOPT_ENCODING, "UTF-8");
            // curl_setopt($ch, CURLOPT_VERBOSE, true);
            // $verbose = fopen(APPPATH . "cache/curl.txt", "w+");
            // curl_setopt($ch, CURLOPT_STDERR, $verbose);
            $output = curl_exec($ch);
            curl_close($ch);
            return $output;
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    // public function sendRequest($data)
    // {
    //     try {
    //         $arr = array();

    //         $arr[$data['api']['sender_parameter']] = $data['order']["sender_id"];
    //         if(isset($data['multiple']) && $data['multiple'] == true){
    //             $arr[$data['api']['to_parameter']] = $data['multiple_phone_numbers'];
    //         }else{
    //             $arr[$data['api']['to_parameter']] = $data['order']['phone_number'];
    //         }
    //         $arr[$data['api']['message_parameter']] = $this->makeMessage($data['order'], $data['link']);
    //         $arr['SenderID'] = $data['order']["sender_id"];

    //         if(is_array($data['api']['parameters'])){
    //             foreach ($data['api']['parameters'] as $key => $value) {
    //                 $arr[$key] = $value;
    //             }
    //         }

    //         $ch = curl_init();
    //         if ($data['api']['method'] == "get") {
    //             curl_setopt($ch, CURLOPT_URL, $data['api']['url'] . "?" . http_build_query($arr));
    //         } else {
    //             curl_setopt($ch, CURLOPT_URL, $data['api']['url']);
    //             curl_setopt($ch, CURLOPT_POST, true);
    //             curl_setopt($ch, CURLOPT_POSTFIELDS, $arr);
    //         }

    //         if ($data['api']['authentication'] == 1) {
    //             if ($data['api']['base64_encoded_authentication'] == 1) {
    //                 $headers = array("Authorization: Basic " . base64_encode((string) $data['api']['auth_username'] . ":" . $data['api']['auth_password']));
    //             } else {
    //                 $headers = array("Authorization: Basic " . (string) $data['api']['auth_username'] . ":" . $data['api']['auth_password']);
    //             }

    //             curl_setopt($ch, CURLOPT_HEADER, 1);
    //             curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
    //             curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    //         }

    //         dd($arr, $headers, $ch);

    //         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //         curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    //         curl_setopt($ch, CURLOPT_ENCODING, "UTF-8");
    //         // curl_setopt($ch, CURLOPT_VERBOSE, true);
    //         // $verbose = fopen(APPPATH . "cache/curl.txt", "w+");
    //         // curl_setopt($ch, CURLOPT_STDERR, $verbose);
    //         $output = curl_exec($ch);
    //         curl_close($ch);
    //         return $output;
    //     } catch (\Throwable $th) {
    //         throw $th;
    //     }
    // }

    public function makeMessage($data, $link)
    {
        try {
            $message = str_replace(['[LINK]', '[IMEI]', '[MODEL]'], [$link . " ", $data->imei, $data->model], $data->message);
            return $message;
        } catch (\Throwable $th) {
            throw $th;
        }
    }
}
