<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\Request;

class SystemSettingController extends Controller
{
    private $prefix = "admin/system-settings/";
    private $resources = [];
    private $checkPermissionAndRolesController;

    public function __construct(CheckPermissionsAndRolesController $checkPermissionAndRolesController)
    {
        $this->checkPermissionAndRolesController = $checkPermissionAndRolesController;
        $this->resources['prefix'] = $this->prefix;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function orderSettings(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Order Settings']);
        $settings = Setting::where('user_id', $request->user()->id)->first();
        $this->resources['settings'] = ($settings) ? $settings : [];
        return view('admin.settings.order-settings')->with($this->resources);
    }
    public function updateAjax(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Order Settings']);
        $credentials = $request->validate([
            'link_auto_block' => ['required'],
            'ip_auto_block' => ['required'],
            'redirect' => ['required'],
            'default_link_type' =>['required']
        ]);
        try {
            $getSetting = Setting::where('user_id', $request->user()->id)->first();
            $settings = [];
            $settings['order_settings']['ip_auto_block'] = $request->ip_auto_block;
            $settings['order_settings']['link_auto_block'] = $request->link_auto_block;
            $settings['order_settings']['redirect'] = $request->redirect;
            $settings['order_settings']['default_link_type'] = $request->default_link_type == 'true' ? '?location=' : false;

            $settings['order_settings']['link_code_length'] = isset($getSetting['order_settings']['link_code_length']) ? $getSetting['order_settings']['link_code_length'] : 3;
            Setting::updateOrCreate(
                ["user_id" => $request->user()->id],
                [
                    "order_settings" => $settings['order_settings'],
                    "user_id" => $request->user()->id
                ]
            );
            return response()->json(['success' => true], 200);
        } catch (\Throwable $th) {
            return response()->json($th->getMessage(), 500);
        }
    }
    public function update(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Order Settings']);
        $credentials = $request->validate([
            'link_code_length' => ['required', 'numeric','min:3', 'max:20']
        ]);
        try {
            $requestAll = $request->all();
            $getSetting = Setting::where('user_id', $request->user()->id)->first();
            $settings = [];
            $settings['order_settings']['ip_auto_block'] = $request->ip_auto_block;
            $settings['order_settings']['link_auto_block'] = isset($getSetting['order_settings']['link_auto_block']) ? $getSetting['order_settings']['link_auto_block'] : false;
            $settings['order_settings']['redirect'] = isset($getSetting['order_settings']['redirect']) ? $getSetting['order_settings']['redirect'] : false;
            $settings['order_settings']['link_code_length'] = $requestAll['link_code_length'];
            Setting::updateOrCreate(
                ["user_id" => $request->user()->id],
                [
                    "order_settings" => $settings['order_settings'],
                    "user_id" => $request->user()->id
                ]
            );
            $this->resources['messages'] = array("type" => "success", "description" => "Order Settings updated success");
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
}
