<?php

namespace App\Http\Controllers;

use App\Models\TwilioFromNumber;
use Illuminate\Http\Request;

class TwilioFromNumberController extends Controller
{
    private $prefix = "admin/twilio/";
    private $resources = [];
    private $checkPermissionAndRolesController;
    public function __construct(CheckPermissionsAndRolesController $checkPermissionAndRolesController)
    {
        $this->resources['prefix'] = $this->prefix;
        $this->checkPermissionAndRolesController = $checkPermissionAndRolesController;
    }
    public function index(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Twilio From Number']);
        $this->resources['data'] =  TwilioFromNumber::paginate(15);
        return view('admin.twilio.call_from_numbers')->with($this->resources);
    }
    public function store(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Twilio From Number']);

        $credentials = $request->validate([
            'name' => ['required'],
            'number' => ['required']
        ]);

        try {
            TwilioFromNumber::create([
                'name' => $request->name,
                'number' => $request->number,
            ]);
            $this->resources['messages'] = array("type" => "success", "description" => "Twilio Number creation success");
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
    public function edit(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Twilio From Number']);
        $this->resources['data'] =  TwilioFromNumber::where('id', $request->id)->first();
        return view('admin.twilio.call-from-number-edit')->with($this->resources);
    }
    public function update(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Twilio From Number']);

        $credentials = $request->validate([
            'id' =>['required'],
            'name' => ['required'],
            'number' => ['required']

        ]);

        try {
            TwilioFromNumber::where('id', $request->id)->update([
                'name' => $request->name,
                'number' => $request->number,
            ]);
            $this->resources['messages'] = array("type" => "success", "description" => "Twilio Number update success");
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
    public function delete(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission'=>'Twilio From Number']);
        $request->validate([
            'id' => ['required'],   
        ]);
        try {
            $superAdmin = $this->checkPermissionAndRolesController->superAdmin($request);
            $query = TwilioFromNumber::where('id', $request->id);
            $result = $query->delete();

            if($result){
                $this->resources['messages'] = array("type" => "success", "description"=>"Twilio Number deleted success");
            }else{
                $this->resources['messages'] = array("type" => "error", "description"=>"Twilio Number deleted failed");
            }
            return redirect()->back()->with('messages',$this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description"=>$th->getMessage());
            return redirect()->back()->with('messages',$this->resources);
        }
    }
}
