<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\UserCredit;
use Illuminate\Http\Request;

class TwilioUserCreditController extends Controller
{
    private $prefix = "admin/twilio/";
    private $resources = [];
    private $checkPermissionAndRolesController;
    public function __construct(CheckPermissionsAndRolesController $checkPermissionAndRolesController)
    {
        $this->resources['prefix'] = $this->prefix;
        $this->checkPermissionAndRolesController = $checkPermissionAndRolesController;
    }
    public function index(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Twilio User Credits']);
        $this->resources['data'] =  UserCredit::join('users', 'user_credits.user_id', 'users.id')->select('users.call_balance', 'user_credits.*', 'users.name as user')->paginate(15);
        $this->resources['users'] =  User::all();
        return view('admin.twilio.user_credit')->with($this->resources);
    }

    public function store(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Twilio User Credits']);

        $credentials = $request->validate([
            'user' => ['required'],
            'credit' => ['required'],

        ]);

        try {
            UserCredit::updateOrCreate(['user_id' => $request->user], [
                'user_id' => $request->user,
                'credit' => $request->credit
            ]);
            $this->resources['messages'] = array("type" => "success", "description" => "Credit creation success");
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
    public function edit(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Twilio User Credits']);
        $this->resources['data'] =  UserCredit::where('id', $request->id)->first();
        $this->resources['users'] =  User::all();
        return view('admin.twilio.user_credit_edit')->with($this->resources);
    }
    public function update(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Twilio User Credits']);

        $credentials = $request->validate([
            'id' => ['required'],
            'user' => ['required'],
            'credit' => ['required'],

        ]);

        try {
            UserCredit::where('id', $request->id)->update([
                'user_id' => $request->user,
                'credit' => $request->credit
            ]);
            $this->resources['messages'] = array("type" => "success", "description" => "Credit update success");
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
    public function delete(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Twilio User Credits']);
        $request->validate([
            'id' => ['required'],
        ]);
        try {
            $superAdmin = $this->checkPermissionAndRolesController->superAdmin($request);
            $query = UserCredit::where('id', $request->id);
            $result = $query->delete();

            if ($result) {
                $this->resources['messages'] = array("type" => "success", "description" => "Credit deleted success");
            } else {
                $this->resources['messages'] = array("type" => "error", "description" => "Credit deleted failed");
            }
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
}
