<?php

namespace App\Http\Controllers;

use App\Models\VoiceCallFromNumber;
use Illuminate\Http\Request;

class VoiceCallFromNumberController extends Controller
{
    private $prefix = "admin/voice-call/";
    private $resources = [];
    private $checkPermissionAndRolesController;
    public function __construct(CheckPermissionsAndRolesController $checkPermissionAndRolesController)
    {
        $this->resources['prefix'] = $this->prefix;
        $this->checkPermissionAndRolesController = $checkPermissionAndRolesController;
    }
    public function index(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Voice Call From Numbers']);
        $this->resources['data'] =  VoiceCallFromNumber::paginate(15);
        return view('admin.voice-call.call_from_numbers')->with($this->resources);
    }
    public function store(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Voice Call From Numbers']);

        $credentials = $request->validate([
            'name' => ['required'],
            'number' => ['required']
        ]);

        try {
            VoiceCallFromNumber::create([
                'name' => $request->name,
                'number' => $request->number,
            ]);
            $this->resources['messages'] = array("type" => "success", "description" => "Voice Call Number creation success");
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
    public function edit(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Voice Call From Numbers']);
        $this->resources['data'] =  VoiceCallFromNumber::where('id', $request->id)->first();
        return view('admin.voice-call.call-from-number-edit')->with($this->resources);
    }
    public function update(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Voice Call From Numbers']);

        $credentials = $request->validate([
            'id' =>['required'],
            'name' => ['required'],
            'number' => ['required']

        ]);

        try {
            VoiceCallFromNumber::where('id', $request->id)->update([
                'name' => $request->name,
                'number' => $request->number,
            ]);
            $this->resources['messages'] = array("type" => "success", "description" => "Voice Call Number update success");
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
    public function delete(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission'=>'Voice Call From Numbers']);
        $request->validate([
            'id' => ['required'],   
        ]);
        try {
            $superAdmin = $this->checkPermissionAndRolesController->superAdmin($request);
            $query = VoiceCallFromNumber::where('id', $request->id);
            $result = $query->delete();

            if($result){
                $this->resources['messages'] = array("type" => "success", "description"=>"Voice Call Number deleted success");
            }else{
                $this->resources['messages'] = array("type" => "error", "description"=>"Voice Call Number deleted failed");
            }
            return redirect()->back()->with('messages',$this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description"=>$th->getMessage());
            return redirect()->back()->with('messages',$this->resources);
        }
    }
}
