<?php

namespace App\Jobs;

use App\Models\Twilio;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Twilio\Rest\Client;

class CheckTwilioCallStatus implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public $uuid;
    public $telegram;
    public $to;
    public function __construct($uuid, $telegram, $to)
    {
        $this->uuid = $uuid;
        $this->telegram = $telegram;
        $this->to = $to;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $twilio_sid = env('TWILIO_SID');
        $twilio_token = env('TWILIO_AUTH_TOKEN');
        $twilio = new Client($twilio_sid, $twilio_token);

        $uuid = $this->uuid;
        $telegram = $this->telegram;
        $to = $this->to;

        $statusValuesPos = ['pending', 'queued', 'initiated', 'ringing', 'in-progress'];
        $statusValuesNeg = ['canceled', 'completed', 'busy', 'no-answer', 'failed'];

        $call = $twilio->calls($uuid)->fetch();
        Log::info("self::dispatch");
        if (session()->get('sent_status_' . $uuid) !=  $call->status) {
            $msg = $to . " : " . $call->status;
            sendTeligramMessage($telegram, $msg);
            session()->put('sent_status_' . $uuid, $call->status);
        }
        if (in_array($call->status, $statusValuesNeg)) {
            Twilio::where('uuid', $uuid)->update(['telegram_status' => 'processed']);
            session()->forget('sent_status_' . $uuid);
        }else{
            Log::info("self::dispatch");
            self::dispatch($this->uuid, $this->telegram, $this->to)->delay(now()->addSeconds(5));
        }
    }
}
