<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Domain extends Model
{
    use HasFactory;
    protected $fillable = ['link','created_by'];

    public function user()
    {
        return $this->belongsTo(User::class,'created_by');
    }

    public function authorization()
    {
        return $this->hasMany(DomainAuthorization::class,'domain_id');
    }

}
