<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBotDetectorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bot_detectors', function (Blueprint $table) {
            $table->id();
            $table->string('ip_address')->nullable();
            $table->string('detection_method')->nullable();
            $table->text('user_agent')->nullable();
            $table->boolean('is_bot')->default(0);
            $table->text('link')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bot_detectors');
    }
}
