@extends('components.app')
@section('styles')
@endsection
@section('title')
    Manage Domains
@endsection

@section('content')
    <!-- Begin Page Content -->
    <div class="container">

        <!-- Page Heading -->
        {{-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add User</h1>
        
    </div> --}}
        <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
            <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32"
                xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32"
                preserveAspectRatio="xMidYMid slice" focusable="false">
                <title>Placeholder</title>
                <rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%" fill="var(--white)"
                    dy=".3em">32x32</text>
            </svg>

            <div class="ml-2">
                <h1 class="h6 mb-0 text-white lh-1">Manage Bot Detector Logs</h1>
                <small><a class="text-white" href="{{ url('admin/dashboard') }}">dashboard</a> > manage bot detector
                    logs</small>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 text-right mt-3 mb-3">
                <a href="{{ url($prefix . 'delete-all') }}" class="btn btn-danger">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                        class="bi bi-trash" viewBox="0 0 16 16">
                        <path
                            d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z" />
                        <path fill-rule="evenodd"
                            d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z" />
                    </svg>
                    delete all
                </a>
            </div>
        </div>
        <!-- Content Row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow table-responsive">
                    <div class="text-right">
                        <form class="w-100" method="GET" action="{{ url($prefix . 'search?') }}" role="search">
                            <div class="input-group">
                                <input type="text" class="form-control bg-light border-0 small"
                                    placeholder="Search for..." aria-label="Search" aria-describedby="basic-addon2"
                                    name="search">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-primary" type="button">
                                        <i class="fas fa-search fa-sm"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <table class="table table-borderd text-dark text-center small">
                        <thead class="text-uppercase small text-dark">
                            <tr>
                                <th>#id</th>
                                <th>Is Bot</th>
                                <th>Ip Address</th>
                                <th>Detected Method</th>
                                <th>Link</th>
                                <th>User Agent</th>
                                <th>action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($data as $item)
                                <tr @if ($item->is_bot) @class(['bg-danger', 'text-white']) @endif>

                                    <td>{{ $item->id }}</td>
                                    <td>
                                        @if ($item->is_bot)
                                            <span class="badge badge-success">true</span>
                                        @else
                                            <span class="badge badge-danger">false</span>
                                        @endif
                                    </td>
                                    <td>{{ $item->ip_address }}</td>
                                    <td>{{ $item->detection_method }}</td>
                                    <td>{{ $item->link }}</td>
                                    <td>{{ $item->user_agent }}</td>

                                    <td>{{ date('Y-m-d H:i', strtotime($item->created_at)) }}</td>
                                    <td>
                                        <div class="nav-item dropdown no-arrow">
                                            <a class="dropdown-toggle" href="#" id="navbarDropdown" role="button"
                                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    fill="currentColor" class="bi bi-three-dots-vertical"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                                </svg>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                                aria-labelledby="navbarDropdown">
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item delete" href="#"
                                                    id="{{ url($prefix . 'delete?id=' . $item->id) }}">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                        fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                                        <path
                                                            d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z" />
                                                        <path fill-rule="evenodd"
                                                            d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z" />
                                                    </svg>
                                                    delete
                                                </a>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    {{-- @if (!empty($data))
                        {{ $data->links() }}
                    @endif --}}
                </div>
            </div>
            <small class="d-block text-end mt-3">

            </small>
        </div>
    </div>
    </div>
@endsection


@section('scripts')
    {{-- <script>
        $(".auth").click(function () {

            var domain_id = $(this).attr("data-domain-id");
            var user_id = $("#"+domain_id).val();
            if(user_id != ""){
                var authorization = $(this).attr("data-value");
                var token = "{{csrf_token()}}";
                var url = "{{url($prefix.'authorization')}}"
                var data = {
                    "method":"POST",
                    "url":url,
                    "data":{
                        "_token":token,
                        "user_id":user_id,
                        "domain_id":domain_id,
                        "authorization":authorization
                    }
                }
                var result = ajax(data);
                if(result.success == true){
                    var ico = '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-circle" viewBox="0 0 16 16">'+
                            '<path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>'+
                            '<path d="M10.97 4.97a.235.235 0 0 0-.02.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-1.071-1.05z"/></svg>'
                    if(authorization == 1){
                        $("#unauth_"+domain_id).removeClass("btn-danger");
                        $("#unauth_"+domain_id).html('Unauthorized')
                        $("#unauth_"+domain_id).addClass("btn-outline-danger");
                        $(this).removeClass("btn-outline-success");
                        $(this).addClass("btn-success");
                        $(this).html(ico+' Authorized')
                    }else{
                        $("#auth_"+domain_id).removeClass("btn-success");
                        $("#auth_"+domain_id).html('Authorized')
                        $("#auth_"+domain_id).addClass("btn-outline-success");
                        $(this).removeClass("btn-outline-danger");
                        $(this).addClass("btn-danger");
                        $(this).html(ico+" Unauthorized")
                    }
                    swAjaxAlert({"type":"success", "title":result.message});
                }
                
            }else{
                swAjaxAlert({"type":"error", "title":"Please select user first!"});
            }   
            
        })
    </script> --}}
@endsection
