@extends('components.app')
@section('styles')
@endsection
@section('title')
    Domain Authorization
@endsection

@section('content')

<!-- Begin Page Content -->
<div class="container">
    
    <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
        <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32" xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32" preserveAspectRatio="xMidYMid slice" focusable="false"><title>Placeholder</title><rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%" fill="var(--white)" dy=".3em">32x32</text></svg>

        <div class="ml-2">
          <h1 class="h6 mb-0 text-white lh-1">Domain Authorization</h1>
          <small><a class="text-white" href="{{url('admin/dashboard')}}">dashboard</a> > <a class="text-white" href="{{url($prefix.'manage')}}">manage users</a> > domain authorization</small>
        </div>
    </div>
    <!-- Content Row -->
    <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-3"></div>
                            <div class="col-sm-6">
                                <div class="row">
                                    <div class="col-sm-12 mt-2 mb-4">
                                        <span>Domain Name : <a href="{{$data['link']}}">{{$data['link']}}</a></span>
                                        <br>
                                        <h6>Authorized Users</h6>
                                        @foreach($data['authorization'] as $item)
                                            @if ($item['authorization'] != 0)
                                                <span class="badge badge-primary p-2 rounded"><a href="{{url('admin/users/view?id=')}}{{$item['authorized_user']['id']}}" class="text-white">{{$item['authorized_user']['name']}}</a></span>&nbsp;
                                            @endif
                                        @endforeach
                                    </div>
                                </div>
                                <form action="{{url($prefix.'authorization')}}" method="post"> 
                                    @csrf
                                    <input type="hidden" name="domain_id" value="{{$data->id}}">
                                    <div class="form-group">
                                        <label class="small">User <span class="text-danger">*</span></label>
                                        <select name="user_id" class="form-control @error("user_id") is-invalid @enderror">
                                            <option value="">select user</option>
                                            @foreach ($users as $user)
                                                <option value="{{$user->id}}">{{$user->name}}</option> 
                                            @endforeach
                                        </select>
                                        @error('user_id')<span class="text-danger small">{{$message}}</span>@enderror 
                                    </div>
                                    <div class="form-group mt-3">
                                        <label class="small">Authorization <span class="text-danger">*</span></label>
                                        <select name="authorization" class="form-control @error("authorization") is-invalid @enderror">
                                            <option value="">select authorization</option>
                                            <option value="1">Authorized</option>
                                            <option value="0">Unauthorized</option>
                                        </select>
                                        @error('authorization')<span class="text-danger small">{{$message}}</span>@enderror 
                                    </div>
                                    <div class="text-right">
                                        <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4" href="{{url($prefix.'manage')}}">Cancel</a>
                                        <button class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4" type="submit">Update</button>
                                    </div>
                                </form>
                            </div>
                            <div class="col-sm-3"></div>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
        <small class="d-block text-end mt-3">
          
        </small>
      </div>
</div>

@endsection

