@extends('components.app')
@section('styles')
@endsection
@section('title')
    Edit Domain
@endsection

@section('content')

<!-- Begin Page Content -->
<div class="container">
    
    <!-- Page Heading -->
    {{-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add User</h1>
        
    </div> --}}
    <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
        <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32" xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32" preserveAspectRatio="xMidYMid slice" focusable="false"><title>Placeholder</title><rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%" fill="var(--white)" dy=".3em">32x32</text></svg>

        <div class="ml-2">
          <h1 class="h6 mb-0 text-white lh-1">Edit Domain</h1>
          <small><a class="text-white" href="{{url('admin/dashboard')}}">dashboard</a> > <a class="text-white" href="{{url($prefix.'manage')}}">manage domains</a> > edit domain</small>
        </div>
    </div>
    <!-- Content Row -->
    <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <form action="{{url($prefix.'update')}}" method="post"> 
                        @csrf
                            <input type="hidden" name="id" value="{{$data->id}}">

                            <div class="row">
                                <div class="col-sm-3"></div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="small">Domain <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('link') is-invalid @enderror" value="{{$data->link}}" name="link" aria-describedby="linkHelp" id="link"  placeholder="Enter Domain... Ex. https://example.com">
                                        @error('link')<span class="text-danger small">{{$message}}</span>@enderror 
                                    </div>
                                    <div class="text-right mt-4">
                                        <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4" href="{{url($prefix.'manage')}}">Cancel</a>
                                        <button class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4" type="submit">Update</button>
                                    </div>   
                                </div>
                                <div class="col-sm-3"></div>
                            </div>
                        </form>
                    </div> 
                </div>
            </div>
        </div>
        <small class="d-block text-end mt-3">
          
        </small>
      </div>
</div>

@endsection
