
@extends('components.app')
@section('styles')
@endsection
@section('title')
    Edit Email Order
@endsection

@section('content')
    <!-- Begin Page Content -->
    <div class="container">

        <!-- Page Heading -->
        {{-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add User</h1>
        
    </div> --}}
        <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
            <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32"
                xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32"
                preserveAspectRatio="xMidYMid slice" focusable="false">
                <title>Placeholder</title>
                <rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%"
                    fill="var(--white)" dy=".3em">32x32</text>
            </svg>

            <div class="ml-2">
                <h1 class="h6 mb-0 text-white lh-1">Edit Order</h1>
                <small><a class="text-white" href="{{ url('admin/dashboard') }}">dashboard</a> > <a class="text-white"
                        href="{{ url($prefix . 'manage') }}">manage email orders</a> > edit email order</small>
            </div>
        </div>
        <!-- Content Row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <form action="{{ url($prefix . 'update') }}" method="post">
                            @csrf
                            <input type="hidden" name="id" value="{{$data->id}}">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="small">Domain <span class="text-danger">*</span></label>
                                        <select name="domain_id" id="domain_id"
                                            class="form-control @error('domain_id') is-invalid @enderror" required>
                                            <option value="" selected disabled>Select Domain*</option>
                                            @foreach ($authorized_domains as $item)
                                                <option value="{{ $item->id }}" @if($data->domain_id == $item->id) selected @endif>{{ $item->link }}</option>
                                            @endforeach
                                        </select>
                                        @error('domain_id')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    {{-- <div class="form-group">
                                        <input type="text" class="form-control @error('link') is-invalid @enderror"
                                            value="{{ $data->link }}" name="link" aria-describedby="nameHelp"
                                            id="link" placeholder="Enter IMEI*" required>
                                        @error('link')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div> --}}
                                    <div class="form-group">
                                        <label class="small">Imei <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('imei') is-invalid @enderror"
                                            value="{{ $data->imei }}" name="imei" aria-describedby="nameHelp"
                                            id="imei" placeholder="Enter IMEI*" required>
                                        @error('imei')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
									 <div class="form-group">
                                        <label class="small" style="color:red">External Link</label>
                                        <input type="text"
                                            class="form-control @error('custom_link') is-invalid @enderror"
                                            value="{{ $data->link }}" name="custom_link"
                                            aria-describedby="urlHelp" id="custom_link" placeholder="Enter Custom Link"
                                        >
                                        @error('custom_link')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small" style="color:orange">Custom Link Code</label>
                                        <input style="border-color:green" type="text"
                                            class="form-control @error('custom_link_code') is-invalid @enderror"
                                            value="{{ $data->custom_link_code }}" name="custom_link_code"
                                            aria-describedby="urlHelp" id="custom_link_code"
                                            placeholder="Enter Custom Link Code">
                                        @error('custom_link_code')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Email</label>
                                        <input type="email" class="form-control @error('email') is-invalid @enderror"
                                            value="{{ $data->email }}" name="email" aria-describedby="urlHelp"
                                            id="email" placeholder="Enter Email" required>
                                        @error('email')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Phone Number <span class="text-danger">*</span></label>
                                        <input type="text"
                                            class="form-control @error('phone_number') is-invalid @enderror"
                                            value="{{ $data->phone_number }}" name="phone_number"
                                            aria-describedby="urlHelp" id="phone_number" placeholder="Enter Phone Number*"
                                            >
                                        @error('phone_number')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Model <span class="text-danger">*</span></label>
                                        <input type="text"
                                            class="form-control @error('model') is-invalid @enderror"
                                            value="{{ $data->model }}" name="model"
                                            aria-describedby="urlHelp" id="model" placeholder="Enter Iphone Model*"
                                            required>
                                        @error('model')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                   
                                    <span class="small font-weight-bold">--Location--</span>
                                    {{-- <div class="form-group">
                                        <label class="small">Country </label>
                                        <select name="country" id="country"
                                            class="form-control @error('country') is-invalid @enderror" >
                                            <option value="">Select Country</option>
                                            <!-- All countries -->
                                            <option value="Afghanistan" @if($data->country == "Afghanistan") selected @endif>Afghanistan</option>
                                            <option value="Aland Islands" @if($data->country == "Aland Islands") selected @endif>Aland Islands</option>
                                            <option value="Albania" @if($data->country == "Albania") selected @endif>Albania</option>
                                            <option value="Algeria" @if($data->country == "Algeria") selected @endif>Algeria</option>
                                            <option value="American Samoa" @if($data->country == "American Samoa") selected @endif>American Samoa</option>
                                            <option value="Andorra" @if($data->country == "Andorra") selected @endif>Andorra</option>
                                            <option value="Angola" @if($data->country == "Angola") selected @endif>Angola</option>
                                            <option value="Anguilla" @if($data->country == "Anguilla") selected @endif>Anguilla</option>
                                            <option value="Antarctica" @if($data->country == "Antarctica") selected @endif>Antarctica</option>
                                            <option value="Antigua and Barbuda" @if($data->country == "Antigua and Barbuda") selected @endif>Antigua and Barbuda</option>
                                            <option value="Argentina" @if($data->country == "Argentina") selected @endif>Argentina</option>
                                            <option value="Armenia" @if($data->country == "Armenia") selected @endif>Armenia</option>
                                            <option value="Aruba" @if($data->country == "Aruba") selected @endif>Aruba</option>
                                            <option value="Australia" @if($data->country == "Australia") selected @endif>Australia</option>
                                            <option value="Austria" @if($data->country == "Austria") selected @endif>Austria</option>
                                            <option value="Azerbaijan" @if($data->country == "Azerbaijan") selected @endif>Azerbaijan</option>
                                            <option value="Bahamas" @if($data->country == "Bahamas") selected @endif>Bahamas</option>
                                            <option value="Bahrain" @if($data->country == "Bahrain") selected @endif>Bahrain</option>
                                            <option value="Bangladesh" @if($data->country == "Bangladesh") selected @endif>Bangladesh</option>
                                            <option value="Barbados" @if($data->country == "Barbados") selected @endif>Barbados</option>
                                            <option value="Belarus" @if($data->country == "Belarus") selected @endif>Belarus</option>
                                            <option value="Belgium" @if($data->country == "Belgium") selected @endif>Belgium</option>
                                            <option value="Belize" @if($data->country == "Belize") selected @endif>Belize</option>
                                            <option value="Benin" @if($data->country == "Benin") selected @endif>Benin</option>
                                            <option value="Bermuda" @if($data->country == "Bermuda") selected @endif>Bermuda</option>
                                            <option value="Bhutan" @if($data->country == "Bhutan") selected @endif>Bhutan</option>
                                            <option value="Bolivia" @if($data->country == "Bolivia") selected @endif>Bolivia</option>
                                            <option value="Bonaire, Sint Eustatius and Saba" @if($data->country == "Bonaire, Sint Eustatius and Saba") selected @endif>Bonaire, Sint Eustatius and
                                                Saba</option>
                                            <option value="Bosnia and Herzegovina" @if($data->country == "Bosnia and Herzegovina") selected @endif>Bosnia and Herzegovina</option>
                                            <option value="Botswana" @if($data->country == "Botswana") selected @endif>Botswana</option>
                                            <option value="Bouvet Island" @if($data->country == "Bouvet Island") selected @endif>Bouvet Island</option>
                                            <option value="Brazil" @if($data->country == "Brazil") selected @endif>Brazil</option>
                                            <option value="British Indian Ocean Territory" @if($data->country == "British Indian Ocean Territory") selected @endif>British Indian Ocean Territory
                                            </option>
                                            <option value="Brunei Darussalam" @if($data->country == "Brunei Darussalam") selected @endif>Brunei Darussalam</option>
                                            <option value="Bulgaria" @if($data->country == "Bulgaria") selected @endif>Bulgaria</option>
                                            <option value="Burkina Faso" @if($data->country == "Burkina Faso") selected @endif>Burkina Faso</option>
                                            <option value="Burundi" @if($data->country == "Burundi") selected @endif>Burundi</option>
                                            <option value="Cambodia" @if($data->country == "Cambodia") selected @endif>Cambodia</option>
                                            <option value="Cameroon" @if($data->country == "Cameroon") selected @endif>Cameroon</option>
                                            <option value="Canada" @if($data->country == "Canada") selected @endif>Canada</option>
                                            <option value="Cape Verde" @if($data->country == "Cape Verde") selected @endif>Cape Verde</option>
                                            <option value="Cayman Islands" @if($data->country == "Cayman Islands") selected @endif>Cayman Islands</option>
                                            <option value="Central African Republic" @if($data->country == "Central African Republic") selected @endif>Central African Republic</option>
                                            <option value="Chad" @if($data->country == "Chad") selected @endif>Chad</option>
                                            <option value="Chile" @if($data->country == "Chile") selected @endif>Chile</option>
                                            <option value="China" @if($data->country == "China") selected @endif>China</option>
                                            <option value="Christmas Island" @if($data->country == "Christmas Island") selected @endif>Christmas Island</option>
                                            <option value="Cocos (Keeling) Islands" @if($data->country == "Cocos (Keeling) Islands") selected @endif>Cocos (Keeling) Islands</option>
                                            <option value="Colombia" @if($data->country == "Colombia") selected @endif>Colombia</option>
                                            <option value="Comoros" @if($data->country == "Comoros") selected @endif>Comoros</option>
                                            <option value="Congo" @if($data->country == "Congo") selected @endif>Congo</option>
                                            <option value="Congo, Democratic Republic of the Congo" @if($data->country == "Congo, Democratic Republic of the Congo") selected @endif>Congo, Democratic
                                                Republic of the Congo</option>
                                            <option value="Cook Islands" @if($data->country == "Cook Islands") selected @endif>Cook Islands</option>
                                            <option value="Costa Rica" @if($data->country == "Costa Rica") selected @endif>Costa Rica</option>
                                            <option value="Cote D'Ivoire" @if($data->country == "Cote D'Ivoire") selected @endif>Cote D'Ivoire</option>
                                            <option value="Croatia" @if($data->country == "Croatia") selected @endif>Croatia</option>
                                            <option value="Cuba" @if($data->country == "Cuba") selected @endif>Cuba</option>
                                            <option value="Curacao" @if($data->country == "Curacao") selected @endif>Curacao</option>
                                            <option value="Cyprus" @if($data->country == "Cyprus") selected @endif>Cyprus</option>
                                            <option value="Czech Republic" @if($data->country == "Czech Republic") selected @endif>Czech Republic</option>
                                            <option value="Denmark" @if($data->country == "Denmark") selected @endif>Denmark</option>
                                            <option value="Djibouti" @if($data->country == "Djibouti") selected @endif>Djibouti</option>
                                            <option value="Dominica" @if($data->country == "Dominica") selected @endif>Dominica</option>
                                            <option value="Dominican Republic" @if($data->country == "Dominican Republic") selected @endif>Dominican Republic</option>
                                            <option value="Ecuador" @if($data->country == "Ecuador") selected @endif>Ecuador</option>
                                            <option value="Egypt" @if($data->country == "Egypt") selected @endif>Egypt</option>
                                            <option value="El Salvador" @if($data->country == "El Salvador") selected @endif>El Salvador</option>
                                            <option value="Equatorial Guinea" @if($data->country == "Equatorial Guinea") selected @endif>Equatorial Guinea</option>
                                            <option value="Eritrea" @if($data->country == "Eritrea") selected @endif>Eritrea</option>
                                            <option value="Estonia" @if($data->country == "Estonia") selected @endif>Estonia</option>
                                            <option value="Ethiopia" @if($data->country == "Ethiopia") selected @endif>Ethiopia</option>
                                            <option value="Falkland Islands (Malvinas)" @if($data->country == "Falkland Islands (Malvinas)") selected @endif>Falkland Islands (Malvinas)
                                            </option>
                                            <option value="Faroe Islands" @if($data->country == "Faroe Islands") selected @endif>Faroe Islands</option>
                                            <option value="Fiji" @if($data->country == "Fiji") selected @endif>Fiji</option>
                                            <option value="Finland" @if($data->country == "Finland") selected @endif>Finland</option>
                                            <option value="France" @if($data->country == "France") selected @endif>France</option>
                                            <option value="French Guiana" @if($data->country == "French Guiana") selected @endif>French Guiana</option>
                                            <option value="French Polynesia" @if($data->country == "French Polynesia") selected @endif>French Polynesia</option>
                                            <option value="French Southern Territories" @if($data->country == "French Southern Territories") selected @endif>French Southern Territories
                                            </option>
                                            <option value="Gabon" @if($data->country == "Gabon") selected @endif>Gabon</option>
                                            <option value="Gambia" @if($data->country == "Gambia") selected @endif>Gambia</option>
                                            <option value="Georgia" @if($data->country == "Georgia") selected @endif>Georgia</option>
                                            <option value="Germany" @if($data->country == "Germany") selected @endif>Germany</option>
                                            <option value="Ghana" @if($data->country == "Ghana") selected @endif>Ghana</option>
                                            <option value="Gibraltar" @if($data->country == "Gibraltar") selected @endif>Gibraltar</option>
                                            <option value="Greece" @if($data->country == "Greece") selected @endif>Greece</option>
                                            <option value="Greenland" @if($data->country == "Greenland") selected @endif>Greenland</option>
                                            <option value="Grenada" @if($data->country == "Grenada") selected @endif>Grenada</option>
                                            <option value="Guadeloupe" @if($data->country == "Guadeloupe") selected @endif>Guadeloupe</option>
                                            <option value="Guam" @if($data->country == "Guam") selected @endif>Guam</option>
                                            <option value="Guatemala" @if($data->country == "Guatemala") selected @endif>Guatemala</option>
                                            <option value="Guernsey" @if($data->country == "Guernsey") selected @endif>Guernsey</option>
                                            <option value="Guinea" @if($data->country == "Guinea") selected @endif>Guinea</option>
                                            <option value="Guinea-Bissau" @if($data->country == "Guinea-Bissau") selected @endif>Guinea-Bissau</option>
                                            <option value="Guyana" @if($data->country == "Guyana") selected @endif>Guyana</option>
                                            <option value="Haiti" @if($data->country == "Haiti") selected @endif>Haiti</option>
                                            <option value="Heard Island and Mcdonald Islands" @if($data->country == "Heard Island and Mcdonald Islands") selected @endif>Heard Island and Mcdonald
                                                Islands</option>
                                            <option value="Holy See (Vatican City State)" @if($data->country == "Holy See (Vatican City State)") selected @endif>Holy See (Vatican City State)
                                            </option>
                                            <option value="Honduras" @if($data->country == "Honduras") selected @endif>Honduras</option>
                                            <option value="Hong Kong" @if($data->country == "Hong Kong") selected @endif>Hong Kong</option>
                                            <option value="Hungary" @if($data->country == "Hungary") selected @endif>Hungary</option>
                                            <option value="Iceland" @if($data->country == "Iceland") selected @endif>Iceland</option>
                                            <option value="India" @if($data->country == "India") selected @endif>India</option>
                                            <option value="Indonesia" @if($data->country == "Indonesia") selected @endif>Indonesia</option>
                                            <option value="Iran, Islamic Republic of" @if($data->country == "Iran, Islamic Republic of") selected @endif>Iran, Islamic Republic of</option>
                                            <option value="Iraq" @if($data->country == "Iraq") selected @endif>Iraq</option>
                                            <option value="Ireland" @if($data->country == "Ireland") selected @endif>Ireland</option>
                                            <option value="Isle of Man" @if($data->country == "Isle of Man") selected @endif>Isle of Man</option>
                                            <option value="Israel" @if($data->country == "Israel") selected @endif>Israel</option>
                                            <option value="Italy" @if($data->country == "Italy") selected @endif>Italy</option>
                                            <option value="Jamaica" @if($data->country == "Jamaica") selected @endif>Jamaica</option>
                                            <option value="Japan" @if($data->country == "Japan") selected @endif>Japan</option>
                                            <option value="Jersey" @if($data->country == "Jersey") selected @endif>Jersey</option>
                                            <option value="Jordan" @if($data->country == "Jordan") selected @endif>Jordan</option>
                                            <option value="Kazakhstan" @if($data->country == "Kazakhstan") selected @endif>Kazakhstan</option>
                                            <option value="Kenya" @if($data->country == "Kenya") selected @endif>Kenya</option>
                                            <option value="Kiribati" @if($data->country == "Kiribati") selected @endif>Kiribati</option>
                                            <option value="Korea, Democratic People's Republic of" @if($data->country == "Korea, Democratic People's Republic of") selected @endif>Korea, Democratic
                                                People's Republic of</option>
                                            <option value="Korea, Republic of" @if($data->country == "Korea, Republic of") selected @endif>Korea, Republic of</option>
                                            <option value="Kosovo" @if($data->country == "Kosovo") selected @endif>Kosovo</option>
                                            <option value="Kuwait" @if($data->country == "Kuwait") selected @endif>Kuwait</option>
                                            <option value="Kyrgyzstan" @if($data->country == "Kyrgyzstan") selected @endif>Kyrgyzstan</option>
                                            <option value="Lao People's Democratic Republic" @if($data->country == "Lao People's Democratic Republic") selected @endif>Lao People's Democratic
                                                Republic</option>
                                            <option value="Latvia" @if($data->country == "Latvia") selected @endif>Latvia</option>
                                            <option value="Lebanon" @if($data->country == "Lebanon") selected @endif>Lebanon</option>
                                            <option value="Lesotho" @if($data->country == "Lesotho") selected @endif>Lesotho</option>
                                            <option value="Liberia" @if($data->country == "Liberia") selected @endif>Liberia</option>
                                            <option value="Libyan Arab Jamahiriya" @if($data->country == "Libyan Arab Jamahiriya") selected @endif>Libyan Arab Jamahiriya</option>
                                            <option value="Liechtenstein" @if($data->country == "Liechtenstein") selected @endif>Liechtenstein</option>
                                            <option value="Lithuania" @if($data->country == "Lithuania") selected @endif>Lithuania</option>
                                            <option value="Luxembourg" @if($data->country == "Luxembourg") selected @endif>Luxembourg</option>
                                            <option value="Macao" @if($data->country == "Macao") selected @endif>Macao</option>
                                            <option value="Macedonia, the Former Yugoslav Republic of" @if($data->country == "Macedonia, the Former Yugoslav Republic of") selected @endif>Macedonia, the
                                                Former Yugoslav Republic of</option>
                                            <option value="Madagascar" @if($data->country == "Madagascar") selected @endif>Madagascar</option>
                                            <option value="Malawi" @if($data->country == "Malawi") selected @endif>Malawi</option>
                                            <option value="Malaysia" @if($data->country == "Malaysia") selected @endif>Malaysia</option>
                                            <option value="Maldives" @if($data->country == "Maldives") selected @endif>Maldives</option>
                                            <option value="Mali" @if($data->country == "Mali") selected @endif>Mali</option>
                                            <option value="Malta" @if($data->country == "Malta") selected @endif>Malta</option>
                                            <option value="Marshall Islands" @if($data->country == "Marshall Islands") selected @endif>Marshall Islands</option>
                                            <option value="Martinique" @if($data->country == "Martinique") selected @endif>Martinique</option>
                                            <option value="Mauritania" @if($data->country == "Mauritania") selected @endif>Mauritania</option>
                                            <option value="Mauritius" @if($data->country == "Mauritius") selected @endif>Mauritius</option>
                                            <option value="Mayotte" @if($data->country == "Mayotte") selected @endif>Mayotte</option>
                                            <option value="Mexico" @if($data->country == "Mexico") selected @endif>Mexico</option>
                                            <option value="Micronesia, Federated States of" @if($data->country == "Micronesia, Federated States of") selected @endif>Micronesia, Federated States of
                                            </option>
                                            <option value="Moldova, Republic of" @if($data->country == "Moldova, Republic of") selected @endif>Moldova, Republic of</option>
                                            <option value="Monaco" @if($data->country == "Monaco") selected @endif>Monaco</option>
                                            <option value="Mongolia" @if($data->country == "Mongolia") selected @endif>Mongolia</option>
                                            <option value="Montenegro" @if($data->country == "Montenegro") selected @endif>Montenegro</option>
                                            <option value="Montserrat" @if($data->country == "Montserrat") selected @endif>Montserrat</option>
                                            <option value="Morocco" @if($data->country == "Morocco") selected @endif>Morocco</option>
                                            <option value="Mozambique" @if($data->country == "Mozambique") selected @endif>Mozambique</option>
                                            <option value="Myanmar" @if($data->country == "Myanmar") selected @endif>Myanmar</option>
                                            <option value="Namibia" @if($data->country == "Namibia") selected @endif>Namibia</option>
                                            <option value="Nauru" @if($data->country == "Nauru") selected @endif>Nauru</option>
                                            <option value="Nepal" @if($data->country == "Nepal") selected @endif>Nepal</option>
                                            <option value="Netherlands" @if($data->country == "Netherlands") selected @endif>Netherlands</option>
                                            <option value="Netherlands Antilles" @if($data->country == "Netherlands Antilles") selected @endif>Netherlands Antilles</option>
                                            <option value="New Caledonia" @if($data->country == "New Caledonia") selected @endif>New Caledonia</option>
                                            <option value="New Zealand" @if($data->country == "New Zealand") selected @endif>New Zealand</option>
                                            <option value="Nicaragua" @if($data->country == "Nicaragua") selected @endif>Nicaragua</option>
                                            <option value="Niger" @if($data->country == "Niger") selected @endif>Niger</option>
                                            <option value="Nigeria" @if($data->country == "Nigeria") selected @endif>Nigeria</option>
                                            <option value="Niue" @if($data->country == "Niue") selected @endif>Niue</option>
                                            <option value="Norfolk Island" @if($data->country == "Norfolk Island") selected @endif>Norfolk Island</option>
                                            <option value="Northern Mariana Islands" @if($data->country == "Northern Mariana Islands") selected @endif>Northern Mariana Islands</option>
                                            <option value="Norway" @if($data->country == "Norway") selected @endif>Norway</option>
                                            <option value="Oman" @if($data->country == "Oman") selected @endif>Oman</option>
                                            <option value="Pakistan" @if($data->country == "Pakistan") selected @endif>Pakistan</option>
                                            <option value="Palau" @if($data->country == "Palau") selected @endif>Palau</option>
                                            <option value="Palestinian Territory, Occupied" @if($data->country == "Palestinian Territory, Occupied") selected @endif>Palestinian Territory, Occupied
                                            </option>
                                            <option value="Panama" @if($data->country == "Panama") selected @endif>Panama</option>
                                            <option value="Papua New Guinea" @if($data->country == "Papua New Guinea") selected @endif>Papua New Guinea</option>
                                            <option value="Paraguay" @if($data->country == "Paraguay") selected @endif>Paraguay</option>
                                            <option value="Peru" @if($data->country == "Peru") selected @endif>Peru</option>
                                            <option value="Philippines" @if($data->country == "Philippines") selected @endif>Philippines</option>
                                            <option value="Pitcairn" @if($data->country == "Pitcairn") selected @endif>Pitcairn</option>
                                            <option value="Poland" @if($data->country == "Poland") selected @endif>Poland</option>
                                            <option value="Portugal" @if($data->country == "Portugal") selected @endif>Portugal</option>
                                            <option value="Puerto Rico" @if($data->country == "Puerto Rico") selected @endif>Puerto Rico</option>
                                            <option value="Qatar" @if($data->country == "Qatar") selected @endif>Qatar</option>
                                            <option value="Reunion" @if($data->country == "Reunion") selected @endif>Reunion</option>
                                            <option value="Romania" @if($data->country == "Romania") selected @endif>Romania</option>
                                            <option value="Russian Federation" @if($data->country == "Russian Federation") selected @endif>Russian Federation</option>
                                            <option value="Rwanda" @if($data->country == "Rwanda") selected @endif>Rwanda</option>
                                            <option value="Saint Barthelemy" @if($data->country == "Saint Barthelemy") selected @endif>Saint Barthelemy</option>
                                            <option value="Saint Helena" @if($data->country == "Saint Helena") selected @endif>Saint Helena</option>
                                            <option value="Saint Kitts and Nevis" @if($data->country == "Saint Kitts and Nevis") selected @endif>Saint Kitts and Nevis</option>
                                            <option value="Saint Lucia" @if($data->country == "Saint Lucia") selected @endif>Saint Lucia</option>
                                            <option value="Saint Martin" @if($data->country == "Saint Martin") selected @endif>Saint Martin</option>
                                            <option value="Saint Pierre and Miquelon" @if($data->country == "Saint Pierre and Miquelon") selected @endif>Saint Pierre and Miquelon</option>
                                            <option value="Saint Vincent and the Grenadines" @if($data->country == "Saint Vincent and the Grenadines") selected @endif>Saint Vincent and the
                                                Grenadines</option>
                                            <option value="Samoa" @if($data->country == "Samoa") selected @endif>Samoa</option>
                                            <option value="San Marino" @if($data->country == "San Marino") selected @endif>San Marino</option>
                                            <option value="Sao Tome and Principe" @if($data->country == "Sao Tome and Principe") selected @endif>Sao Tome and Principe</option>
                                            <option value="Saudi Arabia" @if($data->country == "Saudi Arabia") selected @endif>Saudi Arabia</option>
                                            <option value="Senegal" @if($data->country == "Senegal") selected @endif>Senegal</option>
                                            <option value="Serbia" @if($data->country == "Serbia") selected @endif>Serbia</option>
                                            <option value="Serbia and Montenegro" @if($data->country == "Serbia and Montenegro") selected @endif>Serbia and Montenegro</option>
                                            <option value="Seychelles" @if($data->country == "Seychelles") selected @endif>Seychelles</option>
                                            <option value="Sierra Leone" @if($data->country == "Sierra Leone") selected @endif>Sierra Leone</option>
                                            <option value="Singapore" @if($data->country == "Singapore") selected @endif>Singapore</option>
                                            <option value="Sint Maarten" @if($data->country == "Sint Maarten") selected @endif>Sint Maarten</option>
                                            <option value="Slovakia" @if($data->country == "Slovakia") selected @endif>Slovakia</option>
                                            <option value="Slovenia" @if($data->country == "Slovenia") selected @endif>Slovenia</option>
                                            <option value="Solomon Islands" @if($data->country == "Solomon Islands") selected @endif>Solomon Islands</option>
                                            <option value="Somalia" @if($data->country == "Somalia") selected @endif>Somalia</option>
                                            <option value="South Africa" @if($data->country == "South Africa") selected @endif>South Africa</option>
                                            <option value="South Georgia and the South Sandwich Islands" @if($data->country == "South Georgia and the South Sandwich Islands") selected @endif>South Georgia and
                                                the South Sandwich Islands</option>
                                            <option value="South Sudan" @if($data->country == "South Sudan") selected @endif>South Sudan</option>
                                            <option value="Spain" @if($data->country == "Spain") selected @endif>Spain</option>
                                            <option value="Sri Lanka" @if($data->country == "Sri Lanka") selected @endif>Sri Lanka</option>
                                            <option value="Sudan" @if($data->country == "Sudan") selected @endif>Sudan</option>
                                            <option value="Suriname" @if($data->country == "Suriname") selected @endif>Suriname</option>
                                            <option value="Svalbard and Jan Mayen" @if($data->country == "Svalbard and Jan Mayen") selected @endif>Svalbard and Jan Mayen</option>
                                            <option value="Swaziland" @if($data->country == "Swaziland") selected @endif>Swaziland</option>
                                            <option value="Sweden" @if($data->country == "Sweden") selected @endif>Sweden</option>
                                            <option value="Switzerland" @if($data->country == "Switzerland") selected @endif>Switzerland</option>
                                            <option value="Syrian Arab Republic" @if($data->country == "Syrian Arab Republic") selected @endif>Syrian Arab Republic</option>
                                            <option value="Taiwan, Province of China" @if($data->country == "Taiwan, Province of China") selected @endif>Taiwan, Province of China</option>
                                            <option value="Tajikistan" @if($data->country == "Tajikistan") selected @endif>Tajikistan</option>
                                            <option value="Tanzania, United Republic of" @if($data->country == "Tanzania, United Republic of") selected @endif>Tanzania, United Republic of
                                            </option>
                                            <option value="Thailand" @if($data->country == "Thailand") selected @endif>Thailand</option>
                                            <option value="Timor-Leste" @if($data->country == "Timor-Leste") selected @endif>Timor-Leste</option>
                                            <option value="Togo" @if($data->country == "Togo") selected @endif>Togo</option>
                                            <option value="Tokelau" @if($data->country == "Tokelau") selected @endif>Tokelau</option>
                                            <option value="Tonga" @if($data->country == "Tonga") selected @endif>Tonga</option>
                                            <option value="Trinidad and Tobago" @if($data->country == "Trinidad and Tobago") selected @endif>Trinidad and Tobago</option>
                                            <option value="Tunisia" @if($data->country == "Tunisia") selected @endif>Tunisia</option>
                                            <option value="Turkey" @if($data->country == "Turkey") selected @endif>Turkey</option>
                                            <option value="Turkmenistan" @if($data->country == "Turkmenistan") selected @endif>Turkmenistan</option>
                                            <option value="Turks and Caicos Islands" @if($data->country == "Turks and Caicos Islands") selected @endif>Turks and Caicos Islands</option>
                                            <option value="Tuvalu" @if($data->country == "Tuvalu") selected @endif>Tuvalu</option>
                                            <option value="Uganda" @if($data->country == "Uganda") selected @endif>Uganda</option>
                                            <option value="Ukraine" @if($data->country == "Ukraine") selected @endif>Ukraine</option>
                                            <option value="United Arab Emirates" @if($data->country == "United Arab Emirates") selected @endif>United Arab Emirates</option>
                                            <option value="United Kingdom" @if($data->country == "United Kingdom") selected @endif>United Kingdom</option>
                                            <option value="United States" @if($data->country == "United States") selected @endif>United States</option>
                                            <option value="United States Minor Outlying Islands" @if($data->country == "United States Minor Outlying Islands") selected @endif>United States Minor
                                                Outlying Islands</option>
                                            <option value="Uruguay" @if($data->country == "Uruguay") selected @endif>Uruguay</option>
                                            <option value="Uzbekistan" @if($data->country == "Uzbekistan") selected @endif>Uzbekistan</option>
                                            <option value="Vanuatu" @if($data->country == "Vanuatu") selected @endif>Vanuatu</option>
                                            <option value="Venezuela" @if($data->country == "Venezuela") selected @endif>Venezuela</option>
                                            <option value="Viet Nam" @if($data->country == "Viet Nam") selected @endif>Viet Nam</option>
                                            <option value="Virgin Islands, British" @if($data->country == "Virgin Islands, British") selected @endif>Virgin Islands, British</option>
                                            <option value="Virgin Islands, U.s." @if($data->country == "Virgin Islands, U.s.") selected @endif>Virgin Islands, U.s.</option>
                                            <option value="Wallis and Futuna" @if($data->country == "Wallis and Futuna") selected @endif>Wallis and Futuna</option>
                                            <option value="Western Sahara" @if($data->country == "Western Sahara") selected @endif>Western Sahara</option>
                                            <option value="Yemen" @if($data->country == "Yemen") selected @endif>Yemen</option>
                                            <option value="Zambia" @if($data->country == "Zambia") selected @endif>Zambia</option>
                                            <option value="Zimbabwe" @if($data->country == "Zimbabwe") selected @endif>Zimbabwe</option>
                                        </select>
                                        @error('country')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div> --}}
                                    <div class="form-group">
                                        <label class="small">City/Address</label>
                                        <input type="text" class="form-control @error('city') is-invalid @enderror"
                                            value="{{ $data->city }}" name="city" aria-describedby="urlHelp"
                                            id="city" placeholder="Enter City">
                                        @error('city')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Country/Region </label>
                                        <div class="d-inline-flex w-100">
                                            <input type="text" class="form-control @error('country') is-invalid @enderror"
                                            value="{{ $data->country }}" name="country" aria-describedby="urlHelp"
                                            id="country" placeholder="Enter Country">
                                            <button id="fill_geo" class="btn btn-secondary ml-2 w-25" type="button">fill below</button>
                                        </div>
                                        @error('city')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Latitude </label>
                                        <input type="text" class="form-control @error('latitude') is-invalid @enderror"
                                            value="{{ $data->latitude }}" name="latitude" aria-describedby="urlHelp"
                                            id="latitude" placeholder="Enter Latitude*" >
                                        @error('latitude')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Longitude </label>
                                        <input type="text"
                                            class="form-control @error('longitude') is-invalid @enderror"
                                            value="{{ $data->longitude }}" name="longitude" aria-describedby="urlHelp"
                                            id="longitude" placeholder="Enter Longitude*" >
                                        @error('longitude')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-check mb-3">
                                        <input class="form-check-input" type="checkbox" value="true" name="without_email" id="send-sms" @if($data->send_sms == 1) checked @endif>
                                        <label class="form-check-label" for="send-sms">
                                            Create Order Without Sending Email
                                        </label>
                                      </div>

                                    <div class="form-group">
                                        <label class="small">Smtp <span class="text-danger">*</span></label>
                                        <select name="smtp_id" id="smtp_id"
                                            class="form-control sms-fields @error('smtp_id') is-invalid @enderror" required>
                                            <option value="" selected disabled>Select Sender*</option>
                                            @foreach ($smtp as $item)
                                                <option value="{{ $item->id }}" @if($data->smtp_id == $item->id) selected @endif>{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('sender_api_id')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
									   <div class="form-group">
                                        <label class="small">Subject <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control sms-fields @error('subject') is-invalid @enderror"
                                            value="{{ $data->subject }}" name="subject" aria-describedby="nameHelp"
                                            id="subject" placeholder="Enter Subject*" required>
                                        @error('subject')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">From Name <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control sms-fields @error('from_name') is-invalid @enderror"
                                            value="{{ $data->from_name }}" name="from_name" aria-describedby="nameHelp"
                                            id="from_name" placeholder="Enter From Name*" required>
                                        @error('from_name')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div id="show_template"></div>
                                    <div class="form-group mt-2">
                                        <label class="small">Script <span class="text-danger">*</span></label>
                                        <select name="script_id" id="script_id"
                                            class="form-control @error('script_id') is-invalid @enderror" required>
                                            <option value="" selected disabled>Select Script*</option>
                                            @foreach ($scripts as $item)
                                                <option value="{{ $item->id }}" @if($data->script_id == $item->id) selected @endif>{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('script_id')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Email Template <span class="text-danger">*</span></label>
                                        <select name="template_id" id="template_id"
                                            class="form-control sms-fields @error('template_id') is-invalid @enderror" required>
                                            <option value="" selected disabled>Select Email Template*</option>
                                            @foreach ($email_templates as $item)
                                                <option value="{{ $item->id }}" @if($data->template_id == $item->id) selected @endif>{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('template_id')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                 
                                    <div class="form-group">
                                        <label class="small">Notes</label>
                                        <textarea name="note" id="" cols="30" rows="5" class="form-control">{{ $data->note }}</textarea>
                                        @error('note')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label class="small">Redirect</label>
                                            <select name="redirect" id="redirect"
                                                class="form-control sms-fields @error('redirect') is-invalid @enderror" required>
                                                <option value="" selected disabled>Select True/False</option>
                                                    <option value="1" @if($data->redirect == '1') selected @endif>True</option>
                                                    <option value="0" @if($data->redirect == '0') selected @endif>False</option>
                                            </select>
                                            @error('redirect')
                                                <span class="text-danger small">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        @error('redirect')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="text-right mt-4">
                                        <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            href="{{ url()->previous() }}">Cancel</a>
                                        <button class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            type="submit">Update</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <small class="d-block text-end mt-3">

        </small>
    </div>
    </div>
@endsection

@section('scripts')
<script src="{{asset('assets/js/ajax.js')}}"></script>
    <script>
        $("#send-sms").on("change", function () {
            if(this.checked){
                $(".sms-fields").attr("disabled", "disabled");
            }else{
                $(".sms-fields").removeAttr("disabled");
            }
        })

        $("#template_id").on("change", function () {
            var url = "{{ url('admin/email-order/get-template-ajax') }}"
            var result = ajax({'method':'POST', 'url':url, 'data':{'id':this.value},'type':'JSON'});
            $("#show_template").html(result.template)
        })
    </script>
@endsection
