
@extends('components.app')
@section('styles')
@endsection
@section('title')
    Instant Orders
@endsection

@section('content')
    <!-- Begin Page Content -->
    <div class="container">

        <!-- Page Heading -->
        {{-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add User</h1>
        
    </div> --}}
        <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
            <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32"
                xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32"
                preserveAspectRatio="xMidYMid slice" focusable="false">
                <title>Placeholder</title>
                <rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%"
                    fill="var(--white)" dy=".3em">32x32</text>
            </svg>

            <div class="ml-2">
                <h1 class="h6 mb-0 text-white lh-1">Instant Orders</h1>
                <small><a class="text-white" href="{{ url('admin/dashboard') }}">dashboard</a> > instant-orders</small>
            </div>
        </div>
        <!-- Content Row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <form action="{{ url($prefix . 'store') }}" method="post">
                            @csrf
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="small">Domain <span class="text-danger">*</span></label>
                                        <select name="domain_id" id="domain_id"
                                            class="form-control @error('domain_id') is-invalid @enderror" required>
                                            <option value="" selected disabled>Select Domain*</option>
                                            @foreach ($authorized_domains as $item)
                                                <option value="{{ $item->id }}">{{ $item->link }}</option>
                                            @endforeach
                                        </select>
                                        @error('domain_id')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Imei <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('imei') is-invalid @enderror"
                                            value="{{ old('imei') }}" name="imei" aria-describedby="nameHelp"
                                            id="imei" placeholder="Enter IMEI*" required>
                                        @error('imei')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
										 <div class="form-group">
                                        <label class="small" style="color:red">Custom Link Code</label>
                                        <input style="border-color:green" type="text"
                                            class="form-control @error('custom_link_code') is-invalid @enderror"
                                            value="{{ old('custom_link_code') }}" name="custom_link_code"
                                            aria-describedby="urlHelp" id="custom_link_code"
                                            placeholder="Enter Custom Link Code">
                                        @error('custom_link_code')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
									 <div class="form-group">
                                        <label class="small">Email</label>
                                        <input type="email" class="form-control @error('email') is-invalid @enderror"
                                            value="{{ old('email') }}" name="email" aria-describedby="urlHelp"
                                            id="email" placeholder="Enter Email">
                                        @error('email')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Model <span class="text-danger">*</span></label>
                                        <input type="text"
                                            class="form-control @error('model') is-invalid @enderror"
                                            value="{{ old('model' )?? ('iPhone')}}" name="model"
                                            aria-describedby="urlHelp" id="model" placeholder="Enter iPhone Model*"
                                            required>
                                        @error('model')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                   
                                    
                                    <div class="form-group">
                                        <label class="small">City/Address</label>
                                        <input type="text" class="form-control @error('city') is-invalid @enderror"
                                            value="{{ old('city') }}" name="city" aria-describedby="urlHelp"
                                            id="city" placeholder="Enter City">
                                        @error('city')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Country/Region </label>
                                        <div class="d-inline-flex w-100">
                                            <input type="text" class="form-control @error('country') is-invalid @enderror"
                                            value="{{ old('country') }}" name="country" aria-describedby="urlHelp"
                                            id="country" placeholder="Enter Country">
                                            <button id="fill_geo" class="btn btn-secondary ml-2 w-25" type="button">fill below</button>
                                        </div>
                                        @error('city')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Latitude </label>
                                        <input type="text" class="form-control @error('latitude') is-invalid @enderror"
                                            value="{{ old('latitude') }}" name="latitude" aria-describedby="urlHelp"
                                            id="latitude" placeholder="Enter Latitude*" >
                                        @error('latitude')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Longitude </label>
                                        <input type="text"
                                            class="form-control @error('longitude') is-invalid @enderror"
                                            value="{{ old('longitude') }}" name="longitude" aria-describedby="urlHelp"
                                            id="longitude" placeholder="Enter Longitude*" >
                                        @error('longitude')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-6">
									<div id="show_template"></div>
                                    <div class="form-group mt-2">
                                        <label class="small">Script <span class="text-danger">*</span></label>
                                        <select name="script_id" id="script_id"
                                            class="form-control @error('script_id') is-invalid @enderror" required>
                                            <option value="" selected disabled>Select Script*</option>
                                            @foreach ($scripts as $item)
                                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('script_id')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Notes</label>
                                        <textarea name="note" id="" cols="30" rows="5" class="form-control">{{ old('note') }}</textarea>
                                        @error('note')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="text-right mt-4">
                                        <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            href="{{ url()->previous() }}">Cancel</a>
                                        <button class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            type="submit">Create</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <small class="d-block text-end mt-3">

        </small>
    </div>
    </div>
@endsection

@section('scripts')
<script src="{{asset('assets/js/ajax.js')}}"></script>
    <script>
        $("#send-sms").on("change", function () {
            if(this.checked){
                $(".sms-fields").attr("disabled", "disabled");
            }else{
                $(".sms-fields").removeAttr("disabled");
            }
        })

        $("#template_id").on("change", function () {
            var url = "{{ url('admin/email-order/get-template-ajax') }}"
            var result = ajax({'method':'POST', 'url':url, 'data':{'id':this.value},'type':'JSON'});
            $("#show_template").html(result.template)
        })
    </script>
@endsection
