
@extends('components.app')
@section('styles')
@endsection
@section('title')
    Edit Order
@endsection

@section('content')
    <!-- Begin Page Content -->
    <div class="container">

        <!-- Page Heading -->
        {{-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add User</h1>
        
    </div> --}}
        <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
            <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32"
                xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32"
                preserveAspectRatio="xMidYMid slice" focusable="false">
                <title>Placeholder</title>
                <rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%"
                    fill="var(--white)" dy=".3em">32x32</text>
            </svg>

            <div class="ml-2">
                <h1 class="h6 mb-0 text-white lh-1">Edit Order</h1>
                <small><a class="text-white" href="{{ url('admin/dashboard') }}">dashboard</a> > <a class="text-white"
                        href="{{ url($prefix . 'manage') }}">manage orders</a> > edit order</small>
            </div>
        </div>
        <!-- Content Row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <form action="{{ url($prefix . 'update') }}" method="post">
                            @csrf
                            <input type="hidden" name="id" value="{{$data->id}}">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="small">Domain <span class="text-danger">*</span></label>
                                        <select name="domain_id" id="domain_id"
                                            class="form-control @error('domain_id') is-invalid @enderror" required>
                                            <option value="" selected disabled>Select Domain*</option>
                                            @foreach ($authorized_domains as $item)
                                                <option value="{{ $item->id }}" @if($data->domain_id == $item->id) selected @endif>{{ $item->link }}</option>
                                            @endforeach
                                        </select>
                                        @error('domain_id')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    {{-- <div class="form-group">
                                        <input type="text" class="form-control @error('link') is-invalid @enderror"
                                            value="{{ $data->link }}" name="link" aria-describedby="nameHelp"
                                            id="link" placeholder="Enter IMEI*" required>
                                        @error('link')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div> --}}
                                    <div class="form-group">
                                        <label class="small">Imei <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('imei') is-invalid @enderror"
                                            value="{{ $data->imei }}" name="imei" aria-describedby="nameHelp"
                                            id="imei" placeholder="Enter IMEI*" required>
                                        @error('imei')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
									<div class="form-group">
                                        <label class="small" style="color:red">Custom Link Code</label>
                                        <input style="border-color:green" type="text"
                                            class="form-control @error('custom_link_code') is-invalid @enderror"
                                            value="{{ $data->custom_link_code }}" name="custom_link_code"
                                            aria-describedby="urlHelp" id="custom_link_code"
                                            placeholder="Enter Custom Link Code">
                                        @error('custom_link_code')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Email</label>
                                        <input type="email" class="form-control @error('email') is-invalid @enderror"
                                            value="{{ $data->email }}" name="email" aria-describedby="urlHelp"
                                            id="email" placeholder="Enter Email">
                                        @error('email')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group">
                                        <label class="small">Phone Number <span class="text-danger">*</span> ( separate numbers by comma "," for multiple numbers ) </label>
                                        <textarea
                                            class="form-control validate-number @error('phone_number') is-invalid @enderror"
                                            name="phone_number"
                                            aria-describedby="urlHelp" id="phone_number" placeholder="Enter Phone Number*"
                                            required>{{ $data->phone_number }}</textarea>
                                        @error('phone_number')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                        <button class="btn btn-primary validate-number-btn-multiple mt-2 btn-sm" type="button">validate numbers</button>
                                        <div id="number-validation-result" class="bg-gray mt-2"></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Model <span class="text-danger">*</span></label>
                                        <input type="text"
                                            class="form-control @error('model') is-invalid @enderror"
                                            value="{{ $data->model }}" name="model"
                                            aria-describedby="urlHelp" id="model" placeholder="Enter iPhone Model*"
                                            required>
                                        @error('model')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    
                                    <span class="small font-weight-bold">--Location [Must Setup For Every Map Script]--</--</span>
                                    
                                    <div class="form-group">
                                        <label class="small">City/Address</label>
                                        <input type="text" class="form-control @error('city') is-invalid @enderror"
                                            value="{{ $data->city }}" name="city" aria-describedby="urlHelp"
                                            id="city" placeholder="Enter City">
                                        @error('city')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Country/Region </label>
                                        <div class="d-inline-flex w-100">
                                            <input type="text" class="form-control @error('country') is-invalid @enderror"
                                            value="{{ $data->country }}" aria-describedby="urlHelp"
                                            id="country" placeholder="Enter Country">
                                            <button id="fill_geo" class="btn btn-secondary ml-2 w-25" type="button">fill below</button>
                                        </div>
                                        @error('city')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Latitude </label>
                                        <input type="text" class="form-control @error('latitude') is-invalid @enderror"
                                            value="{{ $data->latitude }}" name="latitude" aria-describedby="urlHelp"
                                            id="latitude" placeholder="Enter Latitude*" >
                                        @error('latitude')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Longitude </label>
                                        <input type="text"
                                            class="form-control @error('longitude') is-invalid @enderror"
                                            value="{{ $data->longitude }}" name="longitude" aria-describedby="urlHelp"
                                            id="longitude" placeholder="Enter Longitude*" >
                                        @error('longitude')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-check mb-3">
                                        <input class="form-check-input" type="checkbox" value="true" name="without_sms" id="send-sms" @if($data->send_sms == 1) checked @endif>
                                        <label class="form-check-label" for="send-sms">
                                            Create Order Without Sending Sms
                                        </label>
                                      </div>
                                    <div class="form-group">
                                        <label class="small">Sender Id <span class="text-danger">*</span></label>
                                        <input type="text"
                                            class="form-control sms-fields @error('sender_id') is-invalid @enderror"
                                            value="{{ $data->sender_id }}" name="sender_id" aria-describedby="urlHelp"
                                            id="sender_id" placeholder="Enter Sender ID*" required>
                                        @error('sender_id')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label class="small">Sender Api <span class="text-danger">*</span></label>
                                        <select name="sender_api_id" id="sender_api_id"
                                            class="form-control sms-fields @error('sender_api_id') is-invalid @enderror" required>
                                            <option value="" selected disabled>Select Sender*</option>
                                            @foreach ($sms_apis as $item)
                                                <option value="{{ $item->id }}" @if($data->sender_api_id == $item->id) selected @endif>{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('sender_api_id')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Sms Template <span class="text-danger">*</span></label>
                                        <select name="template_id" id="template_id"
                                            class="form-control sms-fields @error('template_id') is-invalid @enderror" required>
                                            <option value="" selected disabled>Select Sms Template*</option>
                                            @foreach ($sms_templates as $item)
                                                <option value="{{ $item->id }}" @if($data->template_id == $item->id) selected @endif>{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('template_id')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group">
                                        <label class="small">Message <span class="text-danger">*</span></label>
                                        <textarea name="message" id="message" cols="30" rows="5" class="form-control sms-fields" required>{{ $data->message }}</textarea>
                                        @error('message')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="bg-light p-2">
                                        <span class="small text-bold">
                                            Shortcodes : 
                                            [LINK] ,
                                            [IMEI] ,
                                            [MODEL] 
                                        </span>
                                    </div>
                                    {{-- <div class="form-group">
                                        <label class="small">Send to multiple numbers <strong class="">( separate numbers by comma "," )</strong></label>
                                        <textarea name="multiple_numbers" id="" cols="30" rows="5" class="form-control sms-fields">{{ implode(",", $data->multiple_numbers) }}</textarea>
                                        @error('multiple_numbers')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div> --}}
                                    <div class="form-group mt-2">
                                        <label class="small">Script <span class="text-danger">*</span></label>
                                        <select name="script_id" id="script_id"
                                            class="form-control @error('script_id') is-invalid @enderror" required>
                                            <option value="" selected disabled>Select Script*</option>
                                            @foreach ($scripts as $item)
                                                <option value="{{ $item->id }}" @if($data->script_id == $item->id) selected @endif>{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('script_id')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Notes</label>
                                        <textarea name="note" id="" cols="30" rows="5" class="form-control">{{ $data->note }}</textarea>
                                        @error('note')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <div class="form-group">
                                         
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="text-right mt-4">
                                        <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            href="{{ url()->previous() }}">Cancel</a>
                                        <button class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            type="submit">Update</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <small class="d-block text-end mt-3">

        </small>
    </div>
    </div>
@endsection

@section('scripts')
<script src="{{asset('assets/js/ajax.js')}}"></script>
    <script>
        $("#send-sms").on("change", function () {
            if(this.checked){
                $(".sms-fields").attr("disabled", "disabled");
            }else{
                $(".sms-fields").removeAttr("disabled");
            }
        })

        $("#template_id").on("change", function () {
            var url = "{{ url('admin/orders/get-template-ajax') }}"
            var result = ajax({'method':'POST', 'url':url, 'data':{'id':this.value},'type':'JSON'});
            $("#message").html(result.template)
        })
    </script>
@endsection
