@extends('components.app')
@section('styles')
@endsection
@section('title')
    Add User
@endsection

@section('content')

<!-- Begin Page Content -->
<div class="container">
    
    <!-- Page Heading -->
    {{-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add User</h1>
        
    </div> --}}
    <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
        <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32" xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32" preserveAspectRatio="xMidYMid slice" focusable="false"><title>Placeholder</title><rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%" fill="var(--white)" dy=".3em">32x32</text></svg>

        <div class="ml-2">
          <h1 class="h6 mb-0 text-white lh-1">Add User</h1>
          <small><a class="text-white" href="{{url('admin/dashboard')}}">dashboard</a> > <a class="text-white" href="{{url($prefix.'manage')}}">manage users</a> > add new user</small>
        </div>
    </div>
    <!-- Content Row -->
    <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-3"></div>
                            <div class="col-sm-6">
                                <form action="{{url($prefix.'store')}}" method="post"> 
                                    @csrf
                                    <div class="form-group">
                                        <label class="small">Name <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('name') is-invalid @enderror" value="{{old('name')}}" name="name" aria-describedby="nameHelp" placeholder="Enter Name...">
                                        @error('name')<span class="text-danger small">{{$message}}</span>@enderror 
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Email <span class="text-danger">*</span></label>
                                        <input type="email" class="form-control @error('email') is-invalid @enderror" value="{{old('email')}}" name="email" aria-describedby="emailHelp" placeholder="Enter Email Address...">
                                        @error('email')<span class="text-danger small">{{$message}}</span>@enderror 
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Password <span class="text-danger">*</span></label>
                                        <input type="password" class="form-control @error('password') is-invalid @enderror" value="{{old('password')}}" name="password" aria-describedby="passwordHelp" placeholder="Enter Password...">
                                        @error('password')<span class="text-danger small">{{$message}}</span>@enderror 
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Confirm Password <span class="text-danger">*</span></label>
                                        <input type="password" class="form-control @error('password_confirmation') is-invalid @enderror" value="{{old('password_confirmation')}}" name="password_confirmation" aria-describedby="passwordHelp" placeholder="Enter Confirmed Password...">
                                        @error('password_confirmation')<span class="text-danger small">{{$message}}</span>@enderror 
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Telegram <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('teligram') is-invalid @enderror" value="{{old('teligram')}}" name="teligram" aria-describedby="teligramHelp" placeholder="Enter Teligram Id...">
                                        @error('teligram')<span class="text-danger small">{{$message}}</span>@enderror 
                                    </div>
                                    <div class="form-group mb-2">
                                        <label class="small">Type <span class="text-danger">*</span></label>
                                        <select name="type" id="type" class="form-control @error('type') is-invalid @enderror" >
                                            <option value="">select type</option>
                                            @if(!empty($roles))
                                                @foreach ($roles as $item)
                                                    <option value="{{$item->id}}">{{$item->name}}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                        @error('type')<span class="text-danger small">{{$message}}</span>@enderror 
                                    </div>
        
                                    <div class="form-group small mb-2">
                                        <label class="small">Status <span class="text-danger">*</span></label>
                                        <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" >
                                            <option value="1">active</option>
                                            <option value="0">block</option>
                                        </select>
                                        @error('status')<span class="text-danger small">{{$message}}</span>@enderror 
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Secret Code<span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('secret_code') is-invalid @enderror" value="{{old('secret_code')}}" name="secret_code" aria-describedby="Secret Code" placeholder="Enter secret code...">
                                        @error('secret_code')<span class="text-danger small">{{$message}}</span>@enderror 
                                    </div>
                                    <div class="text-right">
                                        <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4" href="{{url()->previous()}}">Cancel</a>
                                        <button class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4" type="submit">Create</button>
                                    </div>
                                </form>
                            </div>
                            <div class="col-sm-3"></div>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
        <small class="d-block text-end mt-3">
          
        </small>
      </div>
</div>

@endsection
@section('scripts')
<script>
    $(document).ready(function() {
        // Function to generate random secret code
        function generateSecretCode(length = 10) {
            const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()';
            let result = '';
            const charactersLength = characters.length;
            
            for (let i = 0; i < length; i++) {
                result += characters.charAt(Math.floor(Math.random() * charactersLength));
            }
            
            return result;
        }
        
        // Generate and set a random secret code initially
        $('input[name="secret_code"]').val(generateSecretCode());
        
        // Add a refresh button next to the secret code field
        $('input[name="secret_code"]').after(
            '<button type="button" class="btn btn-sm btn-outline-secondary mt-2" id="refreshSecretCode">' +
            '<i class="fas fa-sync-alt"></i> Generate New Code</button>'
        );
        
        // Regenerate code when refresh button is clicked
        $(document).on('click', '#refreshSecretCode', function(e) {
            e.preventDefault();
            $('input[name="secret_code"]').val(generateSecretCode());
        });
    });
</script>   
@endsection
