@extends('components.app')
@section('styles')
@endsection
@section('title')
    User Call Blance
@endsection

@section('content')
    <!-- Begin Page Content -->
    <div class="container">

        <!-- Page Heading -->
        {{-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add User</h1>
        
    </div> --}}
        <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
            <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32"
                xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32"
                preserveAspectRatio="xMidYMid slice" focusable="false">
                <title>Placeholder</title>
                <rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%"
                    fill="var(--white)" dy=".3em">32x32</text>
            </svg>

            <div class="ml-2">
                <h1 class="h6 mb-0 text-white lh-1">User Call Blance</h1>
                <small><a class="text-white" href="{{ url('admin/dashboard') }}">dashboard</a> > user call blance</small>
            </div>
        </div>
        <!-- Content Row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <form action="{{ url($prefix . 'credits-update') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-sm-4">
                                    <input type="hidden" name="id" value="{{$data->id}}">
                                    <div class="form-group">
                                        <label class="small">User <span class="text-danger">*</span></label>
                                        <select name="user" id="user"
                                            class="form-control @error('user') is-invalid @enderror" required>
                                            <option value="" selected disabled>Select User*</option>
                                                @foreach($users as $user)
                                                <option value="{{$user->id}}" @if($data->user_id == $user->id) selected @endif>{{$user->name}}</option>
                                                @endforeach
                                        </select>
                                        @error('user')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Credit Balance <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('credit') is-invalid @enderror"
                                            value="{{$data->credit }}" name="credit" aria-describedby="creditHelp"
                                            id="credit" placeholder="credit" required>
                                        @error('credit')
                                            <span class="text-danger small">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="mt-4">
                                        <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            href="{{ url()->previous() }}">Cancel</a>
                                        <button class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            type="submit">Update</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                        
                        
                    </div>
                </div>
            </div>
        </div>
        <small class="d-block text-end mt-3">

        </small>
    </div>
    </div>
@endsection

@section('scripts')
    <script>
    </script>
@endsection
