
@if(session('messages'))
<script>
  $(document).ready(function () {
    Swal.fire({
      position: 'top-end',
      icon: "{{session('messages')['messages']['type']}}",
      title: "{{session('messages')['messages']['description']}}",
      showConfirmButton: false,
      timer: 5000
    })
  })
</script>
@endif

<script>
  // delete action
  $(document).on("click", ".delete", function () { 
    Swal.fire({
    title: 'Are you sure?',
    text: "You won't be able to revert this!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Yes, delete it!'
  }).then((result) => {
      if (result.isConfirmed) {
        var url = this.id;
        $("#deleteForm").removeAttr("action")
        $("#deleteForm").attr("action",url)
        $("#deleteForm").submit();
      }
    })
  });
  $(document).on("click","#fill_geo", function () {
        const href = "{{ url('admin/common/positionstack') }}"
        var query = $("#city").val()
        var region = $("#country").val()
        var url = href
        if(query === '' || region === ''){
          Swal.fire({
                position: 'top-end',
                icon: "error",
                title: "City and country required",
                showConfirmButton: false,
                timer: 7000
            })
            return
        }
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
            }
        });
        $.ajax({
            type: "POST",
            url: url,
            dataType: "JSON",
            data:{
                query:query,
                region:region
            },
        beforeSend:function (){
            $("#loader").show();
        },
        success: function (response) {
            $("#loader").hide();
            if(response.length == 0 ){
                Swal.fire({
                position: 'top-end',
                icon: "error",
                title: "Location not valid",
                showConfirmButton: false,
                timer: 7000
            })
            }else if(response !== undefined){
              $("#latitude").val(response.latitude)
              $("#longitude").val(response.longitude)
            }
        },
        error:function(xhr){
            $("#loader").hide();
            Swal.fire({
                position: 'top-end',
                icon: "error",
                title: xhr.responseJSON.message,
                showConfirmButton: false,
                timer: 7000
            })
        }
        });
    })
</script>

@if ($errors->any())
    @foreach ($errors->all() as $error)
      <script>
        $(document).ready(function () {
          Swal.fire({
            position: 'top-end',
            icon: "error",
            title: "{{$error}}",
            showConfirmButton: false,
            timer: 5000
          })
        })
      </script>
      @break
    @endforeach 
@endif
<div class="position-fixed top-2 end-0 p-3" style="z-index: 11">
  <div id="liveToast" class="toast toast-session hide" role="alert" aria-live="assertive" aria-atomic="true">
    <div class="toast-header">
      <svg class="bd-placeholder-img rounded mr-2" width="20" height="20" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid slice" focusable="false" role="img">
        <rect width="100%" height="100%" fill="@if(session('messages'))@if(session('messages')['messages']['type'] == 'error') #dc3545 @else #1DBF73 @endif @endif"></rect>
      </svg>
      <strong class="me-auto">&nbsp; @if(session('messages')){{session('messages')['messages']['type']}} @endif</strong>
      <small>just now</small>
      <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
    </div>
    <div class="toast-body">
      @if(session('messages')){{session('messages')['messages']['description']}}@endif
    </div>
  </div>
</div>


<form method="post" id="deleteForm" hidden>
  <div class="modal-body">
      @csrf
  </div>
  <div class="modal-footer">
      <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      <button type="submit" class="btn btn-success ">Delete</button>
  </div>
</form>