<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title'); ?>
Order Settings
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Begin Page Content -->
    <div class="container">

        <!-- Page Heading -->
        
        <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
            <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32"
                xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32"
                preserveAspectRatio="xMidYMid slice" focusable="false">
                <title>Placeholder</title>
                <rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%"
                    fill="var(--white)" dy=".3em">32x32</text>
            </svg>

            <div class="ml-2">
                <h1 class="h6 mb-0 text-white lh-1">Order Settings</h1>
                <small><a class="text-white" href="<?php echo e(url('admin/dashboard')); ?>">dashboard</a> > order settings</small>
            </div>
        </div>
        <!-- Content Row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <form action="<?php echo e(url($prefix . 'update')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-check d-inline-block mr-2">
                                        <input class="form-check-input system-settings-ajax" type="checkbox" value="true" id="link_auto_block" title="block link automatically when true login" <?php echo e(isset($settings['order_settings']['link_auto_block']) && $settings['order_settings']['link_auto_block'] == "true" ? 'checked': ''); ?>>
                                        <label class="form-check-label text-dark" for="link_auto_block" title="block link automatically when true login">
                                          Link Auto Block
                                        </label>
                                    </div>
                                    <div class="form-check d-inline-block mr-2">
                                        <input class="form-check-input system-settings-ajax" type="checkbox" value="true" id="ip_auto_block" title="block ip automatically when true login" <?php echo e(isset($settings['order_settings']['ip_auto_block']) && $settings['order_settings']['ip_auto_block'] == "true" ? 'checked': ''); ?>>
                                        <label class="form-check-label text-dark" for="ip_auto_block" title="block ip automatically when true login">
                                          Ip Auto Block
                                        </label>
                                    </div>
                                    <div class="form-check d-inline-block mr-2">
                                        <input class="form-check-input system-settings-ajax" type="checkbox" value="true" id="redirect" title="Redirect to other url" <?php if(isset($settings['order_settings']['redirect'])): ?> <?php echo e($settings['order_settings']['redirect'] == "true" ? 'checked': ''); ?> <?php endif; ?>>
                                        <label class="form-check-label text-dark" for="redirect" title="Redirect to other url" >
                                          Redirect
                                        </label>
                                    </div>
                                    <hr/>
                                    <div class="form-check mr-2">
                                        <input class="form-check-input system-settings-ajax" type="checkbox" value="true" id="default_link_type" title="Redirect to other url" <?php if(isset($settings['order_settings']['default_link_type'])): ?> <?php echo e($settings['order_settings']['default_link_type'] == "?location=" ? 'checked': ''); ?> <?php endif; ?>>
                                        <label class="form-check-label text-dark" for="default_link_type" title="Redirect to other url" >
                                            Set Default Link Type "domain.com/?location="
                                        </label>
                                    </div>
                                    
                                    
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="text-dark" for="link_code_length" title="Link Code Length" >
                                            Link Code Length min : 3 max : 20
                                          </label>
                                        <input class="form-control" type="number" name="link_code_length" title="Link Code Length" value="<?php echo e($settings['order_settings']['link_code_length']); ?>">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="text-right mt-4">
                                        <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            href="<?php echo e(url()->previous()); ?>">Cancel</a>
                                        <button class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            type="submit">Update</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <small class="d-block text-end mt-3">

        </small>
    </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('assets/js/ajax.js')); ?>"></script>
    <script>
        $(".system-settings-ajax").on("change", function () {
            var url = "<?php echo e(url('admin/system-settings/update-ajax')); ?>"
            var ip_auto_block_checked = $("#ip_auto_block").prop('checked');
            var link_auto_block_checked = $("#link_auto_block").prop('checked');
            var redirect_checked = $("#redirect").prop('checked');
            var default_link_type_checked = $("#default_link_type").prop('checked');
            var result = ajax({'method':'POST', 'url':url, 'data':{'link_auto_block':link_auto_block_checked, 'ip_auto_block': ip_auto_block_checked, 'redirect': redirect_checked, 'default_link_type':default_link_type_checked},'type':'JSON'});
            swAjaxAlert({'title':"Order Setting Updated Success", "type":"success"});
        })        
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kit/kit/resources/views/admin/settings/order-settings.blade.php ENDPATH**/ ?>