<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title'); ?>
    Manage Block Ips
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- Begin Page Content -->
<div class="container">
    
    <!-- Page Heading -->
    
    <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
        <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32" xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32" preserveAspectRatio="xMidYMid slice" focusable="false"><title>Placeholder</title><rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%" fill="var(--white)" dy=".3em">32x32</text></svg>

        <div class="ml-2">
          <h1 class="h6 mb-0 text-white lh-1">Manage Block Ips</h1>
          <small><a class="text-white" href="<?php echo e(url('admin/dashboard')); ?>">dashboard</a> > manage block ips</small>
        </div>
    </div>
    <div class="row">
       
        <div class="col-sm-12 text-right mt-3 mb-3">
            <a href="<?php echo e(url($prefix.'add')); ?>" class="btn btn-primary">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-plus-square" viewBox="0 0 16 16">
                <path d="M14 1a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h12zM2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2z"/>
                <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4z"/>
              </svg>
                add ip
            </a>
            <button class="btn btn-danger" id="delete-selected" style="display: none;"><i
                class="fas fa-trash"></i></button>
        </div>
    </div>
    <!-- Content Row -->
    <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow table-responsive">
                    <div class="text-right">
                        <form class="w-100" method="GET" action="<?php echo e(url($prefix . 'search?')); ?>" role="search">
                            <div class="input-group">
                                <input type="text" class="form-control bg-light border-0 small"
                                    placeholder="Search for..." aria-label="Search" aria-describedby="basic-addon2" name="search">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-primary" type="button">
                                        <i class="fas fa-search fa-sm"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <table class="table table-borderd text-dark text-center small">
                    <thead class="text-uppercase small text-dark">
                        <tr>
                            <th><input type="checkbox" class="form-check" id="checkAll"></th>
                            <th>#id</th>
                            <th>ip</th>
                            <th>created at</th>
                            <th>action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <form action="<?php echo e(url($prefix . 'select-delete')); ?>" method="post" id="select_form">
                            <?php echo csrf_field(); ?>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><input type="checkbox" class="form-check delete_all" name="delete[]" value="<?php echo e($item->id); ?>"></td>
                            <td><?php echo e($item->id); ?></td>
                            <td><?php echo e($item->ips); ?></td>
                            <td><?php echo e(date("Y-m-d H:i", strtotime($item->created_at))); ?></td>
                            <td>
                            <div class="nav-item dropdown no-arrow">
                                <a class="dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-three-dots-vertical" viewBox="0 0 16 16">
                                        <path d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z"/>
                                    </svg>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in" aria-labelledby="navbarDropdown">
                                    <a class="dropdown-item" href="<?php echo e(url($prefix.'add?id='.$item->id)); ?>">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                        <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
                                        <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z"/>
                                      </svg>
                                      edit
                                    </a>
                                    <div class="dropdown-divider"></div>
                                    <a class="dropdown-item delete" href="#" id="<?php echo e(url($prefix.'delete?id='.$item->id)); ?>">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                            <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z"/>
                                            <path fill-rule="evenodd" d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z"/>
                                            </svg>
                                        delete
                                    </a>
                                </div>
                            </div>
                            </td>
                        </tr>
                            
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </form>
                    </tbody>
                </table>
                <?php if(!empty($data)): ?>
                    <?php echo e($data->links()); ?>

                <?php endif; ?>
            </div>
        </div>
        <small class="d-block text-end mt-3">
          
        </small>
      </div>
</div>
</div>
    
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).on("change", "#checkAll", function() {
            var checked = this.checked;
            if (checked) {
                $(".delete_all").attr("checked", "checked");
                $("#delete-selected").show();
            } else {
                $(".delete_all").removeAttr("checked");
                $("#delete-selected").hide();
            }
        })
        $(document).on("change", ".delete_all", function(e) {
            var checked = this.checked;
            if (checked) {
                $(this).attr("checked", "checked");
                $("#delete-selected").show();
            } else {
                $(this).removeAttr("checked");
                $("#delete-selected").hide();
            }

        })
        $(document).on("click", "#delete-selected", function() {

            Swal.fire({
                title: 'Are you sure?',
                text: "Do you want to delete this selected orders?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#select_form").submit();
                }
            })

        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('components.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/theload/kit/resources/views/admin/block-ip/block_ip_manage.blade.php ENDPATH**/ ?>