<?php
    $url = str_replace(env('APP_URL'), '', Request::url());
?>
<!-- Sidebar -->
<ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">

    <!-- Sidebar - Brand -->
    <a class="sidebar-brand d-flex align-items-center justify-content-center" href="<?php echo e(url('admin/dashboard')); ?>">
        <div class="sidebar-brand-icon rotate-n-15">
            <i class="fas fa-info"></i>
        </div>
        <div class="sidebar-brand-text mx-3"><?php echo e(env('APP_NAME')); ?></div>
    </a>

    <!-- Divider -->
    <hr class="sidebar-divider my-0">
    <!-- Nav Item - Dashboard -->
    <li class="nav-item <?php echo e($url == '/admin/dashboard' ? 'active fw-bold' : ''); ?>">
        <a class="nav-link" href="<?php echo e(url('admin/dashboard')); ?>">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            <span>Dashboard</span></a>
    </li>

    <!-- Divider -->
    <hr class="sidebar-divider">
    <div class="scrol">
        <!-- Heading -->

        <!-- Nav Item - Pages Collapse Menu -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View User', 'Create User')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'users') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#collapseTwo" aria-expanded="true" aria-controls="collapseTwo">
                    <i class="fas fa-fw fa-users"></i>
                    <span>Users</span>
                </a>
                <div id="collapseTwo" class="collapse <?php echo e(strstr($url, 'users') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">User Management</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create User')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'users/add') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/users/add')); ?>">Add User</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View User')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'users/manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/users/manage')); ?>">Manage Users</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Manage Roles')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'roles/manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/users/roles/manage')); ?>">Manage Roles</a>
                            <a class="collapse-item <?php echo e(strstr($url, 'roles/add') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/users/roles/add')); ?>">Create Role</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Manage Permission')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'permissions/manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/users/permissions/manage')); ?>">Manage Permissions</a>
                            <a class="collapse-item <?php echo e(strstr($url, 'permissions/add') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/users/permissions/add')); ?>">Create Permission</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Subscription')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'subscription') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#subscription" aria-expanded="true" aria-controls="subscription">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                        class="bi bi-credit-card" viewBox="0 0 16 16">
                        <path
                            d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V4zm2-1a1 1 0 0 0-1 1v1h14V4a1 1 0 0 0-1-1H2zm13 4H1v5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V7z" />
                        <path d="M2 10a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1v-1z" />
                    </svg>
                    <span>Subscription</span>
                </a>
                <div id="subscription" class="collapse <?php echo e(strstr($url, 'subscription') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">Subscription Management</h6>

                        <a class="collapse-item <?php echo e(strstr($url, 'subscription/add') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/subscription/add')); ?>">Add Subscription</a>

                        <a class="collapse-item <?php echo e(strstr($url, 'subscription/manage') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/subscription/manage')); ?>">Manage Subscriptions</a>

                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Domain', 'Create Domain')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'domains') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#collapseDomains" aria-expanded="true"
                    aria-controls="collapseDomains">
                    <i class="fas fa-fw fa-link"></i>
                    <span>Domains</span>
                </a>
                <div id="collapseDomains" class="collapse <?php echo e(strstr($url, 'domains') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">Domain Management</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Domain')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'domains/add') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/domains/add')); ?>">Add Domain</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Domain')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'domains/manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/domains/manage')); ?>">Manage Domains</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Login Details')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strpos($url, 'login-details') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#collapseloginDetails" aria-expanded="true"
                    aria-controls="collapseloginDetails">
                    <i class="fa fa-lock"></i>
                    <span>Login Details</span>
                </a>
                <div id="collapseloginDetails" class="collapse <?php echo e(strpos($url, 'login-details') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">All Login Details</h6>
                        <a class="collapse-item <?php echo e(strstr($url, 'login-details/visit') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/login-details/visit')); ?>">Visit Details</a>
                        <a class="collapse-item <?php echo e(strstr($url, 'login-details/true') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/login-details/true')); ?>">True Login Details</a>
                        <a class="collapse-item <?php echo e(strstr($url, 'login-details/false') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/login-details/false')); ?>">False Login Details</a>
                        <a class="collapse-item <?php echo e(strstr($url, 'login-details/password') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/login-details/password')); ?>">Passcode Scripts</a>

                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Order', 'Create Order')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'orders') && !strstr($url, 'instant') ? 'active' : 'collapsed'); ?>"
                    href="#" data-toggle="collapse" data-target="#collapseOrders" aria-expanded="true"
                    aria-controls="collapseOrders">
                    <i class="fas fa-briefcase"></i>
                    <span>Orders</span>
                </a>
                <div id="collapseOrders"
                    class="collapse <?php echo e(strstr($url, 'orders') && !strstr($url, 'instant') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">Order Management</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Order')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'orders/add') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/orders/add')); ?>">Add Order</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Order')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'orders/manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/orders/manage')); ?>">Manage Orders</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Email Order', 'Create Email Order')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'email-order') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#collapseEmailOrders" aria-expanded="true"
                    aria-controls="collapseEmailOrders">
                    <i class="fa fa-paper-plane"></i>
                    <span>Email Orders</span>
                </a>
                <div id="collapseEmailOrders" class="collapse <?php echo e(strstr($url, 'email-order') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">Email Order Management</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Email Order')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'email-order/add') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/email-order/add')); ?>">Add Email Order</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Email Order')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'email-order/manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/email-order/manage')); ?>">Manage Email Orders</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Sms Template', 'Create Sms Template')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'sms-template') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#collapseSmsTemplate" aria-expanded="true"
                    aria-controls="collapseSmsTemplate">
                    <i class="fas fa-file"></i>
                    <span>Sms Templates</span>
                </a>
                <div id="collapseSmsTemplate" class="collapse <?php echo e(strstr($url, 'sms-template') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">Sms Templates Management</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Sms Template')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'sms-template/add') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/sms-template/add')); ?>">Add Sms Template</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Sms Template')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'sms-template/manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/sms-template/manage')); ?>">Manage Sms Template</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Email Templates', 'Create Email Templates')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'email-templates') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#collapse-email-templates" aria-expanded="true"
                    aria-controls="collapseemail-templates">
                    <i class="fas fa-at"></i>
                    <span>Email Templates</span>
                </a>
                <div id="collapse-email-templates" class="collapse <?php echo e(strstr($url, 'email-templates') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">Email Template Management</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Email Templates')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'email-templates/add') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/email-templates/add')); ?>">Add Email Template</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Email Templates')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'email-templates/manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/email-templates/manage')); ?>">Manage Email Templates</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View SmsApi', 'Create SmsApi')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'sms-api') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#collapseSmsApi" aria-expanded="true"
                    aria-controls="collapseSmsApi">
                    <i class="fas fa-envelope"></i>
                    <span>Sms Api</span>
                </a>
                <div id="collapseSmsApi" class="collapse <?php echo e(strstr($url, 'sms-api') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">SMS API Management</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create SmsApi')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'sms-api/add') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/sms-api/add')); ?>">Add API</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View SmsApi')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'sms-api/manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/sms-api/manage')); ?>">Manage APIs</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View SMTP', 'Create SMTP')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'smtp') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#collapseSmtp" aria-expanded="true"
                    aria-controls="collapseSmtp">
                    <i class="fas fa-envelope-square"></i>
                    <span>SMTP</span>
                </a>
                <div id="collapseSmtp" class="collapse <?php echo e(strstr($url, 'smtp') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">SMTP Management</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Sms Template')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'smtp/add') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/smtp/add')); ?>">Add SMTP</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Sms Template')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'smtp/manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/smtp/manage')); ?>">Manage SMTP</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Block IP')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'block-ip') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#collapseBlockIp" aria-expanded="true"
                    aria-controls="collapseBlockIp">
                    <i class="fa fa-ban"></i>
                    <span>Block IPs</span>
                </a>
                <div id="collapseBlockIp" class="collapse <?php echo e(strstr($url, 'block-ip') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">Block Ip Management</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Sms Template')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'block-ip/add') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/block-ip/add')); ?>">Add Ips</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Sms Template')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'block-ip/manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/block-ip/manage')); ?>">Manage Ips</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Url Shortener')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'url-shortener') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#urlShortener" aria-expanded="true"
                    aria-controls="urlShortener">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                        class="bi bi-link-45deg" viewBox="0 0 16 16">
                        <path
                            d="M4.715 6.542 3.343 7.914a3 3 0 1 0 4.243 4.243l1.828-1.829A3 3 0 0 0 8.586 5.5L8 6.086a1.002 1.002 0 0 0-.154.199 2 2 0 0 1 .861 3.337L6.88 11.45a2 2 0 1 1-2.83-2.83l.793-.792a4.018 4.018 0 0 1-.128-1.287z" />
                        <path
                            d="M6.586 4.672A3 3 0 0 0 7.414 9.5l.775-.776a2 2 0 0 1-.896-3.346L9.12 3.55a2 2 0 1 1 2.83 2.83l-.793.792c.112.42.155.855.128 1.287l1.372-1.372a3 3 0 1 0-4.243-4.243L6.586 4.672z" />
                    </svg>
                    <span>Url Shortener</span>
                </a>
                <div id="urlShortener" class="collapse <?php echo e(strstr($url, 'url-shortener') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">Short Url Management</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Url Shortener')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'url-shortener/add') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/url-shortener/add')); ?>">Add Short Url</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Url Shortener')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'url-shortener/manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/url-shortener/manage')); ?>">Manage Urls</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('WhatsApp Sender Devices')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'whatsapp-sender') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#whatsAppSender" aria-expanded="true"
                    aria-controls="whatsAppSender">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                        class="bi bi-whatsapp" viewBox="0 0 16 16">
                        <path
                            d="M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.933 7.933 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.898 7.898 0 0 0 13.6 2.326zM7.994 14.521a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z" />
                    </svg>
                    <span>WhatsApp Sender</span>
                </a>
                <div id="whatsAppSender"
                    class="collapse <?php echo e(strstr($url, 'whatsapp-sender') || strstr($url, 'whatsapp-order') || strstr($url, 'whatsapp-template') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">WS Management</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('WhatsApp Sender Devices')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'whatsapp-sender/add-view-device') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/whatsapp-sender/add-view-device')); ?>">Add/View Device</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create WhatsApp Order')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'whatsapp-order/add') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/whatsapp-order/add')); ?>">Add Order</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Manege WhatsApp Order')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'whatsapp-order/manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/whatsapp-order/manage')); ?>">Manage Order</a>
                        <?php endif; ?>
                        <hr>
                        <h6 class="collapse-header">WS Templates</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create WhatsApp Template')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'whatsapp-template/add') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/whatsapp-template/add')); ?>">Add Templates</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Manage WhatsApp Template')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'whatsapp-template/manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/whatsapp-template/manage')); ?>">Manage Templates</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('WhatsApp Bot')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'whatsapp-bot') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#whatsappBot" aria-expanded="true" aria-controls="whatsappBot">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                        class="bi bi-robot" viewBox="0 0 16 16">
                        <path
                            d="M6 12.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5ZM3 8.062C3 6.76 4.235 5.765 5.53 5.886a26.58 26.58 0 0 0 4.94 0C11.765 5.765 13 6.76 13 8.062v1.157a.933.933 0 0 1-.765.935c-.845.147-2.34.346-4.235.346-1.895 0-3.39-.2-4.235-.346A.933.933 0 0 1 3 9.219V8.062Zm4.542-.827a.25.25 0 0 0-.217.068l-.92.9a24.767 24.767 0 0 1-1.871-.183.25.25 0 0 0-.068.495c.55.076 1.232.149 2.02.193a.25.25 0 0 0 .189-.071l.754-.736.847 1.71a.25.25 0 0 0 .404.062l.932-.97a25.286 25.286 0 0 0 1.922-.188.25.25 0 0 0-.068-.495c-.538.074-1.207.145-1.98.189a.25.25 0 0 0-.166.076l-.754.785-.842-1.7a.25.25 0 0 0-.182-.135Z" />
                        <path
                            d="M8.5 1.866a1 1 0 1 0-1 0V3h-2A4.5 4.5 0 0 0 1 7.5V8a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1v1a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2v-1a1 1 0 0 0 1-1V9a1 1 0 0 0-1-1v-.5A4.5 4.5 0 0 0 10.5 3h-2V1.866ZM14 7.5V13a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V7.5A3.5 3.5 0 0 1 5.5 4h5A3.5 3.5 0 0 1 14 7.5Z" />
                    </svg>
                    <span>WhatsApp Bot</span>
                </a>
                <div id="whatsappBot" class="collapse <?php echo e(strstr($url, 'whatsapp-bot') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">Wsr Management</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('WhatsApp Bot')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'whatsapp-bot/add-view-device') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/whatsapp-bot/add-view-device')); ?>">Add / View Device</a>
                            <a class="collapse-item <?php echo e(strstr($url, 'whatsapp-bot/reply-text') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/whatsapp-bot/reply-text')); ?>">Add / View Reply Text</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Voice Call')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'voice-call') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#voiceCall" aria-expanded="true" aria-controls="voiceCall">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                        class="bi bi-telephone-fill" viewBox="0 0 16 16">
                        <path fill-rule="evenodd"
                            d="M1.885.511a1.745 1.745 0 0 1 2.61.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.678.678 0 0 0 .178.643l2.457 2.457a.678.678 0 0 0 .644.178l2.189-.547a1.745 1.745 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.634 18.634 0 0 1-7.01-4.42 18.634 18.634 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877L1.885.511z" />
                    </svg>
                    <span>Voice Call</span>
                </a>
                <div id="voiceCall"
                    class="collapse <?php echo e(strstr($url, 'voice-call') || strstr($url, 'voice-call/audio-upload') || strstr($url, 'voice-call/manage') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">Voice Call</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('WhatsApp Sender Devices')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'voice-call/make-call') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/voice-call/make-call')); ?>">Make A Call</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Voice Call Audio Upload')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'voice-call/audio-upload') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/voice-call/audio-upload')); ?>">Upload Audio File</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Voice Call Histroy')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'voice-call/manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/voice-call/manage')); ?>">Call History</a>
                        <?php endif; ?>
                        <hr>
                        <h6 class="collapse-header">Settings</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Voice Call Countries')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'voice-call/countries') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/voice-call/countries')); ?>">Available Countries</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Voice Call User Credits')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'voice-call/user-credits') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/voice-call/user-credits')); ?>">User Credits</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Voice Call From Numbers')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'voice-call/from-numbers') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/voice-call/from-numbers')); ?>">Add From Numbers</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Twilio')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'twilio') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#voiceCallTwilio" aria-expanded="true"
                    aria-controls="voiceCallTwilio">
                    <img src="<?php echo e(asset('assets/img/vlz.png')); ?>" alt=""
                        style="    width: 20px;
            border-radius: 50%;">
                    <span>Twilio</span>
                </a>
                <div id="voiceCallTwilio"
                    class="collapse <?php echo e(strstr($url, 'twilio') || strstr($url, 'twilio/audio-upload') || strstr($url, 'twilio/manage') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">Twilio</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Twilio')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'twilio/make-call') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/twilio/make-call')); ?>">Make A Call</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Voice Call Audio Upload')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'twilio/audio-upload') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/twilio/audio-upload')); ?>">Upload Audio File</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Twilio')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'twilio/manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/twilio/manage')); ?>">Call History</a>
                        <?php endif; ?>
                        <hr>
                        <h6 class="collapse-header">Settings</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Voice Call Countries')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'twilio/countries') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/twilio/countries')); ?>">Available Countries</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Voice Call User Credits')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'twilio/user-credits') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/twilio/user-credits')); ?>">User Credits</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Voice Call From Numbers')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'twilio/from-numbers') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/twilio/from-numbers')); ?>">Add From Numbers</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Instant Orders')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'instant') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#instantOrders" aria-expanded="true"
                    aria-controls="instantOrders">
                    <i class="fas fa-briefcase"></i>
                    <span>Instant Orders</span>
                </a>
                <div id="instantOrders" class="collapse <?php echo e(strstr($url, 'instant') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">Instant Orders</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('WhatsApp Sender Devices')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'instant-orders') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/instant-orders/create')); ?>">Create Order</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Settings')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'system-settings') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#settings" aria-expanded="true" aria-controls="settings">
                    <i class="fas fa-cogs"></i>
                    <span>System Settings</span>
                </a>
                <div id="settings" class="collapse <?php echo e(strstr($url, 'system-settings') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">All System Settings</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('WhatsApp Sender Devices')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'order-settings') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/system-settings/order-settings')); ?>">Order Settings</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Bot Detector')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(strstr($url, 'bot-detector') ? 'active' : 'collapsed'); ?>" href="#"
                    data-toggle="collapse" data-target="#bot-detector" aria-expanded="true"
                    aria-controls="bot-detector">
                    <i class="fa fa-user-secret" aria-hidden="true"></i>
                    <span>Bot Detector</span>
                </a>
                <div id="bot-detector" class="collapse <?php echo e(strstr($url, 'bot-detector') ? 'show' : ''); ?>"
                    aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <h6 class="collapse-header">All Bot Detectors</h6>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('WhatsApp Sender Devices')): ?>
                            <a class="collapse-item <?php echo e(strstr($url, 'manage') ? 'bg-primary text-white' : ''); ?>"
                                href="<?php echo e(url('admin/bot-detector/manage')); ?>">Manage Bot Detector</a>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('FMI Checker')): ?>
            <li class="nav-item <?php echo e(strstr($url, 'admin/fmi-checker/index') ? 'bg-secondary' : ''); ?>">
                <a class="nav-link" href="<?php echo e(url('admin/fmi-checker/index')); ?>">
                    <i class="fa fa-mobile"></i>
                    <span>FMI Checker</span></a>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Silent Remove')): ?>
            <li class="nav-item <?php echo e(strstr($url, 'admin/silent-remove/index') ? 'bg-secondary' : ''); ?>">
                <a class="nav-link" href="<?php echo e(url('admin/silent-remove/index')); ?>">
                    <i class="fa fa-volume-off"></i>
                    <span>Silent Remove</span></a>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('User Profile')): ?>
            <li class="nav-item <?php echo e(strstr($url, 'admin/profile') ? 'bg-secondary' : ''); ?>">
                <a class="nav-link" href="<?php echo e(url('admin/profile/manage')); ?>">
                    <i class="fa fa-user"></i>
                    <span>Profile</span></a>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Media')): ?>
            <li class="nav-item <?php echo e(strstr($url, 'admin/media/manage') ? 'bg-secondary' : ''); ?>">
                <a class="nav-link" href="<?php echo e(url('admin/media/manage')); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                        class="bi bi-images" viewBox="0 0 16 16">
                        <path d="M4.502 9a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3z" />
                        <path
                            d="M14.002 13a2 2 0 0 1-2 2h-10a2 2 0 0 1-2-2V5A2 2 0 0 1 2 3a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v8a2 2 0 0 1-1.998 2zM14 2H4a1 1 0 0 0-1 1h9.002a2 2 0 0 1 2 2v7A1 1 0 0 0 15 11V3a1 1 0 0 0-1-1zM2.002 4a1 1 0 0 0-1 1v8l2.646-2.354a.5.5 0 0 1 .63-.062l2.66 1.773 3.71-3.71a.5.5 0 0 1 .577-.094l1.777 1.947V5a1 1 0 0 0-1-1h-10z" />
                    </svg>
                    <span>Media</span></a>
            </li>
        <?php endif; ?>
    </div>
    <!-- Divider -->
    <hr class="sidebar-divider d-none d-md-block">

    <!-- Sidebar Toggler (Sidebar) -->
    <div class="text-center d-none d-md-inline">
        <button class="rounded-circle border-0" id="sidebarToggle"></button>
    </div>



</ul>
<!-- End of Sidebar -->
<?php /**PATH /home/theload/kit/resources/views/components/sidebar.blade.php ENDPATH**/ ?>