<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title'); ?>
    Available Countries
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- Begin Page Content -->
<div class="container">
    
    <!-- Page Heading -->
    
    <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
        <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32" xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32" preserveAspectRatio="xMidYMid slice" focusable="false"><title>Placeholder</title><rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%" fill="var(--white)" dy=".3em">32x32</text></svg>

        <div class="ml-2">
          <h1 class="h6 mb-0 text-white lh-1">Available Countries</h1>
          <small><a class="text-white" href="<?php echo e(url('admin/dashboard')); ?>">dashboard</a> > Available Countries</small>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12 text-right mt-3 mb-3">
            <a href="<?php echo e(url($prefix.'make-call')); ?>" class="btn btn-primary">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-telephone-plus-fill" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M1.885.511a1.745 1.745 0 0 1 2.61.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.678.678 0 0 0 .178.643l2.457 2.457a.678.678 0 0 0 .644.178l2.189-.547a1.745 1.745 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.634 18.634 0 0 1-7.01-4.42 18.634 18.634 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877L1.885.511zM12.5 1a.5.5 0 0 1 .5.5V3h1.5a.5.5 0 0 1 0 1H13v1.5a.5.5 0 0 1-1 0V4h-1.5a.5.5 0 0 1 0-1H12V1.5a.5.5 0 0 1 .5-.5z"/>
                  </svg>
                Make a Call
            </a>
        </div>
    </div>
    
    <!-- Content Row -->
    <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow table-responsive">
                    <form method="post" action="<?php echo e(url($prefix.'update-countries')); ?>">
                        <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-sm-12 text-right mt-3 mb-3">
                            <input type="submit" value="Update" class="btn btn-success" style="
                            margin-right: 10px;
                        "/>
                        </div>
                    </div>
                    <table class="table table-borderd text-dark text-center small">
                    <thead class="text-uppercase small text-dark">
                        <tr>
                            <th>#id</th>
                            <th>Country</th>
                            <th>Dial Code</th>
                            <th>Code</th>
                            <th>Allow</th>
                            <th>Rate</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($item->id); ?></td>
                            <td><?php echo e($item->name); ?></td>
                            <td><?php echo e($item->dial_code); ?></td>
                            <td><?php echo e($item->code); ?></td>
                            <td>
                                <input type="hidden" name="code[]" value="<?php echo e($item->code); ?>">
                                <div class="form-check form-switch">
                                    <input type="hidden" id=<?php echo e($item->code); ?> name="allow[]" value="0" <?php if($item->allow == 1): ?> disabled <?php endif; ?>>
                                    <input class="form-check-input allow" type="checkbox" role="switch" id="flexSwitchCheckDefault_<?php echo e($item->id); ?>" name="allow[]" <?php if($item->allow == 1): ?> checked <?php endif; ?> value="1" data-id="<?php echo e($item->code); ?>">
                                    <label class="form-check-label" for="flexSwitchCheckDefault_<?php echo e($item->id); ?>">Allow</label>
                                  </div>
                                
                            <td>
                                <input type="number" class="form-control text-center" name="rate[]" id="rate" step="0.01" value="<?php echo e($item->rate); ?>">
                            </td>
                        </tr>
                            
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="row">
                    <div class="col-sm-12 text-right mt-3 mb-3">
                        <input type="submit" value="Update" class="btn btn-success" style="
                        margin-right: 10px;
                    "/>
                    </div>
                </div>
                </form>
            </div>
        </div>
        <small class="d-block text-end mt-3">
          
        </small>
      </div>
</div>
</div>
    
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(".allow").change(function(){
            var id = $(this).attr('data-id');
            var checked = this.checked
            if(!checked){
                $("#"+id).removeAttr('disabled')
            }else{
                $("#"+id).attr('disabled', 'disabled')
            }
            
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kit/kit/resources/views/admin/voice-call/countries.blade.php ENDPATH**/ ?>