<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title'); ?>
    Make A Call
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <!-- Begin Page Content -->
    <div class="container">

        <!-- Page Heading -->
        
        <div class="d-flex align-items-center p-3 my-3 text-white bg-primary rounded shadow-sm">
            <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32"
                xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32"
                preserveAspectRatio="xMidYMid slice" focusable="false">
                <title>Placeholder</title>
                <rect width="100%" height="100%" fill="var(--white)"></rect><text x="50%" y="50%" fill="var(--white)"
                    dy=".3em">32x32</text>
            </svg>

            <div class="ml-2">
                <h1 class="h6 mb-0 text-white lh-1">Make a call</h1>
                <small><a class="text-white" href="<?php echo e(url('admin/dashboard')); ?>">dashboard</a> > make a call</small>
            </div>
        </div>
        <!-- Content Row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card mb-4 shadow">
                    <div class="card-body">
                        <div class="row mb-4">
                            <div class="col-sm-3">
                                <div class="card">
                                    <div class="card-body text-center bg-secondary text-white">
                                        Credit <br>
                                        <h1><?php echo e($credit); ?></h1>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="card">
                                    <div class="card-body text-center bg-success text-white">
                                        Available Balance <br>
                                        <h1><?php echo e($available_balance); ?></h1>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <form action="" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-sm-6">
                                    <input type="hidden" name="inter" id="inter">
                                    <input type="hidden" name="current_sts" id="current_sts" value="null">
                                    <div class="form-group">
                                        <label class="small">Select Country <span class="text-danger">*</span></label>
                                        <select name="country" id="country"
                                            class="form-control <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                            <option value="" selected disabled>Select Country*</option>
                                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($country['id']); ?>"
                                                    data-dial_code="<?php echo e($country['dial_code']); ?>"><?php echo e($country['name']); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <div class="form-check mt-3 dfc" style="display: none">
                                            <input class="form-check-input" type="checkbox" value="true"
                                                id="deafultCountry">
                                            <label class="form-check-label" for="deafultCountry">
                                                Set as Default country
                                            </label>
                                        </div>
                                        <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger small"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group">
                                        <label class="small">From Number <span class="text-danger">*</span></label>
                                        <select name="from_number_id" id="from_number_id"
                                            class="form-control <?php $__errorArgs = ['from_number_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                            <option value="" selected disabled>Select From Number*</option>
                                            <?php $__currentLoopData = $from_numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $from_number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($from_number['id']); ?>">
                                                    <?php echo e($from_number['name'] . ' - +' . $from_number['number']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <?php $__errorArgs = ['from_number_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger small"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group">
                                        <label class="small">Phone Number <span class="text-danger">*</span></label>
                                        <label class="small"><span class="text-danger">enter your number without ountry
                                                code (+,0)</span></label>
                                        <input type="text"
                                            class="form-control <?php $__errorArgs = ['phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            value="<?php echo e(old('phone_number')); ?>" name="phone_number"
                                            aria-describedby="phone_numberHelp" id="phone_number" placeholder="Phone Number"
                                            required>
                                        <?php $__errorArgs = ['phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger small"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-check mt-3 mb-2">
                                        <input class="form-check-input" type="checkbox" name="text_speach" value="true"
                                            id="textSpeach">
                                        <label class="form-check-label" for="textSpeach">
                                            Text Speach
                                        </label>
                                    </div>
                                    <div class="form-group text-speach" style="display: none;">
                                        <label class="small">Select Language <span class="text-danger">*</span></label>
                                        <select id="languageSelect"
                                            class="form-control <?php $__errorArgs = ['language_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> text-speach"
                                            style="display: none;" name="language_code">
                                            <option value="ar-XA">Arabic</option>
                                            <option value="cs-CZ">Czech</option>
                                            <option value="cy-CY">Welsh</option>
                                            <option value="cy-GB">Welsh (UK)</option>
                                            <option value="da-DK">Danish</option>
                                            <option value="de-DE">German</option>
                                            <option value="el-GR">Greek</option>
                                            <option value="en-AU">English (Australia)</option>
                                            <option value="en-GB">English (UK)</option>
                                            <option value="en-IN">English (India)</option>
                                            <option value="en-US">English (US)</option>
                                            <option value="es-ES">Spanish (Spain)</option>
                                            <option value="es-MX">Spanish (Mexico)</option>
                                            <option value="es-US">Spanish (US)</option>
                                            <option value="fi-FI">Finnish</option>
                                            <option value="fil-PH">Filipino</option>
                                            <option value="fr-CA">French (Canada)</option>
                                            <option value="fr-FR">French (France)</option>
                                            <option value="hi-IN">Hindi</option>
                                            <option value="hu-HU">Hungarian</option>
                                            <option value="id-ID">Indonesian</option>
                                            <option value="is-IS">Icelandic</option>
                                            <option value="it-IT">Italian</option>
                                            <option value="ja-JP">Japanese</option>
                                            <option value="ko-KR">Korean</option>
                                            <option value="nb-NO">Norwegian</option>
                                            <option value="nl-NL">Dutch</option>
                                            <option value="pl-PL">Polish</option>
                                            <option value="pt-BR">Portuguese (Brazil)</option>
                                            <option value="pt-PT">Portuguese (Portugal)</option>
                                            <option value="ro-RO">Romanian</option>
                                            <option value="ru-RU">Russian</option>
                                            <option value="sv-SE">Swedish</option>
                                            <option value="th-TH">Thai</option>
                                            <option value="tr-TR">Turkish</option>
                                            <option value="vi-VN">Vietnamese</option>
                                            <option value="yue-CN">Yue Chinese (Cantonese)</option>
                                            <option value="zh-CN">Chinese (Mainland)</option>
                                            <option value="zh-TW">Chinese (Taiwan)</option>
                                        </select>
                                    </div>
                                    <div class="form-group text-speach" style="display: none;">
                                        <label class="small">Write Text To Speach <span
                                                class="text-danger">*</span></label>
                                        <textarea name="text" id="text" cols="30" rows="5"
                                            class="form-control <?php $__errorArgs = ['text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Text Speach"><?php echo e(old('text')); ?></textarea>

                                        <?php $__errorArgs = ['text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger small"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <div class="play mt-3 w-100"></div>
                                    </div>
                                    <div class="form-group audio">
                                        <label class="small">Audio <span class="text-danger">*</span></label>
                                        <select name="audio" id="audio"
                                            class="form-control <?php $__errorArgs = ['audio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                            <option value="" selected disabled>Select Audio*</option>
                                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($d['id']); ?>"
                                                    data-audio="<?php echo e(asset($d['audio'])); ?>"><?php echo e($d['title']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['audio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger small"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <div class="play mt-3 w-100"></div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="event"></div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="mt-4">
                                        <a class="btn btn-secondary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            href="<?php echo e(url()->previous()); ?>">Cancel</a>
                                        <button class="btn btn-primary text-uppercase font-weight-bold rounded pl-4 pr-4"
                                            type="button" id="make_call">Call</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <small class="d-block text-end mt-3">

        </small>
    </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#country').select2();
        });
        $("#make_call").on("click", function() {
            var url = "<?php echo e(url($prefix . 'make-call')); ?>"
            var phone_number = $("#phone_number").val()
            var from_number_id = $("#from_number_id").val()
            var audio = $("#audio").val()
            var country = $("#country").val()
            var country = $("#country").val()
            var text_speach = $("#textSpeach").prop('checked')
            var language_code = $("#languageSelect").val()
            var text = $("#text").val()
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: url,
                dataType: "JSON",
                data: {
                    phone_number: phone_number,
                    from_number_id: from_number_id,
                    audio: audio,
                    country: country,
                    text_speach: text_speach,
                    text: text,
                    language_code: language_code

                },
                beforeSend: function() {
                    $("#loader").show();
                },
                success: function(response) {
                    $("#loader").hide();
                    // setInterval(displayHello, 1000);
                    if (response.success == true) {
                        var uuid = response.data.uuid;
                        Swal.fire({
                            position: 'top-end',
                            icon: "success",
                            title: response.message,
                            showConfirmButton: false,
                            timer: 7000
                        })
                        var intervel_id = window.setInterval(() => getEvents(uuid), 1000);
                        $("#inter").val(intervel_id)
                    } else {
                        Swal.fire({
                            position: 'top-end',
                            icon: "error",
                            title: response.message,
                            showConfirmButton: false,
                            timer: 7000
                        })
                    }
                },
                error: function(xhr) {
                    $("#loader").hide();
                    Swal.fire({
                        position: 'top-end',
                        icon: "error",
                        title: xhr.responseJSON.message,
                        showConfirmButton: false,
                        timer: 7000
                    })
                }
            });
        })

        function getEvents(uuid) {
            var url = "<?php echo e(url($prefix . 'get-event')); ?>"
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: url,
                dataType: "JSON",
                data: {
                    uuid: uuid
                },
                success: function(response) {
                    if (response.success == true) {
                        var status = response.data.status;
                        var event;
                        var intervel_id = $("#inter").val()
                        var current_sts = $("#current_sts").val()

                        if (status == 'started') {
                            event = "<div class='alert alert-primary' role='alert'>" + status + "</div>"
                        } else if (status == 'ringing') {
                            event = "<div class='alert alert-primary' role='alert'>" + status + "</div>"
                        } else if (status == 'answered') {
                            event = "<div class='alert alert-success' role='alert'>" + status + "</div>"
                        } else if (status == 'queued') {
                            event = "<div class='alert alert-success' role='alert'>" + status + "</div>"
                        } else if (status == 'completed') {
                            window.clearInterval(intervel_id)
                            event = "<div class='alert alert-success' role='alert'>" + status + "</div>"
                        } else {
                            if (status != null) {
                                window.clearInterval(intervel_id)
                            }
                            event = "<div class='alert alert-danger' role='alert'>" + status + "</div>"
                        }
                        if (status != null && current_sts != status) {
                            $(".event").append(event)
                            $("#current_sts").val(status)
                        }

                    } else {
                        $(".event").append(
                            '<p>error: ' + response.message + '</p>'
                        )
                    }
                },
                error: function(xhr) {
                    $(".event").append(
                        '<p>error: ' + xhr.responseJSON.message + '</p>'
                    )
                }
            });
        }
        $("#audio").change(function() {
            var element = $(this).find('option:selected');
            var audio = element.attr("data-audio");

            $(".play").html('<audio controls>' +
                '<source src="' + audio + '" type="audio/mpeg">' +
                'Your browser does not support the audio element.' +
                '</audio>'
            )
        });

        $("#country").change(function() {
            var element = $(this).find('option:selected');
            var dial_code = element.attr("data-dial_code");

            $("#phone_number").val(dial_code)
            $(".dfc").show()
        });
        $("#deafultCountry").change(function(e) {
            var country = $("#country").val();
            if (country != "") {
                localStorage.setItem("default_country", country);
            } else {
                e.preventDefault();
            }
        });
        $(document).ready(function() {
            var country = localStorage.getItem("default_country");
            $('#country option[value="' + country + '"]').prop('selected', true);
            var element = $("#country").find('option:selected');
            var dial_code = element.attr("data-dial_code");

            $("#phone_number").val(dial_code)
        })
        $("#textSpeach").change(function() {
            var checked = this.checked
            var a_element = $(".audio");
            var t_element = $(".text-speach");
            if (checked) {
                a_element.hide()
                t_element.show()
            } else {
                a_element.show()
                t_element.hide()
            }

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kit/kit/resources/views/admin/voice-call/make_call.blade.php ENDPATH**/ ?>