<?php
    $url = str_replace(env('APP_URL'), '', Request::url());
?>
<!-- Sidebar -->
<ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">

    <!-- Sidebar - Brand -->
    <a class="sidebar-brand d-flex align-items-center justify-content-center" href="<?php echo e(url('admin/dashboard')); ?>">
        <div class="sidebar-brand-icon rotate-n-15">
            <i class="fas fa-info"></i>
        </div>
        <div class="sidebar-brand-text mx-3"><?php echo e(env('APP_NAME')); ?></div>
    </a>

    <!-- Divider -->
    <hr class="sidebar-divider my-0">

    <!-- Nav Item - Dashboard -->
    <li class="nav-item <?php echo e($url == '/admin/dashboard' ? 'active fw-bold' : ''); ?>">
        <a class="nav-link" href="<?php echo e(url('admin/dashboard')); ?>">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            <span>Dashboard</span></a>
    </li>

    <!-- Divider -->
    <hr class="sidebar-divider">

    <!-- Heading -->
    <div class="sidebar-heading">
        Users
    </div>

    <!-- Nav Item - Pages Collapse Menu -->
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View User', 'Create User')): ?>
        <li class="nav-item">
            <a class="nav-link <?php echo e(strstr($url, 'users') ? 'active' : 'collapsed'); ?>" href="#" data-toggle="collapse"
                data-target="#collapseTwo" aria-expanded="true" aria-controls="collapseTwo">
                <i class="fas fa-fw fa-users"></i>
                <span>Users</span>
            </a>
            <div id="collapseTwo" class="collapse <?php echo e(strstr($url, 'users') ? 'show' : ''); ?>" aria-labelledby="headingTwo"
                data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <h6 class="collapse-header">User Management</h6>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create User')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'users/add') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/users/add')); ?>">Add User</a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View User')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'users/manage') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/users/manage')); ?>">Manage Users</a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Manage Roles')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'roles/manage') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/users/roles/manage')); ?>">Manage Roles</a>
                        <a class="collapse-item <?php echo e(strstr($url, 'roles/add') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/users/roles/add')); ?>">Create Role</a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Manage Permission')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'permissions/manage') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/users/permissions/manage')); ?>">Manage Permissions</a>
                        <a class="collapse-item <?php echo e(strstr($url, 'permissions/add') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/users/permissions/add')); ?>">Create Permission</a>
                    <?php endif; ?>
                </div>
            </div>
        </li>
    <?php endif; ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Domain', 'Create Domain')): ?>
        <li class="nav-item">
            <a class="nav-link <?php echo e(strstr($url, 'domains') ? 'active' : 'collapsed'); ?>" href="#"
                data-toggle="collapse" data-target="#collapseDomains" aria-expanded="true" aria-controls="collapseDomains">
                <i class="fas fa-fw fa-link"></i>
                <span>Domains</span>
            </a>
            <div id="collapseDomains" class="collapse <?php echo e(strstr($url, 'domains') ? 'show' : ''); ?>"
                aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <h6 class="collapse-header">Domain Management</h6>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Domain')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'domains/add') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/domains/add')); ?>">Add Domain</a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Domain')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'domains/manage') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/domains/manage')); ?>">Manage Domains</a>
                    <?php endif; ?>
                </div>
            </div>
        </li>
    <?php endif; ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View SmsApi', 'Create SmsApi')): ?>
        <li class="nav-item">
            <a class="nav-link <?php echo e(strstr($url, 'sms-api') ? 'active' : 'collapsed'); ?>" href="#"
                data-toggle="collapse" data-target="#collapseSmsApi" aria-expanded="true" aria-controls="collapseSmsApi">
                <i class="fas fa-envelope"></i>
                <span>Sms Api</span>
            </a>
            <div id="collapseSmsApi" class="collapse <?php echo e(strstr($url, 'sms-api') ? 'show' : ''); ?>"
                aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <h6 class="collapse-header">SMS API Management</h6>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create SmsApi')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'sms-api/add') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/sms-api/add')); ?>">Add API</a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View SmsApi')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'sms-api/manage') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/sms-api/manage')); ?>">Manage APIs</a>
                    <?php endif; ?>
                </div>
            </div>
        </li>
    <?php endif; ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Order', 'Create Order')): ?>
        <li class="nav-item">
            <a class="nav-link <?php echo e(strstr($url, 'orders') ? 'active' : 'collapsed'); ?>" href="#" data-toggle="collapse"
                data-target="#collapseOrders" aria-expanded="true" aria-controls="collapseOrders">
                <i class="fas fa-briefcase"></i>
                <span>Orders</span>
            </a>
            <div id="collapseOrders" class="collapse <?php echo e(strstr($url, 'orders') ? 'show' : ''); ?>"
                aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <h6 class="collapse-header">Order Management</h6>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Order')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'orders/add') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/orders/add')); ?>">Add Order</a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Order')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'orders/manage') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/orders/manage')); ?>">Manage Orders</a>
                    <?php endif; ?>
                </div>
            </div>
        </li>
    <?php endif; ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Sms Template', 'Create Sms Template')): ?>
        <li class="nav-item">
            <a class="nav-link <?php echo e(strstr($url, 'sms-template') ? 'active' : 'collapsed'); ?>" href="#"
                data-toggle="collapse" data-target="#collapseSmsTemplate" aria-expanded="true"
                aria-controls="collapseSmsTemplate">
                <i class="fas fa-file"></i>
                <span>Sms Templates</span>
            </a>
            <div id="collapseSmsTemplate" class="collapse <?php echo e(strstr($url, 'sms-template') ? 'show' : ''); ?>"
                aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <h6 class="collapse-header">Sms Templates Management</h6>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Sms Template')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'sms-template/add') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/sms-template/add')); ?>">Add Sms Template</a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Sms Template')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'sms-template/manage') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/sms-template/manage')); ?>">Manage Sms Template</a>
                    <?php endif; ?>
                </div>
            </div>
        </li>
    <?php endif; ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Email Templates', 'Create Email Templates')): ?>
        <li class="nav-item">
            <a class="nav-link <?php echo e(strstr($url, 'email-templates') ? 'active' : 'collapsed'); ?>" href="#"
                data-toggle="collapse" data-target="#collapse-email-templates" aria-expanded="true"
                aria-controls="collapseemail-templates">
                <i class="fas fa-at"></i>
                <span>Email Templates</span>
            </a>
            <div id="collapse-email-templates" class="collapse <?php echo e(strstr($url, 'email-templates') ? 'show' : ''); ?>"
                aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <h6 class="collapse-header">Email Template Management</h6>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Email Templates')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'email-templates/add') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/email-templates/add')); ?>">Add Email Template</a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Email Templates')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'email-templates/manage') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/email-templates/manage')); ?>">Manage Email Templates</a>
                    <?php endif; ?>
                </div>
            </div>
        </li>
    <?php endif; ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View SMTP', 'Create SMTP')): ?>
        <li class="nav-item">
            <a class="nav-link <?php echo e(strstr($url, 'smtp') ? 'active' : 'collapsed'); ?>" href="#"
                data-toggle="collapse" data-target="#collapseSmtp" aria-expanded="true" aria-controls="collapseSmtp">
                <i class="fas fa-envelope-square"></i>
                <span>SMTP</span>
            </a>
            <div id="collapseSmtp" class="collapse <?php echo e(strstr($url, 'smtp') ? 'show' : ''); ?>"
                aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <h6 class="collapse-header">SMTP Management</h6>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Sms Template')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'smtp/add') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/smtp/add')); ?>">Add SMTP</a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Sms Template')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'smtp/manage') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/smtp/manage')); ?>">Manage SMTP</a>
                    <?php endif; ?>
                </div>
            </div>
        </li>
    <?php endif; ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Email Order', 'Create Email Order')): ?>
        <li class="nav-item">
            <a class="nav-link <?php echo e(strstr($url, 'email-order') ? 'active' : 'collapsed'); ?>" href="#"
                data-toggle="collapse" data-target="#collapseEmailOrders" aria-expanded="true"
                aria-controls="collapseEmailOrders">
                <i class="fa fa-paper-plane"></i>
                <span>Email Orders</span>
            </a>
            <div id="collapseEmailOrders" class="collapse <?php echo e(strstr($url, 'email-order') ? 'show' : ''); ?>"
                aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <h6 class="collapse-header">Email Order Management</h6>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Email Order')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'email-order/add') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/email-order/add')); ?>">Add Email Order</a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('View Email Order')): ?>
                        <a class="collapse-item <?php echo e(strstr($url, 'email-order/manage') ? 'bg-primary text-white' : ''); ?>"
                            href="<?php echo e(url('admin/email-order/manage')); ?>">Manage Email Orders</a>
                    <?php endif; ?>
                </div>
            </div>
        </li>
    <?php endif; ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Login Details')): ?>
        <li class="nav-item">
            <a class="nav-link <?php echo e(strpos($url, 'login-details') ? 'active' : 'collapsed'); ?>" href="#"
                data-toggle="collapse" data-target="#collapseloginDetails" aria-expanded="true"
                aria-controls="collapseloginDetails">
                <i class="fa fa-lock"></i>
                <span>Loggin Details</span>
            </a>
            <div id="collapseloginDetails" class="collapse <?php echo e(strpos($url, 'login-details') ? 'show' : ''); ?>"
                aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    <h6 class="collapse-header">All Login Details</h6>
                    <a class="collapse-item <?php echo e(strstr($url, 'login-details/true') ? 'bg-primary text-white' : ''); ?>"
                        href="<?php echo e(url('admin/login-details/true')); ?>">True Login Details</a>
                    <a class="collapse-item <?php echo e(strstr($url, 'login-details/false') ? 'bg-primary text-white' : ''); ?>"
                        href="<?php echo e(url('admin/login-details/false')); ?>">False Login Details</a>
                    <a class="collapse-item <?php echo e(strstr($url, 'login-details/password') ? 'bg-primary text-white' : ''); ?>"
                        href="<?php echo e(url('admin/login-details/password')); ?>">Password Scripts</a>
                    <a class="collapse-item <?php echo e(strstr($url, 'login-details/visit') ? 'bg-primary text-white' : ''); ?>"
                        href="<?php echo e(url('admin/login-details/visit')); ?>">Visit Details</a>
                </div>
            </div>
        </li>
    <?php endif; ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Block IP')): ?>
        <li class="nav-item <?php echo e(strstr($url, 'admin/block-ip/manage') ? 'bg-secondary' : ''); ?>">
            <a class="nav-link" href="<?php echo e(url('admin/block-ip/manage')); ?>">
                <i class="fa fa-ban"></i>
                <span>Block Ips</span></a>
        </li>
    <?php endif; ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('User Profile')): ?>
        <li class="nav-item <?php echo e(strstr($url, 'admin/profile') ? 'bg-secondary' : ''); ?>">
            <a class="nav-link" href="<?php echo e(url('admin/profile/manage')); ?>">
                <i class="fa fa-user"></i>
                <span>Profile</span></a>
        </li>
    <?php endif; ?>

    <!-- Divider -->
    <hr class="sidebar-divider d-none d-md-block">

    <!-- Sidebar Toggler (Sidebar) -->
    <div class="text-center d-none d-md-inline">
        <button class="rounded-circle border-0" id="sidebarToggle"></button>
    </div>

    <!-- Sidebar Message -->
    <div class="sidebar-card d-none d-lg-flex">
        <img class="sidebar-card-illustration mb-2" src="<?php echo e(asset('assets/img/logo.jpg')); ?>" alt="...">
        
        
    </div>

</ul>
<!-- End of Sidebar -->
<?php /**PATH /home/iserverkit/iservernew/resources/views/components/sidebar.blade.php ENDPATH**/ ?>