const axios = require('axios')

const baseURL = 'https://thesender.info/api/whatsapp-bot/';

const statusUpdate = async (status, session_id) => {

    // Data to send in the POST request
    const postData = {
        status: status,
        session_id: session_id
    };

    try {
        // Make the POST request using Axios
        const response = await axios.post(baseURL+'status-callback', postData);
        // Handle the response
        console.log('Status Update Response data:', response.data);
    } catch (error) {
        // Handle errors
        console.error('Status Update Error:', error.message);
    }

}

const qrUpdate = async (qrData, session_id) => {

    // Data to send in the POST request
    const postData = {
        data: qrData,
        session_id: session_id
    };

    try {
        // Make the POST request using Axios
        const response = await axios.post(baseURL+'qr-update-callback', postData);
        // Handle the response
        console.log('QR Update Response data:', response.data);
    } catch (error) {
        // Handle errors
        console.error('QR Update Error:', error.message);
    }

}

const getLink = async (qrData, session_id) => {

    // Data to send in the POST request
    const postData = {
        data: qrData,
        session_id: session_id
    };

    try {
        // Make the POST request using Axios
        const response = await axios.post(baseURL+'qr-update-callback', postData);
        // Handle the response
        console.log('QR Update Response data:', response.data);
    } catch (error) {
        // Handle errors
        console.error('QR Update Error:', error.message);
    }

}

module.exports = {
    statusUpdate,
    qrUpdate
}
