<?php

    function isMobile() {
    return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
}

	// Se cargan las librerias de php-gettext:
 	require_once( 'streams.php' );
	require_once( 'gettext.php' );


    // Obtiene el idioma que esta usando el usuario según la configuración de su navegador:
	switch( substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2) )
	{
        case 'ru':
            $language = 'ruso';
		     break;    
        case 'de':
            $language = 'aleman';
		     break;    
        case 'fr':
            $language = 'france';
		     break;
        
        case 'it':
			$language = 'Italiano';
			break;
            
        case 'pt':
			$language = 'Portugues';
			break;
            
		case 'en':
			$language = 'English';
			break;

		default:
			$language = 'Spanish';
			break;
	}

    if($_SESSION['VERSION'] == 'MOBILE')    
    {// Se carga el fichero de traducción:
        if( file_exists($pach .'../../php/php-gettext/language/'. $language .'.mo') )
        {
            $gettext_tables = new gettext_reader( new CachedFileReader($pach .'../../php/php-gettext/language/'. $language .'.mo') );
            $gettext_tables->load_tables();
        }
    }else
    {
        if( file_exists($pach .'../php/php-gettext/language/'. $language .'.mo') )
        {
            $gettext_tables = new gettext_reader( new CachedFileReader($pach .'../php/php-gettext/language/'. $language .'.mo') );
            $gettext_tables->load_tables();
        }
    }

	// Recibe un texto y devuelve la traducción si existe en el catalogo, si no devuelve el texto original:
	function __($text)
	{
		global $gettext_tables;
        return( is_null($gettext_tables) ? $text : $gettext_tables->translate($text) );
	}


	// Recibe un texto e imprime la traducción si existe en el catalogo, si no imprime el texto original:
	function _e($text)
	{
		global $gettext_tables;
        echo( is_null($gettext_tables) ? $text : $gettext_tables->translate($text) );
	}

?>