<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSolicitudsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('solicituds', function (Blueprint $table) {
            $table->id();
            $table->integer('id_user')->unsigned();
            $table->foreign('id_user')->references('id')->on('users')->onDelete('cascade');
            $table->integer('numero')->nullable();
            //$table->foreign('id_credito')->references('id')->on('creditos')->onDelete('cascade'); sid
            $table->string('costo')->nullable();
            $table->string('status')->nullable();
            $table->integer('id_api')->unsigned();
            $table->string('sid')->nullable();
            $table->string('numero_twilio')->nullable();
            $table->foreign('id_api')->references('id')->on('a_p_i_s')->onDelete('cascade');
            $table->string('contenido')->nullable();
            $table->integer('sender_id')->unsigned();
            $table->foreign('sender_id')->references('id')->on('sender_i_d_s')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('solicituds');
    }
}
