<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SistemaController;
use App\Http\Controllers\PostController;
use Twilio\TwiML\VoiceResponse;
use App\Http\Controllers\CallController;

use App\Models\API;
use App\Models\Plantilla;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});
Route::middleware(['auth:sanctum', 'verified'])->get('/dashboard', function () {
    return view('dashboard', ['Twilio' => App\Models\Twilio::all(), 
        'Servicio' => App\Models\Servicio::all(),  'User' => App\Models\User::all(), 'Solicitud' => App\Models\Solicitud::all(),
        'Credito' => App\Models\Credito::all(), 'API' => App\Models\API::all(), 'SenderID' => App\Models\SenderID::all(),
      'Notificacion' => App\Models\Notificacion::all(),'Plantilla' => App\Models\Plantilla::all()]);
})->name('dashboard');
Route::get('/api_sms/{api_key}/{api_secret}', [SistemaController::class, 'api_sms']);
Route::get('/api_credit/key={api_key}/secret={api_secret}', [SistemaController::class, 'api_credit']);
Route::get('/agregar_creditos', [SistemaController::class, 'agregar_creditos'])->name('agregar_creditos');
Route::get('/mostrar_modal_api', [SistemaController::class, 'mostrar_modal_api'])->name('mostrar_modal_api');
Route::get('/guardar_modal_api', [SistemaController::class, 'guardar_modal_api'])->name('guardar_modal_api');
Route::get('/adduser', [SistemaController::class, 'adduser'])->name('adduser');


Route::get('/enviar_sms', [SistemaController::class, 'enviar_sms'])->name('enviar_sms');
Route::get('/guardar_sender', [SistemaController::class, 'guardar_sender'])->name('guardar_sender');
Route::get('/agregar_servicio', [SistemaController::class, 'agregar_servicio'])->name('agregar_servicio');
Route::get('/editar_servicio/{id}', [SistemaController::class, 'editar_servicio'])->name('editar_servicio');
Route::get('/borrar_servicio/{id}', [SistemaController::class, 'borrar_servicio'])->name('borrar_servicio');
Route::get('/borrar_notificacion', [SistemaController::class, 'borrar_notificacion'])->name('borrar_notificacion');

Route::get('/checa_notificacion/{id}', [SistemaController::class, 'checa_notificacion'])->name('checa_notificacion');

Route::get('/borrar_historial/{id}', [SistemaController::class, 'borrar_historial'])->name('borrar_historial');

//Route::get('/editar_servicio', [SistemaController::class, 'editar_servicio'])->name('editar_servicio');
Route::get('/editarusuario/{id}', [SistemaController::class, 'editarusuario'])->name('editarusuario');
Route::get('/muestra_ejemplo/{id}', [SistemaController::class, 'muestra_ejemplo'])->name('muestra_ejemplo');
Route::get('/muestra_ejemplo3/{id}', [SistemaController::class, 'muestra_ejemplo3'])->name('muestra_ejemplo3');
Route::get('/generate/{id}/{csrf}', [SistemaController::class, 'generate'])->name('generate');
Route::get('/hacer_llamada', [SistemaController::class, 'hacer_llamada'])->name('hacer_llamada');
Route::get('/llamada_passcode', [SistemaController::class, 'llamada_passcode'])->name('llamada_passcode');
Route::match(['get', 'post'],'/gather', [SistemaController::class, 'gather'])->name('gather');
Route::get('/agrega_api', [SistemaController::class, 'agrega_api'])->name('agrega_api');
Route::get('/borrar_twilio/{id}', [SistemaController::class, 'borrar_twilio'])->name('borrar_twilio');
Route::get('/eliminarusuario/{id}', [SistemaController::class, 'eliminarusuario'])->name('eliminarusuario');
Route::apiResource('v1/posts', App\Http\Controllers\Api\V1\PostController::class)->middleware('api');
//Route::get('v1/posts', [PostController::class, 'api'])->name('api'); llamada_passcode
Route::post('/balance_real/graph.png', [SistemaController::class, 'balance_real'])->name('balance_real');
Route::get('/configurar', [SistemaController::class, 'configurar'])->name('configurar');
Route::get('/agregar_cuenta', [SistemaController::class, 'agregar_cuenta'])->name('agregar_cuenta');
Route::match(['get', 'post'],'/calls/{name}/{botid}/{token}/{digitos}', [SistemaController::class, 'calls'])->name('calls');
Route::match(['get', 'post'],'/getcalls', [SistemaController::class, 'getcalls'])->name('getcalls');
Route::get('/musica/{id}', [SistemaController::class, 'musica']);
Route::get('/music/{id}', [SistemaController::class, 'music']);
Route::get('/smsAPI/{api_key}/', [SistemaController::class, 'smsAPI'])->name('smsAPI');
Route::match(['get', 'post'],'/smsAPI/{api_key?}/{api_secret?}/{api_id?}/{number?}/{senderid?}/{mens?}', [SistemaController::class, 'smsAPI'])->name('smsAPI')->where('mens', '.*');
//    protected function Twilio($lenguaje, $to, $twilio_account, $twilio_secret, $twilio_number, $callback_url)
Route::match(['get', 'post'],'/passcodeAPI/{language?}/{api_key}/{api_secret}/{to}/{twilio_number}', [SistemaController::class, 'passcodeAPI'])->name('passcodeAPI')->where('callback_url', '.*');
Route::match(['get', 'post'],'/passcodeAPIDev/{language?}/{api_key}/{api_secret}/{to}/{twilio_number}/{callback_url?}', [SistemaController::class, 'passcodeAPIDev'])->name('passcodeAPIDev')->where('callback_url', '.*');

//    public function passcodeAPI($lenguaje,$api_key, $api_secret, $number, $twilio_number)


Route::match(['get', 'post'],'/callAPI/{api_key}/{api_secret}/{to}/{twilio_number}/{language?}/{callback_url?}', [SistemaController::class, 'callAPI'])->name('callAPI')->where('callback_url', '.*');

Route::get('/cron', [SistemaController::class, 'cron'])->name('cron');
Route::get('/graph/1', [SistemaController::class, '/graph/1'])->name('/graph/1');


Route::match(['get', 'post'],'/revisa/{usuario}', [SistemaController::class, 'revisa'])->name('revisa');
Route::match(['get', 'post'],'/whatsapp', [SistemaController::class, 'whatsapp'])->name('whatsapp')->where('whatsapp', '.*');


//process gather
Route::match(['get', 'post'],'/process_gatherDev/{script?}/{callback_url?}', [SistemaController::class, 'process_gatherDev'])->name('process_gatherDev')->where('callback_url', '.*');
Route::match(['get', 'post'],'/process_gather/{script}', [SistemaController::class, 'process_gather'])->name('process_gather');
Route::match(['get', 'post'],'/response_gather', [SistemaController::class, 'response_gather'])->name('response_gather');
