<?php

namespace App\Console\Commands;

use App\Models\BotDetector;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class DeleteBotDetectorLogs extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'botdetectorlogs:delete';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Delete Bot Detector Logs every 5 minutes';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try {
            Log::info('botdetectorlogs:delete');
            BotDetector::truncate();
            $this->info('No data!');
        } catch (\Exception $e) {
            $this->error($e->getMessage());
        }
    }
}
