<?php

namespace App\Console;

use App\Models\Subscription;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\Log;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->call(function () {
            try {

                $subscription = Subscription::all();
                foreach ($subscription as $value) {
                    if ($value['expired'] == 0) {
                        if (isset($value['to'])) {
                            $startDate = Carbon::parse(now());
                            $endDate = Carbon::parse($value['to']);
                            // Calculate the difference in days
                            $diffInDays = $startDate->diffInDays($endDate);
                            $diffInHours = $startDate->diffInHours($endDate);
                            $user = User::where('id', $value['user'])->select('teligram')->first();
                            if ($diffInHours <= 48) {
                                if (isset($user['teligram'])) {
                                    if ($value['notify'] == 0) {
                                        $chat_id = $user['teligram'];
                                        $msg = "Subscription expired within $diffInHours hours! Please renew your subscription to avoid any interruptions.";
                                        sendTeligramMessage($chat_id, $msg);
                                        Subscription::where('id', $value['id'])->update([
                                            'notify' => 1
                                        ]);
                                    }
                                }
                            }
                            if ($diffInHours <= 0 || $startDate > $endDate) {
                                Subscription::where('id', $value['id'])->update([
                                    'expired' => 1,
                                    'exp_notify' => 1
                                ]);
                                if ($value['exp_notify'] == 0) {
                                    if (isset($user['teligram'])) {
                                        $chat_id = $user['teligram'];
                                        $msg = "Your Subscription is expired.! Please renew your subscription to access the panel.";
                                        sendTeligramMessage($chat_id, $msg);
                                    }
                                }
                            }
                        }
                    }
                }
                Log::info('Subscription CornJob', ["Run Successfully"]);
            } catch (\Throwable $th) {
                Log::info('Throwable', [$th->getMessage(), $th->getLine()]);
                throw $th;
            }
        })->everyMinute();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
