<?php

/**
 * 
 */

use App\Models\Subscription;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

if (!function_exists('forwordGeocoding')) {

    function forwordGeocoding(array $data)
    {
        try {
            $queryString = http_build_query([
                'q' => $data["query"] . ",+" . $data["region"],
                'key' => env('POSITIONSTACK_ACCESS_KEY'),
            ]);

            $ch = curl_init(sprintf('%s?%s', 'https://api.opencagedata.com/geocode/v1/json?q=', $queryString . "&language=en&pretty=1"));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $json = curl_exec($ch);
            curl_close($ch);
            $apiResult = json_decode($json, true);
            return $apiResult;
        } catch (\Throwable $th) {
            dd($th);
        }
    }
}
if (!function_exists('send_message_whatsapp_bot')) {

    function send_message_whatsapp_bot($chatID, $session_id, $message, $attachmentURL = NULL, $order_id = NULL, $link = NULL)
    {

        $curl = curl_init();
        $message = urlencode($message);
        curl_setopt_array($curl, array(
            CURLOPT_URL => env('WHATSAPP_BOT_SESSION_URL') . '/send-message?chatID=' . $chatID . '&session_id=' . $session_id . '&message=' . $message . '&attach=' . $attachmentURL . '&order_id=' . $order_id . '&link=' . $link,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        $info = curl_getinfo($curl);
        curl_close($curl);
        if ($info['http_code'] == 200) {
            return $response;
        } else {
            return false;
        }
    }
}
if (!function_exists('need_subscription_within_48_hours')) {
    function need_subscription_within_48_hours()
    {
        try {
            if (isset(Auth::user()->id)) {
                $subscription = Subscription::where('user', Auth::user()->id)->first();
                if (isset($subscription['from'])) {
                    $startDate = Carbon::parse(now());
                    $endDate = Carbon::parse($subscription['to']);

                    // Calculate the difference in days
                    $diffInDays = $startDate->diffInDays($endDate);
                    $diffInHours = $startDate->diffInHours($endDate);
                    if ($diffInHours <= 48) {
                        return ['status' => true, 'hours' => $diffInHours];
                    }
                }
            }
            return false;
        } catch (\Throwable $th) {
            throw $th;
        }
    }
}
if (!function_exists('sendTeligramMessage')) {

    function sendTeligramMessage($chat_id, $msg)
    {
        $token = env('TELEGRAM_BOT_TOKEN');
        Log::info("sendTeligramMessage", [$chat_id, $msg]);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://api.telegram.org/bot$token/sendMessage"); //bot1065040025:AAHk95zd4ZoUhF9eTp-3cPBIgXbd-zjTdiE
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"chat_id\": \"" . $chat_id . "\", \"text\": \"" . $msg . "\"}");
        $headers = array();
        $headers[] = 'Content-Type: application/json';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);
    }
}

if (!function_exists('validatePhoneNumber')) {

    function validatePhoneNumber($number)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://api.veriphone.io/v2/verify?key=" . env("VERIPHONE_KEY") . '&phone=' . $number);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // curl_setopt($ch, CURLOPT_POST, 1);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
        //     "key" => env("VERIPHONE_KEY"),
        //     "phone" => $number
        // ]));
        // $headers = array();
        // $headers[] = 'Content-Type: application/json';
        // curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        curl_close($ch);
        return json_decode($result);
    }
}
