<?php

namespace App\Http\Controllers;

use App\Models\BotDetector;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class BotDetectorController extends Controller
{
    private $prefix = "admin/bot-detector/";
    private $resources = [];
    private $checkPermissionAndRolesController;

    function __construct(
        CheckPermissionsAndRolesController $checkPermissionAndRolesController
    ) {
        $this->resources['prefix'] = $this->prefix;
        $this->checkPermissionAndRolesController = $checkPermissionAndRolesController;
    }
    public function index(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Bot Detector']);
        $this->resources['data'] = $this->get($request, 15);
        return view('admin.botdetector.botdetector_manage')->with($this->resources);
    }
    public function store(Request $request)
    {
        try {
            $requestAll = $request->all();
            
            BotDetector::create([
                'is_bot' => $requestAll['is_bot'],
                'ip_address' => $requestAll['ip_address'],
                'detection_method' => $requestAll['detection_method'],
                'user_agent' => $requestAll['user_agent'],
                'link' => $requestAll['link'],
            ]);
            return response(array('success' => true), 200);
        } catch (\Exception $e) {
            throw $e;
        }
    }
    public function get($request, $count)
    {
        try {

            $superAdmin = $this->checkPermissionAndRolesController->superAdmin($request);
            $query = BotDetector::orderBy('id', 'desc');
            $result = $query->get();
            return $result;
        } catch (\Exception $e) {
            throw $e;
        }
    }
    public function delete(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Bot Detector']);
        $request->validate([
            'id' => ['required'],
        ]);
        try {
            $query = BotDetector::where('id', $request->id);
            $result = $query->delete();
            $this->resources['messages'] = array("type" => "success", "description" => "Log deleted success");
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
    public function deleteAll(Request $request)
    {
        $this->checkPermissionAndRolesController->permissionTo($request, ['permission' => 'Bot Detector']);
        try {
            BotDetector::truncate();
            $this->resources['messages'] = array("type" => "success", "description" => "Log deleted success");
            return redirect()->back()->with('messages', $this->resources);
        } catch (\Throwable $th) {
            $this->resources['messages'] = array("type" => "error", "description" => $th->getMessage());
            return redirect()->back()->with('messages', $this->resources);
        }
    }
}
