<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;

class CheckPermissionsAndRolesController extends Controller
{
    // public function roleAndPermissionTo($request, array $data)
    // {
    //     if($request->user()->hasRole($data['role']) || $request->user()->hasPermissionTo($data['permission'])){
    //         return true;
    //     }else{
    //         abort(403);
    //     }
    // }

    public function permissionTo($request, array $data)
    {
        $role = Role::find($request->user()->type);
        if($role->name == 'Super Admin'){
            return true;
        }else{
            if($role->hasPermissionTo($data['permission'])){
                return true;
            }else{
                abort(403);
            }
        }
        
    }

    public function permissionToAjax($request, array $data)
    {
        $role = Role::find($request->user()->type);
        if($role->name == 'Super Admin'){
            return response(true, 200);
        }else{
            if($role->hasPermissionTo($data['permission'])){
                return response(true, 200);

            }else{
                return response("no permission to do this action", 403);

            }
        }
        
    }

    public function superAdmin($request, array $data = [])
    {
        $role = Role::find($request->user()->type);

        if($role->name == 'Super Admin'){
            return true;
        }else{
            return false;
        }
    }
}
